#ifndef __GL_RE_H__
#define __GL_RE_H__
/**************************************************************************
 *								 	  *
 * 		 Copyright (C) 1988, Silicon Graphics, Inc.		  *
 *								 	  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *								 	  *
 **************************************************************************/

/*
 * ECLIPSE/re.h
 *  - Addresses of registers of RASTER ENGINE 
 *
 * $Revision: 1.2 $
 */

/* Registers that can be written at any time */
#define  RE_ENABRGB	4	/* RE2 only */
#define  RE_BIGENDIAN	5
#define  RE_FUNC	6
#define  RE_HADDR	7
#define  RE_NOPUP	8
#define  RE_XYFRAC	9
#define  RE_RGB	10
#define  RE_YX	11
#define  RE_PUPDATA	12
#define  RE_TEXL	13
#define  RE_TEXH	14
#define  RE_DZINT	15
#define  RE_DZFRAC	16
#define  RE_DR   	17
#define  RE_DG	18
#define  RE_DB	19
#define  RE_ZINT	20
#define  RE_R		21
#define  RE_G		22
#define  RE_B		23
#define  RE_STIP	24
#define  RE_STIPCOUNT	25
#define  RE_DX	26
#define  RE_DY	27
#define  RE_NUMPIX	28
#define  RE_X		29
#define  RE_Y		30
#define  RE_IR	31


/* Registers that can be written only when DRAWDONE is high */
#define  RE_RWDATA	32
#define  RE_PIXMASK	33
#define  RE_AUXMASK	34
#define  RE_WIDDATA	35
#define  RE_UAUXDATA	36
#define  RE_RWMODE	37
#define  RE_READBUF	38
#define  RE_PIXTYPE	39
#define  RE_ASELECT	40
#define  RE_ALIGNTEX	41
#define  RE_ENABTEX	42
#define  RE_ENABSTIP	43
#define  RE_ENABDITH	44
#define  RE_ENABWID	45
#define  RE_CURWID	46
#define  RE_DEPTHFN	47
#define  RE_REPSTIP	48
#define  RE_ENABLWID	49
#define  RE_FBOPT	50
#define  RE_TOPSCAN	51
#define  RE_TESTMODE	52
#define  RE_TESTDATA	53
#define  RE_ZBOPTION	54	/* zbuffer board installed - boolean value */
#define  RE_XZOOM	55
#define  RE_UPACMODE	56
#define  RE_YMIN	57
#define  RE_YMAX	58
#define  RE_XMIN	59
#define  RE_XMAX	60
#define  RE_COLORCMP	61
#define  RE_MEGOPTION	62

/* Opcodes for instructions */
#define  IR_SHADED	1
#define  IR_FLAT	2
#define  IR_FLAT4	3	/* 4 span mode when RE_MEGOPTION = 0 */
#define  IR_BLOCKWRITE	3	/* 20 pix blkwrt mode when RE_MEGOPTION = 1 */
#define  IR_TOPLINE	4
#define  IR_BOTLINE	5
#define  IR_READBUF	6
#define  IR_WRITEBUF	7

/* TOPSCAN values */
#define  TOPSCAN_HIRES	255
#define  TOPSCAN_MIDRES	191
#define  TOPSCAN_PAL		143
#define  TOPSCAN_NTSC	121
/* defines used on RE2 systems with 1Meg video RAMs (RE_MEGOPTION = 1) */
#define  TOPSCAN_HIRES_2	1023
#define  TOPSCAN_MIDRES_2	767
#define  TOPSCAN_MIDRES_NEC_2 749	/* for NEC 1120X750 */
#define  TOPSCAN_PAL_2	575
#define  TOPSCAN_NTSC_2	485

/* Frame-buffer (bitplane expansion) options for RE_FBOPT reg */
#define FB_12		0	/*  8 pixelplanes, 2 wid, 0 uaux, 2 pup */
#define FB_32		1	/* 24 pixelplanes, 4 wid, 2 uaux, 2 pup */
/* The following frame-buffer options are available only with an RE2 */
#define FB_20		2	/* 16 pixelplanes, 2 wid, 0 uaux, 2 pup */
#define FB_24		3	/* 16 pixelplanes, 4 wid, 2 uaux, 2 pup */

#endif	/* !__GL_RE_H__ */
