/****************************************************************************\
*                                                                            *
* Function: Stubbed out entrypoints                                          *
*                                                                            *
*       These routines are either very small or not implemented.             *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "invent.h"

BOOL PASCAL devpSaveScreen(LPRECT);
BOOL PASCAL devpRestoreScreen(LPRECT);

extern WORD ivhw_state;

BOOL WINAPI SaveScreenBitmap
(
    LPRECT lpRect,
    WORD   wCommand
)
{
    static BOOL SaveState=FALSE;
    static RECT SaveRect;

    DBGMSG("SaveScreenBitmap\n\r");

    if (!(ivhw_state & INV_GR1ZBUF24))
        return(FALSE);

    if (wCommand == 0) {            //
                                    // Save Rect
                                    //
        if (SaveState)
            return(FALSE);

        SaveRect = *lpRect;
        devpSaveScreen(lpRect);
        SaveState = TRUE;
    }

    else if (wCommand == 1) {       //
                                    // Restore Rect
                                    //
        
        if ((lpRect->left != SaveRect.left) || (lpRect->right != SaveRect.right)
           || (lpRect->top != SaveRect.top) || (lpRect->bottom != SaveRect.bottom)) 
            return(FALSE);

        devpRestoreScreen(lpRect);

        SaveState = FALSE;
    }
    else {
        SaveState = FALSE;


    }
    return(TRUE);
}
