#ifndef __SYS_SGIGSC_H__
#define __SYS_SGIGSC_H__
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1989-1991, Silicon Graphics, Inc.	  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *									  *
 **************************************************************************/

/*
 *  sgigsc.h
 *	- Constants and structure definitions for the Silicon Graphics graphics
 *	  system call.
 *	- Requires a #include <sys/types.h> to preceed it.
 *
 *  $Revision: 1.2 $
 */

/*
 * Machine independent operations
 */
#define	SGWM_LOCK	1		/* lock graphics hardware */
#define	SGWM_UNLOCK	2		/* unlock graphics hardware */
#define	SGWM_SIO	3		/* steal sio channel */
#define	SGWM_UNSIO	4		/* unsteal sio channel */
#define	SGWM_WMRUNNING	5		/* query window manager existence */
#define	SGWM_MEWM	6		/* declare process as window manager */
#define	SGWM_LOSTGR	9		/* test for graphics capability */
#define	SGWM_TIEMOUSE	10		/* tie mouse to cursor */
#define	SGWM_UNTIEMOUSE	11		/* untie mouse from cursor */
#define	SGWM_CONSOLE	12		/* switch unix console to stream dev */
#define	SGWM_QMEM	13		/* map shared q */
#define	SGWM_UNQMEM	14		/* unmap shared q */
#define	SGWM_WMMODELOCK	15		/* WM lock/unlock mode change lock */
#define	SGWM_INIT	16		/* mark process as graphics process */

/*
 * Machine dependent operations
 */

/* GT/GTX */



/* GR1 (ECLIPSE) */
#define SGGR1_CMD_BASE	200
#define SGGR1_PROBE		236
#define SGGR1_DOWNLD		233
#define SGGR1_CHECKRE		244
#define SGGR1_PROMIO		234
#define SGGR1_MAPALL		200
#define SGGR1_GINIT		201
#define SGGR1_RELEASE_CX	235
#define SGGR1_XMAPMODELO	202
#define SGGR1_XMAPMODEHI	203
#define SGGR1_MAPCOLOR		204
#define SGGR1_GETMCOLOR		223
#define SGGR1_MAPAUXCOLOR	205
#define SGGR1_SWAPBUFFERS	206
#define SGGR1_SWAPINTERVAL	207
#define SGGR1_BLINK		208
#define SGGR1_CYCLEMAP		209
#define SGGR1_GAMMARAMP		210
#define SGGR1_SETCURSOR		211
#define SGGR1_MAPCURSCOLOR	213
#define SGGR1_CURSDISPLAY	212
#define SGGR1_DISPLAYREG	214
#define SGGR1_BLANKSCREEN	215
#define SGGR1_SETMONITOR	216
#define SGGR1_GETMONITOR	222
#define SGGR1_DMA		225
#define SGGR1_GETHWCONFIG	226
#define SGGR1_PICK		219
#define SGGR1_ENDPICK		220
#define SGGR1_GSYNC		221
#define SGGR1_CREATECX		232
#define SGGR1_INITCX		243
#define SGGR1_DESTROYCX		242
#define SGGR1_GIVECX		227
#define SGGR1_TAKECX		228
#define SGGR1_ACT_CX		229
#define SGGR1_DEACT_CX		230
#define SGGR1_STORECX		237
#define SGGR1_LOADCX		238
#define SGGR1_WRITECX		239
#define SGGR1_LOADMODE		245
/* Additions for IRISVISION */
#define SGGR1_GETSCRNMODE	270
#define SGGR1_SETSCRNMODE	271
#define SGGR1_LOADRGB8MAP	272
#define SGGR1_GETCURSOFF	289
#define SGGR1_POSCURSOR		296
#define SGGR1_VIDEOTIMING	290
#define SGGR1_CMD_LIMIT		299

#ifndef	_MSDOS
/*XXX TEMPORARY: ECLIPSE TESTING */
#define SGGR1_CURSOFFHACK	291
#define SGGR1_MODERD		297
#define SGGR1_PROTECT_HQMMSB	298
#endif	/* !_MSDOS */

/* Operations for CG2 board, valid on 4D/60, 4D/70 and 4D/70GT */
#define SG4DCG2_CMD_BASE	400
#define	SG4DCG2_READ_REG	400	/* read any CG2 register */
#define	SG4DCG2_WRITE_REG	401	/* write any CG2 register */
#define SG4DCG2_CMD_LIMIT	419


/* 
 * Operations for GR1_AUXSCRN design -- be extra careful and don't reuse
 * until 1991, just in case.
 */
#define SGAUX_CMD_BASE		500
#define SGAUX_ALLOCSCRN		500	/* allocate a screen */
#define SGAUX_DEALLOCSCRN	501	/* deallocate a screen */
#define SGAUX_SETOUTSCRN	502	/* set graphics output screen */
/* XXX the following 2 are only needed until the window manager is changed to
 * keep track of the currrent input focus screen */
#define SGAUX_SETINSCRN		503	/* set graphics input (mouse tracking)
					 * screen */
#define SGAUX_GETINSCRN		505	/* return the graphics input (mouse 
					 * tracking) screen */
#define	SGAUX_GETNSCRNS		504	/* return number of graphics screens
					 * associated with the current
					 * display */
#define SGAUX_CURSDISPLAY	SGGR1_CURSDISPLAY
#define SGAUX_CMD_LIMIT		509


/*
 * Data structures for SGWM_QMEM operation.
 * All the data structures described below are assumed to be aligned on
 * a longword boundary.
 */

/*
 * This structure defines the argument for the SGWM_QMEM system call.
 */
struct	sgigsc_qmem {
	char	*base;			/* base address of q memory */
	long	entries;		/* number of q entries */
};

/*
 * This structure defines an entry in the q.  Each entry is defined to
 * be 8 longwords in length, aligned on a longword boundary.
 */
struct	sgigsc_qentry {
	struct {
		long	seconds;
		long	microseconds;
	} timeStamp;			/* time of event; relative to boot */

	long	event;			/* unique event identifier */

	union {
		long	value[5];		/* maximum data area */
		unsigned char ascii;		/* ascii code */
		long	pid;			/* process id */

		struct {
			long	x;		/* mouse x coordinate */
			long	y;		/* mouse y coordinate */
			long	buttons;	/* mouse button data */
		} mouse;

		struct {
			dev_t	dev;		/* unix device */
			unsigned char c;	/* character from sio device */
		} sio;
	} ev;				/* event value */
};

/* If timeStamp.seconds is SGT_TIME_RELATIVE
** then timeStamp.microseconds lbolt.
*/
#define SGT_TIME_RELATIVE 0xFFFFFFFF

/* definitions for bits in of ev.mouse.buttons */
#define	SGE_MOUSE_RIGHTMOUSE	0x01
#define	SGE_MOUSE_MIDDLEMOUSE	0x02
#define	SGE_MOUSE_LEFTMOUSE	0x04
#define	SGE_LPEN_BUTTON		0x01

/*
 * This structure defines an actual q.  The first two fields are the index's
 * for the q entry and remove points.  The final field is a variable length
 * array containing the actual q entries.  The number of entries is defined
 * when the SGWM_QMEM call is given, via the sgigsc_mem.entries field.
 */
struct	sgigsc_q {
	long	qin;			/* index for next q enter */
	long	qout;			/* index for next q remove */
	struct sgigsc_qentry q[1];	/* actual q */
};

#define SGWM_MINQSIZE	32		/* minimum queue size allowed */

/*
 * Event identifiers (sgigsc_qentry.event).
 */
#define	SGE_PDEATH	1		/* graphics process death */
#define	SGE_PBLOCK	2		/* graphics process blocked */
#define	SGE_KB		3		/* keyboard data */
#define	SGE_MOUSE	4		/* mouse data */
#define	SGE_SIO		5		/* sio data */
#define	SGE_LPEN	6		/* light pen data */

/*
 * Definitions for structures passed as arguments to sgigsc.
 */


/******************************************************************************
 * GR1 (Eclipse) sgigsc() system call argument structures.
 *****************************************************************************/

/*XXX TEMPORARY FOR ECLIPSE TESTING */
typedef struct sggr1_moderd {
	long xmap;
	long *modes;
} sggr1_moderd_t;

typedef struct sggr1_poscursor {
	long x;
	long y;
} sggr1_poscursor_t;

typedef struct sggr1_cursoffhack {
	long xoff;
	long yoff;
} sggr1_cursoffhack_t;


/*
 * XMAP2 operation argument structures
 */

typedef struct sggr1_xmapmodelo {
	unsigned char colmode;
	unsigned char bufsel;
	unsigned char overlay;
	unsigned long *modeaddr;
	unsigned long modemask;
} sggr1_xmapmodelo_t;

typedef struct sggr1_xmapmodehi {
	unsigned char underlay;
	unsigned char multimap;
	unsigned char mapsel;
	unsigned long *modeaddr;
	unsigned long modemask;
} sggr1_xmapmodehi_t;

typedef struct sggr1_mapcolor {
	short index;
/*XXX shorts as in GL doc or chars? */
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} sggr1_mapcolor_t;

typedef struct sggr1_getmcolor {
	short index;
/*XXX shorts as in GL doc or chars? */
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} sggr1_getmcolor_t;

typedef struct sggr1_mapauxcolor {
	short index;
/*XXX shorts or chars? */
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} sggr1_mapauxcolor_t;

typedef struct sggr1_swapinterval {
	short frames;
} sggr1_swapinterval_t;

typedef struct sggr1_blink {
	short rate;
	unsigned short index;
	unsigned char red, green, blue;
} sggr1_blink_t;

typedef struct sggr1_cyclemap {
	short map;
	short nextmap;
	short duration;
} sggr1_cyclemap_t;


/*
 * DAC operation argument structures
 */

typedef struct sggr1_gammaramp {
/*XXX shorts or chars? */
	unsigned short *red;
	unsigned short *green;
	unsigned short *blue;
} sggr1_gammaramp_t;


/*
 * Cursor operation argument structures
 */

typedef struct sggr1_setcursor {
	char type;
	char xorigin;
	char yorigin;
	unsigned char *glyph;
	unsigned char *glyph2;
} sggr1_setcursor_t;

typedef struct sggr1_mapcurscolor {

	char index;		/* Eclipse has only 1 color entry but we may
				   have more later */
/*XXX shorts or chars? */
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} sggr1_mapcurscolor_t;

typedef struct sggr1_cursdisplay {
	char display;			/* boolean: on or off */
} sggr1_cursdisplay_t;


/*
 * Display Register operation argument structures
 */

typedef struct sggr1_displayreg {
	char regnum;
	unsigned char val;
} sggr1_displayreg_t;

typedef struct sggr1_blankscreen {
	char blankscreen;
} sggr1_blankscreen_t;

typedef struct sggr1_setmonitor {
	unsigned char monitortype;
	unsigned char flag;
	long xmaxscreen;
	long ymaxscreen;
	long xcursmagic;
	long ycursmagic;
	long topscan;
} sggr1_setmonitor_t;

typedef struct sggr1_getmonitor {
	unsigned char monitortype;
	unsigned char flag;
} sggr1_getmonitor_t;

/* Display control flags: */
#define SGGR1_SYNCGRN	0x01		/* Composite sync on green */
#define SGGR1_BLANK	0x02		/* Screen is currently off */
#define SGGR1_STEREO	0x04		/* Stereo optic display enabled */
#define SGGR1_EXTCLK	0x08		/* Timing locked to external clock
					   (ie. in genlock mode) */
#define SGGR1_COMPSYNC	0x20		/* Composite sync */
#define SGGR1_HVSYNC	0x40		/* H/V seperate sync */

#define SGGR1_OVERRIDE_TOPSCAN 0x10	/* Use the topscan value supplied with
					   struct sggr1_setmonitor instead of
					   determining it from monitortype;
					   never set by sggr1_getmonitor */

/*
 * Graphics DMA argument structures
 */

typedef struct sggr1_dma {
	long token;			/* Token to send down pipe */
	long x;				/* Rectangular coordinate in pixels */
	long xlen;
	long y;
	long ylen;
#ifdef WIN_DRIVER
	unsigned char far *buf;			/* Data buffer */
#endif
#ifndef 	WIN_DRIVER
   char *buf;			/* Data buffer */
#endif
	unsigned short flags;		/* Bit flags defined below */
	char pixsize;			/* Pixel size (1, 2, 4 bytes) */
	char pmoffset;			/* Number of bits of the first CPU
					   word of each scanline that are
					   to be ignored */
	long pmstride;			/* Number of 32-bit CPU words per
					   scanline */
} sggr1_dma_t;

/* Flags for graphics DMA */
#define GR1_READ	0x01		/* DMA direction: gfx to host */
#define GR1_WRITE	0x02		/* DMA direction: host to gfx */
#define GR1_LNBYLN	0x04		/* Line by line DMA: 1 line at a time */
#define GR1_SINGLE	0x08		/* Single line DMA (special case) */
#ifdef LATER	/* XXX */
#define GR1_INTR	0x10		/* Ucode should interrupt when done */
#endif
#define GR1_STRIDE	0x20		/* Stride DMA */


/*
 * Misc. operation argument structures
 */

typedef struct sggr1_gethwconfig {
	char bitplanes;
	char zbuf;
	char gsnr;		/* in value: screen that inquiry is for */
	char _filler;
	long invstate;		/* added because shared GL can't import hinv 
				 * routines from libc */
} sggr1_gethwconfig_t;

typedef struct sggr1_pick {	/* for SGGR1_PICK */
	char *buffer;		/* user virtual address of feedback buffer */
	long buflen;		/* length of feedback buffer in 32 bit words */
} sggr1_pick_t;

typedef struct sggr1_endpick {	/* for SGGR1_ENDPICK */
	long token;		/* token kernel sends to GE for GL */
	long overflow;		/* buffer overflow flag (set by sgigsc) */
#ifdef _MSDOS
	long feedcount;		/* count for feedback */
#endif
} sggr1_endpick_t;


/*
 * Window Manager operation argument structures
 */

typedef struct sggr1_initcx {	/* for SGGR1_INITCX */
	long cxid;		/* New context to be initialized */
	long wid;		/* Window ID of new context */
} sggr1_initcx_t;

typedef struct sggr1_givecx {
	long pid;		/* Process to receive the context */
	long cx;		/* Context number */
	long wid;		/* Window ID that context should use*/
} sggr1_givecx_t;

typedef struct sggr1_storecx {	/* for SGGR1_STORECX */
	long	cxid;		/* context to be unloaded */
	char	*buf;		/* user virtual address of unload buffer */
	long	buflen;		/* length of unload buffer in bytes */
} sggr1_storecx_t;

typedef struct sggr1_loadcx {	/* for SGGR1_LOADCX */
	long	cxid;		/* context to be loaded */
	long	wid;		/* Window ID of context */
	char	*buf;		/* user virtual address of load buffer */
	long	buflen;		/* length of buffer to load in bytes */
} sggr1_loadcx_t;

typedef struct sggr1_loadmode {	/* for SGGR1_LOADMODE */
	long	cxid;		/* context who's mode is being loaded */
	long	wid;		/* Window ID that context should use*/
} sggr1_loadmode_t;

typedef struct sggr1_writecx {	/* for SGGR1_WRITECX */
	long cxid;		/* Context writing into */
	long addr;		/* Data RAM addr in words */
	long count;		/* Number of words */
	unsigned long *buf;	/* Buffer to write into context */
} sggr1_writecx_t;

/* argument structure for SG4DCG2_READ_REG and SG4DCG2_WRITE_REG */
typedef struct sgigsc_4DCG2_cgreg {
    unsigned int reg;		/* register number */
    unsigned char value;	/* value */
} sg_4DCG2_cgreg_t;

/* Defines for CG2 register numbers */
#define SG_CG_MODE_REG		0
#define SG_CG_CONTROL_REG	1
#define SG_CG_HORPHASE_REG	2
#define SG_CG_SUBPHASE_REG	3
#define SG_CG_LASTREG		SG_CG_SUBPHASE_REG





/* Arguments to SGWM_WMMODELOCK and SGWM_GLMODELOCK */
#define SG_MODELOCK	0
#define SG_MODEUNLOCK	1

/*
 * Error codes returned by sgigsc()
 */
/*
 * GT specific errors
 */
#define	E_GSC_4D80_BASE		160	/* XXX */
#define E_GSC_4D80_TOOSHORT	(E_GSC_4D80_BASE+0)
#define E_GSC_4D80_TOOLONG	(E_GSC_4D80_BASE+1)
#define E_GSC_4D80_WAITING	(E_GSC_4D80_BASE+2)
#define E_GSC_4D80_GMHUNG	(E_GSC_4D80_BASE+3)
#define E_GSC_4D80_GMNOTREADY	(E_GSC_4D80_BASE+4)
#define E_GSC_4D80_PICKING	(E_GSC_4D80_BASE+5)
#define E_GSC_4D100_DMA_ERR	(E_GSC_4D80_BASE+6)

/*
 * Kernel data structures for sgigsc()
 */
#ifdef _KERNEL
#include "sys/sema.h"

/*
 * sgigsc state structure
 */
typedef struct sgstate_s {
	short	flags;		/* random flags */
	struct	sgigsc_q *q;	/* kernel virtual addr of q */
	caddr_t	uvaddr;		/* users virtual addr of q */
	int	qlen;		/* length of total q memory, in bytes */
	int	pages;		/* # of pages used to map q */
	int	entries;	/* max # of entries in the q */
	struct	proc *wman;	/* proc pointer of window manager process */
#ifdef	SVR0
	struct	pte *pte;	/* pte pointer to users base addr */
#endif
#ifdef	SVR3
	sema_t	waitsema;	/* to queue clients when window mgr is slow */
	int	waittmo;	/* timeout id that will wakeup waitsema wtrs */
	sema_t	wmmodeq;	/* to queue the WM for the mode change lock */
	sema_t	glmodeq;	/* to queue clients for the mode change lock */
	int	glmodelock;	/* count of clients who have the mode lock */
	lock_t	sglock;		/* spinlock to protect sgstate structure */
	lock_t	qlock;		/* spinlock to protect event queue */
	int	lockcount;	/* nesting count for graphics lock calls */
	sema_t	gfxsema;	/* graphics semaphore - need this to image */
	struct	graph_s	*owner;	/* graphics info struct of semaphore owner */
#endif
} sgstate_t;

extern sgstate_t sgstate;

/* bits in sgstate.flags */
#define	OPEN		0x01	/* somebody has us open */
#define	WMRUNNING	0x02	/* window manager is running */
#define	QMEM		0x04	/* q memory is shared */
#define	WANTMODELK	0x08	/* the window manager is waiting for mode lk */

/* Flag for gfx_psema */

#define NOSLEEP		0
#define SLEEP		1

/*
 * Definition of generic functions externalized by a graphics
 * output driver for use by the rest of the kernel.
 */
typedef struct gr_out_s {
	void    (*gr_poscursor)();	/* position the cursor */
	void    (*gr_blank)();		/* blank and unblank the screen */
	void    (*gr_stop)();		/* stop graphics output */
	void    (*gr_ismex)();		/* set state var 'mex is running' */
	struct pregion *(*gr_init)();	/* mark process as graphics process */
	void    (*gr_exit)();		/* called on process exit */
	int     (*gr_disp)();		/* check if process can be dispatched */
	void    (*gr_glock)();		/* lock graphics */
	void    (*gr_gresume)();		/* finish context switch */
	int     (*gr_remap)();		/* remap graphics resources */
	void    (*gr_gswtchout)();	/* context switch out of a process */
	void    (*gr_killall)();	/* kill all graphics processes */
	void	(*gr_setcursorpos)();	/* set saved cursor position */
	void	(*gr_getcursorpos)();	/* get saved cursor position */
} gr_out_t;

extern gr_out_t *gr_out_p;

/*
 * Exported sgigsc functions
 */
extern struct proc	*gsc_window_manager();
extern int		gsc_gfx_locked();
extern int		gsc_glmodelock(int);
extern int		gfx_psema(struct graph_s *, int);
extern void		gfx_vsema(struct graph_s *);
extern int		gfx_valusema();
extern struct graph_s	*gfx_owner();
extern void		gfx_lock();
extern void		gfx_unlock();

/*
 * System parameters for GT graphics
 */
#define SG_4D80_FIFO_VADDR	0x1000	/* FIFO address in user space */
#define SG_4D80_MAXCONTEXT	16	/* number of graphics contexts in HW */
#define SG_4D80_MAXFEEDBACK	0x10000	/* max feedback buffer in bytes */

/*
 * Miscellaneous argument defines
 */
#define NOFORCE		0	/* Do not force an action */
#define FORCE		1	/* Force an action */

#else	/* !_KERNEL */

extern int sgigsc(int, void *);

#endif	/* !_KERNEL */

#endif	/* !__SYS_SGIGSC_H__ */
