/****************************************************************************\
*                                                                            *
* Function: Brush support                                                    *
*                                                                            *
*       Device brush support routines to realize brushes dependent on the    *
*       pixel depth and convert between color and monochrome brushes.        *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/24/93 Dave Schmenk - wrote it.                                    *
*       09/01/93 Dave Schmenk - modified for 24BPP from 8BPP.                *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1993 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "24bpp.h"

//
// Some constants needed by the common code.
//

WORD     memBytesPerPixel = 3;
BYTE     memBitsPerPixel  = 24;
DWORD    devBrushSize = sizeof(BRUSH) + 192 - 1;

//
// Local instance of a temporary brush.
//

DEVBRUSH mempTmpBrush;

LPBRUSH PASCAL memGetTmpBrush
(
    VOID
)
{
    return((LPBRUSH)&mempTmpBrush);
}

