.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: PatBLT 24BPP pattern to 24BPP destination                        ;
;                                                                            ;
;       24BPP pattern BLT fills a rectangular region of a bitmap with a      ;
;       repeating pattern using a binary ROP.  This routine fills the region ;
;       on a scanline basis using a procudure table to apply the individual  ;
;       ROP functions.                                                       ;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/07/93 Dave Schmenk - wrote it.                                    ;
;       09/01/93 Dave Schmenk - modified for 24BPP from 8BPP.                ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

incDrawMode     EQU     1               ; Include DRAWMODE structure

                INCLUDE COMMON.INC
                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

pDst            EQU     [bp + 26]
pDstSegmnt      EQU     [bp + 28]
pDstOffset      EQU     [bp + 26]
dyDst           EQU     [bp + 24]
cDstScanSeg     EQU     [bp + 22]
cDstFillBytes   EQU     [bp + 20]
xDst            EQU     [bp + 18]
yDst            EQU     [bp + 16]
pPat            EQU     [bp + 12]
pPatSegmnt      EQU     [bp + 14]
pPatOffset      EQU     [bp + 12]
xSize           EQU     [bp + 10]
ySize           EQU     [bp + 8]
mode            EQU     [bp + 6]
rop             EQU     [bp + 4]

pDstScan        EQU     [bp - 2]
cDstByte        EQU     [bp - 4]
cScan           EQU     [bp - 6]
pfnScanBlt      EQU     [bp - 8]
clrSolid        EQU     [bp - 12]
;
; Function tables for Fill, Hatch, and Pattern brush BLTs.
;
mempBltFD2424Tbl DW     mempBltFD2424r0, mempBltFD2424r1, mempBltFD2424r2, mempBltFD2424r3
                DW      mempBltFD2424r4, mempBltFD2424r5, mempBltFD2424r6, mempBltFD2424r7
                DW      mempBltFD2424r8, mempBltFD2424r9, mempBltPD2424rA, mempBltFD2424rB
                DW      mempBltFD2424rC, mempBltFD2424rD, mempBltFD2424rE, mempBltFD2424rF
mempBltPD2424Tbl DW     mempBltFD2424r0, mempBltPD2424r1, mempBltPD2424r2, mempBltPD2424r3
                DW      mempBltPD2424r4, mempBltFD2424r5, mempBltPD2424r6, mempBltPD2424r7
                DW      mempBltPD2424r8, mempBltPD2424r9, mempBltPD2424rA, mempBltPD2424rB
                DW      mempBltPD2424rC, mempBltPD2424rD, mempBltPD2424rE, mempBltFD2424rF

memBltPD_ToColor        PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 16
        push    ds
        push    es
        push    si
        push    di
;
; Load pattern segment.
;
        les     si, pPat
;
; Save pointer to first scanline.
;
        mov     ax, yDst
        bmScanAddrInc cDstScanSeg, dyDst, cScan, pDstSegmnt, pDstOffset
        mov     ds, dx
        mov     di, ax
;
; Calculate destination constants.
;
        add     di, xDst                ; ds:[di] = address of first pixel
        add     di, xDst
        add     di, xDst
;
; Save calculated constants.
;
        mov     pDstScan, di
;
; Check for solid colors.
;
        test    WORD PTR es:[si][BRUSH_FLAGS], 4        ; 4 = Solid brush
        jz      PatBlt
;
; Translate rop2 into function pointer.
;
        mov     bx, rop
        add     bx, bx
        mov     bx, mempBltFD2424Tbl[bx]
        mov     ax, es:[si][BRUSH_CLR_SOLID]
        mov     dx, es:[si][BRUSH_CLR_SOLID + 1]
        mov     clrSolid, ax
        mov     clrSolid + 2, dx
        jmp     bx
PatBlt:
;
; Check for transparent HATCH patterns
;
;        cmp     WORD PTR mode, TRANSPARENT
;        je      HatchBlt
;
; Calc horizontal brush alignment.
;
        mov     ax, xDst
        sub     ax, es:[si][BRUSH_X]
        and     ax, 7
        mov     bx, ax
        add     bx, ax
        add     bx, ax
        mov     xDst, bx
;
; Translate rop2 into function pointer.
;
        mov     bx, rop
        add     bx, bx
        mov     bx, mempBltPD2424Tbl[bx]
        jmp     bx
memBltPD_ToColor        ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 1                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r1      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        or      ax, [di]
        not     ax
        mov     [di], ax
        mov     al, es:[si + 2]
        or      al, [di + 2]
        not     al
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r1      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 2                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r2      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        not     ax
        and     [di], ax
        mov     al, es:[si + 2]
        not     al
        and     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r2      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 3                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r3      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        not     ax
        mov     [di], ax
        mov     al, es:[si + 2]
        not     al
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r3      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 4                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r4      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, [di]
        not     ax
        and     ax, es:[si]
        mov     [di], ax
        mov     al, [di + 2]
        not     al
        and     al, es:[si + 2]
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r4      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 6                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r6      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        xor     [di], ax
        mov     al, es:[si + 2]
        xor     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r6      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 7                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r7      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        and     ax, [di]
        not     ax
        mov     [di], ax
        mov     al, es:[si + 2]
        and     al, [di + 2]
        not     al
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r7      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 8                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r8      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        and     [di], ax
        mov     al, es:[si + 2]
        and     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r8      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = 9                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424r9      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        not     ax
        xor     [di], ax
        mov     al, es:[si + 2]
        not     al
        xor     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424r9      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = A                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424rA      PROC NEAR
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424rA      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = B                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424rB      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        not     ax
        or      [di], ax
        mov     al, es:[si + 2]
        not     al
        or      [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424rB      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = C                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424rC      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        mov     [di], ax
        mov     al, es:[si + 2]
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424rC      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = D                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424rD      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, [di]
        not     ax
        or      ax, es:[si]
        mov     [di], ax
        mov     al, [di + 2]
        not     al
        or      al, es:[si + 2]
        mov     [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424rD      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Pattern BLT, 24BPP, rop = E                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltPD2424rE      PROC NEAR
;
; Preload bx for ScanLoop.
;
        mov     bx, yDst
;
; Main scanline blt loop.
;
ScanLoop:
        mov     si, pPatOffset
        sub     bx, es:[si][BRUSH_Y]
        and     bx, 7
        imul    bx, 24
        add     si, BRUSH_COLOR
        add     si, bx
        mov     dx, si
        add     dx, 24
        add     si, xDst
        mov     cx, xSize
PatLoop:
        mov     ax, es:[si]
        or      [di], ax
        mov     al, es:[si + 2]
        or      [di + 2], al
        add     di, 3
        add     si, 3
        cmp     si, dx
        je      @F
        dec     cx
        jnz     PatLoop
        jmp     NextScan
@@:     sub     si, 24
        dec     cx
        jnz     PatLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
;
; Increment current y coordinate for indexing into brush
; and get brush phase alignment.
;
        mov     bx, yDst
        inc     bx
        mov     yDst, bx
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltPD2424rE      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 0                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r0      PROC NEAR
        xor     ax, ax
        mov     clrSolid, ax
        mov     clrSolid + 2, ax
        jmp     mempBltFD2424rC
mempBltFD2424r0      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 1                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r1      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        mov     bx, ax
        or      bx, [di]
        not     bx
        mov     [di], bx
        mov     bl, dh
        or      bl, [di + 2]
        not     bl
        mov     [di + 2], bl
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r1      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 4                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r4      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        mov     bx, [di]
        not     bx
        and     bx, ax
        mov     [di], bx
        mov     bl, [di + 2]
        not     bl
        and     bl, dh
        mov     [di + 2], bl
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r4      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 5                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r5      PROC NEAR
SolidScanLoop:
        mov     cx, xSize
FillLoop:
        not     WORD PTR [di]
        not     BYTE PTR [di + 2]
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r5      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 9                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r9      PROC NEAR
        not     ax
        not     dx
        mov     clrSolid, ax
        mov     clrSolid + 2, dx
;        jmp     mempBltFD2424r6
mempBltFD2424r9      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 6                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r6      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        xor     [di], ax
        xor     [di + 2], dh
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r6      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 7                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r7      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        mov     bx, ax
        and     bx, [di]
        not     bx
        mov     [di], bx
        mov     bl, dh
        and     bl, [di + 2]
        not     bl
        mov     [di + 2], bl
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r7      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 2                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r2      PROC NEAR
        not     ax
        not     dx
        mov     clrSolid, ax
        mov     clrSolid + 2, dx
;        jmp     mempBltFD2424r8
mempBltFD2424r2      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 8                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r8      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        and     [di], ax
        and     [di + 2], dh
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424r8      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = 3                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424r3      PROC NEAR
        not     ax
        not     dx
        mov     clrSolid, ax
        mov     clrSolid + 2, dx
;        jmp     mempBltFD2424rC
mempBltFD2424r3      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = C                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424rC      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
        test    di, 1
        jz      @F
        mov     [di], al
        mov     [di + 1], dx
        add     di, 3
        dec     cx
        jz      NextScan
;
; bx = intermediate WORD with partial last and next pixel values.
;
@@:     mov     bl, dh
        mov     bh, al
        sub     cx, 8
        js      @F
FillLoop8:
        mov     [di], ax
        mov     [di + 2], bx
        mov     [di + 4], dx
        mov     [di + 6], ax
        mov     [di + 8], bx
        mov     [di + 10], dx
        mov     [di + 12], ax
        mov     [di + 14], bx
        mov     [di + 16], dx
        mov     [di + 18], ax
        mov     [di + 20], bx
        mov     [di + 22], dx
        add     di, 24
        sub     cx, 8
        jns     FillLoop8
@@:     add     cx, 8
        jz      NextScan
;
; Fill last < 8 pixels.
;
        mov     [di], ax
        dec     cx
        jz      FillLast
        mov     [di + 2], bx
        mov     [di + 4], dx
        add     di, 6
        dec     cx
        jz      NextScan
        mov     [di], ax
        dec     cx
        jz      FillLast
        mov     [di + 2], bx
        mov     [di + 4], dx
        add     di, 6
        dec     cx
        jz      NextScan
        mov     [di], ax
        dec     cx
        jz      FillLast
        mov     [di + 2], bx
        mov     [di + 4], dx
        add     di, 6
        dec     cx
        jz      NextScan
        mov     [di], ax
FillLast:
        mov     [di + 2], dh
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424rC      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = D                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424rD      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        mov     bx, [di]
        not     bx
        or      bx, ax
        mov     [di], bx
        mov     bl, [di + 2]
        not     bl
        or      bl, dh
        mov     [di + 2], bl
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424rD      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = B                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424rB      PROC NEAR
        not     ax
        not     dx
        mov     clrSolid, ax
        mov     clrSolid + 2, dx
;        jmp     mempBltFD2424rE
mempBltFD2424rB      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = E                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424rE      PROC NEAR
SolidScanLoop:
        mov     ax, clrSolid
        mov     dx, clrSolid + 2
        mov     cx, xSize
FillLoop:
        or      [di], ax
        or      [di + 2], dh
        add     di, 3
        dec     cx
        jnz     FillLoop
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment current scanline pointer.
;
        mov     di, pDstScan
        bmScanInc di, ds, cDstScanSeg, WORD PTR dyDst, WORD PTR cScan, cDstFillBytes
        mov     pDstScan, di
        jmp     SolidScanLoop
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     26
mempBltFD2424rE      ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                  Solid   BLT, 24BPP, rop = F                               ;
;                                                                            ;
;----------------------------------------------------------------------------;

mempBltFD2424rF      PROC NEAR
        xor     ax, ax
        not     ax
        mov     clrSolid, ax
        mov     clrSolid + 2, ax
        jmp     mempBltFD2424rC
mempBltFD2424rF      ENDP

_TEXT           ENDS
                END
