.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: BitBLT 24BPP source and pattern to 24BPP destination bitmap      ;
;                                                                            ;
;       24BPP BitBLT combines a rectangular region of a source bitmap,       ;
;       pattern, and destination bitmap using a ternary ROP.  The ternary    ;
;       ROP is broken down into terms used to evaluate a polynomial that     ;
;       describes the ROP.  This procedure is written for functionality,     ;
;       not for performance.  Cases when only a pattern and destination or   ;
;       a source and destination are handled in other procedures using       ;
;       hard-coded routines for each ROP combination.  The theory being      ;
;       that calls using all three components of a ternary ROP are very      ;
;       rare and infrequent.                                                 ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/10/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE COMMON.INC
                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN xlateRop : BYTE

pDst            EQU     [bp + 38]
pDstSegmnt      EQU     [bp + 40]
pDstOffset      EQU     [bp + 38]
dyDst           EQU     [bp + 36]
cDstScanSeg     EQU     [bp + 34]
cDstFillBytes   EQU     [bp + 32]
xDst            EQU     [bp + 30]
yDst            EQU     [bp + 28]
pSrc            EQU     [bp + 24]
pSrcSegmnt      EQU     [bp + 26]
pSrcOffset      EQU     [bp + 24]
dySrc           EQU     [bp + 22]
cSrcScanSeg     EQU     [bp + 20]
cSrcFillBytes   EQU     [bp + 18]
xSrc            EQU     [bp + 16]
ySrc            EQU     [bp + 14]
pPat            EQU     [bp + 10]
pPatSegmnt      EQU     [bp + 12]
pPatOffset      EQU     [bp + 10]
xSize           EQU     [bp + 8]
ySize           EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
pPatScan        EQU     [bp - 6]
cSrcScan        EQU     [bp - 8]
cDstScan        EQU     [bp - 10]
xSrcRight       EQU     [bp - 12]
xDstRight       EQU     [bp - 14]
xDir            EQU     [bp - 16]
Flags           EQU     [bp - 18]
pPatBegin       EQU     [bp - 20]
pPatEnd         EQU     [bp - 22]
pScanEnd        EQU     [bp - 24]
cScanEnd        EQU     [bp - 26]

memBltPSD_ColorToColor  PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 28
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pattern segment.
;
        mov     fs, pPatSegmnt
;
; Check vertical BLT direction.
;
CheckYDir:
        mov     ax, ySrc
        mov     bx, yDst
        cmp     ax, bx
        jb      @F
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     BYTE PTR Flags, bTopToBottom
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
        jmp     CalcConst
;
; BLT from bottom to top.
; Get pointer to first source scanline.
;
@@:     mov     BYTE PTR Flags, bBottomToTop
        mov     cx, ySize
        dec     cx
        add     ax, cx
        bmScanAddrDec cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, bx
        add     ax, cx
        mov     yDst, ax
        bmScanAddrDec cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
; Calculate destination constants.
;
CalcConst:
        mov     ax, xSrc
        mov     bx, xDst                ; ax = xDstLeft
        mov     dx, xSize
        dec     dx
;
; Check x direction and do BLT.
;
CheckXDir:
        add     si, ax
        add     si, ax
        add     si, ax
        add     di, bx
        add     di, bx
        add     di, bx
        mov     cx, dx
        add     cx, dx
        add     cx, dx
        cmp     ax, bx
        jb      XDirRL
;
; BLT from left to right.
;
XDirLR:
;        or      BYTE PTR Flags, bLeftToRight
;
; Increment scanline pointer to first pixel WORD.
;
        mov     WORD PTR xDir, 3
        mov     cScanEnd, cx
        xor     dx, dx
        jmp     ScanLoop
;
; BLT from right to left.
;
XDirRL:
;       or      BYTE PTR Flags, bRightToLeft    ; bRightToLeft == 0
;
; Increment scanline pointer to first pixel BYTE.
;
        add     si, cx
        add     di, cx
        neg     cx
        mov     cScanEnd, cx
        mov     WORD PTR xDir, -3
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;bx = rop
;si = pSrcScan
;di = pDstScan
;
ScanLoop:
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, pPatOffset
        add     ax, dx
        sub     ax, fs:[bx][BRUSH_X]
        and     ax, 7
        mov     bx, ax
        add     bx, ax
        add     bx, ax
        mov     xDst, bx
        mov     bx, rop
        mov     bl, xlateRop[bx]
        mov     rop, bx
        mov     ax, yDst
ScanLoopTop:
;
;fs:[bx] = pattern
;ds:[si] = source
;es:[di] = destination
;cx      = x index into patttern
;
; Calc end of scanline.
;
        mov     bx, di
        add     bx, cScanEnd
        mov     pScanEnd, bx
;
; Get scanline of pattern.
;
        mov     bx, pPatOffset
        sub     ax, fs:[bx][BRUSH_Y]            ; Align pattern vertically
        and     ax, 7
        imul    ax, 24
        add     bx, ax
        add     bx, BRUSH_COLOR
        mov     pPatBegin, bx
        mov     dx, bx
        add     dx, 21
        mov     pPatEnd, dx
        add     bx, xDst                        ; Align pattern horizontally
InnerLoop:
        rop3_24 [si], fs:[bx], rop
        mov     es:[di], ax
        mov     es:[di + 2], dl
        cmp     di, pScanEnd
        je      NextScan
        add     si, xDir
        add     di, xDir
        add     bx, xDir
        cmp     bx, pPatBegin
        jb      WrapPatLeft
        cmp     bx, pPatEnd
        jbe     InnerLoop
WrapPatRight:
        mov     bx, pPatBegin
        jmp     InnerLoop
WrapPatLeft:
        mov     bx, pPatEnd
        jmp     InnerLoop
;
; Decrement scanline count.
;
NextScan:
        dec     WORD PTR ySize
        jz      Exit
;
; Test for vertical BLT direction.
;
        test    BYTE PTR Flags, bTopToBottom
        jz      @F
;
; Increment pointer to next source, pattern, and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     ax, yDst
        inc     ax
        mov     yDst, ax
        jmp     ScanLoopTop
;
; Decrement pointer to next source and destination scanlines.
;
@@:     mov     si, pSrcScan
        bmScanDec si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanDec di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        mov     ax, yDst
        dec     ax
        mov     yDst, ax
        jmp     ScanLoopTop
Exit:
        cld
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     38

memBltPSD_ColorToColor  ENDP

_TEXT           ENDS
                END
