;----------------------------------------------------------------------------;
;                                                                            ;
; Function: General purpose DIB translation routine                          ;
;                                                                            ;
;       Converting between device bitmap and DIBs involves passing a pointer ;
;       to a scanline translation routine that will carry out the respective ;
;       operation.  Two routines are made, one for translating DIBs to       ;
;       device bitmaps, the other for translating device bitmaps to DIBs.    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/09/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE COMMON.INC           
                INCLUDE BITBLT.INC

_DATA	        SEGMENT WORD PUBLIC 'DATA'

;GDIModuleName   DB 'GDI', 0

EXTERN mempDIB4Pal : DWORD

_DATA	        ENDS
CONST	        SEGMENT WORD PUBLIC 'CONST'
CONST	        ENDS
_BSS	        SEGMENT WORD PUBLIC 'BSS'
_BSS	        ENDS
DGROUP	        GROUP CONST, _BSS, _DATA

_TEXT           SEGMENT PUBLIC WORD 'CODE'
.386


EXTERN GetModuleHandle : FAR
EXTERN GetProcAddress  : FAR
EXTERN mempMatchRGB    : NEAR

dibInfo         EQU     [bp + 30]
dibInfoSegmnt   EQU     [bp + 32]
dibInfoOffset   EQU     [bp + 30]
dibBits         EQU     [bp + 26]
dibSegmnt       EQU     [bp + 28]
dibOffset       EQU     [bp + 26]
dibWidthBytes   EQU     [bp + 24]
bmBits          EQU     [bp + 20]
bmSegmnt        EQU     [bp + 22]
bmOffset        EQU     [bp + 20]
bmWidthBytes    EQU     [bp + 18]
bmScanSeg       EQU     [bp + 16]
bmFillBytes     EQU     [bp + 14]
cWidth          EQU     [bp + 12]
iStart          EQU     [bp + 10]
cScans          EQU     [bp + 8]
lpXlate         EQU     [bp + 4]
XlateSegmnt     EQU     [bp + 6]
XlateOffset     EQU     [bp + 4]

bmScanOffset    EQU     [bp - 2]
bmScanCount     EQU     [bp - 4]
pfnXlateScan    EQU     [bp - 6]
AndMask         EQU     [bp - 8]
XorMask         EQU     [bp - 9]
clrFore         EQU     [bp - 8]
clrBack         EQU     [bp - 9]
clrMax          EQU     [bp - 12]
pfnMatch24      EQU     [bp - 16]

memMonoToDib1   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     ax, cWidth
        add     ax, 7
        shr     ax, 3
        mov     cWidth, ax
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        mov     fs:[bx], eax
        not     eax
        mov     fs:[bx + 4], eax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     si
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib1   ENDP

memMonoToDib4   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        mov     cx, 15
@@:     mov     fs:[bx], eax
        add     bx, 4
        dec     cx
        jnz     @B
        not     eax
        mov     fs:[bx], eax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 4
        inc     si
ByteLoop:
        add     ah, ah
        sbb     al, al
        and     al, 0F0h
        dec     cx
        jz      StoreLast
        lea     bx, clrBack
        add     ah, ah
        sbb     dh, dh
        and     dh, 0Fh
        or      al, dh
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
StoreLast:
        mov     es:[di], al
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib4   ENDP

memMonoToDib8   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        mov     cx, 255
@@:     mov     fs:[bx], eax
        add     bx, 4
        dec     cx
        jnz     @B
        not     eax
        mov     fs:[bx], eax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 8
        inc     si
ByteLoop:
        add     ah, ah
        sbb     al, al
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib8   ENDP

memMonoToDib24  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ah, [si]
        mov     dl, 8
        inc     si
ByteLoop:
        add     ah, ah
        sbb     al, al
        mov     es:[di], al
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], al
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     dec     dl
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memMonoToDib24  ENDP

memColorToDib1  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        xor     eax, eax
        mov     fs:[bx], eax
        not     eax
        mov     fs:[bx + 4], eax
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
        mov     dl, 8
XlateLoop:
        mov     al, [si]
        push    ax
        mov     al, [si + 1]
        push    ax
        mov     al, [si + 2]
        push    ax
        push    2
        mov     bx, XlateOffset
        call    mempMatchRGB
        shr     al, 1
        adc     dh, dh
        dec     cx
        jz      StoreLast
        add     si, 3
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 8
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
StoreLast:
        dec     dl
        mov     cl, dl
        shl     dh, cl
        mov     es:[di], dh
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib1  ENDP

memColorToDib4  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        mov     si, OFFSET mempDIB4Pal
        mov     cx, 16
@@:     mov     eax, [si]
        mov     fs:[bx], eax
        add     si, 4
        add     bx, 4
        dec     cx
        jnz     @B
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        push    ax
        mov     al, [si + 1]
        push    ax
        mov     al, [si + 2]
        push    ax
        push    16
        mov     bx, XlateOffset
        call    mempMatchRGB
        shl     al, 4
        dec     cx
        jz      StoreLast
        mov     dl, al
        mov     al, [si + 3]
        push    ax
        mov     al, [si + 4]
        push    ax
        mov     al, [si + 5]
        push    ax
        push    16
        mov     bx, XlateOffset
        call    mempMatchRGB
        or      dl, al
        mov     es:[di], dl
        dec     cx
        jz      NextScan
        add     si, 6
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
StoreLast:
        mov     es:[di], al
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib4  ENDP

memColorToDib8  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        xor     ax, ax
        xor     dl, dl
        mov     cx, 0100h
FillRGB:
        mov     fs:[bx], al
        mov     fs:[bx + 1], ah
        mov     fs:[bx + 2], dl
        add     al, 85
        jc      @F
        add     bx, 4
        dec     cx
        jnz     FillRGB
        jmp     ExitFillRGB
@@:     xor     al, al
        add     ah, 36
        jc      @F
        add     bx, 4
        dec     cx
        jnz     FillRGB
        jmp     ExitFillRGB
@@:     xor     ah, ah
        add     dl, 36
        add     bx, 4
        dec     cx
        jnz     FillRGB
ExitFillRGB:
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:

        mov     al, [si]
        shr     al, 6
        mov     ah, [si + 1]
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        mov     ah, [si + 2]
        and     ah, 011100000b
        or      al, ah
        mov     es:[di], al
        dec     cx
        jz      NextScan
        add     si, 3
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, es
        add     ax, __AHIncr
        mov     es, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib8  ENDP

memColorToDib24 PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     ds, dx
        mov     si, ax
        mov     bmScanOffset, si
;
; Pointer to first DIB scanline.
;
        les     di, dibBits
ScanLoop:
        mov     dibOffset, di
        mov     cx, cWidth
XlateLoop:
        mov     ax, [si]
        mov     dl, [si + 2]
        mov     es:[di], al
        add     si, 3
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], ah
        inc     di                              ; Segment wrap?
        jnz     @F
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
@@:     mov     es:[di], dl
        dec     cx
        jz      NextScan
        inc     di                              ; Segment wrap?
        jnz     XlateLoop
        mov     bx, es
        add     bx, __AHIncr
        mov     es, bx
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     si, bmScanOffset
        bmScanDec si, ds, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, si
;
; Increment DIB scanline pointer.
;
        mov     di, dibOffset                   ; Update offset register
        add     di, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     es, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memColorToDib24 ENDP

memDib1ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        mov     ax, cWidth
        add     ax, 7
        shr     ax, 3
        mov     cWidth, ax
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
        RGB2Mono fs:[bx]
        sbb     dl, dl
        mov     XorMask, dl
        add     bx, 4
        RGB2Mono fs:[bx]
        sbb     dh, dh
        xor     dl, dh
        mov     AndMask, dl
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        and     al, AndMask
        xor     al, XorMask
        mov     es:[di], al
        dec     cx
        jz      NextScan
        inc     di
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib1ToMono   ENDP

memDib4ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     dl, 4
XlateLoop:
        mov     bl, [si]
        shr     bl, 2
        and     bl, 03Ch
        xor     bh, bh
        add     bx, XlateOffset
        RGB2Mono fs:[bx]
        adc     dh, dh
        dec     cx
        jz      StoreLastPartial
        mov     bl, [si]
        and     bx, 0Fh
        shl     bx, 2
        add     bx, XlateOffset
        RGB2Mono fs:[bx]
        adc     dh, dh
        dec     cx
        jz      StoreLast
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 4
        inc     di
        jmp     XlateLoop
StoreLastPartial:
        mov     cl, dl
        add     cl, cl
        dec     cl
        shl     dh, cl
        mov     es:[di], dh
        jmp     NextScan
StoreLast:
        mov     cl, dl
        dec     cl
        add     cl, cl
        shl     dh, cl
        mov     es:[di], dh
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib4ToMono   ENDP

memDib8ToMono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     dl, 8
XlateLoop:
        xor     bh, bh
        mov     bl, [si]
        shl     bx, 2
        add     bx, XlateOffset
        RGB2Mono fs:[bx]
        adc     dh, dh
        dec     cx
        jz      StoreLast
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
NewSegment:
        dec     dl
        jnz     XlateLoop
        mov     es:[di], dh
        mov     dl, 8
        inc     di
        jmp     XlateLoop
StoreLast:
        dec     dl
        mov     cl, dl
        shl     dh, cl
        mov     es:[di], dh
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     NewSegment
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib8ToMono   ENDP

memDib24ToMono  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
        mov     bx, 0800h
XlateLoop:
        xor     ah, ah
        mov     al, [si]
        inc     si
        jnz     @F
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     add     al, al
        adc     ah, 0
        mov     al, [si]
        inc     si
        jnz     @F
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     add     al, al
        adc     ah, ah
        shr     ah, 2
        rol     bl, 1
        dec     cx
        jz      NextScan
        dec     bh
        jnz     @F
        mov     es:[di], bl
        mov     bx, 0800h
        inc     di
@@:     inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     XlateLoop
NextScan:
        dec     bh
        mov     cl, bh                          ; Update last monochrome byte
        shl     bh, cl
        mov     es:[di], bl
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib24ToMono  ENDP

memDib1ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     dl, [si]
        mov     dh, 8
        inc     si                              ; Segment wrap?
        jz      UpdateSegment
ByteLoop:
        xor     bx, bx
        add     dl, dl
        adc     bx, 0
        shl     bx, 2
        add     bx, XlateOffset
        mov     ax, fs:[bx]
        mov     es:[di], ax
        mov     al, fs:[bx + 2]
        mov     es:[di + 2], al
        dec     cx
        jz      NextScan
        add     di, 3
        dec     dh
        jnz     ByteLoop
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     ByteLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib1ToColor  ENDP

memDib4ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     dh, [si]
        mov     bl, dh
        shr     bl, 2
        and     bx, 003Ch
        add     bx, XlateOffset
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        mov     es:[di], ax
        dec     cx
        jz      StoreLast
        mov     bl, dh
        and     bx, 000Fh
        shl     bx, 2
        add     bx, XlateOffset
        mov     dh, fs:[bx]
        mov     ax, fs:[bx + 1]
        mov     es:[di + 2], dx
        mov     es:[di + 4], ax
        dec     cx
        jz      NextScan
        add     di, 6
        inc     si                              ; Segment Wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
StoreLast:
        mov     es:[di + 2], dl
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib4ToColor  ENDP

memDib8ToColor  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     XlateOffset, bx
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        xor     bh, bh
        mov     bl, [si]
        inc     si                              ; Segment Wrap?
        jz      UpdateSegment
FirstPixel:
        shl     bx, 2
        add     bx, XlateOffset
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        mov     es:[di], ax
        dec     cx
        jz      StoreLast
        xor     bh, bh
        mov     bl, [si]
        shl     bx, 2
        add     bx, XlateOffset
        mov     dh, fs:[bx]
        mov     ax, fs:[bx + 1]
        mov     es:[di + 2], dx
        mov     es:[di + 4], ax
        dec     cx
        jz      NextScan
        add     di, 6
        inc     si                              ; Segment Wrap?
        jnz     XlateLoop
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     XlateLoop
StoreLast:
        mov     es:[di + 2], dl
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
UpdateSegment:
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
        jmp     FirstPixel
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib8ToColor  ENDP

memDib24ToColor PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    fs
        push    si
        push    di
;
; Get pointer to first device bitmap scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, bmSegmnt, bmOffset
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Pointer to first DIB scanline.
;
        lds     si, dibBits
ScanLoop:
        mov     dibOffset, si
        mov     cx, cWidth
XlateLoop:
        mov     al, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     ah, [si]
        inc     si
        jnz     @F
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
@@:     mov     dl, [si]
        mov     es:[di], ax
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        inc     si                              ; Segment wrap?
        jnz     XlateLoop
        mov     bx, ds
        add     bx, __AHIncr
        mov     ds, bx
        jmp     XlateLoop
NextScan:
        dec     WORD PTR cScans
        jz      Exit
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
;
; Increment DIB scanline pointer.
;
        mov     si, dibOffset                   ; Update offset register
        add     si, dibWidthBytes
        jnc     ScanLoop
        mov     ax, dibSegmnt                   ; Update segment register
        add     ax, __AHIncr
        mov     ds, ax
        mov     dibSegmnt, ax
        jmp     ScanLoop
Exit:
        pop     di
        pop     si
        pop     fs
        pop     es
        pop     ds
        leave
        ret     30
memDib24ToColor ENDP

_TEXT           ENDS
                END
