.386

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: SrcBLT 1BPP source bitmap to 24BPP destination bitmap            ;
;                                                                            ;
;       1BPP source BLT copies a rectangular region of a source bitmap       ;
;       to a same sized rectangular region on a destiantion bitmap using     ;
;       a binary ROP to combine source pixels with destination pixels.       ;
;       The source and destination cannot be the same so the direction is    ;
;       always top to bottom, left to right.  The procedure uses a generic   ;
;       main loop that calls individual scanline BLT procedures based upon   ;
;       the ROP.                                                             ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/21/93 Dave Schmenk - wrote it.                                    ;
;       09/01/93 Dave Schmenk - modified for 24BPP from 8BPP.                ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

                INCLUDE BITBLT.INC

_TEXT           SEGMENT PUBLIC WORD USE16 'CODE'

EXTERN LeftMask1  : BYTE
EXTERN RightMask1 : BYTE

pDst            EQU     [bp + 42]
pDstSegmnt      EQU     [bp + 44]
pDstOffset      EQU     [bp + 42]
dyDst           EQU     [bp + 40]
cDstScanSeg     EQU     [bp + 38]
cDstFillBytes   EQU     [bp + 36]
xDst            EQU     [bp + 34]
yDst            EQU     [bp + 32]
pSrc            EQU     [bp + 28]
pSrcSegmnt      EQU     [bp + 30]
pSrcOffset      EQU     [bp + 28]
dySrc           EQU     [bp + 26]
cSrcScanSeg     EQU     [bp + 24]
cSrcFillBytes   EQU     [bp + 22]
xSrc            EQU     [bp + 20]
ySrc            EQU     [bp + 18]
xSize           EQU     [bp + 16]
ySize           EQU     [bp + 14]
clrFore         EQU     [bp + 10]
clrBack         EQU     [bp + 6]
rop             EQU     [bp + 4]

pSrcScan        EQU     [bp - 2]
pDstScan        EQU     [bp - 4]
cSrcScan        EQU     [bp - 6]
cDstScan        EQU     [bp - 8]
FirstShift      EQU     [bp - 10]
cDstByte        EQU     [bp - 12]
pfnScanBlt      EQU     [bp - 14]
clrAnd          EQU     [bp - 18]
clrXor          EQU     [bp - 22]

memBltSD124Tbl  DW      0000h,         memBltSD124r1, memBltSD124r2, memBltSD124r3
                DW      memBltSD124r4, 0000h,         memBltSD124r6, memBltSD124r7
                DW      memBltSD124r8, memBltSD124r9, 0000h,         memBltSD124rB
                DW      memBltSD124rC, memBltSD124rD, memBltSD124rE, 0000h

memBltSD_MonoToColor    PROC NEAR
        
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    ds
        push    es
        push    si
        push    di
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcScanSeg, dySrc, cSrcScan, pSrcSegmnt, pSrcOffset
        mov     ds, dx
        mov     si, ax
;
; Get pointer to first destination scanline.
;
        mov     ax, yDst
        bmScanAddrInc cDstScanSeg, dyDst, cDstScan, pDstSegmnt, pDstOffset
        mov     es, dx
        mov     di, ax
;
;
; Calculate source constants.
;
CalcConst:
        mov     ax, xSrc                ; ax = xSrcLeft
        mov     bx, ax
        and     al, 7                   ; al = shift count to first pixel
        mov     ah, 8
        sub     ah, al                  ; ah = pixel count in first byte
        mov     FirstShift, ax
;
; BLT from left to right.
;
; Increment scanline pointer to first pixel BYTE.
;
        shr     bx, 3
        add     si, bx
        add     di, xDst
        add     di, xDst
        add     di, xDst
;
; Get AND and XOR values to convert colors
;
        mov     ax, clrBack
        mov     dx, clrFore
        xor     ax, dx
        mov     clrAnd, ax
        mov     clrXor, dx
        mov     al, clrBack + 2
        mov     dl, clrFore + 2
        xor     al, dl
        mov     clrAnd + 2, al
        mov     clrXor + 2, dl
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;di = pDstScan
;
RopFunc:
        mov     pSrcScan, si
        mov     pDstScan, di
        mov     bx, rop
        add     bx, bx
        mov     rop, bx
        mov     bx, memBltSD124Tbl[bx]
        jmp     bx
memBltSD_MonoToColor    ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 1                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r1   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        mov     bh, es:[di]
        or      al, bh
        not     al
        mov     es:[di], al
        mov     bh, es:[di + 1]
        or      ah, bh
        not     ah
        mov     es:[di + 1], ah
        mov     bh, es:[di + 2]
        or      dl, bh
        not     dl
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r1   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 2                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r2   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        not     ax
        not     dl
        and     es:[di], ax
        and     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r2   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 3                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r3   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        not     ax
        not     dl
        mov     es:[di], ax
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r3   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 4                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r4   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        mov     bh, es:[di]
        not     bh
        and     al, bh
        mov     es:[di], al
        mov     bh, es:[di + 1]
        not     bh
        and     ah, bh
        mov     es:[di + 1], ah
        mov     bh, es:[di + 2]
        not     bh
        and     dl, bh
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r4   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 6                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r6   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        xor     es:[di], ax
        xor     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r6   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 7                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r7   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        and     ax, es:[di]
        not     ax
        mov     es:[di], ax
        and     dl, es:[di + 2]
        not     dl
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r7   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 8                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r8   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        and     es:[di], ax
        and     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r8   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = 9                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124r9   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        xor     ax, es:[di]
        not     ax
        mov     es:[di], ax
        xor     dl, es:[di + 2]
        not     dl
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124r9   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = B                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124rB   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        not     ax
        not     dl
        or      es:[di], ax
        or      es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124rB   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = C                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124rC   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        mov     es:[di], ax
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124rC   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = D                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124rD   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        mov     bh, es:[di]
        not     bh
        or      al, bh
        mov     es:[di], al
        mov     bh, es:[di + 1]
        not     bh
        or      ah, bh
        mov     es:[di + 1], ah
        mov     bh, es:[di + 2]
        not     bh
        or      dl, bh
        mov     es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124rD   ENDP

;----------------------------------------------------------------------------;
;                                                                            ;
;                          Scan BLT 1BPP, rop = E                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

memBltSD124rE   PROC NEAR
ScanBlt:
        mov     cx, FirstShift
        mov     bl, ch
        mov     dh, [si]
        inc     si
        shl     dh, cl
        mov     cx, xSize
ScanLoop:
        add     dh, dh
        sbb     ax, ax
        mov     dl, al
        and     ax, clrAnd
        and     dl, clrAnd + 2
        xor     ax, clrXor
        xor     dl, clrXor + 2
        or      es:[di], ax
        or      es:[di + 2], dl
        dec     cx
        jz      NextScan
        add     di, 3
        dec     bl
        jnz     ScanLoop
        mov     dh, [si]
        mov     bl, 8
        inc     si
        jmp     ScanLoop
NextScan:
;
; Decrement scanline count.
;
        dec     WORD PTR ySize
        jz      Exit
;
; Increment pointer to next source and destination scanlines.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcScanSeg, WORD PTR dySrc, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        mov     di, pDstScan
        bmScanInc di, es, cDstScanSeg, WORD PTR dyDst, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, di
        jmp     ScanBlt
Exit:
        pop     di
        pop     si
        pop     es
        pop     ds
        leave
        ret     42
memBltSD124rE   ENDP

_TEXT           ENDS
                END
