.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Convert between monochrome and color brushes.                    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       09/21/93 Dave Schmenk - converted from C code.                       ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.CODE
.386

memConvertMonoBrush     PROC NEAR USES ds si di  \
                                lpBrush : DWORD

                        LOCAL   clrAnd  : DWORD, \
                                clrXor  : DWORD
        lds     si, lpBrush
        mov     al, BYTE PTR [si][BRUSH_CLR_FORE]
        xor     ah, ah
        add     al, BYTE PTR [si][BRUSH_CLR_FORE + 1]
        adc     ah, 0
        add     al, BYTE PTR [si][BRUSH_CLR_FORE + 2]
        adc     ah, 0
        add     ah, 255
        sbb     dl, dl
        mov     al, BYTE PTR [si][BRUSH_CLR_BACK]
        xor     ah, ah
        add     al, BYTE PTR [si][BRUSH_CLR_BACK + 1]
        adc     ah, 0
        add     al, BYTE PTR [si][BRUSH_CLR_BACK + 2]
        adc     ah, 0
        add     ah, 255
        sbb     dh, dh
        xor     dl, dh
        mov     al, [si][BRUSH_PAT]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO], al
        mov     al, [si][BRUSH_PAT + 1]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 1], al
        mov     al, [si][BRUSH_PAT + 2]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 2], al
        mov     al, [si][BRUSH_PAT + 3]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 3], al
        mov     al, [si][BRUSH_PAT + 4]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 4], al
        mov     al, [si][BRUSH_PAT + 5]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 5], al
        mov     al, [si][BRUSH_PAT + 6]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 6], al
        mov     al, [si][BRUSH_PAT + 7]
        and     al, dl
        xor     al, dh
        mov     [si][BRUSH_MONO + 7], al
        mov     ax, WORD PTR [si][BRUSH_CLR_FORE]
        mov     dx, WORD PTR [si][BRUSH_CLR_BACK]
        xor     ax, dx
        mov     WORD PTR clrAnd, ax
        mov     WORD PTR clrXor, dx
        mov     al, BYTE PTR [si][BRUSH_CLR_FORE + 2]
        mov     dl, BYTE PTR [si][BRUSH_CLR_BACK + 2]
        xor     al, dl
        mov     BYTE PTR clrAnd + 2, al
        mov     BYTE PTR clrXor + 2, dl
        mov     di, si
        add     si, BRUSH_PAT
        add     di, BRUSH_COLOR
        mov     cx, 8
ConvertColorLoop:
        mov     bl, [si]
        inc     si
        add     bl, bl
        sbb     ax, ax
        mov     dl, al
        and     ax, WORD PTR clrAnd
        and     dl, BYTE PTR clrAnd + 2
        xor     ax, WORD PTR clrXor
        xor     dl, BYTE PTR clrXor + 2
        mov     [di], ax
        mov     al, dl
        add     bl, bl
        sbb     dx, dx
        mov     ah, dl
        and     ah, BYTE PTR clrAnd
        and     dx, WORD PTR clrAnd + 1
        xor     ah, BYTE PTR clrXor
        xor     dx, WORD PTR clrXor + 1
        mov     [di + 2], ax
        mov     [di + 4], dx
        add     bl, bl
        sbb     ax, ax
        mov     dl, al
        and     ax, WORD PTR clrAnd
        and     dl, BYTE PTR clrAnd + 2
        xor     ax, WORD PTR clrXor
        xor     dl, BYTE PTR clrXor + 2
        mov     [di + 6], ax
        mov     al, dl
        add     bl, bl
        sbb     dx, dx
        mov     ah, dl
        and     ah, BYTE PTR clrAnd
        and     dx, WORD PTR clrAnd + 1
        xor     ah, BYTE PTR clrXor
        xor     dx, WORD PTR clrXor + 1
        mov     [di + 8], ax
        mov     [di + 10], dx
        add     bl, bl
        sbb     ax, ax
        mov     dl, al
        and     ax, WORD PTR clrAnd
        and     dl, BYTE PTR clrAnd + 2
        xor     ax, WORD PTR clrXor
        xor     dl, BYTE PTR clrXor + 2
        mov     [di + 12], ax
        mov     al, dl
        add     bl, bl
        sbb     dx, dx
        mov     ah, dl
        and     ah, BYTE PTR clrAnd
        and     dx, WORD PTR clrAnd + 1
        xor     ah, BYTE PTR clrXor
        xor     dx, WORD PTR clrXor + 1
        mov     [di + 14], ax
        mov     [di + 16], dx
        add     bl, bl
        sbb     ax, ax
        mov     dl, al
        and     ax, WORD PTR clrAnd
        and     dl, BYTE PTR clrAnd + 2
        xor     ax, WORD PTR clrXor
        xor     dl, BYTE PTR clrXor + 2
        mov     [di + 18], ax
        mov     al, dl
        add     bl, bl
        sbb     dx, dx
        mov     ah, dl
        and     ah, BYTE PTR clrAnd
        and     dx, WORD PTR clrAnd + 1
        xor     ah, BYTE PTR clrXor
        xor     dx, WORD PTR clrXor + 1
        mov     [di + 20], ax
        mov     [di + 22], dx
        add     di, 24
        dec     cx
        jz      LoopExit
        jmp     ConvertColorLoop
LoopExit:
        ret
memConvertMonoBrush     ENDP

memConvertColorBrush    PROC NEAR USES ds si di \
                                lpBrush : DWORD

        lds     si, lpBrush
        mov     ax, [si][BRUSH_CLR_BACK]
        mov     dl, [si][BRUSH_CLR_BACK + 2]
        mov     di, si
        add     si, BRUSH_MONO
        add     di, BRUSH_COLOR
        mov     cx, 8
ConvertMonoLoop:
        xor     dh, dh
        cmp     ax, [di]
        jne     @F
        cmp     dl, [di + 2]
        jne     @F
        or      dh, 080h
@@:     cmp     ax, [di + 3]
        jne     @F
        cmp     dl, [di + 5]
        jne     @F
        or      dh, 040h
@@:     cmp     ax, [di + 6]
        jne     @F
        cmp     dl, [di + 8]
        jne     @F
        or      dh, 020h
@@:     cmp     ax, [di + 9]
        jne     @F
        cmp     dl, [di + 11]
        jne     @F
        or      dh, 010h
@@:     cmp     ax, [di + 12]
        jne     @F
        cmp     dl, [di + 14]
        jne     @F
        or      dh, 008h
@@:     cmp     ax, [di + 15]
        jne     @F
        cmp     dl, [di + 17]
        jne     @F
        or      dh, 004h
@@:     cmp     ax, [di + 18]
        jne     @F
        cmp     dl, [di + 20]
        jne     @F
        or      dh, 002h
@@:     cmp     ax, [di + 21]
        jne     @F
        cmp     dl, [di + 23]
        jne     @F
        or      dh, 001h
@@:     mov     [si], dh
        inc     si
        add     di, 24
        dec     cx
        jnz     ConvertMonoLoop
        ret
memConvertColorBrush    ENDP
 
        END
