.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and get RLE Dibs to color bitmaps.                           ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/28/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

.DATA

PUBLIC mempDIB4Pal
mempDIB4Pal     DD      0000000h, 0800000h, 0008000h, 0808000h
                DD      0000080h, 0800080h, 0008080h, 0C0C0C0h
                DD      0808080h, 0FF0000h, 000FF00h, 0FFFF00h
                DD      00000FFh, 0FF00FFh, 000FFFFh, 0FFFFFFh

.CODE
.386

memRLE8ToColor  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD
                        
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Start decoding RLE bitmap.
;
Decode:
        mov     cl, [si]
        inc     si
        cmp     cl, 0
        je      Escape
;
; Do run length decode.
;
        xor     bh, bh
        mov     bl, [si]
        shl     bx, 2
        add     bx, WORD PTR dibInfo
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], ax
        mov     es:[di + 2], dl
        add     di, 3
        dec     cl
        jnz     @B
        jmp     Decode
Escape:
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     cmp     cl, 2
        ja      Absolute
        je      DeltaSkip
        cmp     cl, 1
        je      EndOfBitmap
;
; End of current scanline.
;
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     Decode
;
; This is absolute mode, just copy the raw pixels into the bitmap.
;
Absolute:
        xor     bh, bh
        mov     bl, [si]
        shl     bx, 2
        add     bx, WORD PTR dibInfo
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], ax
        mov     es:[di + 2], dl
        add     di, 3
        dec     cl
        jnz     Absolute
        test    si, 1                   ; Start decoding on word boundry
        jz      Decode
        inc     si
        jnz     Decode                  ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     Decode
;
; Skip pixels.
;
DeltaSkip:
        sub     di, bmScanOffset
        push    di
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        xor     ah, ah
        mov     al, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     push    ax
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     or      cl, cl
        jz      SkipHorizontal
;
; Skip vertical scanlines.
;        
SkipVertical:
        dec     cScans
        jz      SkipExit
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        dec     cl
        jnz     SkipVertical
        mov     bmScanOffset, di
;
; Skip horizontal scanlines
;
SkipHorizontal:
        pop     ax
        add     di, ax
        add     di, ax
        add     di, ax
        pop     ax
        add     di, ax
        jmp     Decode
SkipExit:
        pop     ax
        pop     ax
;
; End of bitmap.
;
EndOfBitmap:
        ret        
memRLE8ToColor  ENDP                                

memColorToRLE8  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD,\
                      bmScanEnd    : WORD,\
                      dibSize      : DWORD
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Fill DIBs palette with 3-3-2 RGB ramp.
;
        xor     ax, ax
        xor     dl, dl
        mov     cx, 0100h
FillRGB:
        mov     fs:[bx], al
        mov     fs:[bx + 1], ah
        mov     fs:[bx + 2], dl
        add     al, 85
        jc      @F
        add     bx, 4
        dec     cx
        jnz     FillRGB
        jmp     ExitFillRGB
@@:     xor     al, al
        add     ah, 36
        jc      @F
        add     bx, 4
        dec     cx
        jnz     FillRGB
        jmp     ExitFillRGB
@@:     xor     ah, ah
        add     dl, 36
        add     bx, 4
        dec     cx
        jnz     FillRGB
ExitFillRGB:
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Zero out DIB size.
;
        mov     dibSize, 0
EncodeScanLine:
        mov     ax, di
        add     ax, cWidth
        add     ax, cWidth
        add     ax, cWidth
        mov     bmScanEnd, ax
EncodeNextField:
        cmp     di, bmScanEnd
        jae     EndOfScanLine
        mov     ax, es:[di]                     ; Load starting pixel
        mov     dl, es:[di + 2]
        add     di, 3
        cmp     di, bmScanEnd
        jae     Encode1Pixel                    ; 1 pixel left
        cmp     ax, es:[di]                     ; Get next pixel
        jne     EncodeAbsolute                  ; Not run length
        cmp     dl, es:[di + 2]
        jne     EncodeAbsolute
        mov     dh, 1
EncodeRunLength:
        cmp     dh, 0FFh                        ; Runs can only be 255 long
        je      SaveRunLength
        inc     dh
        add     di, 3
        cmp     di, bmScanEnd                   ; Don't go past end of scanline
        jae     SaveRunLength
        cmp     ax, es:[di]                     ; Get next pixel
        jne     SaveRunLength
        cmp     dl, es:[di + 2]
        je      EncodeRunLength
SaveRunLength:
        shr     al, 6
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        and     dl, 011100000b
        or      al, dl
        mov     ah, al
        mov     al, dh
        call    mempStoreRLE
        inc     dibSize
        jmp     EncodeNextField
Encode2Pixels:
        mov     ax, es:[di]
        mov     dl, es:[di + 2]
        shr     al, 6
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        and     dl, 011100000b
        or      al, dl
        add     di, 3
        mov     ah, al
        mov     al, 1
        call    mempStoreRLE
        inc     dibSize
        mov     ax, es:[di]
        mov     dl, es:[di + 2]
Encode1Pixel:
        shr     al, 6
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        and     dl, 011100000b
        or      al, dl
        add     di, 3
        mov     ah, al
        mov     al, 1
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
;
; Look for two identical pixels before ending the absolute run.
;
EncodeAbsolute:
        sub     di, 3                           ; Move back to first pixel
        push    di                              ; Save it
        add     di, 3
        mov     dh, 1
ScanAbsolute:
        cmp     dh, 0FFh
        je      SaveAbsoluteRun
        inc     dh
        mov     ax, es:[di]
        mov     dl, es:[di + 2]
        add     di, 3
        cmp     di, bmScanEnd
        jae     SaveAbsoluteRun
        cmp     ax, es:[di]
        jne     ScanAbsolute
        cmp     dl, es:[di + 2]
        jne     ScanAbsolute
        cmp     dh, 3                           ; Need at least 3 pixels in absolute run
        jb      ScanAbsolute
SaveAbsoluteRun:
        pop     di                              ; Return to beginning of run
        cmp     dh, 2
        ja      @F
        jmp     Encode2Pixels                   ; Premature end of scanline
@@:     xor     al, al
        mov     ah, dh
        call    mempStoreRLE
        inc     dibSize
StoreAbsolute:
        mov     al, es:[di]
        shr     al, 6
        mov     ah, es:[di + 1]
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        mov     ah, es:[di + 2]
        and     ah, 011100000b
        or      al, ah
        add     di, 3
        cmp     dh, 1
        je      @F                              ; Check for odd absolute run size
        dec     dh
        mov     bl, al
        mov     al, es:[di]
        shr     al, 6
        mov     ah, es:[di + 1]
        shr     ah, 3
        and     ah, 00011100b
        or      al, ah
        mov     ah, es:[di + 2]
        and     ah, 011100000b
        or      al, ah
        add     di, 3
        mov     ah, al
        mov     al, bl
@@:     call    mempStoreRLE
        inc     dibSize
        dec     dh
        jnz     StoreAbsolute
        jmp     EncodeNextField
;
; End of scanline - put escape code.
;
EndOfScanLine:
        xor     ax, ax
        call    mempStoreRLE
        inc     dibSize
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     EncodeScanLine
;
; End of bitmap - put escape code.
;
EndOfBitmap:
        mov     WORD PTR [si], 0100h
        inc     dibSize
;
; Return image size in ax:dx
;
        mov     ax, WORD PTR dibSize
        mov     dx, WORD PTR dibSize+2
        shl     ax, 1                           ; Mul by 2 to get byte size
        rcl     dx, 1
        ret        
memColorToRLE8  ENDP                                

memRLE4ToColor  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD
                        
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Start decoding RLE bitmap.
;
Decode:
        mov     cl, [si]
        inc     si
        cmp     cl, 0
        je      Escape
;
; Do run length.
;
        mov     bl, [si]
        shr     bx, 2
        and     bx, 003Ch
        add     bx, WORD PTR dibInfo
        mov     al, fs:[bx + 2]
        shl     eax, 16
        mov     ax, fs:[bx]
        mov     bl, [si]
        and     bx, 000Fh
        shl     bx, 2
        add     bx, WORD PTR dibInfo
        mov     dl, fs:[bx + 2]
        shl     edx, 16
        mov     dx, fs:[bx]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     mov     es:[di], ax
        ror     eax, 16
        mov     es:[di + 2], al
        ror     eax, 16
        add     di, 3
        dec     cl
        jz      Decode
        mov     es:[di], dx
        ror     edx, 16
        mov     es:[di + 2], dl
        ror     edx, 16
        add     di, 3
        dec     cl
        jnz     @B
        jmp     Decode
Escape:
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     cmp     cl, 2
        ja      Absolute
        je      DeltaSkip
        cmp     cl, 1
        je      EndOfBitmap
;
; End of current scanline.
;
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     Decode
;
; This is absolute mode, just copy the raw pixels into the bitmap.
;
Absolute:
        mov     bl, [si]
        shr     bx, 2
        and     bx, 003Ch
        add     bx, WORD PTR dibInfo
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        mov     es:[di], ax
        mov     es:[di + 2], dl
        add     di, 3
        mov     bl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     dec     cl
        jz      @F
        and     bx, 000Fh
        shl     bx, 2
        add     bx, WORD PTR dibInfo
        mov     ax, fs:[bx]
        mov     dl, fs:[bx + 2]
        mov     es:[di], ax
        mov     es:[di + 2], dl
        add     di, 3
        dec     cl
        jnz     Absolute
@@:     test    si, 1                   ; Start decoding on word boundry
        jz      Decode
        inc     si
        jnz     Decode                  ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
        jmp     Decode
;
; Skip pixels.
;
DeltaSkip:
        sub     di, bmScanOffset
        push    di
;
; Decrement device bitmap scanline pointer.
;
        mov     di, bmScanOffset
        xor     ah, ah
        mov     al, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     push    ax
        mov     cl, [si]
        inc     si
        jnz     @F                      ; Segment wrap
        mov     dx, ds
        add     dx, __AHIncr
        mov     ds, dx
@@:     or      cl, cl
        jz      SkipHorizontal
;
; Skip vertical scanlines.
;        
SkipVertical:
        dec     cScans
        jz      SkipExit
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        dec     cl
        jnz     SkipVertical
        mov     bmScanOffset, di
;
; Skip horizontal scanlines
;
SkipHorizontal:
        pop     ax
        add     di, ax
        add     di, ax
        add     di, ax
        pop     ax
        add     di, ax
        jmp     Decode
SkipExit:
        pop     ax
        pop     ax
;
; End of bitmap.
;
EndOfBitmap:
        ret        

memRLE4ToColor  ENDP

memColorToRLE4  PROC NEAR USES fs es ds si di, dibInfo   : DWORD, dibBits      : DWORD,\
                                               bmBits    : DWORD, bmWidthBytes : WORD,\
                                               bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                               iStart    : WORD,  cScans       : WORD,\
                                               cWidth    : WORD,  lpXlate      : DWORD
                LOCAL bmScanCount  : WORD,\
                      bmScanOffset : WORD,\
                      bmScanEnd    : WORD,\
                      dibSize      : DWORD
;
; Get pointer to color translation array.
;
        lfs     bx, dibInfo
        add     bx, WORD PTR fs:[bx][BITMAPINFOHEADER.biSize]
        mov     WORD PTR dibInfo, bx
;
; Copy 4BPP palette to DIB.
;
        mov     si, OFFSET mempDIB4Pal
        mov     cx, 16
@@:     mov     eax, [si]
        mov     fs:[bx], eax
        add     si, 4
        add     bx, 4
        dec     cx
        jnz     @B
;
; Get pointer to first scanline.
;
        mov     ax, iStart
        bmScanAddrDec bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     es, dx
        mov     di, ax
        mov     bmScanOffset, di
;
; Get pointer to compressed information.
;
        lds     si, dibBits
;
; Zero out DIB size.
;
        mov     dibSize, 0

EncodeScanLine:
        mov     ax, di
        add     ax, cWidth
        add     ax, cWidth
        add     ax, cWidth
        mov     bmScanEnd, ax
EncodeNextField:
        cmp     di, bmScanEnd
        jae     EndOfScanLine
        mov     ax, es:[di]                     ; Load starting pixel
        mov     dl, es:[di + 2]
        add     di, 3
        cmp     di, bmScanEnd
        jae     Encode1Pixel                    ; 1 pixel left in scanline
        cmp     ax, es:[di]                     ; Get next pixel
        jne     EncodeAbsolute                  ; Not run length
        cmp     dl, es:[di + 2]
        jne     EncodeAbsolute                  ; Not run length
        mov     dh, 1
EncodeRunLength:
        cmp     dh, 0FFh                        ; Runs can only be 255 long
        je      SaveRunLength
        inc     dh
        add     di, 3
        cmp     di, bmScanEnd                   ; Don't go past end of scanline
        jae     SaveRunLength
        cmp     ax, es:[di]                     ; Get next pixel
        jne     SaveRunLength
        cmp     dl, es:[di + 2]
        je      EncodeRunLength
SaveRunLength:
        mov     bx, WORD PTR dibInfo
        push    ax
        mov     al, ah
        push    ax
        push    dx
        push    16
        call    mempMatchRGB
        mov     ah, al
        shl     al, 4
        or      ah, al
        mov     al, dh
        call    mempStoreRLE
        inc     dibSize
        jmp     EncodeNextField
Encode2Pixels:
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        add     di, 3
        shl     al, 4
        mov     dh, al
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        mov     ah, al
        or      ah, dh
        mov     al, 2
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
Encode1Pixel:
        mov     bx, WORD PTR dibInfo
        push    ax
        mov     al, ah
        push    ax
        push    dx
        push    16
        call    mempMatchRGB
        mov     ah, al
        shl     ah, 4
        mov     al, 1
        call    mempStoreRLE
        inc     dibSize
        jmp     EndOfScanLine
;
; Look for two identical pixels before ending the absolute run.
;
EncodeAbsolute:
        sub     di, 3                           ; Move back to first pixel
        push    di                              ; Save it
        add     di, 3
        mov     dh, 1
ScanAbsolute:
        cmp     dh, 0FFh
        je      SaveAbsoluteRun
        inc     dh
        mov     ax, es:[di]
        mov     dl, es:[di + 2]
        add     di, 3
        cmp     di, bmScanEnd
        jae     SaveAbsoluteRun
        cmp     ax, es:[di]
        jne     ScanAbsolute
        cmp     dl, es:[di + 2]
        jne     ScanAbsolute
        cmp     dh, 3                           ; Need at least 3 pixels in absolute run
        jb      ScanAbsolute
SaveAbsoluteRun:
        pop     di                              ; Return to beginning of run
        cmp     dh, 2
        ja      @F
        jmp     Encode2Pixels                   ; Premature end of scanline
@@:     xor     al, al
        mov     ah, dh
        call    mempStoreRLE
        inc     dibSize
StoreAbsolute:
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        add     di, 3
        shl     al, 4
        cmp     dh, 1
        je      @F                              ; Check for odd absolute run size
        dec     dh
        mov     dl, al
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        add     di, 3
        or      al, dl
        cmp     dh, 1
        je      @F                              ; Check for odd absolute run size
        dec     dh
        push    ax
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        add     di, 3
        mov     ah, al
        shl     ah, 4
        pop     bx
        mov     al, bl
        cmp     dh, 1
        je      @F                              ; Check for odd absolute run size
        dec     dh
        push    ax
        mov     bx, WORD PTR dibInfo
        mov     al, es:[di]
        push    ax
        mov     al, es:[di + 1]
        push    ax
        mov     al, es:[di + 2]
        push    ax
        push    16
        call    mempMatchRGB
        add     di, 3
        mov     ah, al
        pop     bx
        or      ah, bh
        mov     al, bl
@@:     call    mempStoreRLE
        inc     dibSize
        dec     dh
        jnz     StoreAbsolute
        jmp     EncodeNextField
;
; End of scanline - put escape code.
;
EndOfScanLine:
        xor     ax, ax
        call    mempStoreRLE
        inc     dibSize
        dec     cScans
        jz      EndOfBitmap
        mov     di, bmScanOffset
        bmScanDec di, es, bmScanSeg, WORD PTR bmWidthBytes, WORD PTR bmScanCount, bmFillBytes
        mov     bmScanOffset, di
        jmp     EncodeScanLine
;
; End of bitmap - put escape code.
;
EndOfBitmap:
        mov     WORD PTR [si], 0100h
        inc     dibSize
;
; Return image size in ax:dx
;
        mov     ax, WORD PTR dibSize
        mov     dx, WORD PTR dibSize+2
        shl     ax, 1                           ; Mul by 2 to get byte size
        rcl     dx, 1
        ret        

memColorToRLE4  ENDP                                

mempStoreRLE    PROC
        mov     [si], ax
        add     si, 2
        jnz     @F
        mov     ax, ds
        add     ax, __AHIncr
        mov     ds, ax
@@:     ret
mempStoreRLE    ENDP

mempMatchRGB    PROC NEAR USES cx dx esi edi,   clrBlue  : WORD, \
                                                clrGreen : WORD, \
                                                clrRed   : WORD, \
                                                count    : WORD
;
; Match RGB color to the nearest RGB color in table.
; fs:[bx]     = RGB table
;
        xor     esi, esi                        ; Outrageous initial error term
        not     esi
        xor     eax, eax                        ; Clear upper bits of eax
        xor     dl, dl                          ; Init index count
        mov     cx, count
;
; Caclulate least squared difference between actual RGB color and possible RGB
; colors.
;
MatchLoop:
        sub     al, fs:[bx]                     ; Calc delta blue squared
        sub     al, BYTE PTR clrBlue
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        mov     edi, eax                        ; Save initial working error
        mov     al, fs:[bx + 1]                 ; Calc delta green squared
        sub     al, BYTE PTR clrGreen
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        add     edi, eax                        ; Add to working error
        mov     al, fs:[bx + 2]                 ; Calc red blue squared
        sub     al, BYTE PTR clrRed
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        add     edi, eax                        ; Add to working error
        cmp     edi, esi                        ; Is working error less than
        jb      NewMatch                        ; current minumum error?
        inc     dl
        add     bx, 4
        dec     cx
        jnz     MatchLoop
        jmp     MatchLoopExit
;
; A closer match was found so save it.
;
NewMatch:
        mov     dh, dl
        or      edi, edi                        ; Check for exact match
        jz      MatchLoopExit
        mov     esi, edi
        inc     dl
        add     bx, 4
        dec     cx
        jnz     MatchLoop
MatchLoopExit:
        mov     al, dh
        ret
mempMatchRGB    ENDP

        END


