;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and get RLE Dibs to color bitmaps.                           ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       08/11/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE BITBLT.INC
;
;	Define the flag values which control the direction
;	and type of the scan for ScanLR.

MATCH_COLOR     EQU     0001h
SCAN_LEFT       EQU     0002h

.CODE
.386

memScanColorLR  PROC NEAR USES ds si di, bmBits    : DWORD, bmWidthBytes : WORD,\
                                         bmScanSeg : WORD,  bmFillBytes  : WORD,\
                                         bmWidth   : WORD,                      \
                                         X         : WORD,  Y            : WORD,\
                                         PhysColor : DWORD, Style        : WORD
                LOCAL bmScanCount : WORD
;
; Get pointer to scanline.
;
        mov     ax, Y
        bmScanAddrInc bmScanSeg, bmWidthBytes, bmScanCount, WORD PTR bmBits + 2, WORD PTR bmBits
        mov     ds, dx
        mov     si, ax
;
; Figure out what direction we need to go.
;
        mov     cx, X
        add     si, cx
        add     si, cx
        add     si, cx
        mov     bx, 1                   ; Assume scanning left to right
        test    Style, SCAN_LEFT
        jz      ColorCompare
        mov     bx, -1                  ; Scanning right to left
ColorCompare:
        mov     ax, WORD PTR PhysColor
        mov     dl, BYTE PTR PhysColor + 2
        test    Style, MATCH_COLOR
        jz      NotMatchColor
MatchColor:
        cmp     ax, [si]
        jne     @F
        cmp     dl, [si + 2]
        je      Exit
@@:     add     si, bx
        add     si, bx
        add     si, bx
        add     cx, bx
        cmp     cx, bmWidth
        jb      MatchColor
        jmp     NoMatch
NotMatchColor:
        cmp     ax, [si]
        jne     Exit
        cmp     dl, [si + 2]
        jne     Exit
        add     si, bx
        add     si, bx
        add     si, bx
        add     cx, bx
        cmp     cx, bmWidth
        jb      NotMatchColor
NoMatch:
        xor     cx, cx
        not     cx
Exit:
        mov     ax, cx
        ret

memScanColorLR  ENDP                                

        END


