#ifndef __GL_AGR_H__
#define	__GL_AGR_H__
/**************************************************************************
 *									  *
 *	      Copyright (C) 1992  pellucid, inc.			  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of pellucid, inc., and are	  *
 *  protected by Federal copyright law.  They may not be disclosed	  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *									  *
 **************************************************************************/


/****************************************************************************
 * GRP is a pointer to the starting address of the AGR graphics page.  It is
 * used in all macros that access the memory mapped part of the AGR.
 *
 * GRPsetup must appear before any macros from agr.h that access the AGR
 * graphics page. It is NOT needed for the im macros that access only the
 * FIFO since they have their own pointer set up for them in im_setup.
 *
 ****************************************************************************/
    /*
     *  Make sure that compiling source that uses any of the macros will fail if
     * -D$(PRODUCT) is not given.
     */
#ifdef	AGR
#define GRPsetup		  \
	    extern unsigned char _far *GRP
#endif	/* AGR */

#define MK_FP(seg, off) ((void _far *)( ((unsigned long)(seg) << 16) | (off) ))
#define	MK_PTR(x, y)		((x) + (y))
#define	CHAR_PTR		*(volatile char _far *)	

    /*
     *  The following definitions are useful for MS Windows where the Windows
     *  kernel supplies selectors that point to blocks of physical memory.
     */
#define	GRP_PTR(offset)	 (volatile long _far *)(GRP + (offset))
#define GRP_L_RD(offset, x)  x = *GRP_PTR(offset)

#ifdef STINKY
#define GRP_C_RD(offset, x)  x = *(volatile unsigned char _far *)GRP_PTR(offset)
#endif

#define GRP_C_RD(offset, x)  x = *(volatile unsigned char _far *)(GRP + (offset))

#ifdef SEEMED_LIKE_A_GOOD_IDEA
    /*
     * The following splitting of a "long write" is done to correct the
     * problem caused by the order in which the MSC 16-bit compiler writes
     * each half of the long.  IRISVISION needs low address write first.
     *
     * P.S. This turned out not to work very well.  If the 2 16-bit writes
     *      are separated by an interrupt IrisVision get very unhappy.
     */
#define GRP_WR(offset, x) 						\
    {									\
	volatile unsigned long _IV_Data;				\
									\
	_IV_Data = x;							\
        *(volatile short _far *)GRP_PTR(offset) =			\
				(unsigned short)(_IV_Data);		\
	*(volatile short _far *)GRP_PTR((offset)+2) =			\
				(unsigned short)((_IV_Data)>>16);	\
    }
#endif

/*
 * IrisVision really needs a genuine 32-bit write so we need to do it in
 * assembly code.  NOTE: MSC 6.0 doesn't know about 32-bit writes even
 * with inline assembly code in spite of claims to the contrary (i.e.
 * using the "_emit" pseudo-operator).
 */
extern void far _pascal LongWrite32(volatile long far *,volatile unsigned long);
#define GRP_WR(offset, x) \
    LongWrite32(GRP_PTR(offset), x)

/****************************************************************************
 *  Force Pending I/O Kludge
 ***************************************************************************\
    /*  I/O port used for forcing pending writes to complete */
#define	IW_COMPLETE	0x84		/*  unused DMA page register */
    /*
     *	This macro is used in diagnostics which require writes to hardware
     *	to complete before reading results which depend upon the write.
     *	Cf. COMPAQ memorandum on buffered I/O, possible side-effects and
     *	techniques to force completion of buffered reads/writes.
     *					- CJH / esper  9010.19
     */
#define	FRC_PEND_IO()	\
    {									\
	volatile int dummy = inp((unsigned int) IW_COMPLETE) ;	\
    }

/****************************************************************************
 *	AGR (Eclipse) graphics board hardware address offsets.
 *
 *  The graphics hardware addresses fit within a page (4K) and these are the
 *  offsets within that page to each specific graphics hardware address.
 ****************************************************************************/

#define	URAM_OFF	0x000	/* Microcode Store RAM base */

#define	DRAM_OFF	0x1400	/* Data RAM base */
				/* Extra bit here gets decoded by DK1 on GR1 */
				/* It also causes gfx page to be 2 pages long */

#define	CTLREG_OFF	0x400	/* Control register base (XMAP,DAC,CURSOR,HQ) */
#define	CTLREG_MASK	0x7E0	/* Mask to select following control registers */

#define	XMAP0_OFF	0x400	/* XMAP2 Channel 0 */
#define	XMAP1_OFF	0x420	/* XMAP2 Channel 1 */
#define	XMAP2_OFF	0x440	/* XMAP2 Channel 2 */
#define	XMAP3_OFF	0x460	/* XMAP2 Channel 3 */
#define	XMAP4_OFF	0x480	/* XMAP2 Channel 4 */
#define	XMAPALL_OFF	0x4A0	/* XMAP2 Broadcast (All Channels) */

#define	DREG1_OFF	0x4C0	/* Display Register 1 */
#define	DREG0_OFF	0x4E0	/* Display Register 0 */

#define	DACR_OFF	0x500	/* Red DAC */
#define	XPC0_OFF	0x510	/* XPC (mini-XMAP) channel 0 */
#define	DACG_OFF	0x520	/* Green DAC */
#define	XPC1_OFF	0x530	/* XPC (mini-XMAP) channel 1 */
#define	DACB_OFF	0x540	/* Blue DAC */
#define	XPC2_OFF	0x550	/* XPC (mini-XMAP) channel 2 */
#define	CURS0_OFF	0x560	/* Cursor Chip 0 */
#define	XPC3_OFF	0x570	/* XPC (mini-XMAP) channel 3 */
#define	CURS1_OFF	0x580	/* Cursor Chip 1 */
#define	XPC4_OFF	0x590	/* XPC (mini-XMAP) channel 4 */

#define	DREG4_OFF	0x5A0	/* Display Register 4 */
#define	XPC_ALL_OFF	0x5B0	/* XPC (mini-XMAP) Broadcast (all channels) */
#define	DREG3_OFF	0x5C0	/* Display Register 3 */
#define	DACRGB_OFF	0x5D0	/* RGB DAC */
#define	DREG2_OFF	0x5E0	/* Display Register 2 */

#define	HQCLRSTL_OFF	0x640	/* HQ cmd: Clear Stall */
#define	HQSETSS_OFF	0x680	/* HQ cmd: Set Single Step Mode */
#define	HQCLRSS_OFF	0x6C0	/* HQ cmd: Clear Single Step Mode */
#define	HQSS_OFF	0x700	/* HQ cmd: Execute Single Step */
#define	HQRDPC_OFF	0x740	/* HQ cmd: Read PC */
#define	HQCLRINT_OFF	0x780	/* HQ cmd: Clear Interrupt */

#define	FIFO_OFF	0x800	/* FIFO base */
#define	FIFO16_OFF	0x1800	/* FIFO base */

#define	HQM_OFF		0xC00	/* HQ Middle Address Register base */
#define	HQMMSB_OFF	0xE00	/* HQ Middle Address Register most sig. bit */

/*
 *  The following two finish flags were originally to fix the DMA - Data
 *  RAM read problem.  This fix was on the DK3 (for MGR, GR1 boards).
 *  Note that the gfx region is now 3 pages.
 *
 *  The original names for the FINISH flag offsets were FINISH0_OFF and
 *  FINISH1_OFF but that caused some confusion when reading code because
 *  the define would appear to refer to ON/OFF status rather and OFFset.
 *  The newer defines don't use the "_OFF" suffix.		- Orc
 */
#define	FINISHFLAG0	0x2000
#define	FINISHFLAG1	0x2004
#define	FINISH0_OFF	FINISHFLAG0
#define	FINISH1_OFF	FINISHFLAG1


/****************************************************************************
 * Or these into addresses depending on how much data will be transfered.
 ****************************************************************************/

#define	DATA32		0x0	/* 32 bits data being transfered */
#define	DATA16		0x2	/* 16 bits data being transfered */
#define	DATA8		0x3	/*  8 bits data being transfered */


/****************************************************************************
 * HQ defines and operations
 ****************************************************************************/

#define	HQM_PG_SIZE	256	/* 256 long addressable area w/ HQM */

	    /* HQ op: write HQ mid addr reg most sig. bit */
#define	HQMMSB_WR(x)	\
    {								\
	GRP_WR((HQMMSB_OFF | ((x) << 2)), 0L);			\
	FRC_PEND_IO() ;						\
    }

	    /* HQ op: write HQ mid addr reg */
	    /*  last line of code is a fix for buffered write delays  */
#define	HQM_WR(addr)	\
    {								\
	GRP_WR((HQM_OFF | (((addr) >> 8 ) << 2)), 0L) ;		\
	FRC_PEND_IO() ;						\
    }
    /*	previous variation of last line ... 
     *	 { short dummyx; _disable(); dummyx = inpw(0x150); _enable(); }
     */

    /*
     *	FOR GL ONLY - HQ op: write HQ mid addr reg
     *
     *	Since HQ MAR cannot be read, user proc's must shadow it so that the
     *	kernel can restore it at context switch time. The fastest way is to
     *	write it down pipe and have GE store it in the context save space
     *	instead of making a system call.
     */
	    /*  last line of code is a fix for buffered write delays  */
#define	GL_HQM_WR(addr)	\
    {								\
	GRP_WR(FIFO_OFF | ((GE_HQMSAV) << 2), 0L) ;		\
	GRP_WR(FIFO_OFF | ((GE_DATA) << 2), (addr)) ;		\
	GRP_WR(HQM_OFF | (((addr) >> 8) << 2), 0L) ;		\
	FRC_PEND_IO() ;						\
    }
    /*	previous variation of last line ... 
     *	 { short dummyx; _disable(); dummyx = inpw(0x150); _enable(); }
     */

/*
 *  This is one of several definitions we tried for HQCLRSTL in order to
 *  try to get it working with a 16-bit compiler (MSC 6.0).
 *
 *  #define HQCLRSTL()	_asm \
 *      {								\
 *  	_asm  mov     bx,gfx_offset				\
 *  	_asm  add     bx,HQCLRSTL_OFF				\
 *  	_asm  mov     cx,GRP					\
 *  	_asm  mov     es,cx					\
 *  	_asm  mov     WORD PTR es:[bx],0			\
 *  	_asm  mov     WORD PTR es:[bx+2],0			\
 *      }
 */
#define HQCLRSTL()      GRP_WR(HQCLRSTL_OFF, 0L)
#define	HQSETSS()	GRP_WR(HQSETSS_OFF, 0L)
#define	HQCLRSS()	GRP_WR(HQCLRSS_OFF, 0L)
#define	HQSS()		GRP_WR(HQSS_OFF, 0L)

				/*  Only 15 bits are valid so mask them */
#define	HQCLRINT()	GRP_WR(HQCLRINT_OFF, 0L)

#define	HQRDPC(x, y)	\
			HQMMSB_WR(1) ;			\
			GRP_L_RD(HQRDPC_OFF, x) ;	\
			x &= 0x7fff ;			\
			HQMMSB_WR(y)

/******************************************************************************
 * General memory-map defines and operations
 *****************************************************************************/
#define	MEM_RD(addr, x)	GRP_L_RD((addr), x) ;
#define	MEM_WR(addr, x)	GRP_WR((addr), x)

/******************************************************************************
 * Microcode RAM defines and operations
 *****************************************************************************/

#define	URAM_SIZE	0x8000	/* Microcode RAM size in WORDs */
#define	URAM_NPG	64	/* Number of 256 WORD pages in ucode RAM */
				/*  XXX     should be 128 pages, right?  */

#define	URAM_RD(addr, x)	\
			GRP_L_RD(URAM_OFF | (((addr) & 0xff) << 2), x)
#define	URAM_WR(addr, x)	\
			GRP_WR(URAM_OFF | (((addr) & 0xff) << 2), x)

/******************************************************************************
 * Data RAM defines and operations
 *
 * The GRP must be added instead of OR'ed here because DRAM_OFF offset has an
 * extra bit in it that collides with a bit in the GRP.
 *****************************************************************************/

#define	DRAM_SIZE	0x2000	/* Data RAM size in WORDs */
#define	DRAM_NPG	32	/* Number of 256 WORD pages in data RAM */

#define	DRAM_RD(addr, x)	\
			GRP_L_RD(DRAM_OFF | (((addr) & 0xFF) << 2), x) ;
#define	DRAM_WR(addr, x)	\
			GRP_WR(DRAM_OFF | (((addr) & 0xFF) << 2), x)

#define	DRAM_POLL(addr)	*GRP_PTR(DRAM_OFF | (((addr) & 0xff) << 2))

/******************************************************************************
 * Finish flag operations
 *****************************************************************************/

#define	FINISH_RD(addr, x)	\
				GRP_C_RD((addr), x) ;	\
				x &= 0x1

#define	FINISH_WR(addr, x)	GRP_WR((addr), x)
#define	FINISH_POLL(addr)	(*GRP_PTR(addr) & 0x1)


/****************************************************************************
 * XMAP2 defines and operations
 ****************************************************************************/

#define	XMAP_CMDMASK	(0x7 << 2)	/* XMAP2 Mask to get command */
#define	XMAP_NOOP	(0x0 << 2)	/* XMAP2 op: noop */
#define	XMAP_BLUE	(0x1 << 2)	/* XMAP2 op: RW blue LUT or overlay reg */
#define	XMAP_GREEN	(0x2 << 2)	/* XMAP2 op: RW green LUT or overlay reg */
#define	XMAP_RED	(0x3 << 2)	/* XMAP2 op: RW red LUT or overlay reg */
#define	XMAP_AINC	(0x4 << 2)	/* XMAP2 op: Increment address reg */
#define	XMAP_OTHER	(0x5 << 2)	/* XMAP2 op: RW mode, diplay reg, win/aux */
#define	XMAP_AHI	(0x6 << 2)	/* XMAP2 op: W MS 5 bits addr reg */
#define	XMAP_ALO	(0x7 << 2)	/* XMAP2 op: W LS 8 bits addr reg */

#define	XPC_ADDR	(0x0 << 2)	/* XPC op: W 3 bit addr reg */
#define	XPC_MODE	(0x1 << 2)	/* XPC op: W 8/6 bit mode regs */

	    /* XMAP2 mode register color modes */
#define	XMAP_8CI	0x0	/* 8 bit color index */
#define	XMAP_8DCI	0x1	/* 8 bit double buffered color index */
#define	XMAP_24DCI	0x2	/* 24 bit double buffered color index */
#define	XMAP_24RGB	0x4	/* 24 bit RGB */
#define	XMAP_24DRGB	0x5	/* 24 bit double buffered RGB */

#define	XMAP_BUFSEL	0x08	/* Bit in mode reg to select out buf */
#define	XMAP_MAPSEL	0x3C	/* Bits in mode reg to select multimap map */

#define	XMAP_MODEREG_OFF	0
#define	XMAP_WIDAUX_OFF		32
#define	XMAP_DREG_OFF		33
#define	XMAP_NXMAP		5	/* Number XMAP2's */
#define	XMAP_NCOLMAPENT		4096	/* Number col map entries */
#define	XMAP_NAUXMAPENT		16	/* Number aux col map entries */
#define	XMAP_NMULTIMAP		16	/* Number multimaps */
#define	XMAP_NMODEREGS		16	/* # of entries in mode reg table */
#define	XPC_NMODEREGS		4	/* # of entries in mode reg table */

#define	XMAP_COLSEL		0x1000	/* bit set in A reg to select col tbl */

#define	XMAP_COLRD(xmap_off, xmap_col, x)  GRP_C_RD((xmap_off) | (xmap_col), x)
#define	XMAP_COLWR(xmap_col, x)            GRP_WR(XMAPALL_OFF | (xmap_col), x)
#define	XMAP_OTHERRD(xmap_off, x)          GRP_C_RD((xmap_off) | XMAP_OTHER, x)
#define	XMAP_OTHERWR(x)	GRP_WR(XMAPALL_OFF | XMAP_OTHER, x)
#define	XMAP_INCA()	GRP_WR(XMAPALL_OFF | XMAP_AINC, 0L)
#define	XMAP_ALOWR(x)	GRP_WR(XMAPALL_OFF | XMAP_ALO, x)
#define	XMAP_AHIWR(x)	GRP_WR(XMAPALL_OFF | XMAP_AHI, (x) >> 8)

	    /*  Make XMAP2 mode register entries */
#define	XMAP_MKMODELO(colmode, bufsel, overlay)		\
			((colmode) | ((bufsel) << 3) | ((overlay) << 4))

#define	XMAP_MKMODEHI(underlay, multimap, mapsel)	\
			((underlay) | ((multimap) << 1) | ((mapsel) << 2))

#define	XPC_ADDRWR(x)	GRP_WR(XPC_ALL_OFF | XPC_ADDR, (x) & 0x7)
#define	XPC_MODEWR(x)	GRP_WR(XPC_ALL_OFF | XPC_MODE, x)

#define	XPC_MODERD(xpc_off, x)  GRP_C_RD((xpc_off) | XPC_MODE, x)


/******************************************************************************
 * Digital to analog converter defines and operations
 *****************************************************************************/

#define	DAC_CMDMASK	(0x3 << 2)	/* DAC Mask to get command */
#define	DAC_AREG	(0x0 << 2)	/* DAC op: RW addr reg */
#define	DAC_COL		(0x1 << 2)	/* DAC op: RW color palette RAM */
#define	DAC_CR		(0x2 << 2)	/* DAC op: RW control reg.s */
#define	DAC_OVRLAY	(0x3 << 2)	/* DAC op: RW overlay color */

#define	DAC_READMASK	0x4		/* offset of read mask */
#define	DAC_BLINKMASK	0x5		/* offset of blink mask */
#define	DAC_CMD		0x6		/* offset of command register */
#define	DAC_TEST	0x7		/* offset of test register */
#define	DAC_NGAMMAENT	256		/* Number gamma ramp entries */

	    /* DAC command register bit settings: */
#define	DAC_5TO1MUX	0x80		/* use 5:1 multiplexing */
#define	DAC_RAMENBL	0x40		/* Use RAM if over bits are 0 */
#define	DAC_BLINK0	0x00		/* blink rate 0: 1.024(75/25) */
#define	DAC_BLINK1	0x10		/* blink rate 1: 0.512(50/50) */
#define	DAC_BLINK2	0x20		/* blink rate 2: 1.024(50/50) */
#define	DAC_BLINK3	0x30		/* blink rate 3: 2.048(50/50) */
#define	DAC_OL1BENBL	0x08		/* OL1 Blink Enable */
#define	DAC_OL0BENBL	0x04		/* OL0 Blink Enable */
#define	DAC_OL1ENBL	0x02		/* OL1 Enable */
#define	DAC_OL0ENBL	0x01		/* OL0 Enable */

#define	DAC_ARD(col_off, x)	GRP_C_RD((col_off) | DAC_AREG, x)
#define	DAC_AWR(col_off, x)	GRP_WR((col_off) | DAC_AREG, x)
#define	DAC_COLRD(col_off, x)	GRP_C_RD((col_off) | DAC_COL, x)

    /*
     *	Although only  char's  are needed, the GL interface uses arrays of
     *	  shorts   for the gamma ramp.
     */
#define	DAC_COLWR(col_off, x)	GRP_WR((col_off) | DAC_COL, x)
#define	DAC_CRRD(col_off, x)	GRP_C_RD((col_off) | DAC_CR, x)
#define	DAC_CRWR(col_off, x)	GRP_WR((col_off) | DAC_CR, x)
#define	DAC_OVRLAYRD(col_off, x)	\
				GRP_C_RD((col_off) | DAC_OVRLAY, x)
#define	DAC_OVRLAYWR(col_off, x)	\
				GRP_WR((col_off) | DAC_OVRLAY, x)


/****************************************************************************
 * Cursor chip defines and operations
 ****************************************************************************/

#define	CURS_GLYPH_SIZE	512	/* Number bytes in glyph */

#define	CURS_CMDMASK	(0x3 << 2)	/* Cursor Mask to get command */
#define	CURS_AREG0	(0x0 << 2)	/* Cursor op: RW addr reg 0 */
#define	CURS_AREG1	(0x1 << 2)	/* Cursor op: RW addr reg 1 */
#define	CURS_GLYPH	(0x2 << 2)	/* Cursor op: RW glyph RAM */
#define	CURS_CR		(0x3 << 2)	/* Cursor op: RW control reg */

	    /* Control register offsets */
#define	CURS_CMD	0
#define	CURS_XLO	1
#define	CURS_XHI	2
#define	CURS_YLO	3
#define	CURS_YHI	4
#define	CURS_WINXLO	5
#define	CURS_WINXHI	6
#define	CURS_WINYLO	7
#define	CURS_WINYHI	8
#define	CURS_WINWLO	9
#define	CURS_WINWHI	10
#define	CURS_WINHLO	11
#define	CURS_WINHHI	12

					/* Glyph origin (0,0) is lower left */
#define	CURS_XHOTOFF	31		/* x offset from origin to hotspot */
#define	CURS_YHOTOFF	32		/* y offset from origin to hotspot */
#define	CURS_XOFF	221		/* x hardware offset */
#define	CURS_YOFF	998		/* y hardware offset */
#define	IV_WIN_CURS_XOFF	220	/* x hardware offset for Windows drvr */
#define	IV_WIN_CURS_YOFF	37	/* y hardware offset for Windows drvr */
#define	IV_WIN_CURS_XOFFMED	180	/* x hardware offset for Windows drvr */
#define	IV_WIN_CURS_YOFFMED	41	/* y hardware offset for Windows drvr */
#define	CURS_XOFFREVA	309		/* x hardware offset Rev. A board */
#define	CURS_XOFF_30	39
#define	CURS_YOFF_30	18
#define	CURS_XOFF_170	25
#define	CURS_YOFF_170	437
#define	CURS_XOFF_PAL	57
#define	CURS_YOFF_PAL	535
#define	CURS_XOFF_MED	181
#define	CURS_YOFF_MED	746

	    /*  XXX what if have different size screen? */
#define	CURS_XINIT	639		/*  Initial x coordinate */
#define	CURS_YINIT	511		/*  Initial y coordinate */

	    /*  Command register bits */
#define	CURS_BLOCK	0x40		/* block cursor */
#define	CURS_CROSS	0x20		/* Cross hair cursor */
#define	CURS_FMT	0x01		/* if both block & cursor are enabled:*/
					/* 0 - '^', 1 - '|' bits */
#define	CURS_1TO1MUX	0x00		/* use 1:1 multiplexing */
#define	CURS_4TO1MUX	0x04		/* use 4:1 multiplexing */
#define	CURS_5TO1MUX	0x08		/* use 5:1 multiplexing */
#define	CURS_1THICK	0x00		/* Cross hair is 1 bit thick */
#define	CURS_3THICK	0x01		/* Cross hair is 3 bits thick */
#define	CURS_5THICK	0x02		/* Cross hair is 5 bits thick */
#define	CURS_7THICK	0x03		/* Cross hair is 7 bits thick */

#define	CURS_A0RD(curs_off, x)	GRP_C_RD((curs_off) | CURS_AREG0, x)
#define	CURS_A0WR(curs_off, x)	GRP_WR((curs_off) | CURS_AREG0, x)

#define	CURS_A1RD(curs_off, x)	GRP_C_RD((curs_off) | CURS_AREG1, x)
#define	CURS_A1WR(curs_off, x)	GRP_WR((curs_off) | CURS_AREG1, x)

#define	CURS_GLYPHRD(curs_off, x)	\
				GRP_C_RD((curs_off) | CURS_GLYPH, x)
#define	CURS_GLYPHWR(curs_off, x)	\
				GRP_WR((curs_off) | CURS_GLYPH, x)

#define	CURS_CRRD(curs_off, x)	GRP_C_RD((curs_off) | CURS_CR, x)
#define	CURS_CRWR(curs_off, x)	GRP_WR((curs_off) | CURS_CR, x)


/******************************************************************************
 * Display register defines and operations
 *****************************************************************************/

#define	NDREG			5	/* Number of display reg's */

/*			REG 0 				*/
#define	DREG_GRF1EN		0x01	/* Bit to enable GRF1 board-  disable
					     for RE2 (LOW ENABLED) (reg 0) */
#define	DREG_ZBUF0		0x08	/* Status bit: Z-buffer installed on MGR
					    (LOW ENABLED) (reg 0) */
#define	DREG_SMALLMON0		0x08	/* Status bit: small monitor installed
					    on GR1 (LOW ENABLED) (reg 0) */

/*			REG 1 				*/
#define	DREG_SYNCGRN		0x01	/* Bit to enable composite SYNC on Green
					    (LOW ENABLED) (reg 1) */
#define DREG_VRLS		0x04	/* Vertical Retrace Latency Select */

#define DREG_MONITORMASK2	0x04	/* Upper bit of monitor type (will get
					   transferred to DREG_MONITORUPPER) */
#define DREG_MONITORUPPER	0x02

#define	DREG_TURBO		0x08	/* Status bit: turbo option installed
					    (LOW ENABLED) (reg 1) */
#define	DREG_OVRLAY0_A		0x10	/* Status bit: DAC overlay bit 0 bank A
					    (reg 1) */

/*			REG 2 				*/
#define	DREG_SCREENON		0x01	/* Bit to turn screen on (reg 2) */
#define	DREG_STEREO		0x02	/* Bit to enable stereo optic display
					    (reg 2) */
#define	DREG_LEDOFF		0x04	/* Bit to turn off LED (reg 2) */
#define	DREG_BITPLANES		0x08	/* Status bit: extra bitplanes installed
					    (LOW ENABLED) (reg 2) */
#define	DREG_ZBUF		0x10	/* Status bit: Z-buffer installed
					    (LOW ENABLED) (reg 2) */

/*			REG 3 				*/
#define	DREG_GENSTATEN		0x01	/* Bit to enable status over genlock
					    connector (reg 3) */
#define	DREG_LCARESET		0x02	/* Bit to reset LCA
					    (LOW ENABLED) (reg 3) */
#define	DREG_MONITORRESET	0x04	/* Bit to reset monitor type (reg 3) */
#define	DREG_FIFOEMPTY		0x08	/* Status bit: FIFO empty
					    (LOW ENABLED) (reg 3) */
#define	DREG_FIFOFULL		0x10	/* Status bit: FIFO 1/2 full
					    (LOW ENABLED) (reg 3) */

/*			REG 4 				*/
#define	DREG_EXTCLKSEL		0x04	/*  Bit to select external clock
					    (reg 4) */
#define	DREG_MONITORMASK	0x03	/* Mask for monitor type (reg 4) */
#define	DREG_MONITOR60HZ	0x00	/* Monitor type 60Hz 1280x1024 (reg 4)*/
#define	DREG_MONITOR30HZ	0x01	/* Monitor type 30Hz 1280x1024 (reg 4)*/
#define	DREG_MONITORNTSC	0x02	/* Monitor type NTSC 645x485 (reg 4) */
#define	DREG_MONITORPAL		0x03	/* Monitor type PAL 780x575 (reg 4) */
#define	DREG_MONITORSTEREO	0x04	/*  Monitor type stereo  (reg 1 & 4) */
#define	DREG_MONITORMEDRES	0x06	/*  1024x768 medium res. (reg 1 & 4) */
#define	DREG_MONITORMEDRES_HVSYNC 0x07	/*  1024x768 medium res. (reg 1 & 4) */
#define	DREG_MONITORMED60HZ	0x0f	/* Monitor type 60HZ 1024X768 */

#if	defined(NOTDEF)

#define	DREG_RELOADEN1		0x08	/* Status bit: RE load enable 1
					    (LOW ENABLED) (reg 4) */
#else	/* defined(NOTDEF) */
						/*  new on ARV1, MRV3 boards */
#define	DREG_SELHRES		0x08	/* 1 -> enable hi-res, disable passthru
					   0 ->   enable passthru (reg 4) */
#endif	/* defined(NOTDEF) */

#define	DREG_MEGOPT		0x08	/* Status bit: 1Meg Video RAMs installed
					    (reg 4) */
#define	DREG_GESTALL		0x10	/* Status bit: GE stalled
					    (LOW ENABLED) (reg 4) */
#define	DREG_ACLKEN		0x20	/* Bit to enable clock asynchronously
					    (reg 4) */
#define	DREG_SCLKEN		0x40	/* Bit to enable clock synchronously
					    (reg 4) */

    /*
     *	REMEMBER: must do HQMMSB_WR(1) before accessing display registers!
     */
#define	DREG_RD_XPC(dreg_off, x)  GRP_C_RD(dreg_off, x)
#define	DREG_RD(xmap_off, x)	  GRP_C_RD((xmap_off) | XMAP_OTHER, x)
#define	DREG_WR(dreg_off, x)	  GRP_WR(dreg_off, x)


/******************************************************************************
 *  FIFO defines and operations
 *****************************************************************************/
#define	FIFO_SIZE	512
#define	FIFODATA32	0	/*  fifo offset for 32-bit data writes */
#define	FIFODATA16	0x400	/*  fifo offset for sign extended 16-bit data */

	    /*  Middle address register is a don't care */
#define	FIFO_WR(cmd, x) \
    GRP_WR(FIFO_OFF | ((cmd) << 2), x)
#define	FIFO_WR16(cmd, x) \
    *(volatile short _far *)(GRP + (FIFO16_OFF | ((cmd) << 2))) = \
    							(unsigned short)(x)
#define	FIFO_WR_F(cmd, x) \
    GRP_WR(FIFO_OFF | ((cmd) << 2), *(volatile unsigned long *)&x) 

#define	FIFO_RD(x)	GRP_L_RD(FIFO_OFF, x)


/******************************************************************************
 *  Read / Write Modes for Raster Engine
 *****************************************************************************/
#define	RW_PIXEL	0
#define	RW_PUP		1
#define	RW_UAUX		2
#define	RW_Z		3
#define	RW_WID		4
#define	RW_FBUFFER_28	6
#define	RW_ZBUFFER_28	7

#define	PIX_RGB24	0
#define	PIX_RGB12	1
#define	PIX_C12		2
#define	PIX_C4		3

    /*  Graphics DMA defines */

	    /*  These tell kernel what to do */
#define	GDMA_POLLARG	0	/*  Poll & send arg. to tell GE */
#define	GDMA_POLLNOARG	1	/*  Poll & do NOT send arg. to tell GE */
#define	GDMA_INTRARG	2	/*  Intr. & send arg. to tell GE */
#define	GDMA_INTRNOARG	3	/*  Intr. & do NOT send arg. to tell GE */

#define	GDMA_MAXREADPOLL	40000	/*  maximum length DMA rd/write xfer */
					/*    (in bytes) before stop polling */
#define	GDMA_MAXWRITPOLL	80000	/*    and start intr. for finish   */


/******************************************************************************
 * The following definitions were added to support the micro-channel version
 * of the GR1 graphics boardset (MGR).  Since some graphics interface registers
 * were transplanted from the IP6 to the MGR an additional level of defines
 * were added to make the ECLIPSE graphics code usable in both environments.
 *****************************************************************************/

    /*  offset of the AGR graphics board interface registers address space */
#define	AGR_REGS_OFF	0x00004000

    /*  offsets of the AGR/MGR graphics board interface registers */
#define	MGR_DMA_ADDR0	0x00	/* DMA src/dest addr counter (chan 0) */
#define	MGR_DMA_LEN0	0x04	/* DMA data length down counter (chan 0) */
#define	AGR_CTRL0	0x20	/* control/status register (chan 0) */
#define	MGR_CTRL0	AGR_CTRL0	/** XXX	backward compatibility **/
#define	AGR_IMASK	0x00	/* interrupt mask reg */
#define	MGR_IMASK	AGR_IMASK	/** XXX	backward compatibility **/
#define	AGR_ISR		0x08	/* interrupt status reg */
#define	MGR_ISR		AGR_ISR		/** XXX	backward compatibility **/
#define	MGR_GFX_RESET	0x0b	/* graphics reset reg */
#define	MGR_CMD_FIFO	0x0c	/* command FIFO address */
#define	MGR_DIAG_CTRL	0x0e	/* diagnostics control register */
#define	MGR_DMA_ADDR1	0x10	/* DMA src/dest addr counter (chan 0) */
#define	MGR_DMA_LEN1	0x14	/* DMA data length down counter (chan 1) */
#define	MGR_CTRL1	0x18	/* control/status register (chan 1) */

    /*
     *	For the AGR, map extra page for the control registers
     */
#define	MGR_CSR_PHYS	( MK_PTR(GRP, AGR_REGS_OFF) )

    /*  Graphics Reset Register */
#define	GFX_RESET_ADDR	( MK_PTR(GRP, AGR_REGS_OFF | MGR_GFX_RESET) )
#define	GFX_RESET_BIT		0x80
#define	GFX_DMA_RESET_BIT	0x40

    /*  Graphics Interrupt Status Register */
#define	GFX_ISR_ADDR	( MK_PTR(GRP, AGR_REGS_OFF | AGR_ISR) )

#define	GFX_INT_VR		0x01	/* Vert retrace interrupt */
#define	GFX_INT_GE		0x02	/* GE (graphics) interrupt */
#define	GFX_INT_FIFO		0x04	/* FIFO half-full interrupt */

#if	defined(OBSOLESCENT)

#define	GFX_INT_DMA0_ERR	0x08	/* DMA chan 0 error */
#define	GFX_INT_DMA1_ERR	0x10	/* DMA chan 1 error */
#define	GFX_INT_DMA0_FIN	0x20	/* DMA chan 0 finished */
#define	GFX_INT_DMA1_FIN	0x40	/* DMA chan 1 finished */

#endif	/* defined(OBSOLESCENT) */

    /* Graphics Interrupt Mask Register */
#define	GFX_IMASK_ADDR	( MK_PTR(GRP, AGR_REGS_OFF | AGR_IMASK) )

#define	GFX_VR_MASK		0x10	/* Vert retrace interrupt */
#define	GFX_GE_MASK		0x20	/* GE (graphics) interrupt */
#define	GFX_FIFO_MASK		0x40	/* FIFO half-full interrupt */

#if	defined(OBSOLESCENT)

#define	GFX_DMA0_ERR_MASK	0x08	/* DMA chan 0 error */
#define	GFX_DMA1_ERR_MASK	0x10	/* DMA chan 1 error */
#define	GFX_DMA0_FIN_MASK	0x20	/* DMA chan 0 finished */
#define	GFX_DMA1_FIN_MASK	0x40	/* DMA chan 1 finished */

#endif	/* defined(OBSOLESCENT) */

    /*  Graphics Control Status Registers */
#define	GFX_CTRL0_ADDR	( MK_PTR(GRP, AGR_REGS_OFF | AGR_CTRL0) )

#if	defined(OBSOLESCENT)

#define	GFX_CTRL1_ADDR	( MK_PTR(GRP, MGR_REGS_OFF | MGR_CTRL1) )
#define	GFX_DIAG_CTRL_ADDR	( MK_PTR(GRP, MGR_REGS_OFF | MGR_DIAG_CTRL) )

#endif	/* defined(OBSOLESCENT) */

#define	GFX_VRSTAT	0x04	/* Vertical retrace in progress */
#define	GFX_FIFOSTAT	0x01	/* FIFO status mask (2 bits)
				 *	00 - FIFO < Half Full
				 *	01 - FIFO >= Half Full
				 *	11 - FIFO Full
				 *	10 - FIFO Full (for AGR only)
				 */
#define	GFX_DMA_STATUS	0x1c	/* DMA status mask (3 bits) */
#define	GFX_DMA_DIRECT	0x02	/* DMA direction (0 = host to graphics) */
#define	GFX_DMA_START	0x01	/* DMA start flag (0 = not started) */

#define	HOST_TO_GFX	1L
#define	GFX_TO_HOST	-1L

    /*
     *	CPU/Graphics Interface Macros.
     */

/******************************************************************************
 * graphics board reset
 *****************************************************************************/
#define	RESET_OFF	0x02

#define	RESET_GFX	\
    {							\
	extern short		agr_ioport ;		\
	extern unsigned int	ioport[] ;		\
							\
	outp(ioport[agr_ioport] + RESET_OFF, 0) ;	\
    }

#define	UNRESET_GFX	\
    {							\
	extern short		agr_ioport ;		\
	extern unsigned int	ioport[] ;		\
							\
	outp(ioport[agr_ioport] + RESET_OFF, 1) ;	\
    }

/******************************************************************************
 * interrupt register and interrupt mask register operations
 *****************************************************************************/
    /*
     *	AGR interrupt mask and isr reg macros
     */
#define	GFXINTR		CHAR_PTR(GFX_ISR_ADDR)
#define	GFXIMASK	CHAR_PTR(GFX_IMASK_ADDR)
#define	MASK_GFXINTR(x)	CHAR_PTR(GFX_IMASK_ADDR) &= (~(x))
#define	GFXIMASK_WR(x)	CHAR_PTR(GFX_IMASK_ADDR) = (x)
#define	GFXINTR_CLR(x)	CHAR_PTR(GFX_ISR_ADDR) |= (x)

#define	CLR_GFXINTR(x)	\
    {				\
	HQMMSB_WR(1) ;		\
	HQCLRINT() ;		\
	HQMMSB_WR(0) ;		\
	GFXINTR_CLR(x) ;	\
    }

/*
 * this macro allows routines to assume a 1 represents an interrupt so that
 * routines can be shared by IP6/GR1 and MGR (IP6/GR1 uses "active low"
 * interrupt pending flags but MGR actually uses "active high" flags)
 */
#define	GFXINTR_TEST(x)	( CHAR_PTR(GFX_ISR_ADDR) & (x) )


/******************************************************************************
 * definitions for use in accessing other graphics control/status
 *****************************************************************************/
#define	GFXCTRL0	CHAR_PTR(GFX_CTRL0_ADDR)
#define	DIAG_CTRL	CHAR_PTR(GFX_DIAG_CTRL_ADDR)

#endif	/* !__GL_AGR_H__ */
