incDrawMode EQU 1                               ; Get definitions for OPAQUE & TRANSPARENT

        INCLUDE COMMON.INC
        INCLUDE IV1.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;       07/02/93 Dave Schmenk - added pattern alignment                      ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD

EXTERN  _devXlateTbl         : BYTE
EXTERN  Rop2XlateTable       : BYTE 

EXTERN  BitRTable            : BYTE

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 26]
yDst            EQU [bp + 24]
lpPat           EQU [bp + 20]
xSize           EQU [bp + 18]
ySize           EQU [bp + 16]
colorFore       EQU [bp + 12]
colorBack       EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]

LocRop          EQU [bp - 2]
Sperrow         EQU [bp - 6]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltPD_Mono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 10
        push    esi
        push    edi
        push    gs
        push    es
        push    ds



        mov     ax, ds
        mov     es, ax

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;
; Set Clip Rectangle
;

        mov     WORD PTR gs:[di][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[di][FIFO16_OFF], 1
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, yDst
        add     ax, ySize
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[di][FIFO16_OFF], dx     
        mov     ax, xDst
        add     ax, xSize
        dec     ax
        mov     gs:[di][FIFO16_OFF], ax     
        sub     cx, yDst
        mov     gs:[di][FIFO16_OFF], cx         ; Ytranslation-starty


   ;
   ; Clipped in X and Y
   ;
;
; Done Setting Clip
;

        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     cx,cx
        mov     cl,al

;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        mov     LocRop, cx
        cmp     cx, LO_SOURCECOPY
        jz      BltRopSet

;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     gs:[di][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

BltRopSet:

;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        lds     si,lpPat

        mov     dx, xSize
        add     dx,0fh
        shr     dx,4
        mov     Sperrow, dx


   ;
   ; cx = rop
   ; special case source copy

        cmp     cx,LO_SOURCECOPY
        jnz     NOTSourceCopy

   ; 
   ; at this point, we know its a source copy so do it in 2 passes 
   ; special cased
   ;
        cmp     WORD PTR modeback, OPAQUE
        jne     OpaqueSet


        mov     bx, WORD PTR colorBack
        and     bx, 0ffh                        ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        mov     bl, es:_devXlateTbl[bx]
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], bx     ;color data

        mov     dx, es:_Y_TRANSLATION

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[di][GE_SOLIDBRUSH], 0
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     

        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ;Y translated start 
        
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax

OpaqueSet:
    ; 
    ; Now do Foreground SourceCopy
    ;
        mov     bx, WORD PTR colorFore
        and     bx, 0ffh                        ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        mov     bl, es:_devXlateTbl[bx]
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], bx     ;color data

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[di][GE_MONOPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, Sperrow
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin



        mov     bx, yDst                ; initialize bx for mod 8 counter
        sub     bx, [si][BRUSH_Y]
        and     bx, 7
        mov     cx, xDst
        sub     cx, [si][BRUSH_X]
        and     cx, 7
        add     si, BRUSH_PAT
BltYLoop:                               ;Only need Y loop cause xloop
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     dx, Sperrow
        mov     al,[si][bx]
        rol     al, cl                  ;Align pattern horizontally
        mov     ah,al

BltXLoop:
        test    dx,FIFOLIMIT
        jnz     NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NoCheck:

        mov     gs:[di][FIFO16_OFF], ax     
        dec     dx
        jnz     BltXLoop
        inc     bx
        and     bx,7
        dec     WORD PTR ySize
        jnz     BltYLoop


        jmp     Exit


NOTSourceCopy:


        cmp     WORD PTR modeback, OPAQUE
        jne     NSC_BACK_Done
        
        push    Sperrow
        push    ySize
        push    ds                              ; save offset & seg to bits
        push    si

;;;;
        mov     bx, WORD PTR colorBack
        and     bx, 0ffh                        ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        mov     bl, es:_devXlateTbl[bx]
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], bx     ;color data

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking




        mov     WORD PTR gs:[di][GE_ROPPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax
        mov     dx, Sperrow
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin



        mov     bx, yDst                ; initialize bx for mod 8 counter
        sub     bx, [si][BRUSH_Y]
        and     bx, 7
        mov     cx, xDst
        sub     cx, [si][BRUSH_X]
        and     cx, 7
        add     si, BRUSH_PAT


NSC_BACK_BltYLoop:                               ;Only need Y loop cause xloop
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     dx, Sperrow

        mov     al,[si][bx]
        rol     al, cl                  ;Align pattern horizontally

        push    bx
        mov     bx, OFFSET es:BitRTable
        xlatb   es:[bx]
        pop     bx
        mov     ah,al
        not     ax

NSC_BACK_BltXLoop:
        test    dx,FIFOLIMIT
        jnz     NSC_NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NSC_NoCheck:

        mov     gs:[di][FIFO16_OFF], ax     
        dec     dx
        jnz     NSC_BACK_BltXLoop
        inc     bx
        and     bx,7
        dec     WORD PTR ySize
        jnz     NSC_BACK_BltYLoop

NSC_BACK_Done:
    ; 
    ; Now do Foreground NOT SourceCopy
    ;
        pop     si                              ; restore offset & seg to bits
        pop     ds
        pop     ax
        mov     ySize,ax
        pop     ax
        mov     Sperrow, ax


        mov     bx, WORD PTR colorFore
        and     bx, 0ffh                        ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        mov     bl, es:_devXlateTbl[bx]
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], bx     ;color data

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking




        mov     WORD PTR gs:[di][GE_ROPPATTERN], 0
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax
        mov     dx, Sperrow
        mov     gs:[di][FIFO16_OFF], dx         ; Shorts per row
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ; yorigin




        mov     bx, yDst                ; initialize bx for mod 8 counter
        sub     bx, [si][BRUSH_Y]
        and     bx, 7
        mov     cx, xDst
        sub     cx, [si][BRUSH_X]
        and     cx, 7
        add     si, BRUSH_PAT

NSC_FORE_BltYLoop:                               ;Only need Y loop cause xloop
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     dx, Sperrow
        mov     al,[si][bx]
        rol     al, cl                  ;Align pattern horizontally

        push    bx
        mov     bx, OFFSET es:BitRTable
        xlatb   es:[bx]
        pop     bx
        mov     ah,al

NSC_FORE_BltXLoop:
        test    dx,FIFOLIMIT
        jnz     NSC_FORE_NoCheck
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

NSC_FORE_NoCheck:
        mov     gs:[di][FIFO16_OFF], ax     
        dec     dx
        jnz     NSC_FORE_BltXLoop
        inc     bx
        and     bx,7
        dec     WORD PTR ySize
        jnz     NSC_FORE_BltYLoop

NSC_FORE_Done:

Exit:


;
; Wait until IV1 idle.
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
;
; Reset Clip plane to FULL SCREEN
;

        mov     WORD PTR gs:[di][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[di][FIFO16_OFF], 1
        mov     ax, 0
        mov     gs:[di][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx
        mov     ax, es:_GLOB_Y_Size
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[di][FIFO16_OFF], dx     
        mov     ax, es:_GLOB_X_Size
        dec     ax
        mov     gs:[di][FIFO16_OFF], ax     
        mov     gs:[di][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Resetting Clip
;


;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        cmp     WORD PTR LocRop, LO_SOURCECOPY
        jz      BltSetRopBack
;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], LO_SOURCECOPY
        mov     ax, -1
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;


BltSetRopBack:

        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     24
devBltPD_Mono   ENDP

_TEXT   ENDS

        END


