        INCLUDE COMMON.INC
        INCLUDE IV1.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _devpStatus          : DWORD
EXTERN  _devUnxlateTbl       : BYTE
EXTERN  _devUpdateColorsTbl  : DWORD
EXTERN  _agr_ioport          : WORD
EXTERN  _ioport              : WORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  Ring3ToRing0         : DWORD
EXTERN  Ring0ToRing3         : DWORD

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

lpDstBits       EQU [bp + 22]
cDstWidthBytes  EQU [bp + 20]
cDstWidthBytes_32  EQU [ebp + 20]
cDstSegScan     EQU [bp + 18]
cDstSegScan_32  EQU [ebp + 18]
cDstFillBytes   EQU [bp + 16]
cDstFillBytes_32   EQU [ebp + 16]
xDst            EQU [bp + 14]
yDst            EQU [bp + 12]
xSrc            EQU [bp + 10]
xSrc_32         EQU [ebp + 10]
ySrc            EQU [bp + 8]
ySrc_32         EQU [ebp + 8]
xSize           EQU [bp + 6]
xSize_32        EQU [ebp + 6]
ySize           EQU [bp + 4]
ySize_32        EQU [ebp + 4]

pDstScan        EQU     [bp - 2]
pDstScan_32     EQU     [ebp - 2]
cDstScan        EQU     [bp - 4]
cDstScan_32     EQU     [ebp - 4]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltSD_ToColor PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 28

        push    esi
        push    edi
        push    gs
        push    es
        push    ds

        mov     ax, ds
        mov     es, ax


;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking




;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, yDst
        lds     si,lpDstBits
        bmScanAddrInc cDstSegScan, cDstWidthBytes, cDstScan, ds, si
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        add     si, xDst
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pDstScan, si
	mov	cx,ySize                ;get the y-extent as a loop counter
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[di][GE_READSOURCE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], RW_FBUFFER_28     ; full 28bit fb

;
; At this point 
;       ds:si : Starting Pixel Bits
;

        test    es:_devpStatus, PALETTETRANS
        jz      NoTranslate
;
; must do color translate code
;
        call    devBltSD_Read_translate
        jmp     Exit

NoTranslate:
;
; Switch to Ring3 for fast IN instructions
;
	movzx	ebp,bp	    
	cmp	word ptr es:Ring3ToRing0+2,0
	jz	short @f
	call	es:Ring3ToRing0		;preserves ds, es, ecx, esi, edi, ebp
        mov     gs, WORD PTR es:[_GRP][2]       ; get back gs
@@:
BltYLoop:
;
; Wait for GE FIFO to become available.
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
    ;
    ; Clear the FINISH1 flag
    ;
    ;
    ; Clear the FINISH1 flag.  The microcode will set this flag to indicate
    ; it has received DMA token and is ready to START DMA.
    ;
        sub     eax,eax
        mov     gs:[di][FINISHFLAG1], eax


        mov     WORD PTR gs:[di][GE_READBLOCK_R], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0 ;dummy upacmode 
        mov     ax, xSrc_32
        mov     gs:[di][FIFO16_OFF], ax         ;starting x
        mov     ax, xSize_32
        mov     gs:[di][FIFO16_OFF], ax         ;x size
        mov     ax, ySrc_32
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
	sub	dx, ax                          ;get translated Y
        mov     gs:[di][FIFO16_OFF], dx         ;starting y
    ;
    ; now we need to send down a "no interrupts" flag
    ;
	mov	ax, IV1BLTDONE                  ;-1(for no interrupts, usethe done flag)
	mov	gs:[di][FIFO16_OFF], ax

        mov     ax, 1                           ; must send down Y size of 1
                                                ; cause of IV1 UCode
        mov     gs:[di][FIFO16_OFF], ax         ;y length
        mov     ax, IV1BLTDONE
        mov     gs:[di][FIFO16_OFF], ax         ;done flag
    ;
    ; Wait for microcode to be ready (FINISH1 flag set)
    ;
@@:     test    BYTE PTR gs:[di][FINISHFLAG1], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking
        EnterCrit                               ; 
                                                ; to disable mouse ints
                                                ; which screw up when
                                                ; stringburst is on
                                                ;
    ;
    ; Turn on "string burst" mode
    ;
	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
        mov     cx,dx                           ;save base port

	add	dx, IV1CONFIG_PORT
	in	ax, dx
	or	ax, IV1CFGSTRN_BURST
	out	dx, ax
    ;
    ; Get DMA Port
    ;
        mov     dx, cx                          ;get base port
	add	dx, IV1CFGSTRING_IO_PORT

        cld
        mov     cx,xSize_32
BltXLoop:
        in      eax,dx
        mov     byte ptr ds:[si],al

        inc     si
        dec     cx
        jnz     BltXLoop


   ;
   ;Must Delay before turning off stringburst mode
   ;IV1 HARDWARE BUG
   ;

        mov     cx,IV1HWBUGLOOP         ;do 30 in's from port 84 for delay

IV_DELAYLOOP:
        mov     dx,084h
        in      ax,dx
        loop    IV_DELAYLOOP

   ;
   ;At this point we can turn off stringburst mode
   ;

	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
	add	dx, IV1CONFIG_PORT

	in	ax, dx
	and	ax, NOT IV1CFGSTRN_BURST
	out	dx, ax

        LEAVECRIT                               ;
                                                ; Reenable mouse ints
                                                ;
    ;
    ; Clear the FINISH1 flag
    ;
        sub	eax,eax
        mov     gs:[di][FINISHFLAG1], eax


        dec     WORD PTR ySize_32
        jz      Ring0Exit

        add     WORD PTR ySrc_32,1
;
; Increment to next scanline.
;
        mov     si, pDstScan_32
        bmScanInc si, ds, cDstSegScan_32, cDstWidthBytes_32, WORD PTR cDstScan_32, cDstFillBytes_32
        mov     pDstScan_32, si
        jmp     BltYLoop
Ring0Exit:
;
; Switch back to Ring 3.
;
	cmp	word ptr es:Ring0ToRing3+2,0
	jz	short @f
	call	es:Ring0ToRing3		;preserves ds, es, ecx, esi, edi, ebp
@@:
Exit:
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi

        leave
        ret     22

devBltSD_ToColor ENDP




;
; devBltSD_Read_translate  
;
; on entry ds:si = start of bits
;          gs:di = REXPTR seg
;          es = data seg
;
devBltSD_Read_translate  PROC




BltYLoopXlate:
;
; Wait for GE FIFO to become available.
;
	lea	bx, es:_devUnxlateTbl
@@:
;        test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking
    ;
    ; Clear the FINISH1 flag
    ;
    ;
    ; Clear the FINISH1 flag.  The microcode will set this flag to indicate
    ; it has received DMA token and is ready to START DMA.
    ;
        sub     eax,eax
        mov     gs:[di][FINISHFLAG1], eax


        mov     WORD PTR gs:[di][GE_READBLOCK_R], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0 ;dummy upacmode 
        mov     ax, xSrc
        mov     gs:[di][FIFO16_OFF], ax         ;starting x
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax         ;x size
        mov     ax, ySrc
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
	sub	dx, ax                          ;get translated Y
        mov     gs:[di][FIFO16_OFF], dx         ;starting y
    ;
    ; now we need to send down a "no interrupts" flag
    ;
	mov	ax, IV1BLTDONE                  ;-1(for no interrupts, usethe done flag)
	mov	gs:[di][FIFO16_OFF], ax

        mov     ax, 1                           ; must send down Y size of 1
                                                ; cause of IV1 UCode
        mov     gs:[di][FIFO16_OFF], ax         ;y length
        mov     ax, IV1BLTDONE
        mov     gs:[di][FIFO16_OFF], ax         ;done flag
    ;
    ; Wait for microcode to be ready (FINISH1 flag set)
    ;
@@:     test    BYTE PTR gs:[di][FINISHFLAG1], 1        ;Check for Flag Set
        jz      @b                                      ;Keep checking

        EnterCrit                               ; 
                                                ; to disable mouse ints
                                                ; which screw up when
                                                ; stringburst is on
                                                ;
    ;
    ; Turn on "string burst" mode
    ;
        push    bx
	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
        mov     cx,dx                           ;save base port
        pop     bx

	add	dx, IV1CONFIG_PORT
	in	ax, dx
	or	ax, IV1CFGSTRN_BURST
	out	dx, ax
    ;
    ; Get DMA Port
    ;
        mov     dx, cx                          ;get base port
	add	dx, IV1CFGSTRING_IO_PORT

        cld
        mov     cx,xSize
BltXLoopXlate:
        in      eax,dx
        xlatb   es:[bx]
        mov     byte ptr ds:[si],al

        inc     si
        dec     cx
        jnz     BltXLoopXlate




   ;
   ;Must Delay before turning off stringburst mode
   ;IV1 HARDWARE BUG
   ;

        mov     cx,IV1HWBUGLOOP         ;do 30 in's from port 84 for delay

IV_DELAYLOOP:
        mov     dx,084h
        in      ax,dx
        loop    IV_DELAYLOOP

   ;
   ;At this point we can turn off stringburst mode
   ;

	mov     bx,WORD PTR es:_agr_ioport
	shl     bx,1
	mov     dx,WORD PTR es:_ioport[bx]
	add	dx, IV1CONFIG_PORT

	in	ax, dx
	and	ax, NOT IV1CFGSTRN_BURST
	out	dx, ax


        LEAVECRIT                               ;
                                                ; Reenable mouse ints
                                                ;

    ;
    ; Clear the FINISH1 flag
    ;
        sub	eax,eax
        mov     gs:[di][FINISHFLAG1], eax


        dec     WORD PTR ySize
        jz      ExitXlate

        add     WORD PTR ySrc,1

;
; Increment to next scanline.
;
        mov     si, pDstScan
        bmScanInc si, ds, cDstSegScan, cDstWidthBytes, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, si
        jmp     BltYLoopXlate
ExitXlate:

        ret
devBltSD_Read_translate  ENDP

_TEXT   ENDS

        END


