.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV1.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Solid Filled Bitblt.                                             ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/14/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN Rop2XlateTable : BYTE
EXTERN  _devXlateTbl         : BYTE

EXTERN _GRP:DWORD
EXTERN _Y_TRANSLATION: WORD

.CODE
.386

devBltPD_Solid     PROC NEAR USES gs                    \
                        xDst  : WORD,                   \
                        yDst  : WORD,                   \
                        xSize : WORD,                   \
                        ySize : WORD,                   \
                        color : DWORD,                  \
                        rop   : WORD

        push    edi


;
; Get IV1 version of rop.
;
        xor     cx, cx
        mov     bx, rop
        mov     cl, Rop2XlateTable[bx]
;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
;
; Wait for GE FIFO to become available.
;
        mov     dx, _Y_TRANSLATION
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     gs:[di][FIFO16_OFF], cx     
        cmp     cx,LO_XOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        cmp     cx,LO_XNOR
        jne     @f
        mov     ax,1
        jmp     IVEndRop
@@:
        mov     ax, -1
IVEndRop:
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking


        mov     bx, WORD PTR color
        and     bx, 0ffh                        ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        
         mov     bl, _devXlateTbl[bx]
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], bx     ;color data

;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        cmp     xSize, 1
        jnz     NotVertical


        mov     dx, _Y_TRANSLATION
        mov     cx, dx
        mov     ax, yDst
        sub     dx, ax   
        mov     ax, yDst
        add     ax, ySize
        dec     ax
        sub     cx, ax

        mov     WORD PTR gs:[di][GE_FLINE], 0
        mov     ax, xDst
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     WORD PTR gs:[di][FIFO16_OFF], dx
        add     ax, xSize
        dec     ax
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     WORD PTR gs:[di][FIFO16_OFF], cx     
        jmp     Exit

NotVertical:


        mov     WORD PTR gs:[di][GE_SOLIDBRUSH], 0
        mov     ax, xDst
        mov     gs:[di][FIFO16_OFF], ax     

        sub     dx, yDst
        mov     gs:[di][FIFO16_OFF], dx         ;Y translated start 
        
        mov     ax, xSize
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, ySize
        mov     gs:[di][FIFO16_OFF], ax



Exit:
;@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

;        
; setting IV1 ROP back
;
        mov     WORD PTR gs:[di][GE_RASTEROP], 0
        mov     ax, 3
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, -1
IVEndRopBack:
        mov     gs:[di][FIFO16_OFF], ax     
;        
; end of setting IV1 ROP
;

        pop     edi

        ret
devBltPD_Solid     ENDP


        END


