.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV1.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and reset REX clipping registers.                            ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/20/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA


EXTERN  _GRP                 : DWORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD

.CODE
.386

;
; Enable clip rectangle.
;

devpSetClipRect PROC NEAR USES ds gs si es            \
                        lpRect : DWORD



        mov     ax, ds
        mov     es, ax

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]

        lds     si, lpRect

;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking


;
; Set Clip Rectangle
;

        mov     WORD PTR gs:[bx][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[bx][FIFO16_OFF], 1
        mov     ax, [si]                        ; rectLeft
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     dx, es:_Y_TRANSLATION
        mov     cx, dx

        mov     ax, [si][6]                     ; rectBottom
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[bx][FIFO16_OFF], dx     

        mov     ax, [si][4]                     ; rectRight
        dec     ax
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     ax, [si][2]                     ; rectTop
        sub     cx, ax
        mov     gs:[bx][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Setting Clip
;


        ret

devpSetClipRect ENDP


;
; Disable clip rectangle.
;
devpResetClipRect PROC NEAR USES gs 

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]
;
; Wait until IV1 idle.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
;
; Reset Clip plane to FULL SCREEN
;

        mov     WORD PTR gs:[bx][GE_SCRMASK], 0

    ;
    ;  Need a Y translation first then, a reversal of start y and end y
    ;  because IV is looking for coords in lly first and coming in as uly
    ;  first, etc  
    ;

        mov     WORD PTR gs:[bx][FIFO16_OFF], 1
        mov     ax, 0
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     dx, _Y_TRANSLATION
        mov     cx, dx
        mov     ax, _GLOB_Y_Size
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     gs:[bx][FIFO16_OFF], dx     
        mov     ax, _GLOB_X_Size
        dec     ax
        mov     gs:[bx][FIFO16_OFF], ax     
        mov     gs:[bx][FIFO16_OFF], cx         ; Ytranslation-starty

;
; Done Resetting Clip
;



        ret  

devpResetClipRect ENDP

;
; Draw opaque rectangle for text.
;

devpOpaqueRect  PROC NEAR USES ds gs si                 \
                        lpRect : DWORD,                 \
                        clr    : WORD

;
; Get IV1 GRP PTR
;

        mov     gs, WORD PTR [_GRP][2]
        mov     bx, WORD PTR [_GRP]
        mov     dx, _Y_TRANSLATION
        mov     cx, dx
        lds     si, lpRect

;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking

        mov     ax, WORD PTR clr
        and ax, 0ffh                            ; not sure if this is
                                                ; needed but IV1 has 
                                                ; >256 lookup

        mov     WORD PTR gs:[bx][GE_COLOR], 0
        mov     gs:[bx][FIFO16_OFF], ax     ;color data

;@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1     ;Check for FIFO full
;        jnz     @b                              ;Keep checking

        mov     WORD PTR gs:[bx][GE_SOLIDBRUSH], 0
        mov     ax, [si]                        ; rectLeft
        mov     gs:[bx][FIFO16_OFF], ax     

        mov     ax, [si][2]                     ; rectTop
        sub     dx, ax
        mov     gs:[bx][FIFO16_OFF], dx         ;Y translated start 
        
        mov     dx, [si]
        mov     ax, [si][4]                     ; rectRight
        sub     ax, dx                          ; (get xsize)
        mov     gs:[bx][FIFO16_OFF], ax
        mov     dx, [si][2]
        mov     ax, [si][6]                     ; rectBottom
        sub     ax, dx                          ; (get ysize)
        mov     gs:[bx][FIFO16_OFF], ax


        ret
devpOpaqueRect  ENDP

devpSaveScreen  PROC NEAR USES gs di ds si                \
                        lpRect : DWORD
;
; Get IV1 GRP PTR
;
        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
        mov     ax, ds
        mov     es, ax
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        lds     si, lpRect
;
; Save Rect
;
        mov     WORD PTR gs:[di][GE_AUXWRITEMASK], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0100h     ; ZBUFFER BITplanes
        mov     WORD PTR gs:[di][GE_RWMODE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 3     ; ZBUFFER BITplanes
        mov     WORD PTR gs:[di][GE_READSOURCE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], RW_FBUFFER_28     ; full 28bit fb
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
        mov     cx, dx
        mov     WORD PTR gs:[di][GE_RECTCOPY], 0
        mov     ax, [si][6]                     ; rectBottom
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     WORD PTR gs:[di][FIFO16_OFF], dx
        mov     WORD PTR gs:[di][FIFO16_OFF], dx
        mov     ax, [si][2]                     ; rectTop
        sub     cx, ax
        sub     cx, dx                          ; ySize
        add     cx, 1
        mov     WORD PTR gs:[di][FIFO16_OFF], cx    
        mov     ax, [si]                        ; rectLeft
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     cx, [si][4]                     ; rectRight
        sub     cx, ax                  
        mov     WORD PTR gs:[di][FIFO16_OFF], cx        ; xSize
        mov     WORD PTR gs:[di][GE_RWMODE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0     ; FrameBuffer BITplanes
        mov     WORD PTR gs:[di][GE_AUXWRITEMASK], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 0h     ; FrameBUFFER BITplanes
        ret     

devpSaveScreen    ENDP


devpRestoreScreen       PROC NEAR USES gs di ds si                \
                        lpRect : DWORD
;
; Get IV1 GRP PTR
;
        mov     gs, WORD PTR [_GRP][2]
        mov     di, WORD PTR [_GRP]
        mov     ax, ds
        mov     es, ax
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1     ;Check for FIFO full
        jnz     @b                              ;Keep checking
        lds     si, lpRect
;
; Restore Rect
;
        mov     WORD PTR gs:[di][GE_READSOURCE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], 3     ; ZBUFFER BITplanes
        mov     dx, es:_Y_TRANSLATION           ;Glob Ysize-1
        mov     cx, dx
        mov     WORD PTR gs:[di][GE_RECTCOPY], 0
        mov     ax, [si][6]                     ; rectBottom
        dec     ax
        sub     dx, ax                          ; Ytranslation-endy
        mov     WORD PTR gs:[di][FIFO16_OFF], dx
        mov     WORD PTR gs:[di][FIFO16_OFF], dx
        mov     ax, [si][2]                     ; rectTop
        sub     cx, ax
        sub     cx, dx                          ; ySize
        add     cx, 1
        mov     WORD PTR gs:[di][FIFO16_OFF], cx    
        mov     ax, [si]                        ; rectLeft
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     WORD PTR gs:[di][FIFO16_OFF], ax
        mov     cx, [si][4]                     ; rectRight
        sub     cx, ax                  
        mov     WORD PTR gs:[di][FIFO16_OFF], cx        ; xSize
        mov     WORD PTR gs:[di][GE_READSOURCE], 0
        mov     WORD PTR gs:[di][FIFO16_OFF], RW_FBUFFER_28     ; full 28bit fb
        ret     

devpRestoreScreen    ENDP

        END



