.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Match color to logical or physical color.                        ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       05/28/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN  _devSystemPalette : DWORD
EXTERN  _devColorToMono   : BYTE

.CODE
.386

;
; Match a logical color to the nearest representable physical color.
;
devMatchPhysicalColor   PROC NEAR USES esi edi, clr : DWORD

        mov     ax, WORD PTR clr
        mov     dx, WORD PTR clr + 2
        or      dh, dh
        jnz     Exit
;
; Match a logical color to the nearest representable physical color.
;
; al = logical red
; ah = logical green
; dl = logical blue
;
        mov     cx, ax
        mov     bx, 76                          ; Point to last palette entry    
        xor     esi, esi                        ; Outrageous initial error term
        not     esi
        xor     eax, eax                        ; Clear upper bits of eax
;
; Caclulate least squared difference between logical RGB color and physical RGB
; colors.
;
MatchLoop:
        mov     al, BYTE PTR _devSystemPalette[bx] ; Calc delta red squared
        sub     al, cl
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        mov     edi, eax                        ; Save initial working error
        mov     al, BYTE PTR _devSystemPalette[bx + 1] ; Calc delta green squared
        sub     al, ch
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        add     edi, eax                        ; Add to working error
        mov     al, BYTE PTR _devSystemPalette[bx + 2] ; Calc delta blue squared
        sub     al, dl
        sbb     ah, ah
        xor     al, ah
        sub     al, ah
        mul     al
        add     edi, eax                        ; Add to working error
        cmp     edi, esi                        ; Is working error less than
        jb      NewMatch                        ; current minumum error?
        or      bx, bx
        jz      MatchLoopExit
        sub     bx, 4
        jmp     MatchLoop
;
; A closer match was found so save it.
;
NewMatch:
        mov     dh, bl
        or      edi, edi                        ; Check for exact match
        jz      MatchLoopExit
        mov     esi, edi
        or      bx, bx
        jz      MatchLoopExit
        sub     bx, 4
        jmp     MatchLoop
;
; The closest color match index is now in dh.  Convert it into an actual
; color index and monochrome color.
;
MatchLoopExit:
        mov     bl, dh
        mov     al, BYTE PTR _devSystemPalette[bx + 3]
        shr     bx, 2
        mov     ah, _devColorToMono[bx]
;
; al = physical color index
; ah = physical mono bit
;
        mov     dx, 0FF00h
Exit:
        ret
devMatchPhysicalColor   ENDP

;
; Match a physical color to the nearest representable logical color.
; Return physical color if not in the system palette (i.e. palette managed).
;
devColorMatchLogicalColor       PROC NEAR clr : DWORD

        mov     ax, WORD PTR clr
        mov     dx, WORD PTR clr + 2
        or      dh,dh
        jz      Exit
        cmp     al, 10
        jb      @F
        cmp     al, 246
        jb      Exit
        sub     al, 236
@@:     xor     bh, bh
        mov     bl, al
        shl     bx, 2
        mov     ax, WORD PTR _devSystemPalette[bx]
        mov     dl, BYTE PTR _devSystemPalette[bx + 2]
        xor     dh, dh
Exit:
        ret
devColorMatchLogicalColor       ENDP

;
; Match a physical color to the nearest representable logical color.
; Return physical color if not in the system palette (i.e. palette managed).
;
devMonoMatchLogicalColor        PROC NEAR clr : DWORD

        mov     ax, WORD PTR clr
        mov     dx, WORD PTR clr + 2
        or      dh,dh
        jz      Exit
        cmp     al, 10
        jb      @F
        cmp     al, 246
        jb      Exit
        sub     al, 236
@@:     xor     bh, bh
        mov     bl, al
        mov     ah, _devColorToMono[bx]
        shr     ah, 1
        sbb     ax, ax
        mov     dl, al
        xor     dh, dh
Exit:
        ret
devMonoMatchLogicalColor        ENDP
        END
