/****************************************************************************\
*                                                                            *
* Function: DIB support for devices.                                         *
*                                                                            *
*       Set DIBits and RLEs to device.                                       *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       06/08/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1993 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "bitblt.h"
#include "iv1.h"

extern _AHIncr;
extern devpStatus;

WORD WINAPI DeviceBitmapBits(LPBITMAP, WORD, WORD, WORD, LPBYTE, LPBITMAPINFOHEADER, LPDRAWMODE, LPWORD);

WORD WINAPI SetDIBitsToDevice
(
    LPDEVICE           lpDst,
    WORD               xDst,
    WORD               yDst,
    WORD               iStart,
    WORD               cScans,
    LPRECT             lpClipRect,
    LPDRAWMODE         lpDrawMode,
    LPSTR              dibBits,
    LPBITMAPINFOHEADER lpBitmapInfo,
    LPWORD             lpXlate
)
{
    WORD     yOffset;
    WORD     tmpStatus;
    LPBITMAP lpTmpBitmap;
    RECT     rectDst;

    DBGMSG("SetDIBitsToDevice\n\r");

    //
    // Create temporary bitmap to copy DIB into.
    //

    lpTmpBitmap = CreateColorBitmap((SHORT)lpBitmapInfo->biWidth, (SHORT)lpBitmapInfo->biHeight);

    //
    // Copy DIB to device bitmap.
    //

    DeviceBitmapBits(lpTmpBitmap,
                     0,
                     iStart,
                     cScans,
                     dibBits,
                     lpBitmapInfo,
                     lpDrawMode,
                     lpXlate);

    //
    // Blt temporary bitmap to screen.
    //

    if (iStart < lpTmpBitmap->bmHeight)
    {
        if (iStart + cScans > lpTmpBitmap->bmHeight)
            cScans = lpTmpBitmap->bmHeight - iStart;

        yOffset = lpTmpBitmap->bmHeight - iStart - cScans;

        //
        // Make sure no translation takes place.
        //

        tmpStatus = devpStatus;
        devpStatus &= ~PALETTETRANS;

        //
        // Clip to rectangle.
        //

        rectDst.left   = xDst;
        rectDst.top    = yDst + yOffset;
        rectDst.right  = xDst + lpTmpBitmap->bmWidth;
        rectDst.bottom = yDst + yOffset + cScans;
        if (lpClipRect)
            ClipRect(&rectDst, lpClipRect, &rectDst);

        if ((rectDst.left < rectDst.right) && (rectDst.top < rectDst.bottom))
        {
            devBltSD_Color(rectDst.left,
                           rectDst.top,
                           lpTmpBitmap->bmBits,
                           lpTmpBitmap->bmWidthBytes,
                           lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                           lpTmpBitmap->bmFillBytes,
                           rectDst.left - xDst,
                           rectDst.top  - yDst,
                           rectDst.right  - rectDst.left,
                           rectDst.bottom - rectDst.top,
                           0,
                           OPAQUE,
                           0x0C);  // R2_COPYPEN
        }

        //
        // Restore status.
        //

        devpStatus = tmpStatus;
    }

    //
    // Destroy temporary bitmap.
    //

    DestroyBitmap(lpTmpBitmap);

    return(cScans);
}
