.MODEL SMALL, PASCAL

INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Write/Read 32 bit MEM Writes.                                    ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/11/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA


.CODE
.386

;
;  This function is needed to do real 32-bit writes to IrisVision which
;  MSC 6.0 can't do.
;
LongWrite32     PROC FAR, MemPtr : DWORD, x : DWORD
	push	es
	push	eax

	les     bx,MemPtr
	mov     eax,x
	mov	es:[bx],eax

	pop	eax
	pop	es
        ret
LongWrite32 ENDP

LongRead32     PROC FAR, MemPtr : DWORD
	push	es

	les     bx,MemPtr
	mov	eax,es:[bx]
        mov     edx,eax
        shr     edx,16

	pop	es
        ret
LongRead32 ENDP

END

