#ifndef	GE5GLOBALS
/* $Revision: 1.1 $ */
/**************************************************************************
 *				      *
 *	 Copyright (C) 1987, Silicon Graphics, Inc.	  *
 *				      *
 *  These coded	instructions, statements, and computer programs	 contain  *
 *  unpublished	 proprietary  information of Silicon Graphics, Inc., and  *
 *  are	protected by Federal copyright law.  They  may	not be disclosed  *
 *  to	third  parties	or copied or duplicated	in any form, in	whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *				      *
 **************************************************************************/

/*********************************************************************
*
*   Global variable declarations for GE5.
*
*********************************************************************/

/* the values of these literals	are the	locations in memory */

#define	DIVMODTBL      0	/* base	of divmod table	1280 words */

#if 0 /* this does not appear to be used anywhere */
#define	CONSTMEM    1280	/* base	of constants 120 words */
#endif

#define CHKSUMLOC   1281	/* */
#define	MAXCONS	    1450	/* maximum constants address + 1 */
#define	VARBASE	    1450	/* base	of global variable area	360 words */
#define	DMABASE1    MAXCONS - 1	/* base	of context switch data less 1 */

#define	MATRIXMEM   1810	/* base	of matrix stack	16*17 =	272 words */

#if 0 /* obsolete */
#define	PHIGSMATRIX 1980	/* base	of PHIGS matrix	stack 6*17 words */
#endif

#define	NORMALMEM   2082	/* base	of normal matrix stack 16*11 words */
#define	SAVREG	    2258	/* base	of register save memory	- 40 words */
				/* used	to save	weitek state at	ctx switch */
#define	LIGHTDATA   2298	/* base	of lighting data area  250 words */

#define	DATAMEM	    2548	/* base	of vertex list 256*9 = 2304 words */
#define	PIXELMEM    DATAMEM	/* base	of copy	space for 1280 pixels */
#define	PIXELMEM1   PIXELMEM - 1
#define	PIXELMUL    PIXELMEM + 1280 /* base of copy space for zoomed pixels */
#define	PIXELMUL1   PIXELMUL - 1    /* max zoomed pixels = 2560+24(buffer)  */
#define	MAXPKFEED   1701	/* Maximum picking/feedback buffer size	+ 1 */
#define	LIST2MEM    4852	/* base	of output list-clipping	256*9 (2304) */
#define	DMABASE2    LIST2MEM - 1    /* context switch data - 2nd part less 1 */
#define	IODATA	    5838	/* base	of host	io data	(picking) 700 words */
#define	IODATA1	    IODATA - 1

#if 0 /* obsolete */
#define	SURFMEM	    LIST2MEM+100    /* base of surface data (300 words)	*/
#endif

#define	NAMESTACK   (IODATA+700)    /* base of namestack for picking 1000 words	*/
#define	NAMELESS1   NAMESTACK -	1
#define	NAMELESS2   NAMESTACK -	2
#define	MEM_END	    7538	/* this	is the end of the context */
				/* specific data space */

#define	SCRTMEM	    7538	/* base	of scratch memory area > 40 min	*/
#define	STATMEM	    7702	/* base	of static memory used for communication
				   at DMA time.	 This memory is	not saved and
				   restored at context switch time (46 words) */

#define	NUMMATRIX   F16.0	/* max.	number of matrices in stack */
#define	PT_SMPL_OFF  F0.999999	/* point sampling offset for y coord */
#define	PT_SMPL_XOFF F0.9999	/* point sampling offset for x coord */

#define	DMAMAXSIZE  2047
#define	CTXMAXSIZE  MEM_END - MAXCONS			/* 6138	*/
#define	CTXMAX1_2   DMAMAXSIZE				/* 2047	*/
#define	CTXMAX3	    CTXMAXSIZE - (2 * CTXMAX1_2)	/* 2006	*/
#define	 CTXMINSIZE  DATAMEM - MAXCONS + 180		/* 1232 */
#define	CTXMINSIZE1 DATAMEM - MAXCONS +	90		/* 1142	*/
#define	CTXMINSIZE2 90

/* Ucode has context sizes in words, here they are in bytes */
#define	CXSMALL_NBYTES	((DMAMAXSIZE) *	4)
#define	CXBIG_NBYTES	((CTXMAXSIZE) *	4)

/*
 * Macro to convert data RAM word address to addr in saved kernel/NeWS context.
 * Ucode uses real_address - 1 DMA base	addresses so we	have to	add 1.
 */
#define	GR1_GETOCX(addr)    ((addr) - (DMABASE1	+ 1))


/*** The memory	locations from CR to SCREENZ are required to be
     contiguous	!!! */

#define	CR	    VARBASE+0	/* current Red/Cidx value */
#define	CG	    VARBASE+1
#define	CB	    VARBASE+2

#define	GX	    VARBASE+3	/* current graphics position */
#define	GY	    VARBASE+4
#define	GZ	    VARBASE+5
#define	GW	    VARBASE+6

#define	SCREENX	    VARBASE+7	/* The screen coordinates of the previous */
#define	SCREENY	    VARBASE+8	/* point, when drawing the line	*/
#define	SCREENZ	    VARBASE+9

#define	CHARVALID   VARBASE+10	/* current text	valid flag & position */
#define	AX	    VARBASE+11
#define	AY	    VARBASE+12
#define	AZ	    VARBASE+13
#define	CPOSX	    VARBASE+14	/* integer value of cpos for getcpos */
#define	CPOSY	    VARBASE+15

#define	SCALEX	    VARBASE+16	/* screen transform scale values (AKA SX) */
#define	SCALEY	    VARBASE+17  /* AKA "SY" */
#define	SCALEZ	    VARBASE+18  /* AKA "SZ" */
#define	TX	    VARBASE+19	/* screen transform offset values */
#define	TY	    VARBASE+20
#define	TZ	    VARBASE+21
#define	VPL	    VARBASE+22	/* viewport dimensions */
#define	VPB	    VARBASE+23
#define	VPR	    VARBASE+24
#define	VPT	    VARBASE+25
#define	SCRL	    VARBASE+26	/* screen mask rectangle values	*/
#define	SCRB	    VARBASE+27
#define	SCRR	    VARBASE+28
#define	SCRT	    VARBASE+29

#define	READSOURCE  VARBASE+30	/* RWMODE for reading pixels */

/* CAUTION - DO	NOT CHANGE ORDER OF ANY	OF THE NEXT 20 ITEMS --- THESE
   ARE RESTORED	AT EACH	CONTEXT	SWITCH IN A SPECIFIC ORDER */

#define	PUPDATA	    VARBASE+31	/* pup write data */
#define	STIP	    VARBASE+32	/* the current 16-bit stipple pattern*/
#define	STIPCOUNT   VARBASE+33	/* decremental count register */

#define	PIXMASK	    VARBASE+34	/* current pixel mask 24-bits */
#define	AUXMASK	    VARBASE+35	/* current z,wid,uaux,pup mask 9 bits */
#define	WIDDATA	    VARBASE+36	/* wid write data */
#define	UAUXDATA    VARBASE+37	/* uaux	write data */
#define	RWMODE	     VARBASE+38	 /* read/write pixel mode */
#define	READBUF	    VARBASE+39	/* backbuffer */
#define	PIXTYPE	    VARBASE+40	/* pixel mode (color, RGB, #bits) */
#define	ASELECT	    VARBASE+41	/* anti-aliasing enable	*/
#define	ALIGNTEX    VARBASE+42	/* aligns texture to screen */
#define	ENABTEX	    VARBASE+43	/* texture (patterns) enabled */
#define	ENABSTIP    VARBASE+44	/* line	stipple	enabled	*/
#define	ENABDITH    VARBASE+45	/* dithering enabled */
#define	ENABWID	    VARBASE+46	/* wid check enabled */
#define	CURWID	    VARBASE+47	/* current wid for write enable	*/
#define	DEPTHFN	    VARBASE+48	/* turns on/off	z compare */
#define	REPSTIP	    VARBASE+49	/* stipple repeat count	*/
/* CAUTION!!! FLATMODE and picecelist data must	directly follow	ENABLWID */
/* DO NOT CHANGE THE ORDER OF ANY OF THE NEXT 24 ITEMS */
#define	ENABLWID    VARBASE+50	/* wid check enabled for lines */
#define	FLATMODE    VARBASE+51	/* = 1 when VP obscured; else =	2 */
#define	FLATDX	    VARBASE+52	/* = 0x4000 when VP obscured; else = 0 */
#define	NEWORG	    VARBASE+53	/* window port moved flag 1=moved, -1=not */
#define	XORG	    VARBASE+54	/* X origin of window port */
#define	YORG	    VARBASE+55	/* Y origin of window port */
#define	SIMPLE	    VARBASE+56	/* > -1	= 4 or less rectangles */
#define	NUMPIECES   VARBASE+57	/* number of pieces varies from	1-4 */
				/* for SIMPLE contexts */
#define	YLEN1	    VARBASE+58	/* location of first piece */
#define	LLY1	    VARBASE+59
#define	XLEN1	    VARBASE+60
#define	LLX1	    VARBASE+61
#define	YLEN2	    VARBASE+62	/* location of second piece */
#define	LLY2	    VARBASE+63
#define	XLEN2	    VARBASE+64
#define	LLX2	    VARBASE+65
#define	YLEN3	    VARBASE+66	/* location of third piece */
#define	LLY3	    VARBASE+67
#define	XLEN3	    VARBASE+68
#define	LLX3	    VARBASE+69
#define	YLEN4	    VARBASE+70	/* location of fourth piece */
#define	LLY4	    VARBASE+71
#define	XLEN4	    VARBASE+72
#define	LLX4	    VARBASE+73

/* Branch flags	*/

#define	NOZOOM	    VARBASE+74	/* >= 0	means zoom is not active */
#define	ZOOMX	    VARBASE+75	/* pixel repeat	count -	x direction */
#define	ZOOMY	    VARBASE+76	/* pixel repeat	count -	y direction */
#define	ZOOMX2	    VARBASE+77	/* x zoom 2 flag */
#define	ZOOMX3	    VARBASE+78	/* x zoom 3 flag  */

#define	DRAWBR1	    VARBASE+79	/* drawmode branch flags =1 or -1 */
#define	DRAWBR2	    VARBASE+80	/* drawmode branch flags =1 or -1 */
#define	DRAWBR3	    VARBASE+81	/* drawmode branch flags =1 or -1 */
#define	COLORINDEX  VARBASE+82	/* GM mode flag	color =	1, RGB = -1 */
#define	CSWITCH	    VARBASE+83	/* set to 1 by context switch routine */

/* Mode	flags */

#define	CONCAVE	    VARBASE+84	/* flag	to enable concave checking */
#define	BACKFACE    VARBASE+85	/* flag	to enable backface removal */
#define	SHADEMODEL  VARBASE+86	/* flag	to enable gouraud shading */

#define	DEPTHCUE    VARBASE+87	/* flag	to enable depthcued lines */
#define	ZBUFFER	    VARBASE+88	/* flag	to enable zbuffering */
#define	ANTIALIASE  VARBASE+89	/* True	(0.5), if FLOAT(ASELECT) > 0.0 */
#define	WIDELINE    VARBASE+90	/* True	(positive value), if line width	> 1.0 */
#define	PICKMODE    VARBASE+91	/* set when in hit mode	(picking) */
#define	NOT_SOLID   VARBASE+92	/* True, if STIP != 0xffff */
#define	SCRMASKCLIP VARBASE+93	 /* True, if screen mask clipping is required */
#define	FASTLINE    VARBASE+94	/* flag	for fast line branch*/
#define	FEEDBACK    VARBASE+95	/* TRUE	if feedback mode is set	*/
#define	FIRSTMOVE   VARBASE+96	/* TRUE	if we just did a MOVE */

#define	CONVEX	    VARBASE+97	/* TRUE	if polygon is convex */
#define	CLOCKWISE   VARBASE+98	/* TRUE	if vertices are	in clockwise order */
#define	CLIPFLAG    VARBASE+99	/* TRUE	if the polygon needs clipping */
#define	LINECLIP    VARBASE+100	/* TRUE	if line	needs to be clipped */
#define	CLOSEDLINE  VARBASE+101	/* flag	to enable closedline */
#define	TEXTURE	    VARBASE+102	/* flag	to enable textured polygons */
#define	FATPOLY	    VARBASE+103	/* flag	to enable polygon outlining */
#define	VIEWMODE    VARBASE+104	/* flag	to indicate Viewing Matrix mode	*/
#define	ABNORMAL    VARBASE+105	/* normalize "normal" vector if	TRUE */
#define	SLOWPOLY    VARBASE+106	/* flag	for fast polygon branch	*/

#define	ZMIN	    VARBASE+107	/* shade range values (depthcue) */
#define	ZMAX	    VARBASE+108
#define	RMIN	    VARBASE+109
#define	GMIN	    VARBASE+110
#define	BMIN	    VARBASE+111
#define	RSLOPE	    VARBASE+112
#define	GSLOPE	    VARBASE+113
#define	BSLOPE	    VARBASE+114
#define	TEXADR	    VARBASE+115	/* address of current texture entry */
#define	TEXBASE	    VARBASE+116	/* pointer to the texture array	*/
#define	TEXMAX	    VARBASE+117	/* number of entries in	texture	array */
#define	CURMATRIX   VARBASE+118	/* pointer to the top matrix */
#define	FREELIST    VARBASE+119	/* pointer to the unused matrix	list */
#define	NORMALMATRIX	VARBASE+120 /* pointer to the normal matrix */
#define	NORMALFREE  VARBASE+121	/* pointer to the unused normal	matrix list */


#define	NUMVERTEX   VARBASE+122	/* number of vertices */
#define	FIRSTVERTEX VARBASE+123	/* pointer to the first	vertex */
#define	CURVERTEX   VARBASE+124	/* pointer to the current vertex */
#define	NEXTVERTEX  VARBASE+125	/* pointer to the next vertex */
#define	MIN_VERT    VARBASE+126	/* pointer to the minimum Y vertex */
#define	LNWIDTH	    VARBASE+127	/* Line	width */
#define	RVSTIP	    VARBASE+128	/* TRUE, if calculation	of reverse
				   STIP	is required */
#define	LNSLOPE	    VARBASE+129	/* True	(1.0), if deltay >= deltax
				   False (-1.0), if deltay < deltax */
#define	LN_RtoL	    VARBASE+130	/* True(1.0), if line drawn from right to left*/
#define	SMK_CLIP_LINE	VARBASE+131 /* True, if	scrmask	cliping	required for
					antialising and	wide line */
#define	STIP0_TBL   VARBASE+132	/* 32 locations	are allocated for the first STIP				    table */
#define	STIP1_TBL   VARBASE+164	/* 32 locations	are
				   allocated for the second STIP table */

#define	MOREHITS    VARBASE+196	/* set when hits are received.	Reset to
				 * zero	at each	stack command after
				 * name	list is	loaded to buffer

				 */
#define	PICKPTR	    VARBASE+197	/* pointer to next avail. spot in io space */
#define	PICKSPACE   VARBASE+198	/* */
#define	NAMECOUNT   VARBASE+199	/* number of names in namestack	less 1*/
#define	NAMEPTR	    VARBASE+200	/* next	free namestack location	*/

#define	BBOXMODE    VARBASE+201	/* set when in bbox mode */
#define	BBOX_MINX   VARBASE+202	/* set when in bbox mode */
#define	BBOX_MINY   VARBASE+203	/* set when in bbox mode */
#define	BBOX_VISABLE	VARBASE+204 /* set when	in bbox	mode */
#define	FIRSTX	    VARBASE+205	/* The x coordinate of the first point.
				 * To be saved,	when CLOSEDLINE	is drawn */
#define	FIRSTY	     VARBASE+206 /* The	y coordinate of	the first point.
				 * To be saved,	when CLOSEDLINE	is drawn */
#define	FIRSTZ	    VARBASE+207	/* The z coordinate of the first point.
				 * To be saved,	when CLOSEDLINE	is drawn */
#define	FIRSTW	    VARBASE+208	/* The w coordinate of the first point.
				 * To be saved,	when CLOSEDLINE	is drawn */
#define	NUMPIX	    VARBASE+209	/* read	pixels count */
#define	FINISH0	    VARBASE+210	/* GM finish flag */
#define	FINISH1	    VARBASE+211	/* GM finish flag */

#define	MESHMEM	    DATAMEM	/* location of mesh vertex list	*/
#define	MESHCLIPMEM MESHMEM+100	/* location of mesh clipping list */
#define	MESH_V1	    VARBASE+212	/* pointer to the first	mesh vertex */
#define	MESH_V2	    VARBASE+213	/* pointer to the second mesh vertex */
#define	MESH_V3	    VARBASE+214	/* pointer to the third	mesh vertex */
#define	MESH_SV1    VARBASE+215	/* mesh	vertex in screen coordinates */
#define	MESH_SV2    VARBASE+216
#define	MESH_SV3    VARBASE+217
#define	CLIP_MESH3  VARBASE+218	/* TRUE	if third mesh vertex is	clipped	*/
#define	CLIP_MESH2  VARBASE+219	/* TRUE	if second mesh vertex is clipped */
#define	CLIP_MESH1  VARBASE+220	/* TRUE	if first mesh vertex is	clipped	*/
#define	CLIPSCR_MESH3	VARBASE+221 /* TRUE if screen mask clipping is needed */
#define	CLIPSCR_MESH2	VARBASE+222
#define	CLIPSCR_MESH1	VARBASE+223
#define	MESHMODE	VARBASE+224 /* the vertex command is in	mesh mode */
#define	MESH_RECIEVE2	VARBASE+225 /* recieved	2nd mesh vertex	*/
#define	MESH_RECIEVE1	VARBASE+226 /* recieved	1st mesh vertex	*/
#define	REPLACE_MESH1	VARBASE+227 /* Replace vertex 1	by vertex 3 if TRUE */


#define	FREE_EDGE   VARBASE+228	/* pointer to available	edge nodes */
#define	EDGELIST    VARBASE+229
#define	SORTLIST    VARBASE+230
#define	ZFUNCTION   VARBASE+231

#define	PATTERN_ID  VARBASE+232	/* index used in setpattern */
#define	WIDESTIP    VARBASE+233	/* wide, stipple line */
#define	TEX_ARRAY   VARBASE+234	/* 66 locations	allocated for texture array */
#define	CDITHER	    VARBASE+300
#define	SM_VP_CLIP  VARBASE+301
#define	UAUX_4BIT   VARBASE+302
#define	SCRL_NC	    VARBASE+303	/* these are the unclipped screenmask */
#define	SCRB_NC	    VARBASE+304	/* coords, relative to the lower left */
#define	SCRR_NC	    VARBASE+305	/* corner of the window	*/
#define	SCRT_NC	    VARBASE+306
#define	TX_WIN	    VARBASE+307	/* center of viewport window relative */
#define	TY_WIN	    VARBASE+308
#define	VPL_WIN	    VARBASE+309	/* viewport coords, window relative */
#define	VPB_WIN	    VARBASE+310
#define	VPR_WIN	    VARBASE+311
#define	VPT_WIN	    VARBASE+312
		    /* Rotated stipple saved during context switching */
#define	CT_STIP_SAVE	VARBASE+313
		    /* Rotated stipple count saved during context switching */
#define	CT_STIPCNT_SAVE	VARBASE+314
#define	GEPIXELS    VARBASE+315	/* 1.0 = pixel rd/wr thru GE, else -1.*/
#define	ZSOURCE	    VARBASE+316	/* */
#define	MESH_FACETEST	VARBASE+317

/* RE2 variables  */
#define	IXZOOM	    VARBASE+318	/* Hardware zoom in x */
#define	UPACMODE    VARBASE+319	/* Hardware pixel packing flag */
#define	SCR_YMIN    VARBASE+320	/* Ymin	of hardware scrmask (integer) */
#define	SCR_YMAX    VARBASE+321	/* Ymax	of hardware scrmask (integer) */
#define	SCR_XMIN    VARBASE+322	/* Xmin	of hardware scrmask (DIVMOD) */
#define	SCR_XMAX    VARBASE+323	/* Xmax	of hardware scrmask (DIVMOD) */
#define	COLORCMP    VARBASE+324
#define	SUBPIXEL    VARBASE+325	/* Flag	used to	turn on/off subpixel */
		    /* positioning of anti-aliased lines */
#define	SPOINT	    VARBASE+326	/* Flag	used to	turn on/off anti-aliased point*/
#define	FUNC	    VARBASE+327	/* operation used to combine source and
				    destination	pixels.	*/
#define	RESETLS	    VARBASE+328	/* Flag	used to	set/reset line stipple,
				   in current state. */
#define	LOGICOP_ON  VARBASE+329	/* True	if FUNC	!= 3 */
#define	ROP_XOR	    VARBASE+330	/* Rasterop 6(GXxor) and 9(GXequiv) */
#define	HALF_CLOSED VARBASE+331	/* If true, half-closed	line is	drawn. */
#define	GP_XFORM    VARBASE+332	/* indicates if	GX is valid on GE5 or DSP */
#define	RESTORE_MATRIX	VARBASE+333 /* indicates if matrix in reg.1-16 needs
				       to be restored */
#define	NEW_STIP    VARBASE+334	/* The stipple to be set when gl_resetlsis true. */
#define	NEW_REPSTIP VARBASE+335	/* The lsrepeat	to be set when gl_resetls is true. */
#define	FLATIR	    VARBASE+336	/* Instruction reg value for flat fill */
#define	RE2DX	    VARBASE+337	/* RE2 DX value	for flat fill */
#define	XORG_SAV    VARBASE+338	/* xorg	is saved when window is	moved */
#define	YORG_SAV    VARBASE+339	/* yorg	is saved when window is	moved */
#define	SLOWPOINT   VARBASE+340	/* slow	path flag for smooth_point & pick mode*/
#define	ZBUFDEPTH   VARBASE+341	/* Zbuffered antialiased line */
#define	DSPCTXBASE  VARBASE+342	/* Pointer to the context data for DSPs. */
#define	FACETEST    VARBASE+343	/* flag	to enable polygon direction check */
#define	FRONTFACE   VARBASE+344	/* flag	to enable frontface polygon removal */
/* WARNING: VERBASE+359	is last	available entry	*/


/* Register data saved/restored	at context switch */

#define	MEMPTR	    SAVREG+0
#define	PCSAVE	    SAVREG+1
#define	REG1	    SAVREG+2
#define	REG2	    SAVREG+3
#define	REG3	    SAVREG+4
#define	REG4	    SAVREG+5
#define	REG5	    SAVREG+6
#define	REG6	    SAVREG+7
#define	REG7	    SAVREG+8
#define	REG8	    SAVREG+9
#define	REG9	    SAVREG+10
#define	REG10	    SAVREG+11
#define	REG11	    SAVREG+12
#define	REG12	    SAVREG+13
#define	REG13	    SAVREG+14
#define	REG14	    SAVREG+15
#define	REG15	    SAVREG+16
#define	REG16	    SAVREG+17
#define	REG17	    SAVREG+18
#define	REG18	    SAVREG+19
#define	REG19	    SAVREG+20
#define	REG20	    SAVREG+21
#define	REG21	    SAVREG+22
#define	REG22	    SAVREG+23
#define	REG23	    SAVREG+24
#define	REG24	    SAVREG+25
#define	REG25	    SAVREG+26
#define	REG26	    SAVREG+27
#define	REG27	    SAVREG+28
#define	REG28	    SAVREG+29
#define	REG29	    SAVREG+30
#define	REG30	    SAVREG+31
#define	TMP1	    SAVREG+32
#define	TMP2	    SAVREG+33
#define	TMP3	    SAVREG+34
#define	REPTR	    SAVREG+35
#define	HQMSAV	     SAVREG+36	 /* stored here	at read	from GE	RAM */



/*********** Used by polygon routines. (Do not change) ****************/

#define	    D_VERT	SCRTMEM+1	/* pointer to vertex2 of edge2 */
#define	    B_VERT	SCRTMEM+2	/* pointer to vertex2 of edge1 */
#define	    SLOPE1	SCRTMEM+6	/* 6 values of slope of	edges */
#define	    SLOPE2	SCRTMEM+12	/* dx, dzi, dzf, dr, dg, db */
#define	    SAVE_TEX	SCRTMEM+20	/* save	texture	address	for concave */
#define	    SAVE_EDGE	SCRTMEM+21	/* save	edgelist addr. for concave */
#define	    SAVE_Y	SCRTMEM+22	/* save	current	y value	for concave */
#define	    SAVE_LOCALS	SCRTMEM+23	/* save	registers for concave */

#define	    P1		SCRTMEM+25	/* pointer to min_y mesh vertex	*/
#define	    P2		SCRTMEM+26
#define	    P3		SCRTMEM+27

/*********** Used by line routines. (Do	not change) ****************/

#define	    CURVE_CNT	SCRTMEM+25	/* Number of curve (line segments)
					    to draw */
/*********** Used by line screen mask clipping.	(Do not	change)	*******/
#define	    X1_SAVE	SCRTMEM+1
#define	    Y1_SAVE	SCRTMEM+2
#define	    Z1_SAVE	SCRTMEM+3
#define	    X2_SAVE	SCRTMEM+4
#define	    Y2_SAVE	SCRTMEM+5
#define	    Z2_SAVE	SCRTMEM+6
#define	    NX1		SCRTMEM+7
#define	    NY1		SCRTMEM+8
#define	    NZ1		SCRTMEM+9
#define	    NX2		SCRTMEM+10
#define	    NY2		SCRTMEM+11
#define	    NZ2		SCRTMEM+12
#define	    X_SAVE	SCRTMEM+13
#define	    Y_SAVE	SCRTMEM+14
#define	    Z_SAVE	SCRTMEM+15
#define	    LW_SAVE	SCRTMEM+16
#define	    NEXT_STIP	SCRTMEM+17
#define	    NEXT_STIPCNT    SCRTMEM+18
#define	    FIRSTLN	SCRTMEM+19
#define	    DX_SAVE	SCRTMEM+20
#define	    DY_SAVE	SCRTMEM+21


/* Static memory - this	memory is not context specific */
/* Included here are all context switching and dma flags */

#define	INT_PICK	10
#define	INT_ENDPICK	11
#define	INT_DMA		12
#define	INT_ERROR	13
#define	INT_INIT	14

#define	DMA_CANCEL	-1

/* Flags/variables frequently used by host: */

#define	DMA_FLAG    STATMEM+0	/* */
#define	INTERRUPT   STATMEM+1	/* type	of interrupt: coded as integer */
#define	ERRNO	    STATMEM+2	/* current error number	*/
#define	DMA_COUNT   STATMEM+4	/* number of words to be dma transferred */
#define	REVERSION   STATMEM+5	/* The version number of RE */
#define	MEGOPTION   STATMEM+6	/* Megabit VRAM	installed for color */
#define	HW_GR1ZBUF24	 STATMEM+7   /*	Hardware zbuffer installed */
#define	HW_GR1BIT24 STATMEM+8	/* Hardware 24 bitplanes installed */
#define	HW_GR1AUX4  STATMEM+9	/* Hardware wid/uaux option (daVinci) */
#define	RE2VERSION  STATMEM+10	/* The version number of RE2 */


#endif
