#ifndef __GL_GECMDS_H__
#define __GL_GECMDS_H__
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1987-1991 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *									  *
 **************************************************************************/


/* DATA TOKEN */
#define GE_DATA			0		/* */


/* INITIALIZATION TOKENS */
#define	GE_INIT			1		/* */

/* GM, PIXELS, PICKING and OTHER TOKENS  (Steve) */
#define	GE_AUXWRITEMASK		10	/* sets the writemask for aux. planes*/
#define	GE_BEGINBBOX		11	/* bounding box command */
#define	GE_COLOR		12	/* sets color index */
#define	GE_COLORF		13	/* sets color index */
#define	GE_CURRENTWID		14 	/* sets window id */
#define	GE_DEPTHCUE		15 	/* turns on/off Depthcuing */
#define	GE_ENABDITH		16	/* dithering enabled */
#define	GE_ENABWID		17	/* wid check enabled */
#define	GE_ENDBBOX		18	/* end of bounding box command */
#define	GE_ENDPICKMODE		19	/* end of picking mode */
#define	GE_INITNAMES		20	/* initialize the picking stack */
#define	GE_FINISH0		21	/* Sets geometry pipeline finish flag */
#define	GE_LOADRE		22	/* Loads an RE register with value */
#define	GE_LOADNAME		23	/* load given name into picking stack*/
#define	GE_PICKMODE		24	/* enter GE into pick mode */
#define	GE_PIXTYPE		25	/* Sets the pixel type (RGB, cidx ..)*/
#define	GE_PIXWRITEMASK		26	/* Sets writemask for frame buffer */
#define	GE_POPNAME		27	/* Remove top entry from picking stack*/
#define	GE_PUSHNAME		28	/* Push a name onto picking stack */
#define	GE_READBLOCK		29	/* Reads a large block of pixels DMA */
#define	GE_RECTREAD		30	/* Reads a small block of pixels */
#define	GE_READBUF		31	/* Selects front/back buffer for reading*/
#define	GE_READPIXDMA		32	/* Read a block of pixels thru DMA */
#define	GE_READPIXELS		33	/* Read a given number of pixels */
#define	GE_READRGB		34	/* Read number of pixels in RGB mode */
#define	GE_RECTCOPY		35	/* Copies a block of pixels */
#define	GE_RGBCOLOR		36	/* Sets color in RGB mode */
#define	GE_RGBSHADERANGE	37	/* Sets parameters for depthcuing(RGB)*/
#define	GE_RWMODE		38	/* read/write pixel mode */
#define	GE_SCREENCLEAR		39	/* Clears the screen in current color */
#define	GE_SHADEMODEL		40	/* Selects GOURAUD/FLAT shading model*/
#define	GE_SHADERANGE		41	/* Sets depthcuing parameters(cidx) */
#define	GE_WRITEBLOCK		42	/* Writes a large block of pixels DMA */
#define	GE_RECTWRITE		43	/* Writes a pixel block thru pipe */
#define	GE_WRITEPIXDMA		44	/* */
#define	GE_WRITEPIXELS		45	/* */

/*** DO NOT change GE_ZBUFFER = 46, unless you change feed.h ***/
#define	GE_ZBUFFER		46	/* Turns ON/OFF z-buffer mode */

#define	GE_ZCLEAR		47	/* Clears the z-buffer */
#define	GE_ZOOMFACTOR		48	/* Sets Zoom factor for RECTCOPY */
#define	GE_READSOURCE		49	/* Sets source for reading pixels 
					   (i.e. Frame-buf, Z-buf, Aux_planes)*/
#define	GE_DRAWMODE		50	/* Sets drawing mode (OVERLAY, PUP..)*/
#define	GE_CZCLEAR		51	/* Clears frame buffer and z-buffer */
#define	GE_HQMSAV		52	/* stores HQM in GE RAM */
#define	GE_ZFUNCTION		53	/* Sets a z-buffer function */
#define	GE_SETPIECES		54	/* */
#define GE_FLATMODE		55      /* Sets FLATMODE, FLATDX */
#define GE_DEPTHFN		58      /* Sets RE DEPTHFN */


/* TRANSFORMATION and OTHER TOKENS (Iching) */

#define	GE_LOADMATRIX		60	/* Loads a transformation matrix */
#define GE_MULTMATRIX		61	/* Multiplies a given matrix with the
					   top of the matrix stack */
#define GE_PUSHMATRIX		62	/* push matrix stack down one step */
#define GE_POPMATRIX		63	/* Pop matrix stack up one step */
#define GE_CURVEIT		70	/* Fast curve renderer routine */
#define GE_LOADVIEWP		71	/* Sets current viewport */

/* New lighting commands (vimal) */
#define	GE_LMCOLOR		56	/* load a new color mode is lighting */
#define	GE_LOADAMBIENT		57	/* load a new ambient color value */
#define	GE_LOADDIFFUSE		59	/* load a new diffuse color value */
#define	GE_LOADSPECULAR	 	64	/* load a new specular color value */
#define	GE_LOADEMISSION		65	/* load a new emission color value */
#define	GE_LOADASUM		66	/* load sum of all ambient colors */
#define	GE_LOADLCOLOR		67	/* load a new light color value */


/*** DO NOT change GE_POLYGON = 72, unless you change feed.h ***/
#define GE_POLYGON		72	/* Puts GE in a polygon mode */

#define GE_ENDPOLYGON		73	/* Ends polygon mode (draw polygon )*/
#define GE_TRANSLATEI		74	/* Not Used (Use MULTMATRIX instead) */
#define GE_TRANSLATE		75	/* Not Used (Use MULTMATRIX instead) */

/*** DO NOT change GE_LINESTYLE = 76, unless you change feed.h ***/
#define GE_LINESTYLE		76	/* Sets current linestyle */

/*** DO NOT change GE_LINEWIDTH = 77, unless you change feed.h ***/
#define GE_LINEWIDTH		77	/* Sets current line width */

#define GE_VERTEX2I		78	/* Different vertex commands. Used for*/
#define GE_VERTEX2		79	/* Polygons, rectangles, lines, meshes*/
#define GE_VERTEX3I		80	/* */
#define GE_VERTEX3		81	/* */
#define GE_VERTEX4I		82	/* */
#define GE_VERTEX4		83	/* */
#define GE_RVERTEX2I		84	/* Relative vertex commands */
#define GE_RVERTEX2		85	/* */
#define GE_RVERTEX3I		86	/* */
#define GE_RVERTEX3		87	/* */
#define GE_CLOSEDLINE		88	/* Begin Drawing a series of line in */
#define GE_ENDCLOSEDLINE	89	/* a closed loop */

/*** DO NOT change GE_LSREPEAT = 90, unless you change feed.h ***/
#define GE_LSREPEAT		90	/* Sets repeat count for linestyle */

#define GE_ANTIALIAS		91	/* Sets On/OFF antialiasing of lines */
#define GE_PNT2I		92	/* Commands for drawing a point */
#define GE_PNT2			93	/* */
#define GE_PNT3I		94	/* */

/*** DO NOT change GE_PNT3 = 95, unless you change feed.h ***/
#define GE_PNT3			95	/* */

#define GE_PNT4I		96	/* */
#define GE_PNT4			97	/* */

#define GE_MOVE2I		100	/* Commands to update current graphic */
#define GE_MOVE2		101	/* position. Used for drawing lines */
#define GE_MOVE3I		102	/* */

/*** DO NOT change GE_MOVE3 = 103, unless you change feed.h ***/
#define GE_MOVE3		103	/* */

#define GE_MOVE4I		104	/* */
#define GE_MOVE4		105	/* */
#define GE_RMOVE2I		106	/* Relative Move commands */
#define GE_RMOVE2		107	/* */
#define GE_RMOVE3I		108	/* */
#define GE_RMOVE3		109	/* */
#define GE_DRAW2I		110	/* Draws a line from current graphics */
#define GE_DRAW2		111	/* position to given position */
#define GE_DRAW3I		112	/* */

/*** DO NOT change GE_DRAW3 = 113, unless you change feed.h ***/
#define GE_DRAW3		113	/* */

#define GE_DRAW4I		114	/* */
#define GE_DRAW4		115	/* */
#define GE_RDRAW2I		116	/* Relative draw commands */
#define GE_RDRAW2		117	/* */
#define GE_RDRAW3I		118	/* */
#define GE_RDRAW3		119	/* */

#define GE_ENABLWID		120	/* Enables window id check for lines */
#define GE_LOADGE		121	/* Used for pipe write to GE DRAM */



/* OTHER TOKENS ?  (Vimal) */

#define	GE_STARTHERE2		129	/* */
#define	GE_FRONTFACE	129 /* Turns on/off frontface poly removal */
#define	GE_BACKFACE		130	/* Turns on/off backface poly removal */
#define GE_CONCAVE		131	/* Turns on/off concave polygon mode */
#define	GE_PATTERN		132	/* Turns on/off pattern polygon draw */

/*** DO NOT change GE_SETPATTERN = 133, unless you change feed.h ***/
#define	GE_SETPATTERN		133	/* sets a current pattern bit masks */

/* Nomal matrix tokens */
#define	GE_LOADNORMAL		134	/* Loads a normal matrix on stack */
#define	GE_MULTNORMAL		135	/* Multiplies given normal with stack */
#define	GE_INITSTACK		136	/* Not Used */
#define	GE_MMODE		137	/* Sets current Viewing mode for 
					   lighting calculation */

/* Lighting command tokens */
#define	GE_NORMAL		138	/* Sets current normal for use in 
					   lighting calculation */
#define	GE_ABNORMAL		139	/* Turns on/off renormalization */
#define	GE_LIGHTATTR1		140	/* Command to load lighting parameters*/
#define	GE_LIGHTATTR2		141
#define	GE_LIGHTATTR3		142
#define	GE_LIGHTDATA1		143
#define	GE_LIGHTDATA4		144
#define	GE_LIGHTMEMPTR		145
#define	GE_LIGHTDIRECTION	146
#define	GE_LIGHTPOSITION	147
#define	GE_LIGHTMOVEDATA	148


/* Triangle Mesh commands */
#define	GE_BEGINMESH		149	/* Commands to draw triangle mesh */
#define	GE_ENDMESH		150
#define	GE_SWAPMESH		151

/* Screen aligned rectangle commands */
#define	GE_SBOXF		152	/* Commands to draw screen aligned */
#define	GE_SBOXFI		153	/* filled rectangles */
#define	GE_FATPOLY		154	/* Turns on/off old style polygon mode
					 * for compatibility with IRIS */
#define GE_ENDOLDPOLYGON	155	/* Draws an old style polygon */
#define	GE_SBOX			156	/* Commands to draw screen aligned rects */
#define	GE_SBOXI		157


/* CHARACTER AND OTHER TOKENS (Scott) */

#define GE_CMOV2I		160	/* Sets Current character position */
#define GE_CMOV2		161	/* */
#define GE_CMOV3I		162	/* */

/*** DO NOT change GE_CMOV3 = 163, unless you change feed.h ***/
#define GE_CMOV3		163	/* */
#define GE_CMOV4I		164	/* */
#define GE_CMOV4		165	/* */
#define GE_DRAWCHAR		166	/* Draws a given character */
#define GE_GETCPOS		167	/* Returns the current Char8. position*/
	
#define GE_FEEDBACK		174	/* Commands to put GE in feedback mode*/
#define GE_ENDFEEDBACK		175	/* */

/*** DO NOT change GE_PASSTHROUGH = 176, unless you change feed.h ***/
#define GE_PASSTHROUGH		176	/* */

#ifndef	GL_DOS			/* removed from IRISVISION DOS-GL */
#define	GE_FMOVE		177	/* Fast line drawing commands (2-d)*/
#define GE_FDRAW		178	/* */
#define GE_FLINE		179	/* */
#endif	/* !GL_DOS */

#define	GE_SCRMASK		180	/* Sets current screen mask */

/* LATE ADDITION TOKENS */
#define	GE_ZSOURCE		181  /* zsource is either depth or color */
#define	GE_SUBPIXEL		182  /* subpix position for anti-aliased line */
#define	GE_SMOOTHPOINT		183  /* anti-aliased point */
#define	GE_RASTEROP		184  /* the current rasterop value */
#define	GE_RESETLS		185  /* flag to reset the line stipple */

#if (!defined(GL_DOS) && !defined(WIN_DRIVER))
#define	GE_DSPRD		201
#define	GE_DSPWR		202
#define	GE_DSPNEXT		203
#define	GE_DSPDUMMY		204
#endif	/* !GL_DOS and !WIN_DRIVER */

#define GE_PICKTYPE		205	/* Pick mode 1:none,3:first, */
					/* 5:last,7:all(default) */
#define GE_VERSION		206	/* Ucode version */

/* Tokens most useful for MS Windows */
#define GE_SOLIDBRUSH		207  /* MS Windows screen aligned filled box */
#define GE_WIN_BITBLT		208  /* MS Windows BitBLT to screen */
#define GE_READBLOCK_R		209  /* top-to-bottom (reversed) readblock */
#define GE_SCRNCMOV		210  /* screen coord version of CMOV */
#define GE_COLORBRUSH		211  /* copy 8x8 color brush to framebuffer */
#define GE_MONOPATTERN		212  /* like DRAWCHAR but simpler & reversed */
#define GE_COLORBRUSHLOAD	213  /* load 8x8 color brush into dataram */
#define GE_NOP			214  /* No Op - used for FIFO speed test */
#define GE_ROPPATTERN		215  /* like MONOPATTERN but works with ROPs */


/* CONTEXT SWITCHING TOKENS (240-255 RESERVED) */

#define	GE_CTX0			240	/* 0xf0 context switch token 0 */
#define	GE_CTX1			255	/* 0xff context switch token 1 */

/*
 * Context switch arguments.
 * Following the context switch tokens (CTX0, CTX1) are two flags. The first
 * indicates whether the current context is alive (DMA it out to save it) or
 * dead (we can overwrite it). The second indicates the size of the the
 * incoming context. If this size is CTX_NEW, then there is no saved context
 * to DMA in. These constants are used by the kernel and are therefore
 * defined using the floating pt. syntax for the standard C compiler 		
 */
#define	CTX_ALIVE		1.0	/* Current context in GE - 1st flag */
#define	CTX_DEAD		-1.0	/* Current context in GE - 1st flag */
#define	CTX_NEW			2.0	/* Incoming context to GE - 2nd flag */
#define	CTX_BIG			1.0	/* Incoming context to GE - 2nd flag */
#define	CTX_SMALL		-1.0	/* Incoming context to GE - 2nd flag */

/* Graphics DMA arguments (right now just used for pixel DMA) */
#define	GDMA_INTR		1.0	/* GE interrupts host when DMA done */
#define	GDMA_NOINTR		-1.0	/* Host polls, GE does not intr. host */

#endif	/* !__GL_GECMDS_H__ */
