#ifndef __GL_GFXBOARD_H__
#define __GL_GFXBOARD_H__

/****************************************************************************/

#define   GR1_GFXPG_SIZE      0x4000   /*  Graphics page size */
#define   GR1_GFXPG_VADDR      GRP   /*  Graphics page base user virtual */


/* NB. if -D$(PRODUCT) isn't given, mgr.h will catch it */
#ifdef AGR
#include "agr.h"
#endif
#ifdef MGR
#include "mgr.h"
#endif

/******************************************************************************
 * standalone GEWAIT
 *****************************************************************************/
extern void   far _gl_gewait(void);
#define GEWAIT	if (CHAR_PTR(GFX_CTRL0_ADDR) & GFX_FIFOSTAT)   \
            _gl_gewait()

/******************************************************************************
 * vertical retrace interrupt clear
 *****************************************************************************/

#define   CLEAR_VRI()   CHAR_PTR(GFX_ISR_ADDR) = GFX_INT_VR;

    /*
     *   Wait for retrace by buzzing on status low, then high
     *     (vert. retrace signal is active high for MGR, AGR or NGR boards)
     */
#define   MAX_PER_RASTER   642000

            /*  Wait until somewhere in vertical retrace */
#undef   VRWAIT
#define   VRWAIT   \
    {                  \
   long   i ;            \
                  \
   for (i = 0; i < MAX_PER_RASTER; i++) {   \
       if ( (GFXCTRL0 & GFX_VRSTAT) )   \
      break ;            \
   }               \
    }

            /*  Wait until beginning of vertical retrace */
#undef   VRWAIT2
#define   VRWAIT2   \
    {                  \
   long   i ;            \
                  \
   for (i = 0; i < MAX_PER_RASTER; i++) {   \
       if ( !(GFXCTRL0 & GFX_VRSTAT) )   \
      break ;            \
   }               \
   for (i = 0; i < MAX_PER_RASTER; i++) {   \
       if ( (GFXCTRL0 & GFX_VRSTAT) )   \
      break ;            \
   }               \
    }

    /*
     *   Wait for the real interrupt line to go high & the status line 
     *   must be low...
     */
#define   VRINTWAIT   \
    {                  \
   long   i ;            \
                  \
   CLEAR_VRI() ;            \
   for (i = 0; i < MAX_PER_RASTER; i++) {   \
       if ( (GFXINTR & GFX_INT_VR) )   \
      break ;            \
   }               \
    }

/******************************************************************************
 * Other GR1 Hardware Characteristics
 *****************************************************************************/
       /* Capacity of the bitplanes */
#define   GR1_BITPLANES   12
#define   BP4_BITPLANES   20
#define   ZB3_BITPLANES   24

#define   MAX_BITPLANES   (GR1_BITPLANES + BP4_BITPLANES + ZB3_BITPLANES)
#define   RGB_BITPLANES   (GR1_BITPLANES + BP4_BITPLANES)
#define   MIN_BITPLANES   (GR1_BITPLANES)

#define   COLOR_24_BIT   0x1
#define   HW_ZBUFFER   0x2
#define   RE2_OPTION   0x4

/* ECLIPSE graphics comes in many flavors */
#define   BOARD_GR1   0
#define   BOARD_GR2   1
#define   BOARD_VGR1   2
#define   BOARD_MGR   3
#define   BOARD_AGR   4
#define   BOARD_NGR   5

#define   FULLPIXMASK_GR1   0xfffffff   /*  used by diags for pixel readback */
#define   FULLPIXMASK_GR2   0xf0ff0ff   /*  used by diags for pixel readback */


#ifndef WIN_DRIVER

/* Interrupt control macros -- include <dos.h> when using these */
#define      CLI   _inline(0xfa)   /* disable interrupts */
#define      STI   _inline(0xfb)   /* enable interrupts */

#endif /* WIN_DRIVER */


typedef struct iv_gethwconfig_s {
   char bitplanes;
   char zbuf;
   char gsnr;      /* in value: screen that inquiry is for */
   char _filler;
   long invstate;      /* added because shared GL can't import hinv 
             * routines from libc */
} iv_gethwconfig_t;

#endif   /* !__GL_GFXBOARD_H__ */
