incFont EQU     1

        INCLUDE COMMON.INC
        INCLUDE IV1.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 glyph bltter.                                                ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/15/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _GRP                 : DWORD
EXTERN  _Y_TRANSLATION       : WORD
EXTERN  _GLOB_X_Size         : WORD
EXTERN  _GLOB_Y_Size         : WORD

EXTERN  _devpGlyphClrFore    : WORD
EXTERN  _devpGlyphClrBack    : WORD

devpGlyphScanline       DW      80 DUP (?)

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

lpFontInfo      EQU [bp + 14]
lpGlyphInfo     EQU [bp + 10]
xDst            EQU [bp + 8]
yDst            EQU [bp + 6]
count           EQU [bp + 4]

GlyphHeight     EQU [bp - 4]
GlyphShiftCount EQU [bp - 6]
GlyphWordCount  EQU [bp - 8]
ScanCount       EQU [bp - 10]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devDrawGlyphs   PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 20
        push    esi
        push    edi
        push    fs
        push    gs
        push    es
;
; Get IV1 GRP PTR
;
        lgs     di, _GRP
        lfs     bx, lpGlyphInfo
        les     si, lpFontInfo
;
; Wait for GE FIFO to become available.
;
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1    ;Check for FIFO full
        jnz     @b                              ;Keep checking
        xor     edx, edx
        mov     dx, es:[si][FONTINFO.dfPixHeight]
        mov     GlyphHeight, edx
        mov     ax, _devpGlyphClrFore
        mov     WORD PTR gs:[di][GE_COLOR], 0
        mov     gs:[di][FIFO16_OFF], ax         ;color data
        mov     di, count
        cmp     di, 2                           ; Only one or two glyphs
        jle     SingleGlyphLoopEnter            ; so do it the easy way
        shl     di, 2
        add     di, bx
        mov     dx, fs:[di]
        cmp     dx, 1280                        ; Extent too large for scanline
        jge     SingleGlyphLoopEnter
;
; Draw string one entire scanline at a time.
;
        mov     di, WORD PTR _GRP
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1    ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     WORD PTR gs:[di][GE_MONOPATTERN], 0
        mov     gs:[di][FIFO16_OFF], dx         ; xSize
        mov     ax, GlyphHeight
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, dx
        add     ax, 15
        shr     ax, 4
        mov     GlyphWordCount, ax              ; Save WORD size of string scanline
        mov     gs:[di][FIFO16_OFF], ax         ; Shorts per row
        mov     ax, xDst
        cwde
        mov     gs:[di][FIFO_OFF], eax
        mov     ax, _Y_TRANSLATION
        sub     ax, yDst
        cwde
        mov     gs:[di][FIFO_OFF], eax
        xor     edx, edx
ScanLoop:
;
; Clear out working scanline.
;
        mov     ScanCount, dx
        mov     cx, GlyphWordCount
        mov     di, OFFSET devpGlyphScanline
        xor     eax, eax
        sub     cx, 4
        jb      @F
ClearScan4:
        mov     [di], eax
        mov     [di][4], eax
        add     di, 8
        sub     cx, 4
        jae     ClearScan4
@@:     add     cx, 4
        jz      @F
        mov     [di], ax
        dec     cx
        jz      @F
        mov     [di][2], ax
        dec     cx
        jz      @F
        mov     [di][4], ax
@@:     mov     bx, WORD PTR lpGlyphInfo
        mov     cx, count
GlyphLoop:
        mov     di, fs:[bx]             ; Get X position
        mov     si, fs:[bx][2]          ; Get pointer to FontInfo
        add     bx, 4
        mov     ax, es:[si]             ; Get width in bytes
        or      ax, ax
        jz      NextGlyph
        add     ax, 7
        shr     ax, 3
        mov     esi, es:[si][2]         ; Get pointer to bits
        add     esi, edx                ; Add scanline offset
        push    cx
        mov     cx, di
        shr     di, 3                   ; Calc byte address
        and     cl, 7                   ; Calc alignment shift
        cmp     ax, 3
        ja      RowWide
        je      Row3
        cmp     ax, 2
        je      Row2
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di], ax
        pop     cx
        dec     cx
        jnz     GlyphLoop
        jmp     BlastScan
Row2:
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di], ax
        add     esi, GlyphHeight
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di][1], ax
        pop     cx
        dec     cx
        jnz     GlyphLoop
        jmp     BlastScan
Row3:
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di], ax
        add     esi, GlyphHeight
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di][1], ax
        add     esi, GlyphHeight
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di][2], ax
        pop     cx
        dec     cx
        jnz     GlyphLoop
        jmp     BlastScan
RowWide:
        mov     dx, ax
RowLoop:
        mov     al, es:[esi]            ; Get glyph byte
        xor     ah, ah
        ror     ax, cl
        or      WORD PTR devpGlyphScanline[di], ax
        inc     di
        add     esi, GlyphHeight
        dec     dx
        jnz     RowLoop
        mov     dx, ScanCount           ; Reload dx
        pop     cx
NextGlyph:
        dec     cx
        jnz     GlyphLoop
;
; Blast scanline to IV1.
;
BlastScan:
        mov     di, OFFSET devpGlyphScanline
        mov     cx, GlyphWordCount
        mov     bx, WORD PTR _GRP
@@:     test    BYTE PTR gs:[bx][IV1BUSY], 1    ;Check for FIFO full
        jnz     @b                              ;Keep checking
@@:     mov     ah, [di]
        mov     al, [di + 1]
        mov     gs:[bx][FIFO16_OFF], ax
        add     di, 2
        dec     cx
        jnz     @B
        inc     dx
        cmp     dx, GlyphHeight
        jl      ScanLoop
        jmp     Exit
SingleGlyphLoop:
        mov     count, cx
SingleGlyphLoopEnter:
        mov     si, fs:[bx][2]                  ; Get pointer to first glyph font data
        mov     dx, es:[si]                     ; Get glyph width
        or      dx, dx
        jz      NextSingleGlyph
        mov     esi, es:[si][2]                    ; Get pointer to first glyph bits
        mov     di, WORD PTR _GRP
        mov     cx, fs:[bx]
        add     cx, xDst
        cmp     cx, _GLOB_X_Size                ; Are we off the right edge?
        jge     Exit
@@:     test    BYTE PTR gs:[di][IV1BUSY], 1    ;Check for FIFO full
        jnz     @b                              ;Keep checking
        mov     WORD PTR gs:[di][GE_MONOPATTERN], 0
        mov     gs:[di][FIFO16_OFF], dx         ; xSize
        mov     ax, GlyphHeight
        mov     gs:[di][FIFO16_OFF], ax
        mov     ax, dx
        add     ax, 15
        shr     ax, 4
        mov     gs:[di][FIFO16_OFF], ax         ; Shorts per row
        add     bx, 4
        mov     ax,cx
        cwde    
        mov     gs:[di][FIFO_OFF], eax     
        mov     ax, _Y_TRANSLATION
        sub     ax, yDst
        cwde    
        mov     gs:[di][FIFO_OFF], eax     
        add     dx, 7                           ; Calculate width in bytes
        shr     dx, 3
        mov     ecx, GlyphHeight
        cmp     dx, 2
        ja      GlyphWideRow
        je      Glyph2ByteRow
Glyph1ByteRow:
        xor     eax, eax
        cmp     cx, 4
        jl      @F
        mov     ah, es:[esi]
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ah, es:[esi][1]
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ah, es:[esi][2]
        mov     gs:[di][FIFO16_OFF], ax     
        mov     ah, es:[esi][3]
        mov     gs:[di][FIFO16_OFF], ax     
        add     esi, 4
        sub     cx, 4
        jnz     Glyph1ByteRow
        mov     cx, count
        dec     cx
        jnz     SingleGlyphLoop
        jmp     Exit
@@:     mov     ah, es:[esi]
        inc     esi
        mov     gs:[di][FIFO16_OFF], ax     
        dec     cx
        jnz     @B
        mov     cx, count
        dec     cx
        jnz     SingleGlyphLoop
        jmp     Exit
Glyph2ByteRow:
        xor     eax, eax
        mov     edx, ecx
@@:     mov     ah, es:[esi]
        mov     al, es:[esi][edx]
        mov     gs:[di][FIFO16_OFF], ax     
        inc     esi
        dec     cx
        jnz     @B
        mov     cx, count
        dec     cx
        jnz     SingleGlyphLoop
        jmp     Exit
GlyphWideRow:
        push    esi
        push    dx
Loop2ByteRow:
        cmp     dx, 2
        jb      @F
        mov     ah, es:[esi]
        add     esi, GlyphHeight
        mov     al, es:[esi]
        add     esi, GlyphHeight
        mov     gs:[di][FIFO16_OFF], ax     
        sub     dx, 2
        jnz     Loop2ByteRow
        jmp     NextWideRow
@@:     mov     ah, es:[esi]
        mov     gs:[di][FIFO16_OFF], ax     
NextWideRow:
;
; add FIFO full checking between scanlines.
;
@@:     test    BYTE PTR gs:[di][04020h], 1 ;Check for FIFO full
        jnz     @b                      ;Keep checking
        pop     dx
        pop     esi
        inc     esi
        dec     cx
        jz      NextSingleGlyph
        jmp     GlyphWideRow
NextSingleGlyph:
        mov     cx, count
        dec     cx
        jnz     SingleGlyphLoop
        jmp     Exit
Exit:
        mov     bx, count
        shl     bx, 2
        mov     ax, fs:[bx]
        pop     es
        pop     gs
        pop     fs
        pop     edi
        pop     esi
        leave
        ret     14

devDrawGlyphs   ENDP

_TEXT   ENDS

        END
