/*****************************************************************
 * defines for CPU dependent memory info                         *
 * including page info and dma stuff                             *
 *****************************************************************/

typedef struct gdmada {
	unsigned long bufaddr;
	unsigned long buflen;
	unsigned long dmactl;
	} gdmada_t;

#define POFFMASK	0xFFF   /* Mask to get Page Offset */
#define NBPC		4096	/* Number of Bytes Per Page */
#define PAGEOFFSET(buf)	( _gl_MapVirToPhys(buf) & POFFMASK )
#define BYTESTOPAGES(x) (( (x) >> 12) +1)

#define GDMA_LAST	0xFFFF
#define GDMA_STATUS	0x1D	/* bits of interest in GFXCTRL */
#define GDMA_HTOG	0	/* GDMA_HTOG & _GTOH represent the bit to */
#define GDMA_GTOH	2	/* toggle in the GFX CTRL register */


/** PICKING stuff **/
typedef struct gr1_mapbuf {
	char	*bufp;	/* address of buffer */
	long	buflen;	/* buffer length */
	} gr1_mapbuf_t;

typedef struct gr1_context {
	int	cx_feedcount;
	int	cx_wait;
	int	flags;
	gr1_mapbuf_t	pickbuf;
	} gr1_context_t;

/*
 * Values for gr1_context_t.flags
 */
#define	GR1_CX_DIRTY		0x0001	/* Has not been cleaned up */
#define	GR1_CX_USED		0x0002	/* Not new context: has saved state */
#define	GR1_CX_NOGECX		0x0004	/* Space for GE context was freed */
#define	GR1_CX_XMAPMODELO	0x0008	/* Change XMAP mode lo reg at retr */
#define	GR1_CX_XMAPMODEHI	0x0010	/* Change XMAP mode hi reg at retr */
#define	GR1_CX_SWAP_PENDING	0x0020	/* swap buffers pending */
#define	GR1_CX_GSYNC		0x0040	/* Gsync pending */
#define	GR1_CX_DMA		0x0080	/* Doing user graphics DMA */
#define	GR1_CX_PICKING		0x0100	/* pick/select in progress */
#define	GR1_CX_ENDPICK		0x0200	/* endpick/select in progress */
#define	GR1_CX_OVERFLOW		0x0400	/* pick/select buffer too small */
#define	GR1_CX_CYCLEMAP		0x0800	/* Cyclemap this context at retrace */
