.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV1.INC


GET386API       equ     1684h           ;Get API entry point from VxD.
MULTIPLEX       equ     2fh             ;Multiplex interrupt.
VDD             equ     000Ah           ;id of Virtual Display Driver.
RingAPI         equ     000Ah           ;Ring Transition API of VDD.

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IO permission code init                                          ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       09/08/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
_DATA   SEGMENT WORD PUBLIC 'DATA'
public  Ring3ToRing0
Ring3ToRing0         DD 0
public  Ring0ToRing3
Ring0ToRing3         DD 0
public lpfnVDD
lpfnVDD              DD 0
_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA


_INIT           SEGMENT WORD PUBLIC USE16 'CODE'
.386

        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devInitProtIO   PROC NEAR
        push    es
        push    edi


    	xor	di,di
    	mov	es,di
    	mov	ax,GET386API
    	mov	bx,VDD
    	int	MULTIPLEX
    	mov	ax,es
    	or	ax,ax
    	jz	short G3P_NoVDD		;will be zero if no VDD is present.

    	mov	word ptr lpfnVDD,di
    	mov	word ptr lpfnVDD+2,es

;
;--------------------------------------------------------------------
;If we've made it this far, then we know the VDD is present. 
;Get the ring transition entry point from the VDD.  If this fails,
;then fail (with carry) and the old BitBlt code (w/o ring transition 
;code) will be loaded.
;--------------------------------------------------------------------
;
	xor	dx,dx
	xor	cx,cx
	mov	ax,RingAPI
	mov	cx,_Text
	call	lpfnVDD
	or	dx,dx
	jz	short G3P_NoVDD			;RingAPI not present.
	mov	word ptr Ring3ToRing0,ax	;offset
	mov	word ptr Ring3ToRing0+2,dx	;selector
	mov	word ptr Ring0ToRing3,bx	;offset
	mov	word ptr Ring0ToRing3+2,cx	;selector
G3P_NoVDD:
        pop     edi
        pop     es        

        ret
devInitProtIO     ENDP

_INIT           ENDS

        END



