        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: int2f.                                                           ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/21/93 Dwight Diercks - wrote it from 8514 source.                 ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;



EXTERN GetModuleHandle:FAR
EXTERN GetProcAddress:FAR
EXTERN AllocCSToDSAlias:FAR                             ;Imported from KERNEL



_DATA   SEGMENT WORD PUBLIC 'DATA'

SCREEN_SWITCH_OUT       equ     4001h           ;Moving 3xBox to background
SCREEN_SWITCH_IN        equ     4002h           ;Moving 3xBox to foreground
DOS_VERSION             equ     0310h           ;Earliest DOS we must support (03.10)
HOT_KEY_VERSION         equ     1000h           ;Version with hot key support (10.00)


INT_MULT                equ     2Fh             ;Multiplexed interrupt number

pre_switch      LABEL   WORD
                DW      pre_switch_to_background
                DW      pre_switch_to_foreground

switch_proc     LABEL   WORD
                DW      switch_to_background
                DW      switch_to_foreground

post_switch     LABEL   WORD
                DW      post_switch_to_background
                DW      post_switch_to_foreground


switch_control  db      0               ;Switch control flags
PREVENT_SWITCH  equ     10000000b       ;Don't allow switch (DOS 3.x, 4.x)
DO_SWITCHING    equ     01000000b       ;Have to do switching
INT_2F_HOOKED   equ     00000001b       ;Have hooked int 2Fh
DISABLE_HOT_KEY equ     00000010b       ;Set if keyboard disabling required

FLAGS_ON_STACK  equ     4               ;iret --> offset(0), seg(2), flags(4)
CARRY_FLAG      equ     00000001b


REPAINT_EXPORT_INDEX    equ     275
repaint_addr    DD      0
repaint_disable DB      0h              ;ok to call user to repaint
user_string     DB      'USER',0
repaint_pending DB      0               ;repaint is pending.





_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA


_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

EXTERN  devEnableHWFAR:FAR                ;in INIT.c
EXTERN  devDisableHWFAR:FAR               ;in INIT.c


prev_int_2Fh	dd	0		;Previous int 2Fh vector
page

;----------------------------------------------------------------------------;
; UserRepaintDisable:							     ;
;								             ;
; USER calls this function to tell the display driver whether it expects     ;
; the repaint call to be postponed or not.			             ;
;								             ;
; If RepaintDisable is TRUE then the display driver should not send          ;
; repaint requests to USER immediately but wait till it is enabled again.    ;
; USER will enable repaint by seting RepaintDisable to FALSE.		     ;
;----------------------------------------------------------------------------;

UserRepaintDisable      PROC FAR PASCAL                 \
        ArgRepaintDisable  : BYTE       ;TRUE to Disable/FALSE to enable

        push    ds
        mov     ax, _Data
        mov     ds, ax
        assume  ds: DGROUP
        mov     al,ArgRepaintDisable    ;get the value
        mov     repaint_disable,al      ;save it
        or      al,al                   ;being enabled again
        jnz     @f                      ;no.
        cmp     repaint_pending,0ffh    ;pending repaint ?
        jnz     @f			;no.
        call    pre_switch_to_foreground;call repaint
        mov     repaint_pending,0       ;done with pending call
@@:
        pop     ds
        ret

UserRepaintDisable      ENDP
;-------------------------Interrupt-Handler-----------------------------;
; screen_switch_hook
;
; Watches calls to the OS/2 multiplex interrupt chain, and traps calls
; to the driver to save or restore the state of the display hardware
; before a context switch.
;
; If a save/restore call is recognized, then it will be dispatched
; to the device dependent handler unless PREVENT_SWITCH is
; set in switch_control.
;
;   If we're not running under OS/2, it is possible a pop-up not
;   caused by a hot key could try and grab the screen away from us .
;   In this case, we'll return with 'C' set to show that it's a real
;   bad time and try again later (they may still grab it, though).
;   In this case, PREVENT_SWITCH could be set.
;
; Entry:
;	AH = multiplex number
;	AL = function code
; Returns:
;	'C' set if screen switch cannot occur (DOS's < 10.0)
;	'C' clear otherwise
; Registers Preserved:
;	AL,BX,CX,DX,SI,DI,BP,DS,ES,SS
; Registers Destroyed:
;	AH,FLAGS
; Calls:
;
; History:
;	Sun 20-Sep-1987 23:02:58 -by-  Walt Moore [waltm]
;	Added switch_control flag,
;
;	Wed 16-Sep-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;
screen_switch_hook      PROC FAR
        cmp	ax,SCREEN_SWITCH_IN     ;switch to foreground int
        je	screen_switch_occurring
        cmp	ax,SCREEN_SWITCH_OUT    ; switch to background
        je	screen_switch_occurring
        jmp	prev_int_2Fh		;Not ours, pass it along

screen_switch_occurring:

        push    bp			;set up frame for altering flags
	mov     bp,sp

	push    ds

        mov     bx, _Data
        mov     ds, bx

        mov     ah,switch_control
        add     ah,ah
        jc      exit_screen_switch_error
                                                                      
do_screen_switch:
	pusha
	push    es
	and     ax,00000010b            ;Use D1 of function to index into
                                        ;  the two word dispatch table
        xchg    ax,bx

                                        ; use bx as index 0 or 2 cause address
                                        ; is 2 bytes long
        call    pre_switch[bx]          ;if foreground
                                        ; either repaint or if repaint disabled
                                        ; set pending repaint
                                        ;if background
                                        ; doesn't do a damn thing

        call    switch_proc[bx]         ;call the correct switching procedure
                                        ;if foreground
                                        ; call hardware enable
                                        ;if background
                                        ; doesn't do a damn thing


	call	post_switch[bx]         ; for either foreground or 
                                        ; background, this function
                                        ; does not do a Damn Thing
	pop	es

	popa
	pop	ds


;	Note that BP is still on the stack (hence FLAGS_ON_STACK+2).

	and	WORD PTR [bp][FLAGS_ON_STACK][2],not CARRY_FLAG
	pop	bp
	iret

exit_screen_switch_error:
	pop	ds

	or	WORD PTR [bp][FLAGS_ON_STACK][2],CARRY_FLAG
	pop	bp
	iret

screen_switch_hook      endp
;
;
page
switch_to_foreground    PROC NEAR
        push    bx                              ;save our index to proper 
                                                ;procedure          
        call    devEnableHWFAR                  ;go reset the hardware into
                                                ;IV2 mode
        pop     bx                              ;restore saved index
        ret
switch_to_foreground    ENDP
;
;                           
switch_to_background    PROC NEAR
        push bx
        call  devDisableHWFAR
        pop bx

        ret                                             ;
switch_to_background    ENDP

page
;---------------------------Public-Routine-----------------------------;
; pre_switch_to_foreground
;
; This function is called when switching to the foreground, before
; any device-specific code has executed.
;
; Entry:
;	DS = Data
; Returns:
;	DS = Data
; Registers Preserved:
;	BX,SI,DI,BP,DS
; Registers Destroyed:
;	AX,CX,DX,ES,FLAGS
; Calls:
; History:
;	Mon 05-Oct-1987 20:13:46 -by-  Walt Moore [waltm]
;	Moved repaint address fetch to hook_int_2F
;
;	Mon 05-Oct-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

pre_switch_to_foreground        PROC NEAR
        push    bx                      ;Save dispatch table index
        mov	ax,WORD PTR repaint_addr[0] ;We expect to always have the
	or	ax,WORD PTR repaint_addr[2] ;  address, but let's be sure
	jz	pre_switch_to_fore_exit
	cmp	repaint_disable,0	;is repaint enabled ?
	jz	@f			;yes.
	mov	repaint_pending,0ffh	;repaint pending
	jmp	short pre_switch_to_fore_exit
@@:
	call	repaint_addr		;Force repaint of all windows
pre_switch_to_fore_exit:
	pop	bx
	ret

pre_switch_to_foreground        ENDP


;---------------------------Public-Routine-----------------------------;
; pre_switch_to_background
;
; This function is called when switching to the background, before
; any device-specific code has executed.
;
; Entry:
;	DS = Data
; Returns:
;	DS = Data
; Registers Preserved:
;	AH,BX,CX,DX,SI,DI,BP,DS,ES,FLAGS
; Registers Destroyed:
;	AL
; Calls:
; History:
;	Mon 05-Oct-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

pre_switch_to_background        PROC NEAR
	ret

pre_switch_to_background        ENDP


;---------------------------Public-Routine-----------------------------;
; post_switch_to_foreground
;
; This function is called when switching to the foreground, after
; any device-specific code has executed.
;
; Entry:
;	DS = Data
; Returns:
;	DS = Data
; Registers Preserved:
;	AH,BX,CX,DX,SI,DI,BP,DS,ES,FLAGS
; Registers Destroyed:
;	AL
; Calls:
; History:
;	Mon 05-Oct-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

post_switch_to_foreground       PROC NEAR
	ret

post_switch_to_foreground       ENDP


;---------------------------Public-Routine-----------------------------;
; post_switch_to_background
;
; This function is called when switching to the background, after
; any device-specific code has executed.
;
; Entry:
;	DS = Data
; Returns:
;	DS = Data
; Registers Preserved:
;	AX,BX,CX,DX,SI,DI,BP,DS,ES,FLAGS
; Registers Destroyed:
;	None
; Calls:
; History:
;	Mon 05-Oct-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

post_switch_to_background       PROC NEAR
	ret

post_switch_to_background       ENDP

_TEXT   ENDS



_INIT   SEGMENT WORD PUBLIC 'CODE'


;---------------------------Public-Routine-----------------------------;
; hook_int_2Fh
;
; Installs a link in the 2Fh multiplex interrupt chain to watch for
; calls to the driver to save or restore the state of the display
; hardware before a context switch.
;
; This function is called whenever the driver recieves an enable call.
;
; Entry:
;	DS = Data
; Returns:
;	DS = Data
; Registers Preserved:
;	BX,CX,DX,SI,DI,BP,DS,ES
; Registers Destroyed:
;	AX,flags
; Calls:
;	none
; History:
;	Mon 05-Oct-1987 20:13:46 -by-  Walt Moore [waltm]
;	Moved getting the repaint procedure address to this
;	routine.
;
;	Sun 20-Sep-1987 19:00:13 -by-  Walt Moore [waltm]
;	Added addressibility to the Code segment where stuff
;	is stored.  Added switch_control flag.
;
;	Wed 16-Sep-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

_hook_int_2Fh	PROC    NEAR

	push	ds

;	See if we already have repaint_addr.
	mov	ax,WORD PTR [repaint_addr][0]
	or	ax,WORD PTR [repaint_addr][2]
	jnz	hook_int_2f_repaint_addr

;	Need module handle to pass to GetProcAddress.
	mov	ax,OFFSET user_string
        push    ds
        push    ax
	call	GetModuleHandle
	
;	Get the value of repaint_addr.
	xchg	ax,bx
	mov	ax,REPAINT_EXPORT_INDEX
	cwd
        push    bx
        push    dx
        push    ax
	call	GetProcAddress
	mov	WORD PTR [repaint_addr][0],ax
	mov	WORD PTR [repaint_addr][2],dx

hook_int_2f_repaint_addr:

	mov	al,switch_control	;Only hook if we have the correct DOS
	xor	al,INT_2F_HOOKED
	test	al,DO_SWITCHING+INT_2F_HOOKED
	jz	hook_int_done		;Don't need to hook it


	cli	
	or	switch_control,INT_2F_HOOKED
;	 xor	 ax,ax

	push	ds

	mov	ax, _Text
        push    ax
	call	AllocCSToDSAlias
	mov	ds,ax
        assume  ds:_Text

	mov	ax, 3500h+INT_MULT	; get old vector and keep it in a save
	int	21h			; place
	mov	WORD PTR prev_int_2Fh[2], es
	mov	WORD PTR prev_int_2Fh[0], bx

	mov	ax, _Text
	mov	dx, OFFSET screen_switch_hook
	mov	ds, ax
	mov	ax, 2500h+INT_MULT
	int	21h

	pop	ds
	assume  ds:DGROUP
	sti

        mov ax,4000h                    ; turn on int 2fs from VDD
        int 2fh
hook_int_done:
	pop	ds
	assume  ds:nothing
	ret

_hook_int_2Fh	endp
page

;---------------------------Public-Routine-----------------------------;
; restore_int_2Fh
;
; If we installed ourselves into int 2Fh, we'll restore the previous
; vector.
;
; This function is called whenever the driver receives a disable call.
;
; Entry:
;	ES = Data
; Returns:
;	ES = Data
; Registers Preserved:
;	BX,CX,DX,SI,DI,BP,DS
; Registers Destroyed:
;	AX,ES,flags
; Calls:
;	none
; History:
;	Sun 20-Sep-1987 19:00:13 -by-  Walt Moore [waltm]
;	Added addressibility to the Code segment where stuff
;	is stored.  Added switch_control flag.
;
;	Wed 16-Sep-1987 20:17:08 -by-  Bob Grudem [bobgru]
;	Wrote it.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

		public	restore_int_2Fh

restore_int_2Fh proc    near
;
;ES & DS are destroyed by this proc.
;
        assume  ds:DGROUP
        assume  es:nothing


        test	switch_control,INT_2F_HOOKED
	jz	restore_done
	cli	
	and	switch_control,not INT_2F_HOOKED

        mov	ax, _Text
        push    ax
	call	AllocCSToDSAlias
	mov	es, ax
	assume  es: _Text

	push	ds
	lds	dx, prev_int_2Fh	; previous vector was stored in Code
	mov	ax, 2500h+INT_MULT
	int	21h
	pop	ds

	sti

restore_done:
	ret

restore_int_2Fh endp


_INIT   ENDS


        END

