#ifndef __IV_DREG_H__
#define __IV_DREG_H__
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1992, pellucid, inc.	                  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of pellucid, inc., and          *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of pellucid, inc.          *
 *									  *
 **************************************************************************/

/*
 * Display Register operation argument structures
 */

typedef struct iv_displayreg {
	char regnum;
	unsigned char val;
} iv_displayreg_t;

typedef struct iv_blankscreen {
	char blankscreen;
} iv_blankscreen_t;

typedef struct iv_setmonitor {
	unsigned char monitortype;
	unsigned char flag;
	long xmaxscreen;
	long ymaxscreen;
	long xcursmagic;
	long ycursmagic;
	long topscan;
} iv_setmonitor_t;

typedef struct iv_getmonitor {
	unsigned char monitortype;
	unsigned char flag;
} iv_getmonitor_t;

/* Display control flags: */
#define IV_SYNCGRN	0x01		/* Composite sync on green */
#define IV_BLANK	0x02		/* Screen is currently off */
#define IV_STEREO	0x04		/* Stereo optic display enabled */
#define IV_EXTCLK	0x08		/* Timing locked to external clock
					   (ie. in genlock mode) */
#define IV_COMPSYNC	0x20		/* Composite sync */
#define IV_HVSYNC	0x40		/* H/V seperate sync */

#define IV_OVERRIDE_TOPSCAN 0x10	/* Use the topscan value supplied with
					   struct sggr1_setmonitor instead of
					   determining it from monitortype;
					   never set by sggr1_getmonitor */

#endif	/* !__IV_DREG_H__ */
