/* $Revision: 1.2 $ */
#define WIN_DRIVER 1
#define AGR 1

#include "common.h"
#include "iv1.h"

#include "invent.h"
#include "gfxboard.h"
#include "ge5_glob.h"
#include "re.h"
#include "gecmds.h"
#include "iv_ucode.h"



#include "externs.h"
#include "protos.h"

#include "atsubr.h"


/* possible values for iv_videotiming */
#define IV_MEDRES                 0
#define IV_HIRES                  1
#define IV_NTSC                   2
#define IV_PAL                    3
#define IV_MEDRES_X               4
#define IV_MEDRES_NEC             5
#define IV_MEDRES_NEC_X           6

/* defines used by iv_init() when setting RE2 version number */
#define    RE2_1    -1
#define    RE2_2    1


extern  SHORT   GlobCursXPos;                       
extern  SHORT   GlobCursYPos;

extern short iv_curs_xoff,iv_curs_yoff;

/* external function prototypes */
extern void FAR iv_setcursglyph(CURSSTATE *); 
extern void FAR iv_readcursglyph(CURSSTATE *); 
extern void FAR iv_readcurscolors(CURSSTATE *); 
extern void FAR iv_setcurscolors(CURSSTATE *); 

extern unsigned short _gl_ge_irq;
extern int _loadds iv_mload(uc_hdr_t FAR *ucp);
extern void load_gammatab(void);
extern void iv_setscrnmode(long mode);
extern void FAR iv_cursdisplay(short);
extern void FAR iv_poscursor(short, short);
extern void FAR iv_setcursor(CURSORSHAPE FAR *);
extern void FAR iv_mapcurscolor(unsigned long, unsigned long,
                            unsigned long, unsigned long);

extern unsigned int GLOB_X_Size;
extern unsigned int GLOB_Y_Size;

extern int GLOB_Sync;



/* forward references */
int far iv_save_state(void);
int near iv_readpalettecolors(PALSTATE *) ;
int near iv_setpalettecolors(PALSTATE *) ;

int near iv_displayinit(void);
static int near iv_gethwconfig(void);
void near reset_delay(void);

void iv_setmontiming(void);

static unsigned char hwconfig = 0;
int ivhw_state;
int iv_dispinit = 0;  /* display subsystem initialization state flag */
int iv_videotiming;  /* XXX - for now init to HIRES (1280 x 1024) */
int IVDriverInitialized=0;


CURSSTATE IVCursorstructure;
CURSSTATE *IVCursState;

PALSTATE  IVPalstructure;
PALSTATE *IVPalState;

unsigned char dregdata;
/* DAC address offsets used in display initialization */
long iv_dacaddrs[] = {
    DACR_OFF,
    DACG_OFF,
    DACB_OFF,
};

#define NUMTOTCOLORS   256
#define NUMOFCOLORS    20
#define PAL_LENGTH    NUMOFCOLORS * 3
#define BLACK        0
#define RED        13
#define MONEY        8

#define WINRED 249
#define WINGREEN 250
#define WINYELLOW 251
#define WINBLUE 252

#ifdef OLD

/* 20 color palette matches Windows default colors */
static unsigned char Palette[NUMOFCOLORS][3] = {
    0x00, 0x00, 0x00,        /* BLACK */
    0xbf, 0x00, 0x00,        /* Dim RED */
    0x00, 0xbf, 0x00,        /* Dim GREEN */
    0xbf, 0xbf, 0x00,        /* Dim YELLOW */
    0x00, 0x00, 0xbf,        /* Dim BLUE */
    0xbf, 0x00, 0xbf,        /* Dim MAGENTA */
    0x00, 0xbf, 0xbf,        /* Dim CYAN */
    0xc0, 0xc0, 0xc0,        /* Light Grey */
    0xc0, 0xdc, 0xc0,        /* Money Green */
    0xa4, 0xc8, 0xf0,        /* Cool Blue */

    0xff, 0xfb, 0xf0,        /* Off White */
    0xa0, 0xa0, 0xa4,        /* Medium Grey */
    0x80, 0x80, 0x80,        /* Dark Grey */
    0xff, 0x00, 0x00,        /* RED */
    0x00, 0xff, 0x00,        /* GREEN */
    0xff, 0xff, 0x00,        /* YELLOW */
    0x00, 0x00, 0xff,        /* BLUE */
    0xff, 0x00, 0xff,        /* MAGENTA */
    0x00, 0xff, 0xff,        /* CYAN */
    0xff, 0xff, 0xff,        /* WHITE */
};
#endif

/* 20 color palette matches Windows default colors */
static unsigned char Palette[NUMOFCOLORS][3] = {
    0x00, 0x00, 0x00,        /* BLACK */
    0xbf, 0x00, 0x00,        /* Dim RED */
    0x00, 0x9f, 0x00,        /* Dim GREEN */
    0xbf, 0x9f, 0x00,        /* Dim YELLOW */
    0x00, 0x00, 0xbf,        /* Dim BLUE */
    0xbf, 0x00, 0xbf,        /* Dim MAGENTA */
    0x00, 0x9f, 0xbf,        /* Dim CYAN */
    0xc0, 0xc0, 0xc0,        /* Light Grey */
    0x80, 0xff, 0x80,        /* Money Green */
//    0xc0, 0xdc, 0xc0,        /* Money Green */
    0xa4, 0xc8, 0xf0,        /* Cool Blue */

    0xff, 0xfb, 0xf0,        /* Off White */
    0xa0, 0xa0, 0xa4,        /* Medium Grey */
    0x80, 0x80, 0x80,        /* Dark Grey */
    0xff, 0x00, 0x00,        /* RED */
    0x00, 0xff, 0x00,        /* GREEN */
    0xff, 0xff, 0x00,        /* YELLOW */
    0x00, 0x00, 0xff,        /* BLUE */
    0xff, 0x00, 0xff,        /* MAGENTA */
    0x00, 0xff, 0xff,        /* CYAN */
    0xff, 0xff, 0xff,        /* WHITE */
};

#ifdef OLDWAY

/* readpixel buffer variables */
HGLOBAL bufhandle;
unsigned long _FAR *longbufptr;

#define GLOBALIVSIZE    5120
#define DITHEREDSIZENEED    64

unsigned long GlobalIVarea[GLOBALIVSIZE];

/* GlobalIVarea is used for the following things

   UpdateColors   - Temporary scratch area for this routine
   DitheredBrush  - Temporary 64 byte scratch area to create dither pattern
   Scanlr         - Temporary Scratch area to for routine


*/

#endif

unsigned int Y_TRANSLATION;


/*
 *  iv_get_hwstate
 *
 *  Get the configuration (options) and state of IRISVISION hardware.
 */
static void 
iv_get_hwstate()
{
   GRPsetup;
   int b;


   /*
    *  Read Display Reg 0 for ZBIN (z-buffer option) bit.  Shift it left to
    *  match the bit placement in hwconfig word from IRISVISION system.
    *  Read Display Reg 2 for BPIN (24 bitplane option) bit and OR it into
    *  hwconfig.
    *
    *  NOTE: For ZBIN & BPIN option bits - installed = 0 
    */ 

   HQMMSB_WR(1);  /* prepare to access display registers */

   ivhw_state = 0;  /* high-res monitor implied */
   ivhw_state |= INV_GR1RE2 | INV_GR1CURS2;

   DREG_RD_XPC(DREG0_OFF, b);
   hwconfig = (unsigned char)((b & DREG_ZBUF0) << 1);
   if (!(b & DREG_ZBUF0))
       ivhw_state |= INV_GR1ZBUF24;

   DREG_RD_XPC(DREG2_OFF, b);
   hwconfig |= (b & DREG_BITPLANES);
   if (!(hwconfig & DREG_BITPLANES))
       ivhw_state |= INV_GR1BIT24 | INV_GR1AUX4;
   else
       ivhw_state |= INV_GR1SMALLMAP | INV_GR1NOGAMMA;

   if ((iv_videotiming == IV_MEDRES) || (iv_videotiming == IV_MEDRES_X))
       ivhw_state |= INV_GR1SMALLMON;

   HQMMSB_WR(0);  /* driver must always set mid addr reg MSB back to 0 */
}


/* clear UAUX, PUP and WID bitplanes */

static void
near clear_bitplanes(void)
{
   GRPsetup;
   int    i;
   long zero = 0, one = 1, mone = -1;
   long mask, tmp;

   /*set the piece list since GE_SCREENCLEAR uses it */

   GEWAIT;
   FIFO_WR(GE_SETPIECES,zero);
   FIFO_WR(GE_DATA,one);

   tmp = 1024;
   
   FIFO_WR(GE_DATA, tmp);  /* ylen1 */
   tmp = 0;
   FIFO_WR(GE_DATA, tmp);  /* lly1 */
 
   tmp = 1280;

   FIFO_WR(GE_DATA, tmp);  /* xlen1 */
   tmp = 0;
   FIFO_WR(GE_DATA, tmp);  /* llx1 */

   /* now fill the other three pieces to zero */
   for (i=0 ; i < 12 ; ++i) {
       FIFO_WR(GE_DATA,zero);
   }



   FIFO_WR(GE_PIXTYPE, 0);
   tmp = 2;
   FIFO_WR(GE_DATA, tmp);  /* 8 bit CI (base) or 12 bit CI */


   /* select NORMALDRAW framebuffer */
   GEWAIT;
   FIFO_WR(GE_DRAWMODE,0);
   FIFO_WR(GE_DATA,1);
   FIFO_WR(GE_DATA,1);
   FIFO_WR(GE_DATA,1);

   GEWAIT;
   FIFO_WR(GE_COLOR, 0);
   FIFO_WR(GE_DATA, 0);


   FIFO_WR(GE_PIXWRITEMASK, 0);
   mask = 0xFFFFFF;   
   FIFO_WR(GE_DATA,mask);

   FIFO_WR(GE_AUXWRITEMASK, 0);
   mask = 0x0;
   FIFO_WR(GE_DATA,mask);

   /* zero the bitplanes (including the z-buffer) */
   FIFO_WR(GE_CZCLEAR,zero);
   FIFO_WR(GE_DATA,zero);    /* R (or CI) */
   FIFO_WR(GE_DATA,zero);    /* G */
   FIFO_WR(GE_DATA,zero);    /* B */
   FIFO_WR(GE_DATA,zero);    /* Z */   
   FIFO_WR(GE_DATA,mone);    /* disable fast z clear */ /*dwight maybe change this to fast zclear*/


   GEWAIT;
   FIFO_WR(GE_SCREENCLEAR,0);


   FIFO_WR(GE_PIXWRITEMASK, 0);
   mask = 0x0;
   FIFO_WR(GE_DATA,mask);
   GEWAIT;

   /* select OVERDRAW/UNDERDRAW framebuffer (UAUX bitplanes) */
   GEWAIT;
   FIFO_WR(GE_DRAWMODE,0);
   FIFO_WR(GE_DATA,-1);
   FIFO_WR(GE_DATA,-1);
   FIFO_WR(GE_DATA,-1);

   GEWAIT;
   FIFO_WR(GE_COLOR, 0);
   FIFO_WR(GE_DATA, 0);

   FIFO_WR(GE_AUXWRITEMASK, 0);
   mask = 0x0C;
   FIFO_WR(GE_DATA,mask);

   /* clear the bitplanes */
   GEWAIT;
   FIFO_WR(GE_SCREENCLEAR,0);


   /* select PUPDRAW framebuffer */
   GEWAIT;
   FIFO_WR(GE_DRAWMODE,0);
   FIFO_WR(GE_DATA,-1);
   FIFO_WR(GE_DATA,-1);
   FIFO_WR(GE_DATA,1);

   GEWAIT;
   FIFO_WR(GE_COLOR, 0);
   FIFO_WR(GE_DATA, 0);

   FIFO_WR(GE_AUXWRITEMASK, 0);
   mask = 0x03;
   FIFO_WR(GE_DATA,mask);

   /* clear the bitplanes */
   GEWAIT;
   FIFO_WR(GE_SCREENCLEAR,0);

   /* select drawmode of the WID bitplanes */
   GEWAIT;
   FIFO_WR(GE_DRAWMODE,0);
   FIFO_WR(GE_DATA,-1);
   FIFO_WR(GE_DATA,1);
   FIFO_WR(GE_DATA,1);


   GEWAIT;
   FIFO_WR(GE_COLOR, 0);
   FIFO_WR(GE_DATA, 0);

   FIFO_WR(GE_AUXWRITEMASK, 0);
   mask = 0xF0;
   FIFO_WR(GE_DATA,mask);

   /* clear the bitplanes */
   GEWAIT;
   FIFO_WR(GE_SCREENCLEAR,0);


   /* leave the aux mask as zero */
   FIFO_WR(GE_AUXWRITEMASK, 0);
   mask = 0x0;
   FIFO_WR(GE_DATA,mask);

}



int _loadds
iv_deinit()
{


#ifdef MAKEITSTATIC
    /* get rid of readpixel buffer */
    GlobalUnlock(bufhandle);
    GlobalFree(bufhandle);
#endif

    iv_save_state();


    iv_setscrnmode(SCMD_VGAMODE);

    /* Disable the board */
//    outp(ioport[agr_ioport] + CONFIG_PORT, 1);

    return(1);

}


/*
 * iv_init()
 *
 *   Called to initialize the IRISVISION graphics subsystem.  Full blown
 *   graphics is ready to go.
 *
 */
int
iv_init()
{
    GRPsetup;
    long tmp;
    long rtn;
    const long zero = 0;
    const long one = 1;
    const long mone = -1;
    unsigned long re2version;
    uc_hdr_t uc;
    int status; 

    /*
     *  Get IRISVISION configuration
     */

    IVCursState = &IVCursorstructure;
    IVPalState = &IVPalstructure;

    Y_TRANSLATION=GLOB_Y_Size-1;

    /* First Get Resolution Mode */
    if (GLOB_X_Size == 1024) {
       iv_videotiming = IV_MEDRES;  
    }
    else {   /* Default Case 1280 */
       iv_videotiming = IV_HIRES;  


    }


    status = iv_gethwconfig();
    if (!status) return(0);
    /*
     *  Initialize the display hardware.
     */
    status = iv_displayinit();
    if (!status) return(0);

    iv_setmontiming();

    /*
     * Download microcode
     */
    /* clear ucode header (we used to do this with "memset") */
    uc.magic = 0;
    uc.version=0;    /* microcode header version */
    uc.codelen=0;
    uc.codehandle=0;    /* handle to buffer allocated by Windows */
    uc.constlen=0;
    uc.consthandle=0;    /* handle to buffer allocated by Windows */
    uc.ucversion=0;    /* microcode version word */

    rtn = iv_mload((uc_hdr_t FAR *)&uc);

    /* disable graphics interrupts */
    GFXIMASK_WR( 0 );

    /* Bail out if microcode download failed. */
    if (rtn != 0)
        return(0);

    /*
     * Send hardware config info down to the microcode which uses it
     * to set RE regs.
     */
    if (hwconfig & DREG_BITPLANES) {
        FIFO_WR(GE_DATA, zero);
    } else {
        FIFO_WR(GE_DATA, one);
    }

    if (hwconfig & DREG_ZBUF) {
        FIFO_WR(GE_DATA, zero);
    } else {
        FIFO_WR(GE_DATA, one);
    }

    FIFO_WR(GE_DATA, one);    /* I meg VRAM installed */





    /* Context Init Time p 4 - 85 of MGR manual */   


    /* This is place to set Hires or Medres */
    FIFO_WR(GE_LOADRE, zero);    /* set top scan value */
    tmp = RE_TOPSCAN;
    FIFO_WR(GE_DATA,tmp);

    if (ivhw_state & INV_GR1SMALLMON)
        tmp = TOPSCAN_MIDRES_2;    /* 1 meg VRAM topscan value 767*/
    else
        tmp = TOPSCAN_HIRES_2;    /* 1 meg VRAM topscan value 0x3ff*/
    FIFO_WR(GE_DATA,tmp);

    FIFO_WR(GE_LOADRE, zero);    /* set enabrgb reg */
    tmp = RE_ENABRGB;
    FIFO_WR(GE_DATA,tmp);
    tmp = 1;        /* 1 to enable 8 bit RGB operation */
    FIFO_WR(GE_DATA,tmp);

    /*
     *  OK, lets get the RE working in "Little Endian" mode now (by clearing
     *  the RE_BIGENDIAN register to zero) so the BitBLTs from Windows will
     *  come out right.
     *                                - Orc
     */
    FIFO_WR(GE_LOADRE, 0);
    FIFO_WR(GE_DATA, RE_BIGENDIAN);
    FIFO_WR(GE_DATA, 0);


    /* Enable the display. */ 
    HQMMSB_WR(1);
    DREG_WR(DREG2_OFF, DREG_SCREENON);

    /*
     *  Test and correct the RE2VERSION flag to tell the GE5 microcode how to
     *  deal with the 1Meg VRAM / screenmask bug in line drawing.  The bug
     *  is fixed in RE 2.2.  The microcode stores a value in the data ram at
     *  location RE2VERSION which reflects the version of the RE2 in bits
     *  8-15.  These 8 bits are 0xff for RE 2.1 and 0xfe for RE 2.2.
     */
    HQMMSB_WR(0);
    HQM_WR(RE2VERSION);
    DRAM_RD(RE2VERSION, re2version);
    re2version = 256 - ( (unsigned short)(re2version >> 8) & 0xff );
    if (re2version > 1) {
        DRAM_WR(RE2VERSION, RE2_2);
    } else {
        DRAM_WR(RE2VERSION, RE2_1);
    }


    clear_bitplanes();    /* clear UAUX, PUP and WID bitplanes */


    /* Switch display output over to IRISVISION (turn off passthru). */
    iv_setscrnmode(SCMD_IVMODE);

    /*
     *  Make sure the sreenmask (clipping mask) is set to full screen.
     */
    IVSetClip(0
             ,0
             ,GLOB_X_Size-1
             ,GLOB_Y_Size-1);


    /* select framebuffer bitplanes as drawing destination */
   GEWAIT;
   FIFO_WR(GE_DRAWMODE,0);
   FIFO_WR(GE_DATA,1);
   FIFO_WR(GE_DATA,1);
   FIFO_WR(GE_DATA,1);

    /* select color index pixel type */
    FIFO_WR(GE_PIXTYPE,zero);
    tmp = 2;
    FIFO_WR(GE_DATA,tmp);
    GEWAIT;

    /* enable writing to all bitplanes */
    FIFO_WR(GE_PIXWRITEMASK, 0);
    tmp = 0xFFFFFF;
    FIFO_WR(GE_DATA,tmp);
    GEWAIT;

    FIFO_WR(GE_RASTEROP, 0);
    FIFO_WR(GE_DATA, 3);
    FIFO_WR(GE_DATA, -1);


 
    IVDriverInitialized=1;
    return(1);
}


void _loadds _pascal
IVSetClip(unsigned int start_x
         ,unsigned int start_y
         ,unsigned int end_x
         ,unsigned int end_y)
{
   int clipflag=1;

   GRPsetup;
   GEWAIT;
   FIFO_WR(GE_SCRMASK, 0);

   /*
    *  Need a Y translation first then, a reversal of start y and end y
    *  because IV is looking for coords in lly first and coming in as uly
    *  first, etc  
    */

   FIFO_WR(GE_DATA, (long) clipflag);
   FIFO_WR(GE_DATA, (unsigned long)start_x);
   FIFO_WR(GE_DATA, (unsigned long)  (Y_TRANSLATION  -end_y));
   FIFO_WR(GE_DATA, (unsigned long)end_x);
   FIFO_WR(GE_DATA, (unsigned long)  (Y_TRANSLATION  -start_y));

}

/*
 *  reset_delay
 */
void
near reset_delay(void)
{
   int    i,j;

   for (i = 0, j = 1;i < 10000; i++) {
    j = j * 1;
    j = j + i;    /* Make sure hardware sees the reset */
   }
}


/*
 * iv_hwreset
 *
 * Resets GR1 board
 *
 */
void
iv_hwreset()
{
   GRPsetup;

   unsigned char monitor_type;
   unsigned char nosyncongreen;
   unsigned char reg1bit,reg4bits;

   /*
    * Assert a reset to the graphics board and DMA hardware while graphics
    * interrupts are masked.
    */
   RESET_GFX;
   reset_delay();
   /* Release reset */
   UNRESET_GFX;
   reset_delay();


   HQMMSB_WR(1);    /* Set mid addr reg MSB to access display reg's */
   /* TURN the screen OFF (DREG_LEDOFF has bit 0 = 0) */
   DREG_WR(DREG2_OFF, DREG_LEDOFF);



   /*
    * Init Display registers. RMW display reg.s.
    *XXX Should be RMW
    */

   if (iv_videotiming == IV_MEDRES) {
      monitor_type = 7;
   }
   else{
      monitor_type = 0;
   }

   nosyncongreen=(unsigned char) GLOB_Sync;        /* For now, hard code this puppy, I guess
                              should prompt for this in sys ini */

#ifdef SPECIALNOSYNCONGREEN
   nosyncongreen=1;

#endif

   /* monitor_type ranges from 0 -> 7 */
   if (monitor_type & DREG_MONITORMASK2) 
      reg1bit = DREG_MONITORUPPER;
   else
      reg1bit = 0;
   reg4bits = monitor_type & (unsigned char ) DREG_MONITORMASK;

   /* Store value here instead of accessing DREG1 cause that hangs machine */

   dregdata = reg1bit | nosyncongreen;


   DREG_WR(DREG4_OFF, reg4bits );
   DREG_WR(DREG4_OFF, reg4bits | DREG_ACLKEN);
   DREG_WR(DREG4_OFF, reg4bits | DREG_ACLKEN | DREG_SCLKEN);



   DREG_WR(DREG3_OFF, 0);
   /*
   *  must take MONSET bit low and then high to reload monitor 
   *  timing table into Xilinx chip
   */
   DREG_WR(DREG3_OFF, DREG_MONITORRESET);



   HQMMSB_WR(0);    /* must always set mid addr reg MSB back to 0 */

}





/*
 * iv_setmontiming
 *
 * this routine is identical as iv_hwreset except for 
 * this routine modifies DREG1, IF this is done in iv_hwreset
 * it will HANG THE MACHIN accessing DREG1 Memory
 * therefore, just make new routine and call again later
 * in the init process, although some of the stuff is redundant
 * it is necessary to have in both places.     Dwight
 *
 */
void
iv_setmontiming()
{
   GRPsetup;

   unsigned char monitor_type;
   unsigned char nosyncongreen;
   unsigned char reg1bit,reg4bits;


   /*
    * Assert a reset to the graphics board and DMA hardware while graphics
    * interrupts are masked.
    */
   RESET_GFX;
   reset_delay();
   /* Release reset */
   UNRESET_GFX;
   reset_delay();

   HQMMSB_WR(1);    /* Set mid addr reg MSB to access display reg's */
   /* TURN the screen OFF (DREG_LEDOFF has bit 0 = 0) */
   DREG_WR(DREG2_OFF, DREG_LEDOFF);

   /*
    * Init Display registers. RMW display reg.s.
    *XXX Should be RMW
    */

   if (iv_videotiming == IV_MEDRES) {
      monitor_type = 7;
   }
   else{
      monitor_type = 0;
   }

   nosyncongreen=(unsigned char) GLOB_Sync;        /* For now, hard code this puppy, I guess
                              should prompt for this in sys ini */
#ifdef SPECIALNOSYNCONGREEN
   nosyncongreen=1;

#endif

   /* monitor_type ranges from 0 -> 7 */
   if (monitor_type & DREG_MONITORMASK2) 
      reg1bit = DREG_MONITORUPPER;
   else
      reg1bit = 0;
   reg4bits = monitor_type & (unsigned char ) DREG_MONITORMASK;
   /* Store value here instead of accessing DREG1 cause that hangs machine */


	DREG_RD_XPC(DREG1_OFF, dregdata);  
   DREG_WR(DREG1_OFF, (dregdata & ~DREG_MONITORUPPER) | reg1bit | nosyncongreen);

   DREG_WR(DREG4_OFF, reg4bits );
   DREG_WR(DREG4_OFF, reg4bits | DREG_ACLKEN);
   DREG_WR(DREG4_OFF, reg4bits | DREG_ACLKEN | DREG_SCLKEN);



   DREG_WR(DREG3_OFF, 0);
   /*
   *  must take MONSET bit low and then high to reload monitor 
   *  timing table into Xilinx chip
   */
   DREG_WR(DREG3_OFF, DREG_MONITORRESET);



   HQMMSB_WR(0);    /* must always set mid addr reg MSB back to 0 */
}


/*
 * iv_displayinit()
 *
 * Initialize graphics display hardware.
 *
 */
int near
iv_displayinit()
{
    extern int curs_status;
    GRPsetup;
    register long i, j;
    register long daddr;
    long vertMissCount = 0;


    HQMMSB_WR(1);
    /*
     * Init DACS
     */
    if (ivhw_state & INV_GR1BIT24) {

#ifdef DEBUG
        OutputDebugString("iv_displayinit: 24 color planes detected\r\n");
#endif
        for (j = 0; j < 3; j++) {
            daddr = iv_dacaddrs[j];

            DAC_AWR(daddr, DAC_READMASK);
            DAC_CRWR(daddr, 0xFF);
            DAC_AWR(daddr, DAC_BLINKMASK);
            DAC_CRWR(daddr, 0x00);
            DAC_AWR(daddr, DAC_CMD);
            /* Make overlay 0 transparent mode */
            DAC_CRWR( daddr, DAC_5TO1MUX | DAC_RAMENBL |
                DAC_OL0ENBL | DAC_OL1ENBL );
            DAC_AWR(daddr, DAC_TEST);
            DAC_CRWR(daddr, 0x00);
        } /* for j 0..3 */
    } else {  /* 8 color planes detected */
#ifdef DEBUG
        OutputDebugString("iv_displayinit: 8 color planes detected\r\n");
#endif
        DAC_AWR(DACRGB_OFF, DAC_READMASK);
        DAC_CRWR(DACRGB_OFF, 0xff);
        DAC_AWR(DACRGB_OFF, DAC_BLINKMASK);
        DAC_CRWR(DACRGB_OFF, 0x00);
        DAC_AWR( DACRGB_OFF, DAC_CMD);
        /* Make overlay 0 transparent mode */
        /* 
         * XXX - might need to change this to enable hardware cursor
         *       on minimum bitplane system  - Orc
         */
        DAC_CRWR(DACRGB_OFF, DAC_5TO1MUX | DAC_RAMENBL |
                DAC_OL0ENBL | DAC_OL1ENBL );
        DAC_AWR(DACRGB_OFF, DAC_TEST);
        DAC_CRWR(DACRGB_OFF, 0x00);
    }

    if (!IVDriverInitialized)   {        /* Only Do this the first time */
         /*
         * Init Cursor.
         */
   
         /* Init cursor color */
         iv_mapcurscolor(1, (unsigned long)0x00, (unsigned long)0x00,
	      (unsigned long)0x00);
         iv_mapcurscolor(2, (unsigned long)0xFF, (unsigned long)0x00,
	      (unsigned long)0x00);
         iv_mapcurscolor(3, (unsigned long)0xFF, (unsigned long)0xFF,
	      (unsigned long)0xFF);
         HQMMSB_WR(1);  /* iv_mapcurscolor clears HQMMSB so set it again */

         /* INitialize Cursor Fudge Factors for either Video Mode */

         if (iv_videotiming == IV_MEDRES) {
            iv_curs_xoff = IV_WIN_CURS_XOFFMED;
            iv_curs_yoff = IV_WIN_CURS_YOFFMED;
         }
         else {                 /* Default Case 1280x1024*/
            iv_curs_xoff = IV_WIN_CURS_XOFF;
            iv_curs_yoff = IV_WIN_CURS_YOFF;

         }

         /* Load cursor glyph */
         /* make sure cursor 1 cmd register is zero */
         CURS_A0WR(CURS1_OFF, CURS_CMD);
         CURS_A1WR(CURS1_OFF, CURS_CMD);
         CURS_CRWR(CURS1_OFF, 0x0);

         /*
         *  cursor 0
         */
         /* Set cursor type to block */
         CURS_A0WR(CURS0_OFF, CURS_CMD);
         CURS_A1WR(CURS0_OFF, CURS_CMD);
         CURS_CRWR(CURS0_OFF, CURS_BLOCK | CURS_5TO1MUX);

         CURS_A0WR(CURS0_OFF, 0);
         CURS_A1WR(CURS0_OFF, 0);
         for (i = CURS_GLYPH_SIZE; i; i--) { 
            CURS_GLYPHWR(CURS0_OFF, 0x00);
         }

         /*
         *  cursor 1
         */
         /* Set cursor type to block */
         CURS_A0WR(CURS1_OFF, CURS_CMD);
         CURS_A1WR(CURS1_OFF, CURS_CMD);
         CURS_CRWR(CURS1_OFF, CURS_BLOCK | CURS_5TO1MUX);

         CURS_A0WR(CURS1_OFF, 0);
         CURS_A1WR(CURS1_OFF, 0);
         for (i = CURS_GLYPH_SIZE; i; i--) {
            CURS_GLYPHWR(CURS1_OFF, 0x00);
         }  /* for i curs_glyph_size do */

         /* set the cursor position and enable it */
         iv_poscursor((GLOB_X_Size/2 -1),(GLOB_Y_Size/2 -1));
         iv_cursdisplay(1);
         HQMMSB_WR(1);  /* iv_poscursor & iv_cursdisplay clear HQMMSB */



    } /* end of if IVDriverInitialized */
    else { /* Driver Already Initialized */


      iv_setcurscolors(IVCursState);
      iv_setcursglyph(IVCursState); 

      /* okay, now we need to position the cursor where it last was
         because running GL programs will screw these reg's up */

      iv_poscursor(GlobCursXPos,GlobCursYPos);
      iv_cursdisplay(1);
      HQMMSB_WR(1);  /* iv_setcursor clears HQMMSB */


    }



    if (ivhw_state & INV_GR1BIT24) {

        /*
         *  Init all 16 XMAP Mode Registers to 8 bit color index mode.
         */
        XMAP_ALOWR(0);
        XMAP_AHIWR(0);
        for (i = 0; i < XMAP_WIDAUX_OFF; i += 2) {
            /*
             *  color map mode avoids cyan flash
             *  (Low 8 bits of mode register)
             */
            XMAP_OTHERWR(XMAP_8CI);
            XMAP_INCA();

            /* High 6 bits of mode register */
            XMAP_OTHERWR(0);
            XMAP_INCA();
        }

        /*
         *  Set WID/AUX bit to 0 if 24 color bitplanes, 1 otherwise.
         *  NOTE:  The XMAP_OTHERWR operation below assumes the XMAP
         *  address register is already pointing to the WID/AUX Control
         *  Register, which should have happened immediately above this
         *  point.
         */
        if (hwconfig & DREG_BITPLANES) {
            XMAP_OTHERWR(1);
        } else {
            XMAP_OTHERWR(0);
        }
   
        /*
         *  Set aux color map to black/transparent.
         */
        XMAP_ALOWR(0);
        XMAP_AHIWR(0);
        for (i = 0; i < XMAP_NAUXMAPENT; i++) {
            XMAP_COLWR(XMAP_RED, 0);
            XMAP_COLWR(XMAP_GREEN, 0);
            XMAP_COLWR(XMAP_BLUE, 0);
   
            XMAP_INCA();
        }
   
        if (!IVDriverInitialized)   {        /* Only Do this the first time */
            /* Start out with entire colormap set to black. */
            for (i = 0; i < XMAP_NCOLMAPENT; i+=32) {
                  HQMMSB_WR( 1 );
                  XMAP_ALOWR(i | XMAP_COLSEL);
                  XMAP_AHIWR(i | XMAP_COLSEL);
   
                  for (j=0; ((j<32)&&((i+j)<XMAP_NCOLMAPENT)); j++) {
                     XMAP_COLWR(XMAP_RED, 0);
                     XMAP_COLWR(XMAP_GREEN, 0);
                     XMAP_COLWR(XMAP_BLUE, 0);
                     XMAP_INCA();
                  }
            }
            /*
               * Set up the first default entries in color map.
               */
            XMAP_ALOWR(XMAP_COLSEL);
            XMAP_AHIWR(XMAP_COLSEL);
   
            for (i = 0; i < NUMOFCOLORS/2; i++) {
                  XMAP_COLWR(XMAP_RED, Palette[i][0]);
                  XMAP_COLWR(XMAP_GREEN, Palette[i][1]);
                  XMAP_COLWR(XMAP_BLUE, Palette[i][2]);
                  XMAP_INCA();
            }

            /* Now put Windows Last 10 colors in the lower 10 entries */
            /* first set up that xmap stuff */
            HQMMSB_WR( 1 );

            /* Use 7*32=224 cause 246/32&256/32 both = 7 */
            XMAP_ALOWR(246 | XMAP_COLSEL);
            XMAP_AHIWR(246 | XMAP_COLSEL);

            for (i=(NUMOFCOLORS/2); i < NUMOFCOLORS; i++) {
                  XMAP_COLWR(XMAP_RED, Palette[i][0]);
                  XMAP_COLWR(XMAP_GREEN, Palette[i][1]);
                  XMAP_COLWR(XMAP_BLUE, Palette[i][2]);
                  XMAP_INCA();
            }
        } /* end if driver not initialized */
        else {       /* driver already initialized, reload saved pal */

            iv_setpalettecolors(IVPalState);
            HQMMSB_WR(1);  /* iv_setpalette clears HQMMSB */

        }
           
    } 
    else {  /* minimum bitplane system */
        /* Init XPC to all 8 bit color index mode. */
        for (i = 0; i < XPC_NMODEREGS; i++) {
            XPC_ADDRWR (i*2);
            XPC_MODEWR (XMAP_MKMODELO(XMAP_8CI, 0, 0));
            XPC_ADDRWR ((i*2)+1);
            XPC_MODEWR (XMAP_MKMODEHI(0, 0, 0));
        } 
   
        if (!IVDriverInitialized)   {        /* Only Do this the first time */
            /* Init first 10 color entries */
            DAC_AWR(DACRGB_OFF, 0);
            for (i = 0; i < NUMOFCOLORS/2; i++) {
                  DAC_COLWR(DACRGB_OFF, Palette[i][0]);
                  DAC_COLWR(DACRGB_OFF, Palette[i][1]);
                  DAC_COLWR(DACRGB_OFF, Palette[i][2]);
            }

            /* Init first 10 color entries */
            DAC_AWR(DACRGB_OFF, 246);
            for (i = (NUMOFCOLORS/2); i < NUMOFCOLORS; i++) {
                  DAC_COLWR(DACRGB_OFF, Palette[i][0]);
                  DAC_COLWR(DACRGB_OFF, Palette[i][1]);
                  DAC_COLWR(DACRGB_OFF, Palette[i][2]);
            }
        } /* end IV driver initialized */

        else {       /* driver already initialized, reload saved pal */

            iv_setpalettecolors(IVPalState);
            HQMMSB_WR(1);  /* iv_setpalette clears HQMMSB */
        }

    }  /* end else */
    HQMMSB_WR(0);
   
    load_gammatab();
   
    /*
    * Initialize HQ middle address reg most significant bit for accesses
    * to the data RAM.  That's what user programs will need it to be.
    * The driver interrupt routines are the only ones who change the bit
    * and they always reset it when they exit.  It shouldn't matter what
    * we initialize the rest of the HQ middle address reg to since each
    * new GL program should write it before it uses it.
    */
    HQMMSB_WR(0);
    HQM_WR(0);
   
    /*
     *  Tell any other concerned routines that IRISVISION display
     *  subsystem is initialized.
     */
    iv_dispinit = 1;
   
    return(1);
}

int near
iv_readpalettecolors(PALSTATE * IVPaletteState) 
{

   GRPsetup;
   unsigned int i,j;

    HQMMSB_WR(1);
    if (ivhw_state & INV_GR1BIT24) {

        /* Start out with entire colormap set to black. */
        for (i = 0; i < NUMTOTCOLORS; i+=32) {
            XMAP_ALOWR(i | XMAP_COLSEL);
            XMAP_AHIWR(i | XMAP_COLSEL);
   
            for (j=0; ((j<32)&&((i+j)<XMAP_NCOLMAPENT)); j++) {
                XMAP_COLRD(XMAP0_OFF,XMAP_RED, IVPaletteState->PalColors[i+j].Red);
                XMAP_COLRD(XMAP0_OFF,XMAP_GREEN, IVPaletteState->PalColors[i+j].Green);
                XMAP_COLRD(XMAP0_OFF,XMAP_BLUE, IVPaletteState->PalColors[i+j].Blue);
                XMAP_INCA();
            }
        }
    } 
    else {  /* minimum bitplane system */

        for (i = 0; i < NUMTOTCOLORS; i++) {
           DAC_AWR(DACRGB_OFF, i);

           DAC_COLRD(DACRGB_OFF, IVPaletteState->PalColors[i].Red);
           DAC_COLRD(DACRGB_OFF, IVPaletteState->PalColors[i].Green);
           DAC_COLRD(DACRGB_OFF, IVPaletteState->PalColors[i].Blue);
        }
   }

   HQMMSB_WR(0);
   return(1);

}


int near
iv_setpalettecolors(PALSTATE * IVPaletteState) 
{

   GRPsetup;
   unsigned int i,j;

    HQMMSB_WR( 1 );
    if (ivhw_state & INV_GR1BIT24) {

        /* Start out with entire colormap set to black. */
        for (i = 0; i < NUMTOTCOLORS; i+=32) {
            XMAP_ALOWR(i | XMAP_COLSEL);
            XMAP_AHIWR(i | XMAP_COLSEL);
   
            for (j=0; ((j<32)&&((i+j)<XMAP_NCOLMAPENT)); j++) {
                XMAP_COLWR(XMAP_RED, IVPaletteState->PalColors[i+j].Red);
                XMAP_COLWR(XMAP_GREEN, IVPaletteState->PalColors[i+j].Green);
                XMAP_COLWR(XMAP_BLUE, IVPaletteState->PalColors[i+j].Blue);
                XMAP_INCA();
            }
        }
    } 
    else {  /* minimum bitplane system */

        for (i = 0; i < NUMTOTCOLORS; i++) {
           DAC_AWR(DACRGB_OFF, i);

           DAC_COLWR(DACRGB_OFF, IVPaletteState->PalColors[i].Red);
           DAC_COLWR(DACRGB_OFF, IVPaletteState->PalColors[i].Green);
           DAC_COLWR(DACRGB_OFF, IVPaletteState->PalColors[i].Blue);
        }
   }
   HQMMSB_WR( 0 );

   return(1);

}

int far
iv_save_state()   
{





   /*
    * Save Cursor Color Table  and glyph
    */
   
   iv_readcurscolors(IVCursState);

   iv_readcursglyph(IVCursState); 


   /*
    * Save Palette Color Table 
    */

   iv_readpalettecolors(IVPalState);



   return(1);


}




/* Number loops before time out. No need to handle delicately. */
#define TIMEOUT_FIFO    20000000  /* waiting for FIFO being < half full */

/*
 * gr1_fifo_intr()
 *
 * Handle FIFO high water mark interrupts from the GR1 by spinning until the
 * host status register shows that the FIFO half full condition has cleared.
 *
 * FIFO full interrupt is latched so that even if it goes away we'll know why
 * we got an interrupt. We must unlatch it to be able to poll the real value.
 * This is done by masking the interrupt. The local interrupt code does this
 * for us.
 *
 * Called from:
 *    Interrupt
 */
void
gr1_fifo_intr()
{
   GRPsetup;
   register unsigned long count;

   for (count = 1; count < TIMEOUT_FIFO; count ++) {
    /*
     * Don't poll every time through loop.
     */
    if (count & 0x7)
       continue;

    if ( !( GFXCTRL0 & GFX_FIFOSTAT) ) {
       return;
    }
   }
}


/************************************************************************/
/*                                  */
/*    Entry Point:    intr                       */
/*                                  */
/*    Purpose:    Handle IV graphics board interrupts.        */
/*                                  */
/************************************************************************/
void
_gl_gr1_intr()
{
    GRPsetup;
    unsigned char int_status;

    int_status = GFXINTR;

    if (int_status & GFX_INT_VR) {
        GFXINTR_CLR (GFX_INT_VR);
    }
#ifndef WIN_DRIVER
    if (int_status & GFX_INT_GE) {
        gr1_ge_intr();
        GFXINTR_CLR (GFX_INT_GE);
    }
#endif /* !WIN_DRIVER */
    if (int_status & GFX_INT_FIFO) {
        gr1_fifo_intr();
        GFXINTR_CLR (GFX_INT_FIFO);
    }
#ifdef MGR
    if (int_status & GFX_INT_BUS_TO) {
        GFXINTR_CLR (GFX_INT_BUS_TO);
    }
#endif
}


#define MAXPOLLCOUNT 2000000

/*
 * iv_gethwconfig
 *
 *
 */
static int near
iv_gethwconfig()
{
    GRPsetup;
    unsigned long pollcount = 0;
    static int iv_gethwconfig_once = 0;

//    if (!iv_gethwconfig_once) {
        iv_gethwconfig_once = 1;

#ifdef AGR
        if (io_init()) {
#ifdef DEBUG
            OutputDebugString("iv_gethwconfig: io_init failure\r\n");
#endif /* DEBUG */
            return(0);
        }


#ifdef DEBUG
        OutputDebugString("iv_gethwconfig: io_init success\r\n");
#endif /* DEBUG */
#endif

#ifdef MGR
        ivmca_init();
#endif
//    }

    iv_hwreset(); /* reset the IRISVISION subsystem */

    iv_get_hwstate();
    return(1);
}
