/**************************************************************************
 *                                               *
 *            Copyright (C) 1990, Silicon Graphics, Inc.            *
 *                                               *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *                                               *
 **************************************************************************/
#define WIN_DRIVER 1
#define AGR 1

#include "common.h"
//#include <conio.h>
//#include "windows.h"
#include "gfxboard.h" 

#define     SWITCHABLE     4

unsigned long _gl_phys_addr;  /* base address of graphics hardware */

#ifdef AGR
#include "atsubr.h"
#endif

static unsigned long physicalMem[8] =
    { PHYADDR0, PHYADDR1, PHYADDR2, PHYADDR3,
      PHYADDR4, PHYADDR5, PHYADDR6, PHYADDR7 };

unsigned char far *GRP;  /* graphics hardware segment */

/*
 * win_grp_set - Windows Graphics Pointer Set
 * 
 *   Get a valid selector from the Windows kernel and use it to
 *   set up the GRP.
 */
LPLONG 
win_grp_set(unsigned long phys_addr)
{
    extern _near _C000H, _D000H;
    GRPsetup;
     if (phys_addr == PHYADDR0) {
#ifdef DEBUG
         OutputDebugString("win_grp_set: Phys Addr = 0xD8000\r\n");
#endif
         GRP = MK_FP( (unsigned short)(&_D000H), 0x8000 );
     }
     else if (phys_addr == PHYADDR2) {
#ifdef DEBUG
         OutputDebugString("win_grp_set: Phys Addr = 0xD0000\r\n");
#endif
         GRP = MK_FP( (unsigned short)(&_D000H), 0 );
     }
     else if (phys_addr == PHYADDR4) {
#ifdef DEBUG
         OutputDebugString("win_grp_set: Phys Addr = 0xC0000\r\n");
#endif
         GRP = MK_FP( (unsigned short)(&_C000H), 0 );
     }
     else if (phys_addr == PHYADDR6) {

#ifdef DEBUG
         OutputDebugString("win_grp_set: Phys Addr = 0xC8000\r\n");
#endif
         GRP = MK_FP( (unsigned short)(&_C000H), 0x8000 );
     }
     else  {
#ifdef DEBUG
         OutputDebugString("win_grp_set: Invalid board address range\r\n");
#endif
      
    }
    return (LPLONG)(GRP);
}

#ifdef AGR

unsigned short _gl_ge_irq;

short agr_ioport;
unsigned int ioport[4] = { IOADDR1, IOADDR2, IOADDR3, IOADDR4 };
int priority[SWITCHABLE] = { 7, 5, 3, 1 };

static unsigned short int_vec_sel[4] = { 15, 10, 12, 10 };

/*
 *  verify that this physical address is ok for agr board
 *    return -1: the given address is not available for agr board
 *            0: the given address is ok for thr agr board
 */
static int 
check_addr(unsigned long phys_addr)
{
    int inx2, chkks, noBytes;
    volatile LPWORD vaddrTmp;
    volatile LPWORD vaddrTmp2;
    unsigned short originalWord, originalWord2;

    vaddrTmp = (volatile LPWORD)win_grp_set(phys_addr);
    noBytes = NOBYTES1;
    chkks = 16;  /* 32k, 2K each */

    for (inx2 = 0; inx2 < chkks; inx2++) {     /* total 32K or 128K */
        vaddrTmp2 = vaddrTmp + 1;
        originalWord = *vaddrTmp;
        originalWord2 = *vaddrTmp2;
        /* check if any ROM at this location? */
        if (originalWord == 0xaa55) {
#if 0
            vidunmap(vaddrTmp, noBytes);
#endif
#ifdef DEBUG
   OutputDebugString("check_addr: ROM found\r\n");
#endif
            return -1;   /* bad news */
        }

        /* now try to do memory test */
        *vaddrTmp = 0x5555;
        *vaddrTmp2 = 0xaaaa;
        if ((*vaddrTmp == 0x5555) && (*vaddrTmp2 == 0xaaaa)) {
	    /* bad news - memory exists */
	    *vaddrTmp = originalWord;       /* put back the original */
	    *vaddrTmp2 = originalWord2;     /* put back the original */
#if 0
            vidunmap(vaddrTmp, noBytes);
#endif
#ifdef DEBUG
	   OutputDebugString("check_addr: memory found\r\n");
#endif
            return -1;
        }
        vaddrTmp += 1024;   /* add 2K bytes */
    }
#if 0
    vidunmap(vaddrTmp, noBytes);
#endif
    return 0;   /* no problem */
}

/**************************************************************************/
/*       Check the AT-386 clone AGR dip switchs                           */
/*       return 0 --> normal, _gl_phys_addr contain the physical address  */
/*             -1 --> AGR board is not there                              */
/*             -2 --> no memory address available for AGR board           */
/**************************************************************************/
int 
io_init()
{
    int inx, inx2;
    unsigned char iodata[2];
    unsigned char config;
    unsigned char switches, mem_select;
    agr_ioport = -1;

    /*
     *  Search for the AGR adapter in an AT-bus slot by accessing the I/O
     *  port and checking for the AGR adapter Magic # of 0x8EE6.  Continue
     *  checking each possible I/O port until the AGR adapter is found or
     *  all possible I/O ports have been checked.
     */
    for (inx = 0; inx < 4; inx++) {
        iodata[0] = (unsigned char)inp(ioport[inx] + MAGIC_ADDRLO);
        iodata[1] = (unsigned char)inp(ioport[inx] + MAGIC_ADDRHI);
        /* AGR only uses bits 1 - 15 for board ID, bit 0 is for VGA/hires */
        if (((iodata[0] & 0xfe)== MAGICLO) && (iodata[1] == MAGICHI)) {
            agr_ioport = inx;
            break;
        }
    }
                   
    /* AGR board is not installed */
    if (agr_ioport == -1)
        return -1;

    /* check memory switches first */
    switches = (unsigned char)inp(ioport[agr_ioport] + SWITCH_PORT);


#ifdef NOTDEF
    /* force board to address 0xd0000 */
    switches |= 0xc0;  /* switches 7 & 8 - OFF */
    switches &= 0xdf;  /* switch 6 - ON */
#endif

    _gl_ge_irq = int_vec_sel[ switches & 3 ]; /* choose the IRQ line */

    /* Disable the board */
    config = 0x1;
    outp(ioport[agr_ioport] + CONFIG_PORT, config);

    mem_select = switches & (unsigned char)0xf0;
    
    /* covert switches 6 - 8 to index array */
    config = 0;
    for (inx2 = 5; inx2 < 8; inx2++)
     config |= (mem_select & (1 << inx2)) ? (1 << (7 - inx2)) : 0;

    switches |= 0x10;
    switches &= 0xf3;
    _gl_phys_addr = physicalMem[config];

    if (check_addr(_gl_phys_addr))
	return -2;  /* address conflict */

    outp(ioport[agr_ioport] + CONFIG_PORT, switches);
    return 0;
}

#endif /* AGR */


#ifdef MGR
#include "pos.h"

#define MGR_ADDRESS     0xc0000          

static int mgr_slot;
unsigned short _gl_ge_irq;


/**************************************************************************/
/**       Set up the POS registers to allow access to the MGR              */
/**************************************************************************/
void 
iv_mca_init()
{
    unsigned char *puchar, posdata[4];
    unsigned char pos2sav;
    int slotnum, addr_range;
    GRPsetup;

#ifdef DEBUG
    printf("Inside mca_init\n");
#endif

    mgr_slot = -1;
    /* search for the MGR subsystem on the bus */
    for (slotnum=0 ; slotnum < 8 ; slotnum++) {
     outp(POS_SLOTSELECT, SELECT_ENABLE | slotnum);
     posdata[0] = (unsigned char)inp(POS_CARDID_L);
     posdata[1] = (unsigned char)inp(POS_CARDID_H);
     if (posdata[0] == 0xE6 && posdata[1] == 0x8E) {
         mgr_slot = slotnum;
         break;
     }
     outp(POS_SLOTSELECT, 0);  /* deselect slot (it's not the one) */
    }
    if (mgr_slot == -1) {
     gposterror(GLERR_SYSTEMERROR, FATAL, MKSTR(iv_mca_init), 
             "board not found");
     /* NOTREACHED */
    }
#ifdef DEBUG
    printf("Card found in slot %d.\n", mgr_slot);
#endif
    outp(POS_SLOTSELECT, SELECT_ENABLE | mgr_slot);

    /*
     *  Check to see if an address has already been programed into the
     *  POS sub-registers for the MGR.
     */
    outp(POS_SUBADDR, POSSUB_CARDADR2);
    if ( inp(POS_SUBDATA) ) {
     /*
      *  An address already exists so read _gl_phys_addr from POS
      *  sub-registers 1 thru 3
      */
     outp(POS_SUBADDR, POSSUB_CARDADR1);
     _gl_phys_addr = (unsigned long)inp(POS_SUBDATA) << 8;
     outp(POS_SUBADDR, POSSUB_CARDADR2);
     _gl_phys_addr |= (unsigned long)inp(POS_SUBDATA) << 16;
     outp(POS_SUBADDR, POSSUB_CARDADR3);
     _gl_phys_addr |= (unsigned long)inp(POS_SUBDATA) << 24;
     _gl_phys_addr &= 0xfff8000;
#ifdef DEBUG
     printf("MGR address obtained from POS sub-registers: 0x%lx\n",
          _gl_phys_addr);
#endif
    }
    else
    {
     /*
      *  Since it doesn't seem to know yet, it's only polite to tell the MGR
      *  where we think it is located in memory, so ... 
      */
     pos2sav = inp(POS_CARDENAB);
     addr_range = (pos2sav & 0x60) >> 5;
#ifdef DEBUG
     printf("Address range obtained from DMA blocksize field: %d\n",
         addr_range);
#endif
     _gl_phys_addr = MGR_ADDRESS + (0x8000L * addr_range);

     /*
      *  Clear out 2 bogus DMA blocksize bits (used for address range by
      *  "reference" program).  Then set the correct blocksize and the
      *  "card enable" bit.
      */
     pos2sav &= 0x9f;
     outp(POS_CARDENAB, pos2sav | DMA_BLKSZ_64 | CARD_ENABLE);

     /* read & write "channel check" POS reg to clear any previous error */
     posdata[0] = (unsigned char)inp(POS_CHANCHK);
     outp(POS_CHANCHK, posdata[0]);

     /* write top 17 bits of _gl_phys_addr to POS sub-registers 1 thru 3 */
     outp(POS_SUBADDR, POSSUB_CARDADR1);
     outp(POS_SUBDATA, (char)((_gl_phys_addr & 0x8000) >> 8));
     outp(POS_SUBADDR, POSSUB_CARDADR2);
     outp(POS_SUBDATA, (char)((_gl_phys_addr & 0xff0000) >> 16));
     outp(POS_SUBADDR, POSSUB_CARDADR3);
     outp(POS_SUBDATA, (char)((_gl_phys_addr & 0xf000000) >> 24));

     /*** now do remainder of POS reg setup ***/
     outp(POS_SUBADDR, POSSUB_CONFIG);

     outp(POS_SUBDATA, LITTLE_ENDIAN | NON_STREAMING | BUS_MASTER);

    }

     pos2sav = inp(POS_CARDENAB);
     _gl_ge_irq = (pos2sav & 0x1E) >> 1;     /* choose the IRQ line */
     if ( (_gl_ge_irq < 2) || (_gl_ge_irq == 7) ||
          (_gl_ge_irq == 8) || (_gl_ge_irq > 12)) {
        /* The valid interrupts are [2,3,4,5,6,9,10,11,12] */
        _gl_ErrorHandler(GLERR_SYSTEMERROR, WARNING, 
              "_gl_mca_init: Invalid interrupt vector");
           _gl_ge_irq = 0;      /* disable interrupt */
     }

    outp(POS_SLOTSELECT, 0); /* deselect slot (we're done with setup) */
    
    /*****************************************************/
    /* now let's set the MGR graphics page address (GRP) */
    /*****************************************************/
    /*
     *  This is the way to do it in real mode:
     *
     *    GRP = _gl_phys_addr >> 4;
     */

    win_grp_set(_gl_phys_addr);
} 
#endif /* MGR */


void far
_gl_gewait(void)
{
    long cnt = 0x900000;
    GRPsetup;

    while (CHAR_PTR(GFX_CTRL0_ADDR) & GFX_FIFOSTAT) { 
#ifdef DEBUG
	OutputDebugString("_gl_gewait: fifo half full\r\n"); 
#endif

#ifdef STINKY  /* We need to loop till finished PERIOD! */
	if (cnt-- < 0)  {
_asm int 1;
	    break;  /* this path means trouble */
	}
#endif
    }
    return; 
}
