/****************************************************************************\
*                                                                            *
* File : LG1 INCLUDE FILE                                                    *
*                                                                            *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Some Guy at SGI                                                      *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       06/09/93 Dwight Diercks -implemented it                              *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

typedef union {
    volatile float flt;
    volatile unsigned long word;
} fixed9_11;

typedef volatile unsigned long fixed12;

typedef union {
    volatile float flt;
    volatile unsigned long word;
} fixed12_11;

typedef union {
    volatile float flt;
    volatile unsigned long word;
} fixed12_11i;

typedef union {
    volatile float flt;
    volatile unsigned long word;
} fixed12_15;

typedef union {
    volatile float flt;
    volatile unsigned long word;
} DDAslope;

typedef struct rexregs {
    volatile unsigned long command;	/* instruction register	     0x0000 */
    volatile unsigned long aux1;	/* extra mode bits for GL    0x0004 */
    volatile unsigned long xstate;	/* remapping for X	     0x0008 */
    fixed12 xstarti;			/* integer xstart	     0x000C */
    fixed12_11 xstartf;			/* fixed point xstart	     0x0010 */
    fixed12_15 xstart;			/* full xstart		     0x0014 */
    fixed12_11i xendf;			/* float xend		     0x0018 */
    fixed12 ystarti;			/* integer ystart	     0x001C */
    fixed12_11 ystartf;			/* fixed point ystart	     0x0020 */
    fixed12_15 ystart;			/* full ystart		     0x0024 */
    fixed12_11i yendf;			/* float yend		     0x0028 */
    fixed12 xsave;			/* copy of xstart	     0x002C */
    DDAslope minorslope;		/* DDA slope for line drawing0x0030 */
    volatile unsigned long xymove;	/* x, y offset from xstart   0x0034 */
    volatile unsigned long colorredi;	/* integer part of red CI reg0x0038 */
    fixed9_11 colorredf;		/* full state of RGB red     0x003C */
    volatile unsigned long colorgreeni;	/* integer part of green reg 0x0040 */
    fixed9_11 colorgreenf;		/* full state of RGB green   0x0044 */
    volatile unsigned long colorbluei;	/* integer part of blue reg  0x0048 */
    fixed9_11 colorbluef;		/* full state of RGB blue    0x004C */
    DDAslope slopered;			/* DDA slope for CI or RGB   0x0050 */
    DDAslope slopegreen;		/* DDA slope for RGB shading 0x0054 */
    DDAslope slopeblue;			/* DDA slope for RGB shading 0x0058 */
    volatile unsigned long colorback;	/* background color	     0x005C */
    volatile unsigned long zpattern;	/* Z write enable mask	     0x0060 */
    volatile unsigned long lspattern;	/* line stipple pattern	     0x0064 */
    volatile unsigned long lsmode;	/* line stipple mode register0x0068 */
    volatile unsigned long aweight;	/* antialiasing weight values0x006C */
    volatile unsigned long rwaux1;	/* host r/w data register    0x0070 */
    volatile unsigned long rwaux2;	/* swizzled use of rwaux1    0x0074 */
    volatile unsigned long rwmask;	/* readmask#writemask	     0x0078 */
    volatile unsigned long smask1x;	/* screenmask1 right#left    0x007C */
    volatile unsigned long smask1y;	/* screenmask1 bottom#top    0x0080 */
    fixed12 xendi;			/* integer xend		     0x0084 */
    fixed12 yendi;			/* integer yend		     0x0088 */
    volatile unsigned long reserved;	/* reserved                  0x008C */
} Rexregs;

typedef struct configregs {
    volatile unsigned long smask2x;	/* screenmask2 right#left    0x4790 */
    volatile unsigned long smask2y;	/* screenmask2 bottom#top    0x4794 */
    volatile unsigned long smask3x;	/* screenmask3 right#left    0x4798 */
    volatile unsigned long smask3y;	/* screenmask3 bottom#top    0x479C */
    volatile unsigned long smask4x;	/* screenmask4 right#left    0x47A0 */
    volatile unsigned long smask4y;	/* screenmask4 bottom#top    0x47A4 */
    volatile unsigned long aux2;	/* additional mode bits	     0x47A8 */
    volatile unsigned long reserved;	/* reserved                  0x47AC */
    volatile unsigned long _pad0[10]; 	/* 0x47B0 - 0x47D4 */
    volatile unsigned long diagvram;	/* reg for VRAM write test   0x47D8 */
    volatile unsigned long diagcid;	/* reg for CID write test    0x47DC */
    volatile unsigned long _pad1; 	/* 			     0x47E0 */
    volatile unsigned long wclock;	/* NSCLOCK or REVREG	     0x47E4 */
    volatile unsigned long rwdac;	/* 8b addr/data for Bt479 I/O0x47E8 */
    volatile unsigned long configsel;	/* select DAC or VC1 function0x47EC */
    volatile unsigned long rwvc1;	/* 8b addr/data for VC1 I/O  0x47F0 */
    volatile unsigned long togglectxt;	/* context toggle	     0x47F4 */
    volatile unsigned long configmode;	/* REX system config/monitor 0x47F8 */
    volatile unsigned long xywin;	/* screen x, y, offset	     0x47FC */
} Configregs;

typedef struct rexchip {
		/* page 0 */    
	struct rexregs set;		/* 0x0000 */
	char _pad0LE[0x200-sizeof(struct rexregs)];
	struct rexregs setLE;		/* 0x200 */

	char _pad0[0x7fc-sizeof(struct rexregs)-0x200];
	volatile unsigned long int dummy; /* 0x7fc */
	struct rexregs go;		/* 0x0800 */
	char _pad1[0x0a00-0x800-sizeof(struct rexregs)];
	struct rexregs goLE;		/* 0x0a00 */

	char _pad1LE[0x1290-0xa00-sizeof(struct rexregs)];
	struct {
	    struct configregs setLE; 	/* 0x1290 */
	    char _pad2[0x1690-0x1290-sizeof(struct configregs)];
	    struct configregs set; 	/* 0x1690 */
	    char _pad3[0x1a90-0x1690-sizeof(struct configregs)];
	    struct configregs goLE; 	/* 0x1a90 */
	    char _pad4[0x1e90-0x1a90-sizeof(struct configregs)];
	    struct configregs go; 	/* 0x1e90 */
	} p1;
} REXCHIP;

typedef REXCHIP FAR *LPREXCHIP;


#define BIT(n)	(0x1L << n)

#define CHIPBUSY	BIT(0)
#define DFIFO		(0x1f00)
#define BFIFO		(0x1f000000)

//
//  command flags
//

#define BLOCK		BIT(3)
#define LENGTH32	BIT(4)
#define QUADMODE	BIT(5)
#define XMAJOR		BIT(6)
#define XYCONTINUE	BIT(7)
#define STOPONX		BIT(8)
#define STOPONY		BIT(9)
#define ENZPATTERN	BIT(10)
#define ENLSPATTERN	BIT(11)
#define LSADVLAST	BIT(12)
#define LSCONTINUE	BIT(13)
#define RGBMODECMD	BIT(14)
#define DITHER		BIT(15)
#define COLORCOMP	BIT(16)
#define SHADE		BIT(17)
#define INITFRAC	BIT(18)
#define LOGICSRC	BIT(19)
#define SHADECONTINUE	BIT(20)
#define COLORAUX	BIT(21)
#define LSOPAQUE	BIT(22)
#define ZOPAQUE		BIT(23)
#define ZCONTINUE	BIT(24)
#define LRQPOLY		BIT(25)

//
//  bits in xstate register
//

#define XSTATE_COLORAUX BIT(28)
#define XSTATE_LOGICSRC BIT(29)
#define XSTATE_LSOPAQUE BIT(30)
#define XSTATE_ZOPAQUE BIT(31)

//
//  rex opcodes
//

#define REX_NOP		0x0		/* 0x7 */
#define REX_DRAW	0x1
#define REX_LSPATSAVE	0x2		/* next <== working lspat regs	*/
#define REX_LDPIXEL	0x3		/* load pixels			*/
#define REX_ANTITOP	0x4		/* anti-alias line top		*/
#define REX_ANTIBOT	0x5		/* anti-alias line bot		*/
#define REX_ANTIAUX	0x6		/* anti-alias point		*/

//
// logicop masks
//

#define REX_LO_ZERO	(0x0L << 28)
#define REX_LO_AND	(0x1L << 28)
#define REX_LO_ANDR	(0x2L << 28)
#define REX_LO_SRC	(0x3L << 28)
#define REX_LO_ANDI	(0x4L << 28)
#define REX_LO_DST	(0x5L << 28)
#define REX_LO_XOR	(0x6L << 28)
#define REX_LO_OR	(0x7L << 28)
#define REX_LO_NOR	(0x8L << 28)
#define REX_LO_XNOR	(0x9L << 28)
#define REX_LO_NDST	(0xaL << 28)
#define REX_LO_ORR	(0xbL << 28)
#define REX_LO_NSRC	(0xcL << 28)
#define REX_LO_ORI	(0xdL << 28)
#define REX_LO_NAND	(0xeL << 28)
#define REX_LO_ONE	(0xfL << 28)

//
//  Auxilliary 1 flags		
//

#define FRACTION0	BIT(0)
#define FRACTION1	BIT(1)
#define DBLDST0		BIT(2)
#define DBLDST1		BIT(3)
#define DBLSRC		BIT(4)
#define DOUBLEBUF	BIT(5)
#define COLORCOMPLT	BIT(6)
#define COLORCOMPEQ	BIT(7)
#define COLORCOMPGT	BIT(8)
#define DITHERRANGE	BIT(9)

//
// Auxilliary 2 flags		
//

#define SMASK0	BIT(0)
#define SMASK1	BIT(1)
#define SMASK2	BIT(2)
#define SMASK3	BIT(3)

//
// smask polarity 
//

#define SMASK0_IN	BIT(4)
#define SMASK1_IN	BIT(5)
#define SMASK2_IN	BIT(6)
#define SMASK3_IN	BIT(7)

//
// cid range masks 
//

#define CIDMATCH1_BITS (0xfL << 8)
#define CIDMATCH2_BITS (0xfL << 12)
#define CIDMATCH3_BITS (0xfL << 16)
#define CIDMATCH4_BITS (0xfL << 20)


//
// Plane masks			
//

#define NOPLANES	(0x0L << 29)
#define PIXELPLANES	(0x1L << 29)
#define OVERLAYPLANES	(0x2L << 29)
#define CIDPLANES	(0x3L << 29)


//
//  VC1
//


#define VC1_VID_LINE_TBL_ADDR  0x0000
#define VC1_VID_FRAME_TBL_ADDR 0x0800
#define VC1_CURSOR_GLYPH_ADDR  0x0700
#define VC1_DID_LINE_TBL_ADDR  0x4800
#define VC1_DID_FRAME_TBL_ADDR 0x4000
#define VC1_CURSOR_ADDR        0x3000


//
// Host Command 
//


#define VC1_VID_TIMING	0x0
#define VC1_CURSOR_CTRL	0x0
#define VC1_DID_CTRL	0x0
#define VC1_XMAP_CTRL	0x0
#define VC1_XMAP_MODE	0x1
#define VC1_EXT_MEMORY	0x2
#define VC1_TEST_REGS	0x3
#define VC1_ADDR_LOW	0x4
#define VC1_ADDR_HIGH	0x5
#define VC1_SYS_CTRL	0x6

//
// Host Interface 
//

#define VC1_INTERRUPT		BIT(0)  /* active low */
#define VC1_VTG			BIT(1)	/* active low */
#define VC1_VC1			BIT(2)	/* active high */
#define VC1_DID			BIT(3)	/* active high */
#define VC1_CURSOR		BIT(4)	/* active high */
#define VC1_CURSOR_DISPLAY	BIT(5)	/* active high */
#define VC1_GENSYNC		BIT(6)	/* active high */
#define VC1_VIDEO		BIT(7)	/* active high */

//
// Video Timing Generator 
//

#define VID_EP		0x00
#define VID_LC		0x02
#define VID_SC		0x04
#define VID_TSA		0x06
#define VID_TSB		0x07
#define VID_TSC		0x08
#define VID_LP		0x09
#define VID_LS_EP	0x0b
#define VID_LR		0x0d
#define VID_FC		0x10
#define VID_ENABLE	0x14

//
// Cursor Generator 
//

#define CUR_EP		0x20
#define CUR_XL		0x22
#define CUR_YL		0x24
#define CUR_MODE   	0x26
#define CUR_BX		0x27
#define CUR_LY		0x28
#define CUR_YC		0x2a
#define CUR_XC		0x2c
#define CUR_CC		0x2e
#define CUR_RC		0x30

#define CUR_MODE_NORMAL    0x0
#define CUR_MODE_SPECIAL   0x1
#define CUR_MODE_CROSSHAIR 0x2

#define CURSOR_XOFF 140
#define CURSOR_YOFF 39

//
//  Display ID Generation 
//

#define DID_EP		0x40
#define DID_END_EP	0x42
#define DID_HOR_DIV	0x44
#define DID_HOR_MOD	0x45
#define DID_LP		0x46
#define DID_LS_EP	0x48
#define DID_WC		0x4a
#define DID_RC		0x4c
#define DID_XL		0x4e
#define DID_XD5		0x50
#define DID_XM5		0x51
#define DID_DID		0x52

//
// Control Register 
//

#define BLKOUT_EVEN	0x60
#define BLKOUT_ODD	0x61
#define AUXVIDEO_MAP	0x62

//
// Mode Register 
//


//
// Even XMAP 
//

#define MODE_REG_0_E	0x00
#define MODE_REG_1_E	0x02
#define MODE_REG_2_E	0x04
#define MODE_REG_3_E	0x06
#define MODE_REG_4_E	0x08
#define MODE_REG_5_E	0x0a
#define MODE_REG_6_E	0x0c
#define MODE_REG_7_E	0x0e
#define MODE_REG_8_E	0x10
#define MODE_REG_9_E	0x12
#define MODE_REG_A_E	0x14
#define MODE_REG_B_E	0x16
#define MODE_REG_C_E	0x18
#define MODE_REG_D_E	0x1a
#define MODE_REG_E_E	0x1c
#define MODE_REG_F_E	0x1e
#define MODE_REG_10_E	0x20
#define MODE_REG_11_E	0x22
#define MODE_REG_12_E	0x24
#define MODE_REG_13_E	0x26
#define MODE_REG_14_E	0x28
#define MODE_REG_15_E	0x2a
#define MODE_REG_16_E	0x2c
#define MODE_REG_17_E	0x2e
#define MODE_REG_18_E	0x30
#define MODE_REG_19_E	0x32
#define MODE_REG_1A_E	0x34
#define MODE_REG_1B_E	0x36
#define MODE_REG_1C_E	0x38
#define MODE_REG_1D_E	0x3a
#define MODE_REG_1E_E	0x3c
#define MODE_REG_1F_E	0x3e

//
//  Odd XMAP 
//

#define MODE_REG_0_O	0x40
#define MODE_REG_1_O	0x42
#define MODE_REG_2_O	0x44
#define MODE_REG_3_O	0x46
#define MODE_REG_4_O	0x48
#define MODE_REG_5_O	0x4a
#define MODE_REG_6_O	0x4c
#define MODE_REG_7_O	0x4e
#define MODE_REG_8_O	0x50
#define MODE_REG_9_O	0x52
#define MODE_REG_A_O	0x54
#define MODE_REG_B_O	0x56
#define MODE_REG_C_O	0x58
#define MODE_REG_D_O	0x5a
#define MODE_REG_E_O	0x5c
#define MODE_REG_F_O	0x5e
#define MODE_REG_10_O	0x60
#define MODE_REG_11_O	0x62
#define MODE_REG_12_O	0x64
#define MODE_REG_13_O	0x66
#define MODE_REG_14_O	0x68
#define MODE_REG_15_O	0x6a
#define MODE_REG_16_O	0x6c
#define MODE_REG_17_O	0x6e
#define MODE_REG_18_O	0x70
#define MODE_REG_19_O	0x72
#define MODE_REG_1A_O	0x74
#define MODE_REG_1B_O	0x76
#define MODE_REG_1C_O	0x78
#define MODE_REG_1D_O	0x7a
#define MODE_REG_1E_O	0x7c
#define MODE_REG_1F_O	0x7e

//
// Test Registers 
//

#define CRC_SYNDROME	0x00
#define CRC_CONTROL	0x03
#define RAMTEST		0x04
#define CHIP_REVISION	0x05

//
//   Values for RS0-RS2, host addressable registers on bt479
//

#define WRITE_ADDR		0
#define READ_ADDR		3
#define PALETTE_RAM		1
#define PIXEL_READ_MASK		2
#define OVERLAY_WRITE_ADDR	4
#define OVERLAY_READ_ADDR	7
#define OVERLAY			5
#define CONTROL			6

//
//  access modes for LUT1
//

#define LUT_WRITE_ADDR		0
#define LUT_READ_ADDR		3
#define LUT_DATA		1
#define LUT_COMMAND		6


//
// Dwight Added 
//

//
// OPCODE definitions
//

#define OC_NOOP     0x00
#define OC_DRAW     0x01
#define OC_LSPATSAVE 0x02
#define OC_LDPIXEL  0x03
#define OC_ANTITOP  0x04
#define OC_ANTIBOT  0x05
#define OC_ANTIAUX  0x06
#define OC_NOOP2    0x07

//
//LOGICOP definitions
//

#define LOGICOP(c)  ((unsigned long)(c) << 28)
#define LO_CLEAR    (0x00L << 28)
#define LO_AND      (0x01L << 28)
#define LO_ANDREVERSE (0x02L << 28)
#define LO_COPY     (0x03L << 28)
#define LO_ANDINVERT (0x04L << 28)
#define LO_NOOP     (0x05L << 28)
#define LO_XOR      (0x06L << 28)
#define LO_OR       (0x07L << 28)
#define LO_NOR      (0x08L << 28)
#define LO_EQ       (0x09L << 28)
#define LO_INVERT   (0x0AL << 28)
#define LO_ORREVERSE (0x0BL << 28)
#define LO_COPYINVERT (0x0CL << 28)
#define LO_ORINVERT (0x0DL << 28)
#define LO_NAND     (0x0EL << 28)
#define LO_SET      (0x0FL << 28)





//
// AUX2 Register field definitions
//

#define POLARITY(p)     (((unsigned long)(p) & 0x07) << 4)
#define CIDMATCH1(m)    (((unsigned long)(m) & 0x07) << 8)
#define CIDMATCH2(m)    (((unsigned long)(m) & 0x07) << 12)
#define CIDMATCH3(m)    (((unsigned long)(m) & 0x07) << 16)
#define CIDMATCH4(m)    (((unsigned long)(m) & 0x07) << 20)
#define CIDNEW(c)       (((unsigned long)(c) & 0x03) << 24)
#define CIDNEWMASK(m)   (((unsigned long)(m) & 0x03) << 26)
#define CIDUPDATE       0x10000000
#define PLANES_PIXEL    (0x01L << 29)
#define PLANES_OVERLAY  (0x02L << 29)
#define PLANES_CID      (0x03L << 29)

//
// STATE Register definitions
// These have already been defined so they are not redefined here...
//

//
// CONFIGMODE Register definitions
//

#define DFIFOFAIL       0x00000002
#define BFIFOFAIL       0x00000004
//#define ADDPLANES       0x00000008
#define VERSION(v)      (((unsigned long)(v) >> 4) & 0x0F)
#define DFIFOLEVEL(l)   (((unsigned long)(l) >> 8) & 0x1F)
#define DFIFOMAX(m)     (((unsigned long)(m) & 0x1F) << 13)
#define BFIFOMAX(m)     (((unsigned long)(m) & 0x1F) << 18)
#define BFIFOLEVEL(l)   (((unsigned long)(l) >> 24) & 0x1F)
#define WDMASTALL       0x40000000
#define FASTCLOCK       0x80000000




