/*
 * This header file defines the output format of a microcode file
 * for the GE4, GE5, PP and EP assemblers.
 */
/* $Revision: 1.1 $ */

typedef struct {
	short		f_magic;	/* magic number */
	short		f_version;	/* object file version */
	long		f_descoff;	/* file description offset */
	long		f_desclen;	/* description length */
	long		f_codeoff;	/* code offset */
	long		f_codelen;	/* code length */
	/*
	 * Further extensions should come after these fields.  The above
	 * initial format should never change, since version1 programs
	 * are not required to check the version number.
	 */
	long		f_constoff;	/* microcode constants offset */
	long		f_constlen;	/* microcode constants length */
	unsigned long	f_ucversion;	/* microcode version word */
} mcout_t;

/* microcode (ucode) file reader return values */
#define ABORTDOWNLD	 1		/* Ucode download unnecessary */
#define E_UCREAD	-1		/* Error: Misc. ucode file error */
#define E_UCMAGIC	-2		/* Error: Bad ucode file magic number 
					 * or unexpected object file version */

#define GE4_MAGIC	0x4538
#define PP_MAGIC	0x4539
#define EP_MAGIC	0x4540
#define GE5_MAGIC	0x4541

#define VERSION1	1
#define UNIX_VERSION	VERSION1
#define DOS_VERSION	2		/* after processing by uctodos,
					 * f_version is set to this */

char	*obj_rdata();
char	*obj_rdesc();

