/****************************************************************************\
*                                                                            *
* Function: Bitmap text support                                              *
*                                                                            *
*       Device text output routines to draw glyphs on the device.            *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       06/15/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1993 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "textout.h"

//
// Private variables shared with the assembly glyph blt routines.
//

DWORD     devpGlyphCmd;
LPRECT    devpGlyphClipRect;
WORD      devpGlyphClrFore;
WORD      devpGlyphClrBack;
GLYPHPROC devpGlyphFunc;

VOID PASCAL devDrawNopGlyphs(LPFONTINFO, LPGLYPHINFO, SHORT, SHORT, SHORT);
VOID PASCAL devDrawClipGlyphs(LPFONTINFO, LPGLYPHINFO, SHORT, SHORT, SHORT);
VOID PASCAL devDrawGlyphs(LPFONTINFO, LPGLYPHINFO, SHORT, SHORT, SHORT);
VOID PASCAL devpSetClipRect(LPRECT);
VOID PASCAL devpResetClipRect(VOID);
VOID PASCAL devpOpaqueRect(LPRECT, WORD);

WORD PASCAL devTextFunc
(
    LPRECT     lpClip,
    LPRECT     lpText,
    LPDRAWMODE lpDrawMode,
    WORD       Options
)
{
    WORD pfnGlyph;

    DBGMSG("devTextFunc\n\r");

    //
    // Assume no clipping.
    //

    pfnGlyph = (WORD)devDrawGlyphs;

    //
    // Determine if clipping is required.
    //

    if (ClipRect(lpText, lpClip, lpText))
    {
        if ((lpText->left >= lpText->right) || (lpText->top >= lpText->bottom))
        {
            //
            // Text is totally clipped.
            //

            return((WORD)devDrawNopGlyphs);
        }

        //
        // Save clip rectangle.
        //

        devpGlyphClipRect = lpClip;
        devpGlyphFunc     = (GLYPHPROC)pfnGlyph;
        pfnGlyph          = (WORD)devDrawClipGlyphs;
    }
    
    //
    // Draw opaque or not.
    //

    if (lpDrawMode->bkMode == OPAQUE)
    {
        devpOpaqueRect(lpText, (WORD)lpDrawMode->bkColor);
    }

    //
    // Save text colors.
    //

    devpGlyphClrFore = (WORD)lpDrawMode->TextColor;
    devpGlyphClrBack = (WORD)lpDrawMode->bkColor;
    return(pfnGlyph);
}

VOID PASCAL devDrawNopGlyphs
(
    LPFONTINFO  lpFontInfo,
    LPGLYPHINFO lpGlyphInfo,
    SHORT       xDst,
    SHORT       yDst,
    SHORT       count
)
{
    DBGMSG("devDrawNopGlyphs\n\r");
}

VOID PASCAL devDrawClipGlyphs
(
    LPFONTINFO  lpFontInfo,
    LPGLYPHINFO lpGlyphInfo,
    SHORT       xDst,
    SHORT       yDst,
    SHORT       count
)
{
    DBGMSG("devDrawClipGlyphs\n\r");

    devpSetClipRect(devpGlyphClipRect);
    (*devpGlyphFunc)(lpFontInfo, lpGlyphInfo, xDst, yDst, count);
    devpResetClipRect();
}
