        INCLUDE COMMON.INC
        INCLUDE IV2.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD
EXTERN  _devpStatus          : DWORD
EXTERN  _devXlateTbl         : BYTE
EXTERN  _devUpdateColorsTbl  : DWORD

public Rop2XlateTable	
Rop2XlateTable	label	byte

        db      00h     ;Rop2=1         DDx
        db      08h     ;Rop2=2         DPon
        db      04h     ;Rop2=3         DPna
        db      0ch     ;Rop2=4         Pn
        db      02h     ;Rop2=5         PDna
        db      0ah     ;Rop2=6         Dn
        db      06h     ;Rop2=7         DPx
        db      0eh     ;Rop2=8         DPan
        db      01h     ;Rop2=9         DPa
        db      09h     ;Rop2=10        DPxn
        db      05h     ;Rop2=11        D
        db      0dh     ;Rop2=12        DPno
        db      03h     ;Rop2=13        P
        db      0bh     ;Rop2=14        PDno
        db      07h     ;Rop2=15        DPo
        db      0fh     ;Rop2=16        DDxn


_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 32]
yDst            EQU [bp + 30]
lpSrcBits       EQU [bp + 26]
cSrcWidthBytes  EQU [bp + 24]
cSrcSegScan     EQU [bp + 22]
cSrcFillBytes   EQU [bp + 20]
xSrc            EQU [bp + 18]
ySrc            EQU [bp + 16]
xSize           EQU [bp + 14]
ySize           EQU [bp + 12]
clrBack         EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]

pSrcScan        EQU     [bp - 2]
cSrcScan        EQU     [bp - 4]
LocXlateTbl     EQU     [bp - 8]        ; DWORD LOCAL XLATE TBL
LocXlateTblSeg  EQU     [bp - 6]
LocXlateTblOff  EQU     [bp - 8]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltSD_Color  PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 36
        push    esi
        push    edi
        push    gs
        push    es
        push    ds
        mov     ax, ds
        mov     es, ax
        mov     gs, WORD PTR [_REX][2]
        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     bx,bx
        mov     bl,al
        shl     ebx,28                          ;ebx contains ROP code
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcSegScan, cSrcWidthBytes, cSrcScan, lpSrcBits + 2, lpSrcBits
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        add     si, xSrc
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pSrcScan, si
	mov	cx,ySize                ;get the y-extent as a loop counter
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
;
; At this point 
;       ds:si : Starting Pixel Bits
; 
        test    es:_devpStatus, PALETTETRANS
        jz      NoTranslate
;
; must do color translate code
;
        mov     LocXlateTblSeg, es
	lea     ax, es:_devXlateTbl
	mov	LocXlateTblOff, ax
        call    devBltSD_translate
        jmp     Exit


NoTranslate:

        mov     ax, xDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     eax, 0
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax, 0002000a9h
        or      eax, ebx                            ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
BltYLoop:
        mov     cx,xSize
        sub     cx, 64
        js      @F
BltXLoop64:
        mov     eax,dword ptr ds:[si]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][4]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][8]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][12]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][16]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][20]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][24]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][28]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][32]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][36]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][40]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][44]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][48]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][52]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][56]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][60]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        jz      YContinue
        add     si, 64
        sub     cx,64
        jae     BltXLoop64
@@:     add     cx, 32
        js      @F
BltXLoop32:
        mov     eax,dword ptr ds:[si]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][4]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][8]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][12]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][16]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][20]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][24]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax,dword ptr ds:[si][28]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        jz      YContinue
        add     si, 32
        sub     cx,32
        jae     BltXLoop32
@@:     add     cx, 28
        js      @F
BltXLoop4:
        mov     eax,dword ptr ds:[si]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        jz      YContinue
        add     si, 4
        sub     cx,4
        jae     BltXLoop4
;
; Guaranteed to have less than four pixels left here.
;
@@:     add     cx, 4
        mov     al, BYTE PTR ds:[si]
        cmp     cx, 2
        jl      BltXLast
        mov     ah, BYTE PTR ds:[si][1]
        cmp     cx, 3
        jl      BltXLast
        ror     eax, 8
        mov     ah, BYTE PTR ds:[si][2]
        rol     eax, 8
BltXLast:
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
YContinue:
        dec     WORD PTR ySize
        jz      Exit
;
; Increment to next scanline.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     BltYLoop
Exit:
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi

        leave
        ret     30

devBltSD_Color  ENDP



;
; devBltSD_translate
;
; on entry ds:si = start of bits
;          ebx = ROP
;          gs = REXPTR seg
;
devBltSD_translate  PROC


        mov     ax, xDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     eax, 0
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax, 000200089h
        or      eax, ebx                            ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax


        les     bx, LocXlateTbl
        xor     eax, eax

BltYLoopXlate:
        mov     cx,xSize
        sub     cx, 4
        js      @F
BltXLoop4Xlate:
        mov     edx,dword ptr ds:[si]
        mov     al,dl
        xlatb   es:[bx]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     al,dh
        xlatb   es:[bx]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        shr     edx,16
        mov     al,dl
        xlatb   es:[bx]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     al,dh
        xlatb   es:[bx]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        cmp     cx,0                                    ;
                                                        ; must get flags 
                                                        ; again because shr
                                                        ; destroyed above so
                                                        ; can't do jz here
                                                        ; without doing another
                                                        ; cmp
                                                        ;
        jz      YContinueXlate
        add     si, 4
        sub     cx,4
        jae     BltXLoop4Xlate
;
; Guaranteed to have less than four pixels left here.
;
@@:     add     cx, 4

@@:
        mov     al,byte ptr ds:[si]
        xlatb   es:[bx]
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        dec     cx
        jz      YContinueXlate
        inc     si
        jmp     @B

YContinueXlate:
        dec     WORD PTR ySize
        jz      ExitXlate
;
; Increment to next scanline.
;
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     BltYLoopXlate
ExitXlate:

        ret
devBltSD_translate  ENDP





devpUpdateColors PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 36
        push    esi
        push    edi
        push    gs
        push    es
        push    ds
        mov     ax, ds
        mov     es, ax
        mov     gs, WORD PTR [_REX][2]
        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     bx,bx
        mov     bl,al
        shl     ebx,28                          ;ebx contains ROP code
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        lds     si,lpSrcBits
        bmScanAddrInc cSrcSegScan, cSrcWidthBytes, cSrcScan, ds, si
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        add     si, xSrc
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pSrcScan, si
	mov	cx,ySize                ;get the y-extent as a loop counter
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
;
; Save translate table pointer.
;
        les     ax,es:_devUpdateColorsTbl
        mov     LocXlateTblSeg, es
	mov	LocXlateTblOff, ax
;
; At this point 
;       ds:si : Starting Pixel Bits
; 
        call    devBltSD_translate
Exit:
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi

        leave
        ret     30

devpUpdateColors        ENDP


_TEXT   ENDS

        END




