        INCLUDE COMMON.INC
        INCLUDE IV2.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD

EXTERN  Rop2XlateTable       : BYTE 


_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 36]
yDst            EQU [bp + 34]
lpSrcBits       EQU [bp + 30]
cSrcWidthBytes  EQU [bp + 28]
cSrcSegScan     EQU [bp + 26]
cSrcFillBytes   EQU [bp + 24]
xSrc            EQU [bp + 22]
ySrc            EQU [bp + 20]
xSize           EQU [bp + 18]
ySize           EQU [bp + 16]
clrFore         EQU [bp + 12]
colorBack       EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]

pSrcScan        EQU     [bp - 2]
cSrcScan        EQU     [bp - 4]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING


devBltSD_Mono   PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 40
        push    esi
        push    edi
        push    gs
        push    es
        push    ds
        mov     gs, WORD PTR [_REX][2]
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
;
; Set Clip Rectangle
;
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_SMASK0 + AUX2_SMASK0IN + AUX2_MATCH0 + AUX2_PXLPLANES
        mov     ax, xDst   
        add     ax, xSize                       ; Right Edge
        dec     ax
        shl     eax, 16
        mov     ax, xDst                        ; Left Edge
        mov     gs:REX_SET + REX_REGS.SMASK1X, eax
        mov     ax, yDst
        add     ax, ySize                       ; Bottom Edge
        dec     ax
        shl     eax, 16
        mov     ax, yDst                        ; Top Edge
        mov     gs:REX_SET + REX_REGS.SMASK1Y, eax
;
; Done Setting Clip
;
        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, fs:Rop2XlateTable
        xlatb
        xor     bx,bx
        mov     bl,al
        shl     ebx,28                          ;ebx contains ROP code
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, ySrc
        bmScanAddrInc cSrcSegScan, cSrcWidthBytes, cSrcScan, lpSrcBits + 2, lpSrcBits
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        mov     ax, xSrc                
        shr     ax, 3                           ; convert to bytes
        add     si, ax                          ; increment bit pointer to start
        mov     ax, xSrc
        and     ax, 07h
        add     xSize, ax
        sub     xDst, ax
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pSrcScan, si
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
        xor     edx, edx
        xor     eax, eax
        mov     eax, colorBack
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     eax, clrFore
        mov     gs:REX_SET + REX_REGS.CLRBACK, eax
;
; At this point 
;       cx : ySize
;       ds:si : Starting Pixel Bits
;
        mov     ax, xDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        xor     eax, eax
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax,  0008005b9h
        or      eax, ebx                                ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
BltYLoop:
        mov     cx,xSize
        sub     cx, 32
        js      @F
BltXLoop32:
        mov     eax,dword ptr ds:[si]
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        jz      YContinue
        add     si, 4
        sub     cx,32
        jae     BltXLoop32
;
; Guaranteed to have less than 32 pixels left here.
;
@@:     add     cx, 32
        cmp     cx, 24
        jle     @F
        sub     cx, cx                  ;Set Zero Flag
                                        ;and do one more DWORD
        jmp     BltXLoop32      
@@:     mov     al, BYTE PTR ds:[si]
        cmp     cx, 9
        jl      BltXLast
        mov     ah, BYTE PTR ds:[si][1]
        cmp     cx, 17
        jl      BltXLast
        ror     eax, 8
        mov     ah, BYTE PTR ds:[si][2]
        rol     eax, 8
BltXLast:
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
YContinue:
        dec     WORD PTR ySize
        jz      Exit
        mov     si, pSrcScan
        bmScanInc si, ds, cSrcSegScan, cSrcWidthBytes, WORD PTR cSrcScan, cSrcFillBytes
        mov     pSrcScan, si
        jmp     BltYLoop
Exit:
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
;
; Reset Clip plane
;
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_PXLPLANES
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     34

devBltSD_Mono   ENDP

_TEXT   ENDS

        END


