        INCLUDE COMMON.INC
        INCLUDE IV2.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;       07/02/93 Dave Schmenk - added pattern alignment                      ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD

EXTERN  Rop2XlateTable       : BYTE 


_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 16]
yDst            EQU [bp + 14]
lpPat           EQU [bp + 10]
xSize           EQU [bp + 8]
ySize           EQU [bp + 6]
rop             EQU [bp + 4]

xPat            EQU [bp - 2]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING


devBltPD_Color  PROC NEAR
        push    bp
        mov     bp, sp
        sub     sp, 4
        push    esi
        push    edi
        push    gs
        push    ds
        mov     gs, WORD PTR [_REX][2]
        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, Rop2XlateTable
        xlatb
        xor     bx, bx
        mov     bl, al
        shl     ebx, 28                         ;ebx contains ROP code
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        lds     si,lpPat
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
        mov     ax, xDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        xor     eax,eax
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax, 0002000a9h
        or      eax, ebx                                ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
        mov     di, xDst
        sub     di, [si][BRUSH_X]
        and     di, 7
        mov     xPat, di
        mov     di, yDst
        sub     di, [si][BRUSH_Y]
        and     di, 7
BltYLoop:
;
; Get current scanline of brush into ebx:esi (8 pixels worth).
; di = current pattern scanline.
;
        mov     si, di
        shl     si, 3
        add     si, lpPat
        add     si, BRUSH_COLOR
        mov     ebx, [si]
        mov     edx, [si + 4]
;
; Calculate which half of the brush is first to be drawn
;
        mov     cx, xPat 
        test    cx, 4
        jz      @F
        xchg    ebx, edx
        and     cx, 3
;
; Align second half of brush scanline in ebx:edx to destination.
;
@@:     test    cl, 2
        jz      @F
        xchg    bx, dx
        ror     ebx, 16
        ror     edx, 16
@@:     test    cl, 1
        jz      @F
        xchg    bl, dl
        ror     ebx, 8
        ror     edx, 8
@@:     mov     cx, xSize
        sub     cx, 32
        js      @F
PatLoop32:
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, ebx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, edx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, ebx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, edx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, ebx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, edx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, ebx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, edx
        jz      YContinue
        sub     cx,32
        jae     PatLoop32
@@:     add     cx, 24                          ; 24 = 32 - 8
        js      @F
PatLoop8:
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, ebx
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, edx
        jz      YContinue
        sub     cx, 8
        jae     PatLoop8
@@:     add     cx, 8
        mov     eax, ebx
        cmp     cx, 4
        jb      @F
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
        mov     eax, edx
        sub     cx, 4
@@:     jz      YContinue
        mov     gs:REX_GO_LE + REX_REGS.RWAUX1, eax
YContinue:
        inc     di                                      ;outer counter
	and	di, 7
        dec     WORD PTR ySize
        jnz     BltYLoop
Exit:
        pop     ds
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     14
devBltPD_Color  ENDP

_TEXT   ENDS

        END
