incDrawMode EQU 1                               ; Get definitions for OPAQUE & TRANSPARENT

        INCLUDE COMMON.INC
        INCLUDE IV2.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;       07/02/93 Dave Schmenk - added pattern alignment                      ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD

EXTERN  Rop2XlateTable       : BYTE 

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

xDst            EQU [bp + 26]
yDst            EQU [bp + 24]
lpPat           EQU [bp + 20]
xSize           EQU [bp + 18]
ySize           EQU [bp + 16]
colorFore       EQU [bp + 12]
colorBack       EQU [bp + 8]
modeback        EQU [bp + 6]
rop             EQU [bp + 4]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltPD_Mono   PROC NEAR
        push    bp
        mov     bp, sp
        push    esi
        push    edi
        push    gs
        push    es
        push    ds
        mov     gs, WORD PTR [_REX][2]
        mov     ax, rop                         ; rop is in al, ah reserved
        lea     bx, fs:Rop2XlateTable
        xlatb
        xor     bx, bx
        mov     bl, al
        shl     ebx, 28                         ;ebx contains ROP code
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        lds     si,lpPat
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
        mov     eax, colorFore
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     eax, colorBack
        mov     gs:REX_SET + REX_REGS.CLRBACK, eax
        mov     ax, xDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     eax, 0
        mov     gs:REX_GO  + REX_REGS.CMD, eax  ;NO-OP
        mov     eax,  0000005a9h
        cmp     WORD PTR modeback, OPAQUE
        jne     @F
        or      eax, CMD_ZOPAQUE                ; fill OPAQUE or TRANSPARENT
@@:     or      eax, ebx                        ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
        mov     bx, yDst                ; initialize bx for mod 8 counter
        sub     bx, [si][BRUSH_Y]
        and     bx, 7
        mov     cx, xDst
        sub     cx, [si][BRUSH_X]
        and     cx, 7
        add     si, BRUSH_PAT
BltYLoop:                               ;Only need Y loop cause xloop
                                        ;is repeatedly done by REX
        mov     al,[si][bx]
        rol     al, cl                  ;Align pattern horizontally
        mov     ah,al
        mov     dx,ax
        shl     eax,16                  ;replicate pattern
        mov     ax,dx                   ;to 32 bit value                
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        inc     bx
        and     bx,7
        dec     WORD PTR ySize
        jnz     BltYLoop
Exit:
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     24
devBltPD_Mono   ENDP

_TEXT   ENDS

        END

