        INCLUDE COMMON.INC
        INCLUDE IV2.INC
        INCLUDE BITBLT.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 bltter.                                                      ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/17/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD

EXTERN  _devpStatus          : DWORD
EXTERN  _devUnxlateTbl       : BYTE

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

lpDstBits       EQU [bp + 22]
cDstWidthBytes  EQU [bp + 20]
cDstSegScan     EQU [bp + 18]
cDstFillBytes   EQU [bp + 16]
xDst            EQU [bp + 14]
yDst            EQU [bp + 12]
xSrc            EQU [bp + 10]
ySrc            EQU [bp + 8]
xSize           EQU [bp + 6]
ySize           EQU [bp + 4]

pDstScan        EQU     [bp - 2]
cDstScan        EQU     [bp - 4]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devBltSD_ToColor PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 28
        push    esi
        push    edi
        push    gs
        push    es
        push    ds
        mov     ax, ds
        mov     es, ax
        mov     gs, WORD PTR [_REX][2]
;
; BLT from top to bottom.
; Get pointer to first source scanline.
;
        mov     ax, yDst
        lds     si,lpDstBits
        bmScanAddrInc cDstSegScan, cDstWidthBytes, cDstScan, ds, si
;
; now dx:ax equals start of Src
; and cSrcSegScan = current scans left in segment
;
        mov     ds, dx
        mov     si, ax
        add     si, xDst
;
; Initialize pointer to scanline BLT routine and preload register values.
;
;si = pSrcScan
;
        mov     pDstScan, si
	mov	cx,ySize                ;get the y-extent as a loop counter
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    ax, REX_BUSY
        jnz     @B
;
; At this point 
;       ds:si : Starting Pixel Bits
;

        test    es:_devpStatus, PALETTETRANS
        jz      NoTranslate
;
; must do color translate code
;
        call    devBltSD_Read_translate
        jmp     Exit

NoTranslate:

        mov     ax, xSrc
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, ySrc
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     eax, 0
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax, 00020008bh
        mov     gs:REX_GO + REX_REGS.CMD, eax
BltYLoop:
        mov     cx,xSize
BltXLoop:
        xor     eax,eax
        mov     eax,gs:REX_GO_LE + REX_REGS.RWAUX1
        mov     byte ptr ds:[si],al
        inc     si
        dec     cx
        jnz     BltXLoop
        dec     WORD PTR ySize
        jz      Exit
;
; Increment to next scanline.
;
        mov     si, pDstScan
        bmScanInc si, ds, cDstSegScan, cDstWidthBytes, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, si
        jmp     BltYLoop
Exit:
        pop     ds
        pop     es
        pop     gs
        pop     edi
        pop     esi
        leave
        ret     22

devBltSD_ToColor ENDP




;
; devBltSD_Read_translate  
;
; on entry ds:si = start of bits
;          gs = REXPTR seg
;          es = data seg
;
devBltSD_Read_translate  PROC

	lea	bx, es:_devUnxlateTbl

        mov     ax, xSrc
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, xSize
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, ySrc
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        add     ax, ySize
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     eax, 0
        mov     gs:REX_GO  + REX_REGS.CMD, eax      ;NO-OP
        mov     eax, 00020008bh
        mov     gs:REX_GO + REX_REGS.CMD, eax
BltYLoopXlate:
        mov     cx,xSize
BltXLoopXlate:
        xor     eax,eax
        mov     eax,gs:REX_GO_LE + REX_REGS.RWAUX1
        xlatb   es:[bx]
        mov     byte ptr ds:[si],al
        inc     si
        dec     cx
        jnz     BltXLoopXlate
        dec     WORD PTR ySize
        jz      ExitXlate
;
; Increment to next scanline.
;
        mov     si, pDstScan
        bmScanInc si, ds, cDstSegScan, cDstWidthBytes, WORD PTR cDstScan, cDstFillBytes
        mov     pDstScan, si
        jmp     BltYLoopXlate




ExitXlate:

        ret
devBltSD_Read_translate  ENDP

_TEXT   ENDS

        END


