.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV2.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and reset REX clipping registers.                            ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/20/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
           
.DATA

EXTERN _REX : DWORD

.CODE
.386

;
; Enable clip rectangle.
;

devpSetClipRect PROC NEAR USES ds gs si                 \
                        lpRect : DWORD

        mov     gs, WORD PTR [_REX][2]
        lds     si, lpRect
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_SMASK0 + AUX2_SMASK0IN + AUX2_MATCH0 + AUX2_PXLPLANES
        mov     ax, [si][4]                     ; rectRight
        dec     ax
        shl     eax, 16
        mov     ax, [si]                        ; rectLeft
        mov     gs:REX_SET + REX_REGS.SMASK1X, eax
        mov     ax, [si][6]                     ; rectBottom
        dec     ax
        shl     eax, 16
        mov     ax, [si][2]                     ; rectTop
        mov     gs:REX_SET + REX_REGS.SMASK1Y, eax
        ret

devpSetClipRect ENDP


;
; Disable clip rectangle.
;
devpResetClipRect PROC NEAR USES gs

        mov     gs, WORD PTR [_REX][2]
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_PXLPLANES
        ret  

devpResetClipRect ENDP

;
; Draw opaque rectangle for text.
;

devpOpaqueRect  PROC NEAR USES ds gs si                 \
                        lpRect : DWORD,                 \
                        clr    : WORD

        mov     gs, WORD PTR [_REX][2]
        lds     si, lpRect
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     ax, clr                         ; color
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     ax, [si]                        ; rectLeft
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        mov     ax, [si][4]                     ; rectRight
        dec     ax
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        mov     ax, [si][2]                     ; rectTop
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        mov     ax, [si][6]                     ; rectBottom
        dec     ax
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     DWORD PTR gs:REX_GO + REX_REGS.CMD, 030000000h + CMD_BLOCK + CMD_QUADMODE + CMD_STOPONX + CMD_STOPONY + CMD_DRAW
        ret
devpOpaqueRect  ENDP

        END


