.386
                INCLUDE WINDEFS.INC
                INCLUDE IV2.INC

_DATA	        SEGMENT WORD PUBLIC USE16 'DATA'


EXTERN  _REX                 : DWORD

EXTERN  _GlobCursXPos        : WORD
EXTERN  _GlobCursYPos        : WORD
EXTERN  _GlobCursXHotSpot    : WORD
EXTERN  _GlobCursYHotSpot    : WORD

_DATA	        ENDS
CONST	        SEGMENT WORD PUBLIC USE16 'CONST'
CONST	        ENDS
_BSS	        SEGMENT WORD PUBLIC USE16 'BSS'
_BSS	        ENDS
DGROUP	        GROUP CONST, _BSS, _DATA


loaddr          EQU [bp - 4]
hiaddr          EQU [bp - 8]
tmpdata         EQU [bp - 12]
valcfgsel       EQU [bp - 16]
tmpX            EQU [bp - 18]
tmpY            EQU [bp - 20]

_TEXT           SEGMENT WORD PUBLIC USE16 'CODE'

        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

;
; CheckCursor is called at timer interrupt time so its entrypoint is in 
; assembly. It is called as:
;
;       CheckCursor();
;

CHECKCURSOR     PROC FAR

;
; Since we assume a hardware cursor, this should be a NOOP.
;
        ret

CHECKCURSOR     ENDP

;
; MoveCursor is called at mouse interrupt time so its entrypoint is in 
; assembly. It is called as:
;
;       MoveCursor(wAbsX, wAbsY);
;

wAbsX   EQU     [bp + 8]
wAbsY   EQU     [bp + 6]


MOVECURSOR      PROC FAR
        push    bp
        mov     bp, sp
        sub     sp, 24
        push    gs
        push    ds
        push    dx
        push    eax
        push    ebx
        mov     ax, DGROUP
        mov     ds, ax
;
; Do MoveCursor processing.
;
        EnterCrit

        mov     gs, WORD PTR [_REX][2]
        mov     dx,0                                    ;dx = savetmp variable

        mov     ax,wAbsX
        mov     _GlobCursXPos,ax
        add     ax,X_MOUSE_OFFSET
        sub     ax,_GlobCursXHotSpot
        mov     tmpX,ax


        mov     ax,wAbsY
        mov     _GlobCursYPos,ax
        add     ax,Y_MOUSE_OFFSET
        sub     ax,_GlobCursYHotSpot
        mov     tmpY,ax

;
; Wait until FIFO idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    eax, FIFO_BUSY
        jnz     @B
;
; save configel
;
        mov     eax, gs:CFG_SET + CFG_REGS.CONFIGSEL
        mov     valcfgsel,eax

;
; read lo byte of address register 
;
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        
        mov     eax, gs:CFG_GO + CFG_REGS.RWVC1
        mov     eax, gs:CFG_SET + CFG_REGS.RWVC1
        mov     loaddr,eax
;
; write lo addr back to make sure hi is latched 
; if X wrote hi, but not yet lo, the vc1 hasn't actually updated hi 
;
        mov     eax, loaddr
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
;
; read hi byte of address register 
;
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax, gs:CFG_GO + CFG_REGS.RWVC1
        mov     eax, gs:CFG_SET + CFG_REGS.RWVC1
        mov     hiaddr, eax

        test    dword ptr loaddr,1
        jnz     NoSaveTmp
        mov     eax,valcfgsel
        cmp     eax,2
        jz      SaveTmp
        cmp     eax,1
        jz      SaveTmp
        jmp     NoSaveTmp
SaveTmp:
        mov     dx, 1
;
; write 0 to get us out of intermediate state 
;
        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
 
;   
; Set address to TMP_EVEN 
;
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
    
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,080h
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
    
        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
 
;   
; read even byte from TMP_EVEN 
;
        mov     eax, gs:CFG_GO + CFG_REGS.RWVC1
        mov     eax, gs:CFG_SET + CFG_REGS.RWVC1
        mov     tmpdata,eax

NoSaveTmp:


;
; Wait until FIFO idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    eax, FIFO_BUSY
        jnz     @B


;
; set cursor x and y 
;

;
; x
;        
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,022h
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax

        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

        xor     eax,eax
        mov     ax,tmpX
        mov     ebx,eax
        shr     eax,8
        and     ebx,0ffh
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1, ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1, ebx



;
; y
;        
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,024h
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax

        mov     eax,0
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

        xor     eax,eax
        mov     ax,tmpY
        mov     ebx,eax
        shr     eax,8
        and     ebx,0ffh
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1, ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1, ebx


;
; Wait until FIFO idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    eax, FIFO_BUSY
        jnz     @B


        cmp     dx, 1                           ; savetmp??
        jnz     RestoreAddr


;    
; restore addr to addr - 1 
;
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

        mov     eax,hiaddr
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,loaddr
        dec     eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax

;    
; restore configsel 
;
        mov     eax,valcfgsel
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
 
;   
; write even byte 
;
        mov     eax, tmpdata
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        jmp     GoodExit

RestoreAddr:
        mov     eax,5
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax

;
; restore addr to addr 
;
        mov     eax,hiaddr
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax
        mov     eax,loaddr
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
;
; restore configsel 
;
        mov     eax,valcfgsel
        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, eax


GoodExit:
;
; Wait until FIFO idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    eax, FIFO_BUSY
        jnz     @B

        LeaveCrit
    
        pop     ebx
        pop     eax
        pop     dx
        pop     ds
        pop     gs
        leave
        ret     4

MOVECURSOR      ENDP





lpCursorShape   EQU     [bp + 6]

SETCURSOR      PROC FAR
        push    bp
        mov     bp, sp
        sub     sp, 4
        push    si
        push    di
        push    gs
        push    es
        push    ds
        mov     ax, DGROUP
        mov     ds, ax
        mov     es, ax
        mov     gs, WORD PTR [_REX][2]

EnterCrit
;
; Call Disable Cursor(bx=0)
;
        mov     bx,0
        call    REXDISPLAYENABLECURSOR 
        cmp     dword ptr lpCursorShape,0
        jz      SetCursorExit

        lds     si,lpCursorShape
        mov     di,si
        add     di,sizeof cursorShape                   ;di points at cursor bits

        mov     eax,5
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax

        mov     eax,030h                                ;
                                                        ; upper 8 bits of 3000h
                                                        ;

        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax
        mov     eax,0                                   ;
                                                        ; lower 8 bits of 3000h
                                                        ;

        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     eax,2
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax

        mov     cx,[si + cursorShape.csHeight]
        cmp     cx,0
        jz      SetCursorExit
        xor     ebx,ebx
AndMaskLoop:
        mov     eax,[di]
        add     di,4
        not     eax
        
        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        dec     cx
        jnz     AndMaskLoop


        mov     cx,32
        sub     cx,[si + cursorShape.csHeight]

        jz      FinishedAndMask
        xor     eax,eax

FinishAndLoop:
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax

        dec     cx
        jnz     FinishAndLoop
FinishedAndMask:

        mov     cx,[si + cursorShape.csHeight]
        xor     ebx,ebx
DoXOrMask:

        mov     eax,[di]
        add     di,4
        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        shr     eax,8
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        mov     bl,al
        mov     gs:CFG_SET + CFG_REGS.RWVC1,ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1,ebx

        dec     cx
        jnz     DoXOrMask


        mov     cx,32
        sub     cx,[si + cursorShape.csHeight]
        jz      FinishedXORMask

        xor     eax,eax

FinishXORLoop:
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax

        dec     cx
        jnz     FinishXORLoop

FinishedXORMask:

        mov     ax,[si + cursorShape.csHotX]
        mov     bx,[si + cursorShape.csHotY]
        mov     es:_GlobCursXHotSpot,ax
        mov     es:_GlobCursYHotSpot,bx


        mov     eax,5
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax

        mov     eax,0h                                  ;
                                                        ; upper 8 bits of 0020h
                                                        ;

        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax
        mov     eax,4
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax
        mov     eax,20h                                 ;
                                                        ; lower 8 bits of 0020h
                                                        ;

        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     eax,0
        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, eax


        mov     eax,030h                                ;
                                                        ; upper 8 bits of 3000h
                                                        ;
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax

        mov     eax,00h                                 ;
                                                        ; lower 8 bits of 3000h
                                                        ;
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax



                                                        ;
        xor     eax, eax                                ; Set X
        mov     ax,es:_GlobCursXPos                     ;
        add     ax,X_MOUSE_OFFSET
        sub     ax,es:_GlobCursXHotSpot
        mov     ebx,eax
        shr     eax,8
        and     ebx,0ffh
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1, ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1, ebx



        xor     eax,eax                                 ; 
        mov     ax,es:_GlobCursYPos                     ; Set Y
        add     ax,Y_MOUSE_OFFSET                       ;
        sub     ax,es:_GlobCursYHotSpot

        mov     ebx,eax
        shr     eax,8
        and     ebx,0ffh
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax
        mov     gs:CFG_SET + CFG_REGS.RWVC1, ebx
        mov     gs:CFG_GO + CFG_REGS.RWVC1, ebx


        mov     eax,0c0h                                ;
                                                        ; upper 8 bits of c000h
                                                        ;
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax

        mov     eax,00h                                 ;
                                                        ; lower 8 bits of c000h
                                                        ;
        mov     gs:CFG_SET + CFG_REGS.RWVC1,eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1,eax



        mov     bx,1                                    ; 
                                                        ; enable cursor
                                                        ; 
        call    REXDISPLAYENABLECURSOR 

SetCursorExit:
LeaveCrit
        pop     ds
        pop     es
        pop     gs
        pop     di
        pop     si
        leave
        ret     4
SETCURSOR      ENDP


; RexDisplayEnableCursor
;
; bx = 1 enable
; bx = 0 disable
; gs = REX segment
;
REXDISPLAYENABLECURSOR          PROC NEAR

        mov     gs:CFG_GO + CFG_REGS.CONFIGSEL, VC1_SYS_CTRL
        mov     eax, gs:CFG_GO + CFG_REGS.RWVC1
        mov     eax, gs:CFG_SET + CFG_REGS.RWVC1

        xor     ecx,ecx
        mov     ecx,VC1_CURSOR_DISPLAY + VC1_CURSOR
        cmp     bx,1
        jz      EnableCurs                    
;
; Must Disable Cursor
;
        not     ecx
        and     eax,ecx

        jmp     SetCurs

EnableCurs:
        or      eax,ecx

SetCurs:

        mov     gs:CFG_SET + CFG_REGS.CONFIGSEL, VC1_SYS_CTRL
        mov     gs:CFG_SET + CFG_REGS.RWVC1, eax
        mov     gs:CFG_GO + CFG_REGS.RWVC1, eax

        ret

REXDISPLAYENABLECURSOR          ENDP

_TEXT           ENDS
                END

