/****************************************************************************\
*                                                                            *
* Function: Cursor entrypoints                                               *
*                                                                            *
*       Control cursor glyph.                                                *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "cursor.h"




#include "lg1hw.h"

#include "iv2.h"

VOID RexDisplayEnableCursor(USHORT);


SHORT   GlobCursXHotSpot=0;             //
SHORT   GlobCursYHotSpot=0;             //Initial Cursor Global Variables
SHORT   GlobCursXPos=MAX_X_SIZE/2;      //
SHORT   GlobCursYPos=MAX_Y_SIZE/2;

                            //
extern LPREXCHIP REX;       // Global Variable - Base pointer to IV2 Board
                            //




WORD WINAPI Inquire
(
    LPCURSORINFO lpCursorInfo
)
{
    DBGMSG("Inquire\n\r");

    lpCursorInfo->dpXRate = 1;
    lpCursorInfo->dpYRate = 2;

    return(4);
}

#ifdef STINKY

VOID WINAPI SetCursor
(
    LPCURSORSHAPE lpCursorShape
)
{

//    LPBYTE pulSrc;
    LPULONG pulSrc;
    int cyMask, nmaps;
    RexDisplayEnableCursor (FALSE);             //
                                                //disable cursor
                                                //

                                                //
    if (!(lpCursorShape))   {                   //Erased Cursor now leave
        return;                                 //
    }



    pulSrc = (LPULONG) lpCursorShape->csAndBits;

    DBGMSG("SetCursor\n\r");
    // Move masks into VC1 SRAM.
    //
    VC1_WRITE_ADDR(REX, 0x3000, 0x02);

    // Transfer scanlines of AND map
    //
	for (cyMask = 0; cyMask < lpCursorShape->csHeight;
		cyMask++, pulSrc++) {
	    // Transfer scanline of AND map.
	    //
	    VC1_WRITE8(REX, ~(*pulSrc >> 0));
	    VC1_WRITE8(REX, ~(*pulSrc >> 8));
	    VC1_WRITE8(REX, ~(*pulSrc >> 16));
	    VC1_WRITE8(REX, ~(*pulSrc >> 24));
	}
	
	while (cyMask++ < 32) {
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	}
    //
    // Transfer scanlines of XOR map
    //
   
	for (cyMask = 0; cyMask < lpCursorShape->csHeight;
		cyMask++, pulSrc++) {
	    VC1_WRITE8(REX, *pulSrc >> 0);
	    VC1_WRITE8(REX, *pulSrc >> 8);
	    VC1_WRITE8(REX, *pulSrc >> 16);
	    VC1_WRITE8(REX, *pulSrc >> 24);
	}
	
	while (cyMask++ < 32) {
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	    VC1_WRITE8(REX, 0);
	}

    GlobCursXHotSpot = lpCursorShape->csHotX;
    GlobCursYHotSpot = lpCursorShape->csHotY;

    VC1_WRITE_ADDR(REX, 0x20, 0);
    VC1_WRITE16(REX, 0x3000);
    VC1_WRITE_ADDR(REX, 0x26, 0);
    VC1_WRITE16(REX, 0xc000);

    RexDisplayEnableCursor (TRUE);              //
                                                //disable cursor
                                                //

}



static VOID
RexDisplayEnableCursor (
    USHORT EnableFlag
)
{
    unsigned long SysControlValue;

    REX->p1.go.configsel = VC1_SYS_CTRL;
    SysControlValue = REX_READ(&(REX->p1.go.rwvc1));
    SysControlValue = REX_READ(&(REX->p1.set.rwvc1));

    if (EnableFlag == TRUE) {
        SysControlValue |= (VC1_CURSOR_DISPLAY|VC1_CURSOR);
    }
    else
        SysControlValue &= ~(VC1_CURSOR_DISPLAY|VC1_CURSOR);

    REX->p1.set.configsel = VC1_SYS_CTRL;
    VC1_WRITE8(REX, SysControlValue);
}

#endif

#ifdef STINKY

VOID WINAPI MoveCursor
(
    WORD xPos,
    WORD yPos
)
{
    ULONG loaddr, hiaddr, tmpdata;
    ULONG configsel;
    ULONG savetmp = 0;

    //
    // Update h/w cursor X and Y location.
    //
    /* See if some user process has the vc1 in an intermediate
     * state, and if so, save it.
     *
     * The hi and lo bytes of the address register, and the configsel
     * register must always be saved and restored.
     *
     * If the address is odd then the vc1 is in an intermediate state,
     * the user process having only written one byte of a two byte value.
     * In this case we have to save TMP_EVEN, and restore the machine back
     * to this intermediate state when done updating the cursor.
     */

    GlobCursXPos = xPos + X_MOUSE_OFFSET - GlobCursXHotSpot;
    GlobCursYPos = yPos + Y_MOUSE_OFFSET - GlobCursYHotSpot;
    REX_WAIT(REX);
    
    /* save configsel */
    configsel = REX_READ(&(REX->p1.set.configsel));
    
    /* read lo byte of address register */
    REX_WRITE(&(REX->p1.set.configsel),4);
    loaddr = REX_READ(&(REX->p1.go.rwvc1));
    loaddr = REX_READ(&(REX->p1.set.rwvc1));
    
    /* write lo addr back to make sure hi is latched */
    /* if X wrote hi, but not yet lo, the vc1 hasn't actually updated hi */
    REX_WRITE(&(REX->p1.set.rwvc1),loaddr);
    REX_WRITE(&(REX->p1.go.rwvc1),loaddr);
    
    /* read hi byte of address register */
    REX_WRITE(&(REX->p1.set.configsel),5);
    hiaddr = REX_READ(&(REX->p1.go.rwvc1));
    hiaddr = REX_READ(&(REX->p1.set.rwvc1));
    
    /* XXX only do this for SRAM and MODE access.  Is this right? */
    if ( ( loaddr & 1 ) && ( ( configsel == 2 ) || ( configsel == 1 ) ) )
    	savetmp = 1;
    
    if ( savetmp )
    {
        DBGMSG("Saving VC1 state-move cursor\n\r");

    	/* write 0 to get us out of intermediate state */
    	REX_WRITE(&(REX->p1.set.rwvc1),0);
    	REX_WRITE(&(REX->p1.go.rwvc1),0);
    
    	/* Set address to TMP_EVEN */
    	REX_WRITE(&(REX->p1.set.configsel),5);
    	REX_WRITE(&(REX->p1.set.rwvc1),0);
    	REX_WRITE(&(REX->p1.go.rwvc1),0);
    
    	REX_WRITE(&(REX->p1.set.configsel),4);
    	REX_WRITE(&(REX->p1.set.rwvc1),0x80);
    	REX_WRITE(&(REX->p1.go.rwvc1),0x80);
    
    	REX_WRITE(&(REX->p1.set.configsel), 0);
    
    	/* read even byte from TMP_EVEN */
    	tmpdata = REX_READ(&(REX->p1.go.rwvc1));
    	tmpdata = REX_READ(&(REX->p1.set.rwvc1));
    }
    
    /* set cursor x and y */
    
    REX_WAIT(REX);
    			/* x */
    REX_WRITE(&(REX->p1.set.configsel),5);
    REX_WRITE(&(REX->p1.set.rwvc1), 0);
    REX_WRITE(&(REX->p1.go.rwvc1), 0);
    REX_WRITE(&(REX->p1.set.configsel), 4);
    REX_WRITE(&(REX->p1.set.rwvc1), 0x22);
    REX_WRITE(&(REX->p1.go.rwvc1), 0x22);
    
    REX_WRITE(&(REX->p1.set.configsel), 0);
    REX_WRITE(&(REX->p1.set.rwvc1),(GlobCursXPos>>8));
    REX_WRITE(&(REX->p1.go.rwvc1),(GlobCursXPos>>8));
    REX_WRITE(&(REX->p1.set.rwvc1),(GlobCursXPos & 0xff));
    REX_WRITE(&(REX->p1.go.rwvc1),(GlobCursXPos & 0xff));
    
    			/* y */
    REX_WRITE(&(REX->p1.set.configsel),5);
    REX_WRITE(&(REX->p1.set.rwvc1),0);
    REX_WRITE(&(REX->p1.go.rwvc1), 0);
    REX_WRITE(&(REX->p1.set.configsel), 4);
    REX_WRITE(&(REX->p1.set.rwvc1), 0x24);
    REX_WRITE(&(REX->p1.go.rwvc1), 0x24);
    
    REX_WRITE(&(REX->p1.set.configsel), 0);
    REX_WRITE(&(REX->p1.set.rwvc1), (GlobCursYPos>>8));
    REX_WRITE(&(REX->p1.go.rwvc1), (GlobCursYPos>>8));
    REX_WRITE(&(REX->p1.set.rwvc1), (GlobCursYPos & 0xff));
    REX_WRITE(&(REX->p1.go.rwvc1), (GlobCursYPos & 0xff));
    
    REX_WAIT(REX);
    
    if ( savetmp )
    {
    
    	/* restore addr to addr - 1 */
    	REX_WRITE(&(REX->p1.set.configsel),5);
    	REX_WRITE(&(REX->p1.set.rwvc1), hiaddr);
    	REX_WRITE(&(REX->p1.go.rwvc1), hiaddr);
    
    	REX_WRITE(&(REX->p1.set.configsel),4);
    	REX_WRITE(&(REX->p1.set.rwvc1), ( loaddr - 1 ));
    	REX_WRITE(&(REX->p1.go.rwvc1), ( loaddr - 1 ));
    
    	/* restore configsel */
    	REX_WRITE(&(REX->p1.set.configsel), configsel);
    
    	/* write even byte */
    	REX_WRITE(&(REX->p1.set.rwvc1), tmpdata);
    	REX_WRITE(&(REX->p1.go.rwvc1), tmpdata);
    }
    else
    {
    	/* restore addr to addr */
    	REX_WRITE(&(REX->p1.set.configsel),5);
    	REX_WRITE(&(REX->p1.set.rwvc1), hiaddr);
    	REX_WRITE(&(REX->p1.go.rwvc1),  hiaddr);
    
    	REX_WRITE(&(REX->p1.set.configsel),  4);
    	REX_WRITE(&(REX->p1.set.rwvc1), loaddr);
    	REX_WRITE(&(REX->p1.go.rwvc1),  loaddr);
    
    	/* restore configsel */
    	REX_WRITE(&(REX->p1.set.configsel), configsel);
    }
    
    REX_WAIT(REX);






}












#endif
