incFont EQU     1

        INCLUDE COMMON.INC
        INCLUDE IV2.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 glyph bltter.                                                ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/15/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

_DATA   SEGMENT WORD PUBLIC 'DATA'

EXTERN  _REX                 : DWORD
EXTERN  _devpGlyphCmd        : DWORD
EXTERN  _devpGlyphClrFore    : WORD
EXTERN  _devpGlyphClrBack    : WORD

devpDrawDoubleGlyph     DW      0,              devpGlyphBlt10, devpGlyphBlt20, 0
                        DW      devpGlyphBlt01, devpGlyphBlt11, devpGlyphBlt21, 0
                        DW      devpGlyphBlt02, devpGlyphBlt12, devpGlyphBlt22, 0

_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
DGROUP  GROUP   CONST, _BSS, _DATA

lpFontInfo      EQU [bp + 14]
lpGlyphInfo     EQU [bp + 10]
xDst            EQU [bp + 8]
yDst            EQU [bp + 6]
count           EQU [bp + 4]

GlyphHeight     EQU [bp - 6]
GlyphShiftCount EQU [bp - 8]

_TEXT   SEGMENT WORD PUBLIC 'CODE'
.386
        ASSUME  DS: DGROUP
        ASSUME  SS: NOTHING

devDrawGlyphs   PROC NEAR

        push    bp
        mov     bp, sp
        sub     sp, 20
        push    esi
        push    edi
        push    fs
        push    gs
        push    es
        push    ds
        mov     gs, WORD PTR [_REX][2]
        mov     ax, ds
        mov     es, ax
        lds     si, lpFontInfo
        lfs     bx, lpGlyphInfo
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
;
; Y coordinates don't change between characters.
;
        mov     ax, yDst
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        xor     edx, edx
        mov     dx, [si][FONTINFO.dfPixHeight]
        mov     GlyphHeight, edx
        add     ax, dx
        dec     ax
        mov     gs:REX_SET + REX_REGS.YENDI, eax
        mov     ax, es:_devpGlyphClrFore
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     ax, es:_devpGlyphClrBack
        mov     gs:REX_SET + REX_REGS.CLRBACK, eax
        mov     cx, count
        jmp     GlyphLoopEnter
GlyphLoop:
        mov     count, cx
GlyphLoopEnter:
        mov     si, fs:[bx][2]                  ; Get pointer to first glyph font data
        mov     dx, [si]                        ; Get glyph width
        mov     esi, [si][2]                    ; Get pointer to first glyph bits
        cmp     cx, 2                           ; Is only one glyph left to draw
        jl      DrawSingleGlyph
        cmp     dx, 16                          ; Is this a candidate for doubling
        ja      DrawSingleGlyph                 ; Too big, do one at a time
        mov     ax, fs:[bx][4]                  ; Is the spacing good
        sub     ax, fs:[bx]
        js      DrawSingleGlyph                 ; Can't do reverse spacing
        mov     cx, 16
        sub     cx, ax
        js      DrawSingleGlyph                 ; Too far apart
        mov     GlyphShiftCount, cl             ; Save shift count for later
        mov     di, fs:[bx][6]                  ; Get pointer to second glyph bits
        mov     cx, [di]                        ; Get glyph width
        mov     edi, [di][2]                    ; Get pointer to second glyph bits
        cmp     cx, 16
        ja      DrawAbortedDoubleGlyphs         ; Abort, second glyph too wide
        mov     ax, dx
        add     ax, cx
        or      ax, ax                          ; Total width is zero, skip
        jz      NextGlyphs                      ; to next glyphs
        mov     ax, fs:[bx]
        add     ax, xDst
        cmp     ax, 1024                        ; Are we off the right edge?
        jge     EarlyExit
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        mov     ax, fs:[bx][4]
        add     ax, xDst
        add     ax, cx
        dec     ax
        js      NextGlyphs                      ; Skip these glyphs if negative
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        xor     eax, eax
        mov     gs:REX_GO + REX_REGS.CMD, eax   ; Prepare to draw double
        mov     eax, es:_devpGlyphCmd           ; glyphs
        mov     gs:REX_SET + REX_REGS.CMD, eax
        add     dx, 7                           ; Calculate width in bytes
        shl     dx, 5                           ; ch = glyph1 width in bytes
        and     dh, 000000011b
        add     cx, 7
        shr     cl, 1
        and     cl, 000001100b
        push    bx                              ; Convert glyph width into
        mov     bl, dh                          ; index of routines to draw
        or      bl, cl                          ; the glyphs
        xor     bh, bh
        add     bx, bx
        mov     edx, GlyphHeight
        call    WORD PTR es:devpDrawDoubleGlyph[bx]
        pop     bx
NextGlyphs:
        add     bx, 8
        mov     cx, count
        sub     cx, 2
        jnz     GlyphLoop
        jmp     Exit
DrawAbortedDoubleGlyphs:
        push    cx                              ; Save glyph2 width
        or      dx, dx
        jz      @F                              ; Skip if zero width
        mov     ax, fs:[bx]
        add     ax, xDst
        add     bx, 4
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, dx
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        xor     eax, eax
        mov     gs:REX_GO + REX_REGS.CMD, eax
        mov     eax, es:_devpGlyphCmd
        mov     gs:REX_SET + REX_REGS.CMD, eax
        add     dx, 7                           ; Calculate width in bytes
        shl     dx, 5                           ; ch = glyph1 width in bytes
        and     dh, 000000011b
        push    bx                              ; Convert glyph width into
        mov     bl, dh                          ; index of routines to draw
        xor     bh, bh
        add     bx, bx
        mov     edx, GlyphHeight
        call    WORD PTR fs:devpDrawDoubleGlyph[bx]
        pop     bx
@@:     mov     esi, edi
        pop     dx
        dec     WORD PTR count                  ; Known that count > 1
DrawSingleGlyph:
        mov     ax, fs:[bx]
        add     ax, xDst
        cmp     ax, 1024                        ; Are we off the right edge?
        jge     EarlyExit
        add     bx, 4
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        add     ax, dx
        dec     ax
        mov     gs:REX_SET + REX_REGS.XENDI, eax
        xor     eax, eax
        mov     gs:REX_GO + REX_REGS.CMD, eax
        mov     eax, fs:_devpGlyphCmd
        mov     gs:REX_SET + REX_REGS.CMD, eax
        add     dx, 7                           ; Calculate width in bytes
        shr     dx, 3
        mov     ecx, GlyphHeight
        cmp     dx, 3
        ja      GlyphWideRow
        je      Glyph3ByteRow
        cmp     dx, 2
        je      Glyph2ByteRow
Glyph1ByteRow:
        cmp     cx, 4
        jl      @F
        mov     eax, [esi]
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        add     esi, 4
        sub     cx, 4
        jnz     Glyph1ByteRow
        mov     cx, count
        dec     cx
        jnz     GlyphLoop
        jmp     Exit
@@:     mov     al, [esi]
        inc     esi
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        dec     cx
        jnz     @B
        mov     cx, count
        dec     cx
        jnz     GlyphLoop
        jmp     Exit
Glyph2ByteRow:
        xor     eax, eax
        mov     edx, ecx
@@:     mov     al, [esi]
        mov     ah, [esi][edx]
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        inc     esi
        dec     cx
        jnz     @B
        mov     cx, count
        dec     cx
        jnz     GlyphLoop
        jmp     Exit
Glyph3ByteRow:
        xor     edx, edx
        mov     dx, cx
@@:     mov     ah, [esi]
        mov     al, [esi][edx]
        shl     eax, 16
        mov     ah, [esi][edx * 2]
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        inc     esi
        dec     cx
        jnz     @B
        mov     cx, count
        dec     cx
        jnz     GlyphLoop
        jmp     Exit
GlyphWideRow:
        push    esi
        push    dx
Loop4ByteRow:
        cmp     dx, 4
        jb      @F
        mov     ah, [esi]
        add     esi, GlyphHeight
        mov     al, [esi]
        add     esi, GlyphHeight
        shl     eax, 16
        mov     ah, [esi]
        add     esi, GlyphHeight
        mov     al, [esi]
        add     esi, GlyphHeight
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        sub     dx, 4
        jnz     Loop4ByteRow
        jmp     NextWideRow
@@:     cmp     dx, 3
        jl      @F
        mov     ah, [esi]
        add     esi, GlyphHeight
        mov     al, [esi]
        add     esi, GlyphHeight
        shl     eax, 16
        mov     ah, [esi]
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        jmp     NextWideRow
@@:     cmp     dx, 2
        jl      @F
        mov     ah, [esi]
        add     esi, GlyphHeight
        mov     al, [esi]
        shl     eax, 16
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        jmp     NextWideRow
@@:     mov     ah, [esi]
        shl     eax, 16
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
NextWideRow:
        pop     dx
        pop     esi
        inc     esi
        dec     cx
        jnz     GlyphWideRow
        mov     cx, count
        dec     cx
        jnz     GlyphLoop
        jmp     Exit
EarlyExit:
        mov     bx, count
        add     bx, bx
Exit:
        mov     ax, fs:[bx]
        pop     ds
        pop     es
        pop     gs
        pop     fs
        pop     edi
        pop     esi

        leave
        ret     14

devDrawGlyphs   ENDP

;
; On entry to the glyph blt routines:
;   esi = pointer to glyph1 bits
;   edi = pointer to glyph2 bits
;   edx = glyph height
;

;
; Glyph1 is 1 byte wide, glyph2 is 0 bytes wide.
;
devpGlyphBlt10  PROC
ScanLoop:
        cmp     dx, 4
        jl      @F
        mov     eax, [esi]
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        shr     eax, 8
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        add     esi, 4
        sub     dx, 4
        jnz     ScanLoop
        ret
@@:     mov     al, [esi]
        inc     esi
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        dec     dx
        jnz     ScanLoop
        ret
devpGlyphBlt10  ENDP

;
; Glyph1 is 2 bytes wide, glyph2 is 0 bytes wide.
;
devpGlyphBlt20  PROC
        xor     eax, eax
        mov     cx, dx
ScanLoop:
        mov     al, [esi]
        mov     ah, [esi][edx]
        inc     esi
        mov     gs:REX_GO_LE + REX_REGS.ZPATTERN, eax
        dec     cx
        jnz     ScanLoop
        ret
devpGlyphBlt20  ENDP

;
; Glyph1 is 0 bytes wide, glyph2 is 1 byte wide.
;
devpGlyphBlt01  PROC
        mov     cl, GlyphShiftCount
ScanLoop:
        xor     eax, eax
        mov     ah, [edi]
        inc     edi
        shl     eax, cl
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     dx
        jnz     ScanLoop
        ret
devpGlyphBlt01  ENDP

;
; Glyph1 is 1 byte wide, glyph2 is 1 byte wide.
;
devpGlyphBlt11  PROC
        mov     cl, GlyphShiftCount
ScanLoop:
        xor     al, al
        xor     ebx, ebx
        mov     ah, [esi]
        inc     esi
        shl     eax, 16
        mov     bh, [edi]
        inc     edi
        shl     ebx, cl
        or      eax, ebx
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     dx
        jnz     ScanLoop
        ret

devpGlyphBlt11  ENDP

;
; Glyph1 is 2 bytes wide, glyph2 is 1 byte wide. Glyph cannot be taller than
; 255 scanlines.  Hopefully this isn't a problem.
;
devpGlyphBlt21  PROC
        or      dh, dh
        jnz     Break
        mov     cl, GlyphShiftCount
        mov     ch, dl
ScanLoop:
        xor     ebx, ebx
        mov     ah, [esi]
        mov     al, [esi][edx]
        inc     esi
        shl     eax, 16
        mov     bh, [edi]
        inc     edi
        shl     ebx, cl
        or      eax, ebx
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     ch
        jnz     ScanLoop
        ret
Break:  int 3
        ret
devpGlyphBlt21  ENDP

;
; Glyph1 is 0 bytes wide, glyph2 is 2 bytes wide. Glyph cannot be taller than
; 255 scanlines.  Hopefully this isn't a problem.
;
devpGlyphBlt02  PROC
        mov     cl, GlyphShiftCount
ScanLoop:
        xor     eax, eax
        mov     ah, [edi]
        mov     al, [edi][edx]
        inc     edi
        shl     eax, cl
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     dx
        jnz     ScanLoop
        ret
devpGlyphBlt02  ENDP

;
; Glyph1 is 1 byte wide, glyph2 is 2 bytes wide. Glyph cannot be taller than
; 255 scanlines.  Hopefully this isn't a problem.
;
devpGlyphBlt12  PROC
        or      dh, dh
        jnz     Break
        mov     cl, GlyphShiftCount
        mov     ch, dl
ScanLoop:
        xor     al, al
        xor     ebx, ebx
        mov     ah, [esi]
        inc     esi
        shl     eax, 16
        mov     bh, [edi]
        mov     bl, [edi][edx]
        inc     edi
        shl     ebx, cl
        or      eax, ebx
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     ch
        jnz     ScanLoop
        ret
Break:  int 3
        ret
devpGlyphBlt12  ENDP

;
; Glyph1 is 2 bytes wide, glyph2 is 2 bytes wide. Glyph cannot be taller than
; 255 scanlines.  Hopefully this isn't a problem.
;
devpGlyphBlt22  PROC
        or      dh, dh
        jnz     Break
        mov     cl, GlyphShiftCount
        mov     ch, dl
ScanLoop:
        xor     ebx, ebx
        mov     ah, [esi]
        mov     al, [esi][edx]
        inc     esi
        shl     eax, 16
        mov     bh, [edi]
        mov     bl, [edi][edx]
        inc     edi
        shl     ebx, cl
        or      eax, ebx
        mov     gs:REX_GO + REX_REGS.ZPATTERN, eax
        dec     ch
        jnz     ScanLoop
        ret
Break:  int 3
        ret
devpGlyphBlt22  ENDP

_TEXT   ENDS

        END
