/****************************************************************************\
*                                                                            *
* Function: Device initialization entrypoints                                *
*                                                                            *
*       Initialize device specific fields in the GDIINFO and DEVICE          *
*       structures.  Init and uninit graphics hardware.                      *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/19/93 Dave Schmenk - wrote it.                                    *
*       06/09/93 Dwight Diercks - Added IV2 Init stuff                       *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/


#include "common.h"

#include "lg1hw.h"
#include "iv2.h"

//
//External function references
//

WORD PASCAL devpMapFramebuffer(VOID);
VOID devpProgramICD2062x6410(VOID);
VOID devpDisplayInitLUT(LPREXCHIP,ULONG);
VOID devpDisplayLoadSRAM(LPREXCHIP,PUCHAR,USHORT,USHORT);
VOID devpDisplayLoadSRAMConstant(LPREXCHIP,UCHAR,UCHAR,UCHAR,UCHAR,USHORT,USHORT);

VOID PASCAL SetMultiResSetting(VOID);

VOID devpColor(DWORD );
VOID devpBlock(DWORD, DWORD , DWORD ,DWORD ,DWORD );

VOID WINAPI SetPalette(WORD,WORD,LPRGBQUAD);

VOID hook_int_2fh(VOID);


//
//Global Variables
//

                        //
LPREXCHIP REX;         // Global Variable - Base pointer to IV2 Board
                        //

unsigned int RexDriverInitialized=0;
//
// External Variables 
//

extern DWORD devSystemPalette[];
extern DWORD devPalette[];
extern BYTE  devXlateTbl[];
extern BYTE  devUnxlateTbl[];
extern devpStatus;


#ifdef IV2REVB



int IV2Probe(unsigned);
unsigned int IV2GlobCtrlVal;
unsigned int IV2GlobModeVal;

unsigned int IV2GlobPort;


#endif


                        //
#include "vc1vars.h"    //Contains VC1 Timing Tables Variables
                        //       



#ifdef DEBUGINIT

VOID test_routine(VOID);
#endif


WORD PASCAL devEnableHW
(
    VOID
)
{
    WORD ii,i;

    DBGMSG("devEnableHW\n\r");

    REX = MK_FP(devpMapFramebuffer(), 0 );

#ifdef IV2REVB

    /*
     *  Probe for a good port address (amoung the 4 possible addresses)
     *  so we can read the NVRAM.  Pick one of the 4 possible addresses
     *  (IOADDR0) as an arbitrary starting point.
     */
    if ( (IV2GlobPort = IV2Probe(IOADDR3) ) == -1 ) {
    	return(0);                  //
                                    //Error cannot find board
                                    //

    }
    IV2GlobCtrlVal = CFGENABLE | HIVGA;
    outp(IV2GlobPort,IV2GlobCtrlVal); //Enable config bits

    outp(IV2GlobPort+2, 0);     //
    outp(IV2GlobPort+3, 3);     //This contains the address
                            //of the board currently at a constant of 
                            //03000000h from our VDD
                            //

    IV2GlobModeVal = SWRESET;
    outp(IV2GlobPort+1,IV2GlobModeVal); //disable swreset

#else

    UNRESETREX(IV2_MODEREG_3);

    WRITECONFIGREG(IV2_CONFIGREG_3,0x03);
#endif


    REX_WAIT(REX);

    //
    // set up 1024x768, 60Hz refresh, 64.000 MHz dot clk 
    //

    devpProgramICD2062x6410();

    //
    // Set origin to upper left of screen
    //

    REX_WRITE((&(REX->p1.set.xywin)), 0x00000000);

    //
    // Set max FIFO depths (disables FIFO INTs) and set VC1 clock for 1024
    //

    REX_WRITE(&(REX->p1.set.configmode),BFIFOMAX(0x04) | DFIFOMAX(0x04) | FASTCLOCK);

    //
    // Bits for GL are set to 0 for Windows
    //

    REX_WRITE(&(REX->set.aux1),0); 
   
    REX_WRITE(&(REX->set.rwmask),0xff); 
    REX_WRITE(&(REX->go.command),OC_NOOP);

    REX_WAIT(REX);

    // Clear overlay planes
    //
    REX_WRITE(&(REX->p1.set.aux2 ), PLANES_OVERLAY) ; 
    devpColor(0);

    devpBlock(0,0,1023,767,REX_LO_SRC);

    REX_WAIT(REX);      

    //
    // Clear Pixel Planes
    //

    REX_WRITE(&(REX->set.aux1 ),0);

    REX_WAIT(REX);


    REX_WRITE(&(REX->p1.set.aux2),PLANES_PIXEL); 
    devpColor(0);

    devpBlock(0,0,1023,767,REX_LO_SRC);


    REX_WAIT(REX);


    //
    // Set background color to 1, foreground to 0
    // Set background color to 1, foreground to 0
    //

    REX_WRITE(&(REX->set.xstate ), 0x83ff0100); 



    REX_WAIT(REX);

    //
    // Initialize the DAC chips: Bt479 for LG1, LUT for LG2
    //

    devpDisplayInitLUT (REX, 0); /* no sync on green */
    REX_WAIT(REX);

    // Initialize the VC1 by loading all the timing and display tables into
    // external SRAM.
    //
    // Disable VC1 function.
    //

    REX_WRITE(&(REX->p1.go.configsel), 0x06); 
    VC1_WRITE8(REX, 0x03);

    //
    // Load video timing generator table
    //

    devpDisplayLoadSRAM(REX, vtgLineTable,  VC1_VID_LINE_TBL_ADDR,  sizeof(vtgLineTable));
    devpDisplayLoadSRAM(REX, vtgFrameTable, VC1_VID_FRAME_TBL_ADDR, sizeof(vtgFrameTable));

    //
    // Write VC1 VID_EP, VID_ENCODE(0x1D) register
    //

    VC1_WRITE_ADDR(REX, 0x00, 0x00);
    VC1_WRITE16(REX, (VC1_VID_FRAME_TBL_ADDR) | 0x8000);
    VC1_WRITE_ADDR(REX, 0x14, 0x00);
    VC1_WRITE16(REX, 0x1d00);

    devpDisplayLoadSRAMConstant(REX, 0x48, 0x00, 0x48, 0x40, VC1_DID_FRAME_TBL_ADDR, 767*2);
    devpDisplayLoadSRAM(REX, didLineTable,  VC1_DID_LINE_TBL_ADDR,  sizeof(didLineTable));

    //
    // Write VC1 WIDs
    //

    VC1_WRITE_ADDR(REX, 0x40, 0x00);
    VC1_WRITE16(REX, 0x4000);
    VC1_WRITE16(REX, 0x4600);
    VC1_WRITE8(REX, 1024/5);
    VC1_WRITE8(REX, 1024%5);
    VC1_WRITE_ADDR(REX, 0x60, 0x00);
    VC1_WRITE8(REX, 0x01);
    VC1_WRITE8(REX, 0x01);

    //
    // Write VC1 DID mode registers
    //

    VC1_WRITE_ADDR(REX, 0x00, 0x01);
    for (i = 0; i < 0x80; i += 2) {
         VC1_WRITE16(REX, 0x0000);  //Don't enable AUX planes
                                    //or turn on Double buff
    }

    if (!RexDriverInitialized) {
        //
        // Load NULL cursor
        //

        devpDisplayLoadSRAMConstant(REX, 0x00, 0x00, 0x00, 0x00, VC1_CURSOR_ADDR, 254);

        VC1_WRITE_ADDR(REX, 0x20, 0x00);
        VC1_WRITE16(REX, VC1_CURSOR_ADDR);
        VC1_WRITE16(REX, 0x0240);
        VC1_WRITE16(REX, 0x0240);

        //
        // Set cursor XMAP 3, submap 0, mode = normal.
        //

        VC1_WRITE16(REX, 0xC000);
    }
    //
    // Enable VC1 function
    //

    REX_WRITE(&(REX->p1.go.configsel), 0x06); 
    VC1_WRITE8(REX, 0xbc); /* pass 0xbc for sys control for now */

    if (!RexDriverInitialized) {

        //
        // Load up device palette.
        //
                   
        for (ii = 0; ii < 10; ii++)
        {
            devPalette[ii] = devSystemPalette[ii] & 0x00FFFFFFL;
            devPalette[ii + 246] = devSystemPalette[ii + 10] & 0x00FFFFFFL;
        }
        for (ii = 10; ii < 246; ii++)
            devPalette[ii] = 0;

        SetPalette(0,10,(LPRGBQUAD)&devPalette[0]);
        SetPalette(246,10,(LPRGBQUAD)&devPalette[246]);

        //
        // Set identity for palette translation tables.
        //

        for (ii = 0; ii < 256; ii++)
        {
            devXlateTbl[ii]   = (BYTE)ii;
            devUnxlateTbl[ii] = (BYTE)ii;
        }

    }
    else {

        SetPalette(0,256,(LPRGBQUAD)&devPalette[0]);
    
    }
#ifdef DEBUGINIT
    test_routine();
#endif
    hook_int_2fh();


    RexDriverInitialized = 1;

    //
    // Indicate success.
    //

    return(TRUE);
}



WORD FAR PASCAL devEnableHWFAR
(
    VOID
)
{

    return(devEnableHW());


}





#define MAXFNAMELEN             64

VOID PASCAL SetMultiResSetting
(
VOID
)
{
    char    RetString[MAXFNAMELEN];

    GetPrivateProfileString( "iv2.DRV", "ResourceSize",
                             "ResourceSize",(LPSTR)RetString, 
                             MAXFNAMELEN, "SYSTEM.INI" );
    switch (*RetString) {

        case 's'    :
            devpStatus |= MULTIRES_96DPI;
            break;
        case 'l'    :
        default     :
            break;
    }


}


#ifdef DEBUGINIT

VOID test_routine()
{
    WORD i;


   for (i=0; i<10; i++) {
	devpColor(i);
	devpBlock(40+i*40,100,  80+i*40,700,REX_LO_SRC);
   }


   for (i=246; i<256; i++) {
	devpColor(i);
	devpBlock(40+(10+(i-246))*40,100,  80+(10+(i-246))*40,700,REX_LO_SRC);
   }

}

#endif

VOID PASCAL devDisableHW
(
    VOID
)
{
    DBGMSG("devDisableHW\n\r");

    IV2GlobCtrlVal &= ~HIVGA;
    outp(IV2GlobPort,IV2GlobCtrlVal); //Enable config bits

}

VOID FAR PASCAL devDisableHWFAR
(
    VOID
)
{
    devDisableHW();

}

VOID PASCAL devGdiInfo
(
    GDIINFO * pGdiInfo
)
{
    DBGMSG("devGdiInfo\n\r");


    pGdiInfo->dpHorzSize      = 280;
    pGdiInfo->dpVertSize      = 210;
    pGdiInfo->dpHorzRes       = 1024;
    pGdiInfo->dpVertRes       = 768;
    pGdiInfo->dpBitsPixel     = 8;
    pGdiInfo->dpNumPalReg     = 256;
    pGdiInfo->dpNumColors     = 20;
    pGdiInfo->dpPalReserved   = 20;
    pGdiInfo->dpNumPens       = 20;
    pGdiInfo->dpRaster       |= RC_PALETTE;
    pGdiInfo->dpMLoWin.xcoord = 2800;
    pGdiInfo->dpMLoWin.ycoord = 2100;
    pGdiInfo->dpMLoVpt.xcoord = 1024;
    pGdiInfo->dpMLoVpt.ycoord = -768;
    pGdiInfo->dpMHiWin.xcoord = 28000;
    pGdiInfo->dpMHiWin.ycoord = 21000;
    pGdiInfo->dpMHiVpt.xcoord = 1024;
    pGdiInfo->dpMHiVpt.ycoord = -768;
    pGdiInfo->dpELoWin.xcoord = 4375;
    pGdiInfo->dpELoWin.ycoord = 4375;
    pGdiInfo->dpELoVpt.xcoord = 4064;
    pGdiInfo->dpELoVpt.ycoord = -4064;
    pGdiInfo->dpEHiWin.xcoord = 21875;
    pGdiInfo->dpEHiWin.ycoord = 21875;
    pGdiInfo->dpEHiVpt.xcoord = 2032;
    pGdiInfo->dpEHiVpt.ycoord = -2032;
    pGdiInfo->dpTwpWin.xcoord = 7875;
    pGdiInfo->dpTwpWin.ycoord = 7875;
    pGdiInfo->dpTwpVpt.xcoord = 508;
    pGdiInfo->dpTwpVpt.ycoord = -508;
    if (devpStatus & MULTIRES_96DPI)
    {
        pGdiInfo->dpLogPixelsX    = 96;
        pGdiInfo->dpLogPixelsY    = 96;
    }
    else
    {
        pGdiInfo->dpLogPixelsX    = 120;
        pGdiInfo->dpLogPixelsY    = 120;
    }
}

VOID PASCAL devDevInfo
(
    LPDEVICE lpDev
)
{
    DBGMSG("devDevInfo\n\r");

    lpDev->devType       = 0x6900;
    lpDev->devWidth      = 1024;
    lpDev->devHeight     = 768;
    lpDev->devWidthBytes = 0x69;
    lpDev->devBitsPixel  = 8;
    lpDev->devPlanes     = 1;
}




















