/****************************************************************************\
*                                                                            *
* File : IV2 INCLUDE FILE                                                    *
*                                                                            *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dwight Diercks                                                       *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       06/09/93 Dwight Diercks -wrote it                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

//
// REX diagnostic code header file.  
//

//
// IV2 Config Regs   
//

#ifdef IV2REVB
#define IOADDR0	0x53C
#define IOADDR1	0xE8C
#define IOADDR2	0xF4C
#define IOADDR3	0x610
#define NUMOFPORTADDRS	4

#else

#define IV2_CONFIGREG_0    0x150
#define IV2_CONFIGREG_1    0x3e0
#define IV2_CONFIGREG_2    0xf48
#define IV2_CONFIGREG_3    0x608



//
// IV2 Mode Regs //
//

#define IV2_MODEREG_0      IV2_CONFIGREG_0+1
#define IV2_MODEREG_1      IV2_CONFIGREG_1+1
#define IV2_MODEREG_2      IV2_CONFIGREG_2+1
#define IV2_MODEREG_3      IV2_CONFIGREG_3+1


//
// IV2 Vert Retrace Ints 
//

#define IV2_VERT_RETRACE_0    7
#define IV2_VERT_RETRACE_1    9
#define IV2_VERT_RETRACE_2    10
#define IV2_VERT_RETRACE_3    11
#define IV2_VERT_RETRACE_4    99


//
// REX Memory Maps 
//

#define REX_MEMORY_MAP_0      0xc800L
#define REX_MEMORY_MAP_1      0xcc00L
#define REX_MEMORY_MAP_2      0xd000L
#define REX_MEMORY_MAP_3      0xd400L
#define REX_MEMORY_MAP_4      0xd800L
#define REX_MEMORY_MAP_5      0xdc00L
#define REX_MEMORY_MAP_6      0xe000L
#define REX_MEMORY_MAP_7      0xe400L



#endif      // IV2REVB

//
// REX Memory Map Address Bits 
//

#define REX_16BIT_ACCESSBIT   0x0100
#define REX_LITTLE_ENDIAN     0x0200
#define REX_GO_ADDRESS        0x0400


//
// REX SMASK AND CONFIG REGISTERS 
//

#define REX_SMASK_REG         0x1000





#define BITP(n) (0x1L << n)



//
// DEVPSTATUS bits
//

#define PALETTETRANS    BITP(0)
#define MULTIRES_96DPI  BITP(1)

//
// IV2 Constants 
//

#ifdef IV2REVB


//
// control val bits
//
#define CFGENABLE   BITP(0)
#define ICDCLK      BITP(2)
#define EEPROMCK    BITP(3)
#define EEPROMCS    BITP(4)
#define ICDDATA     BITP(5)
#define HIVGA       BITP(6)



//
// mode(control+1) val bits
//
#define SWRESET     BITP(0)
#define FIFODIAGBIT BITP(1)
#define DOUBLEB8    BITP(2)
#define INTSEL0     BITP(3)
#define INTSEL1     BITP(4)
#define VSEFBA      BITP(5)

#else

#define ICDDATA   2
#define ICDCLK    3




#define WRITECONFIGREG(port,value) outp(port,value)  
#define UNRESETREX(port) outp(port,0x1)

#endif      //IV2REVB


#define MAX_X_SIZE      1024
#define MAX_Y_SIZE      768

//
// IV2 Macros 
//


//
//Mouse Constants
//
#define X_MOUSE_OFFSET  140
#define Y_MOUSE_OFFSET  39

extern VOID far PASCAL LongWrite32(volatile long far *,volatile unsigned long);
extern DWORD far PASCAL LongRead32(volatile long far *);

#define REX_WRITE(pr,val)    LongWrite32(pr,val)

#define REX_READ(pr)    LongRead32(pr)


#ifdef IV2REVB



#else

#define  WCLOCK_WRITE(pr,addr,val)           \
    REX_WRITE(&((pr)->p1.set.configsel),addr);       \
    REX_WRITE(&((pr)->p1.set.wclock),val);           \
    REX_WRITE(&((pr)->p1.go.wclock),val);             

#define  WCLOCK_READ(pr,addr,val)           \
    REX_WRITE(&((pr)->p1.set.configsel),addr);      \
    val = REX_READ(&((pr)->p1.go.wclock));           \
    val = REX_READ(&((pr)->p1.set.wclock))
#endif // IV2REVB


#define MK_FP(seg, off) ((VOID _far *)( ((unsigned long)(seg) << 16) | (off) ))


#define REX_WAIT(pr)    while (REX_READ(&(((pr)->p1.set.configmode))) & CHIPBUSY)

#define DAC_WRITE(pr, addr, data)                                           \
                        REX_WRITE(&((pr)->p1.set.configsel), addr);  \
                        REX_WRITE(&((pr)->p1.set.rwdac),data);      \
                        REX_WRITE(&((pr)->p1.go.rwdac), data)        




#define VC1_WRITE8(pr, data)                                                \
    REX_WRITE(&((pr)->p1.set.rwvc1),data);       \
    REX_WRITE(&((pr)->p1.go.rwvc1),data);       

//
// Write word value to VC1
//

#define VC1_WRITE16(pr, data)                                               \
                        VC1_WRITE8(pr, ((data) >> 8) & 0xFF);               \
                        VC1_WRITE8(pr, (data) & 0xFF)

//
// Set address for writes to VC1
//

#define VC1_WRITE_ADDR(pr, addr, cmd)                                       \
                        REX_WRITE(&((pr)->p1.go.configsel),5);      \
                        VC1_WRITE8(pr, ((addr) >> 8) & 0xFF);               \
                        REX_WRITE(&((pr)->p1.go.configsel),4);      \
                        VC1_WRITE8(pr, (addr) & 0xFF);                      \
                        REX_WRITE(&((pr)->p1.go.configsel),cmd)

