;----------------------------------------------------------------------------;
;                                                                            ;
; Function: IV2 hardware defintions.                                         ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/15/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

;
; REX register structure.
;

REX_REGS        STRUC
    CMD         DWORD   ?
    AUX1        DWORD   ?
    XSTATE      DWORD   ?
    XSTARTI     DWORD   ?
    XSTARTF     DWORD   ?
    XSTART      DWORD   ?
    ENDF        DWORD   ?
    YSTARTI     DWORD   ?
    YSTARTF     DWORD   ?
    YSTART      DWORD   ?
    YENDF       DWORD   ?
    XSAVE       DWORD   ?
    MINORSLOPE  DWORD   ?
    XYMOVE      DWORD   ?
    CLRREDI     DWORD   ?
    CLRREDF     DWORD   ?
    CLRGREENI   DWORD   ?
    CLRGREENF   DWORD   ?
    CLRBLUEI    DWORD   ?
    CLRBLUEF    DWORD   ?
    SLOPERED    DWORD   ?
    SLOPEGREEN  DWORD   ?
    SLOPEBLUE   DWORD   ?
    CLRBACK     DWORD   ?
    ZPATTERN    DWORD   ?
    LSPATTERN   DWORD   ?
    LSMODE      DWORD   ?
    AWEIGHT     DWORD   ?
    RWAUX1      DWORD   ?
    RWAUX2      DWORD   ?
    RWMASK      DWORD   ?
    SMASK1X     DWORD   ?
    SMASK1Y     DWORD   ?
    XENDI       DWORD   ?
    YENDI       DWORD   ?
REX_REGS        ENDS

CFG_REGS        STRUCT
    SMASK2X     DWORD   ?
    SMASK2Y     DWORD   ?
    SMASK3X     DWORD   ?
    SMASM3Y     DWORD   ?
    SMASK4X     DWORD   ?
    SMASK4Y     DWORD   ?
    AUX2        DWORD   ?
    RESERVED0   DWORD   ?
    RESERVED1   DWORD   ?
    RESERVED2   DWORD   ?
    RESERVED3   DWORD   ?
    RESERVED4   DWORD   ?
    RESERVED5   DWORD   ?
    RESERVED6   DWORD   ?
    RESERVED7   DWORD   ?
    RESERVED8   DWORD   ?
    RESERVED9   DWORD   ?
    RESERVED10  DWORD   ?
    DIAGVRAM    DWORD   ?
    DIAGCID     DWORD   ?
    RESERVED11  DWORD   ?
    WCLOCK      DWORD   ?
    RWDAC       DWORD   ?
    CONFIGSEL   DWORD   ?
    RWVC1       DWORD   ?
    TOGGLECTXT  DWORD   ?
    CONFIGMODE  DWORD   ?
    XYWIN       DWORD   ?
CFG_REGS        ENDS

REX_SET         EQU 00000h
REX_GO          EQU 00800h
CFG_SET         EQU 01690h
CFG_GO          EQU 01e90h


; Little Endian Defines
;
REX_SET_LE      EQU 00200h             
REX_GO_LE       EQU 00a00h
CFG_SET_LE      EQU 01290h
CFG_GO_LE       EQU 01a90h


; Mouse defines
X_MOUSE_OFFSET  EQU 140
Y_MOUSE_OFFSET  EQU 39


; VC1 Defines


VC1_VID_LINE_TBL_ADDR  EQU 00000h
VC1_VID_FRAME_TBL_ADDR EQU 00800h
VC1_CURSOR_GLYPH_ADDR  EQU 00700h
VC1_DID_LINE_TBL_ADDR  EQU 04800h
VC1_DID_FRAME_TBL_ADDR EQU 04000h
VC1_CURSOR_ADDR        EQU 03000h


;
; Host Command 
;


VC1_VID_TIMING	EQU 00h
VC1_CURSOR_CTRL	EQU 00h
VC1_DID_CTRL	     EQU 00h
VC1_XMAP_CTRL	     EQU 00h
VC1_XMAP_MODE      EQU 01h
VC1_EXT_MEMORY     EQU 02h
VC1_TEST_REGS      EQU 03h
VC1_ADDR_LOW       EQU 04h
VC1_ADDR_HIGH      EQU 05h
VC1_SYS_CTRL       EQU 06h



; Command flags.
;

CMD_BLOCK       EQU 00000000000000000000000000001000b
CMD_LENGHT32    EQU 00000000000000000000000000010000b
CMD_QUADMODE    EQU 00000000000000000000000000100000b
CMD_XMAJOR      EQU 00000000000000000000000001000000b
CMD_XYCONTINUE  EQU 00000000000000000000000010000000b
CMD_STOPONX     EQU 00000000000000000000000100000000b
CMD_STOPONY     EQU 00000000000000000000001000000000b
CMD_ENZPATTERN  EQU 00000000000000000000010000000000b
CMD_ENLSPATTERN EQU 00000000000000000000100000000000b
CMD_LSADVLAST   EQU 00000000000000000001000000000000b
CMD_LSCONTINE   EQU 00000000000000000010000000000000b
CMD_RGBMODE     EQU 00000000000000000100000000000000b
CMD_ENDITHER    EQU 00000000000000001000000000000000b
CMD_COLORCOMP   EQU 00000000000000010000000000000000b
CMD_SHADE       EQU 00000000000000100000000000000000b
CMD_INITFRAC    EQU 00000000000001000000000000000000b
CMD_LOGICSRC    EQU 00000000000010000000000000000000b
CMD_SHADECONT   EQU 00000000000100000000000000000000b
CMD_COLORAUX    EQU 00000000001000000000000000000000b
CMD_LSOPAQUE    EQU 00000000010000000000000000000000b
CMD_ZOPAQUE     EQU 00000000100000000000000000000000b
CMD_ZCONTINUE   EQU 00000001000000000000000000000000b
CMD_LRQPOLY     EQU 00000010000000000000000000000000b

;
; Command opcodes.
;

CMD_NOP         EQU 00000h
CMD_DRAW        EQU 00001h
CMD_LSPATSAVE   EQU 00002h
CMD_LDPIXEL     EQU 00003h
CMD_ANTITOP     EQU 00004h
CMD_ANTIBOT     EQU 00005h
CMD_ANTIAUX     EQU 00006h

;
; Aux1 flags.
;

AUX1_FRAC0      EQU 0000000000000001b
AUX1_FRAC1      EQU 0000000000000010b
AUX1_DBLDST0    EQU 0000000000000100b
AUX1_DBLDST1    EQU 0000000000001000b
AUX1_DBLSRC     EQU 0000000000010000b
AUX1_DOUBLEBUF  EQU 0000000000100000b
AUX1_CLRCOMPLT  EQU 0000000001000000b
AUX1_CLRCOMPEQ  EQU 0000000010000000b
AUX1_CLRCOMPGT  EQU 0000000100000000b
AUX1_CLRCOMPGE  EQU 0000001000000000b
AUX1_DITHRANGE  EQU 0000010000000000b

;
; Aux2 flags.
;

AUX2_SMASK0     EQU 000000000000000000000000000000001b
AUX2_SMASK1     EQU 000000000000000000000000000000010b
AUX2_SMASK2     EQU 000000000000000000000000000000100b
AUX2_SMASK3     EQU 000000000000000000000000000001000b
AUX2_SMASK0IN   EQU 000000000000000000000000000010000b
AUX2_SMASK1IN   EQU 000000000000000000000000000100000b
AUX2_SMASK2IN   EQU 000000000000000000000000001000000b
AUX2_SMASK3IN   EQU 000000000000000000000000010000000b
AUX2_MATCH0     EQU 000000000000000000000111100000000b
AUX2_MATCH1     EQU 000000000000000001111000000000000b
AUX2_MATCH2     EQU 000000000000011110000000000000000b
AUX2_MATCH3     EQU 000000000111100000000000000000000b
AUX2_NOPLANES   EQU 000000000000000000000000000000000b
AUX2_PXLPLANES  EQU 000100000000000000000000000000000b
AUX2_OLPLANES   EQU 001000000000000000000000000000000b
AUX2_CIDPLANES  EQU 001100000000000000000000000000000b

;
; ConfigMode flags.
;

REX_BUSY        EQU 000000001b
FIFO_BUSY       EQU 01f000000h



;
; Host Interface 
;

VC1_INTERRUPT      EQU  000000000000000000000000000000000b ;
                                                           ; active low 
                                                           ;
VC1_VTG            EQU  000000000000000000000000000000001b ; 
                                                           ; active low 
                                                           ;
VC1_VC1            EQU  000000000000000000000000000000010b ;
                                                           ; active high 
                                                           ;
VC1_DID            EQU  000000000000000000000000000000100b ;
                                                           ; active high 
                                                           ;
VC1_CURSOR         EQU  000000000000000000000000000001000b ;
                                                           ; active high 
                                                           ;
VC1_CURSOR_DISPLAY EQU  000000000000000000000000000010000b ;
                                                           ; active high 
                                                           ;
VC1_GENSYNC        EQU  000000000000000000000000000100000b ;
                                                           ; active high 
                                                           ;
VC1_VIDEO          EQU  000000000000000000000000001000000b ;
                                                           ; active high 
                                                           ;

;
; Cursor generator.
;

CUR_EP          EQU 00020h
CUR_XL          EQU 00022h
CUR_YL          EQU 00024h
CUR_MODE        EQU 00026h
CUR_BX          EQU 00027h
CUR_LY          EQU 00028h
CUR_YC          EQU 0002Ah
CUR_XC          EQU 0002Ch
CUR_CC          EQU 0002Eh
CUR_RC          EQU 00030h
CUR_MODE_NORMAL EQU 00000h
CUR_MODE_SPECL  EQU 00001h
CUR_MODE_XHAIR  EQU 00002h
CUR_XOFFSET     EQU 140
CUR_YOFFSET     EQU 39



;
; DEVPSTATUS bits
;

PALETTETRANS    EQU     000000000000000000000000000000001b
MULTIRES_96DPI  EQU     000000000000000000000000000000010b

;
; Structure used for parsing sysini commands
;

SYSINI	STRUC
    SYSINI_CMPSTR	DW	0
    SYSINI_CMPLEN	DW	0
    SYSINI_RETVAL	DW	0
SYSINI	ENDS


