/****************************************************************************\
*                                                                            *
* File : IV2 General Hardware routines                                       *
*                                                                            *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dwight Diercks                                                       *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       06/09/93 Dwight Diercks -implemented it                              *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"


#include "lg1hw.h"

#include "iv2.h"

                            //
extern LPREXCHIP REX;       // Global Variable - Base pointer to IV2 Board
                            //



#ifdef IV2REVB

void IV2Enable(unsigned);
void IV2Disable(unsigned);

int IV2Probe(unsigned);
extern unsigned int IV2GlobCtrlVal;
extern unsigned int IV2GlobModeVal;

extern unsigned int IV2GlobPort;








/*
 *  Test to see if the suggested port address is a good one.  If it
 *  is, then return that address.  If it is not, find a port that is
 *  good and return that address.
 */
int
IV2Probe(unsigned SuggestedPort)
{
    unsigned portaddr;
    int portnum;
    int ioport[NUMOFPORTADDRS] = { IOADDR0, IOADDR1, IOADDR2, IOADDR3 };


    // Disable whatever port we're currently using
    for (portnum=0; portnum<NUMOFPORTADDRS; portnum++)
    	IV2Disable(ioport[portnum]);

    // Unused port should return 0xFF
    if (inp(SuggestedPort + 1) == 0xFF) {
        
	    // Try enabling IV2 at suggested port address
	    IV2Enable(SuggestedPort);

	    // Look for IV2 signature
	    switch (SuggestedPort) {
	        case IOADDR0:
		    if ( (inp(SuggestedPort + 1) & 0x0F) == 0x09 ) {
		        return SuggestedPort;
		    }
		    break;
	        case IOADDR1:
		    if ( (inp(SuggestedPort + 1) & 0x0F) == 0x09 ) {
		        return SuggestedPort;
		    }
		    break;
	        case IOADDR2:
		    if ( (inp(SuggestedPort + 1) & 0x0F) == 0x09 ) {
		        return SuggestedPort;
		    }
		    break;
	        case IOADDR3:
		    if ( (inp(SuggestedPort + 1) & 0x0F) == 0x09 ) {
		        return SuggestedPort;
		    }
		    break;
	    }
    }

    /*
     *  Suggested address doesn't look so good, so look through all
     *  other possible port addresses.
     */
    for (portnum=0; portnum < NUMOFPORTADDRS; portnum++) {
    	portaddr = ioport[portnum];

	    // skip over the port addr that we already checked
	    if (portaddr != SuggestedPort) {

	        // Unused port should return 0xFF
	        if (inp(portaddr + 1) == 0xFF) {

		    // Try enabling IV2 at suggested port address
		    IV2Enable(portaddr);

		    // Look for IV2 signature
		    switch (portaddr) {
		        case IOADDR0:
			    if ( (inp(portaddr + 1) & 0x0F) == 0x09 ) {
			        return portaddr;
			    }
			    break;
		        case IOADDR1:
			    if ( (inp(portaddr + 1) & 0x0F) == 0x09 ) {
			        return portaddr;
			    }
			    break;
		        case IOADDR2:
			    if ( (inp(portaddr + 1) & 0x0F) == 0x09 ) {
			        return portaddr;
			    }
			    break;
		        case IOADDR3:
			    if ( (inp(portaddr + 1) & 0x0F) == 0x09 ) {
			        return portaddr;
			    }
			    break;
		    }

		    //  If we got this far we need to disable this port (just
		    //  in case) and move on.
		    IV2Disable(portaddr);
	        }
	    }
    }

    return -1;
}


void
IV2Enable(unsigned PortAddr)
{
    outp(PortAddr, CFGENABLE);
}


void
IV2Disable(unsigned PortAddr)
{
    // Look for IV2 signature
    switch (PortAddr) {
	case IOADDR0:
        if ( (inp(PortAddr + 1) & 0x0F) == 0x09 ) {
            outp(PortAddr, 0);
	    }
	    break;
	case IOADDR1:
	    if ( (inp(PortAddr + 1) & 0x0F) == 0x09 ) {
            outp(PortAddr, 0);
	    }
	    break;
	case IOADDR2:
	    if ( (inp(PortAddr + 1) & 0x0F) == 0x09 ) {
            outp(PortAddr, 0);
	    }
	    break;
	case IOADDR3:
	    if ( (inp(PortAddr + 1) & 0x0F) == 0x09 ) {
            outp(PortAddr, 0);
	    }
	    break;
    }
}

//#define SLOW 1


//
// ProgramICD2062(vclk, mclk)
// program the ICD2062 programmable clock chip to
// vclk, mclk (in MHz)= 64 and 10 respectively
//
// set up 1024x768, 60Hz refresh, 64.000 MHz dot clk 
// SGI Indigo monitor 
//
VOID devpProgramICD2062x6410
(
)
{
    int k;
    unsigned long data, I, P, Q, j;
    volatile unsigned long junk;

#if SLOW
    I = 3;

    P = 53;
    Q = 23;
#else
    I = 7;

    P = 95;
    Q = 34;

#endif

    data = (Q-2) | ((P-3) << 10) | (I << 17) | 
        	(unsigned long)(3 << 21) | (unsigned long)(1 << 7);

    //
	// OK. now perform the serial programming trick 
	// first do the unlock sequence 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
	
    for (k=0; k < 10; k++)
    {
                                                        //
        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     // toggle
                                                        // clock with data = 1 

                                                        //
        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK);    // toggle
                                                        // clock with data = 1 
                                                        //
    }
    //
    // unlock 
    //
                                                  //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
                                                  //


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
	// unlock 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 


    //
	// unlock 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
	// now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {
        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }			
        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }			
        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     
        data = data >> 1;
    }
    //
    // stop bit 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
	// select clock 0 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0

    //
    // delay at least 5ms 
    //
    for (j=0; j < 100000; j++)
        junk = inp(0x84);

    //
    // VIDEO CLOCK 
    // first compute the VCO program word 
    // NOTE: assume that 52MHz < VCLK < 135MHz , so M=000 
    //

#ifdef SLOW
    I = 3;
	
    //
    // now compute P and Q, based on exhaustive search 
    //

    P = 38;
    Q = 17;
#else

    I = 3;
	
    //
    // now compute P and Q, based on exhaustive search 
    //

    P = 38;
    Q = 17;
#endif
    
    data = (Q-2) | ((P-3) << 10) | (I << 17);

    //
    // OK. now perform the serial programming trick 
    // first do the unlock sequence 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
	
    for (k=0; k < 10; k++)
    {

        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     
                                            /* toggle 
                                             clock with data = 1 */

        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    }

    //
	// unlock 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     


    //
	// unlock 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 



    //
	// unlock 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
    // now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {
        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }
			
        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }			

        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     
        data = data >> 1;

    }



    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
	// select clock 0 
    //

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0

    //
    // delay at least 5ms 
    //
    for (j=0; j < 100000; j++)
        junk = inp(0x84);



    data = 0xc10000; /* Control Register vclk = TTL */

    //
	// OK. now perform the serial programming trick 
	// first do the unlock sequence 

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
	
    for (k=0; k < 10; k++)
    {
        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     
                                        /* toggle 
                                        clock with data = 1 */

        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 
    }




    //
	// unlock 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     


    //
	// unlock 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 



    //
	// unlock 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     


    //
	// now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {

        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }			
        outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

        if ((data & 1) == 0) {
            outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0
        }
        else  {
            outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     
        }			
        outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     
        data = data >> 1;


    }

    //
	// stop bit 
    //


    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDDATA);     

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal |= ICDCLK);     

    //
	// select clock 0 
    //
    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDCLK); 

    outp(IV2GlobPort,IV2GlobCtrlVal &= ~ICDDATA); // Data = 0

    //
	// delay at least 5ms 
    //

    for (j=0; j < 100000; j++)
        junk = inp(0x84);


}



#else



//
// ProgramICD2062(vclk, mclk)
// program the ICD2062 programmable clock chip to
// vclk, mclk (in MHz)= 64 and 10 respectively
//
// set up 1024x768, 60Hz refresh, 64.000 MHz dot clk 
// SGI Indigo monitor 
//
VOID devpProgramICD2062x6410
(
)
{
    int k;
    unsigned long data, I, P, Q, j;
    volatile unsigned long junk;

    I = 7;

    P = 95;
    Q = 34;
    data = (Q-2) | ((P-3) << 10) | (I << 17) | 
        	(unsigned long)(3 << 21) | (unsigned long)(3 << 7);

    //
	// OK. now perform the serial programming trick 
	// first do the unlock sequence 
    //

    WCLOCK_WRITE(REX,ICDDATA,1);  /* DATA = 1 */
	
    for (k=0; k < 10; k++)
    {
                                     //
        WCLOCK_WRITE(REX,ICDCLK,1);  // toggle
                                     // clock with data = 1 

                                     //
        WCLOCK_WRITE(REX,ICDCLK,0);  // toggle
                                     // clock with data = 1 
                                     //
    }
    //
    // unlock 
    //
                                  //
    WCLOCK_WRITE(REX,ICDDATA,0);  // Data = 0
                                  //


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
	// unlock 
    //
    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */


    //
	// unlock 
    //

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
	// now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {
        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }
        else  {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }			
        WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }
        else  {
          WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }			
        WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */
        data = data >> 1;
    }
    //
    // stop bit 
    //
    WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */

    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
	// select clock 0 
    //
    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */

    //
    // delay at least 5ms 
    //
    for (j=0; j < 100000; j++)
        WCLOCK_READ(REX,ICDDATA,junk);

    //
    // VIDEO CLOCK 
    // first compute the VCO program word 
    // NOTE: assume that 52MHz < VCLK < 135MHz , so M=000 
    //

    I = 3;
	
    //
    // now compute P and Q, based on exhaustive search 
    //

    P = 38;
    Q = 17;
    
    data = (Q-2) | ((P-3) << 10) | (I << 17);

    //
    // OK. now perform the serial programming trick 
    // first do the unlock sequence 
    //

    WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
	
    for (k=0; k < 10; k++)
    {

        WCLOCK_WRITE(REX,ICDCLK,1);  /* toggle 
                                             clock with data = 1 */

        WCLOCK_WRITE(REX,ICDCLK,0);  /* toggle 
                                             clock with data = 1 */

    }

    //
	// unlock 
    //

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */


    //
	// unlock 
    //

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */



    //
	// unlock 
    //
    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
    // now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {
        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }
        else  {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }
			
        WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }
        else  {
            WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }			

        WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */
        data = data >> 1;

    }



    WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */

    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
	// select clock 0 
    //

    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */

    //
    // delay at least 5ms 
    //
    for (j=0; j < 100000; j++)
        WCLOCK_READ(REX,ICDDATA,junk);



    data = 0xc10000; /* Control Register vclk = TTL */

    //
	// OK. now perform the serial programming trick 
	// first do the unlock sequence 

    WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
	
    for (k=0; k < 10; k++)
    {
        WCLOCK_WRITE(REX,ICDCLK,1);  /* toggle 
                                        clock with data = 1 */

        WCLOCK_WRITE(REX,ICDCLK,0);  /* toggle 
                                             clock with data = 1 */
    }




    //
	// unlock 
    //
    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */


    //
	// unlock 
    //
    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */



    //
	// unlock 
    //
    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */


    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */


    //
	// now clock in 24 bits of manchester encoded data 
    //

    for (k=0; k < 24; k++)
    {

        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }
        else  {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }			
        WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

        if ((data & 1) == 0) {
            WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */
        }
        else  {
            WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */
        }			
        WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */
        data = data >> 1;


    }

    //
	// stop bit 
    //


    WCLOCK_WRITE(REX,ICDDATA,1);  /* Data = 1 */

    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDCLK,1);  /* CLK = 1 */

    //
	// select clock 0 
    //
    WCLOCK_WRITE(REX,ICDCLK,0);  /* CLK = 0 */

    WCLOCK_WRITE(REX,ICDDATA,0);  /* Data = 0 */

    //
	// delay at least 5ms 
    //

    for (j=0; j < 100000; j++)
        WCLOCK_READ(REX,ICDDATA,junk);


}

#endif // IV2REVB

VOID devpDisplayInitLUT
(
   LPREXCHIP pRexRegs,
   ULONG Sync
)

/*++

Routine Description:

    Load the LUT on the LG2 board

Arguments:

    pRexRegs - Addres of Rex chip registers
    Sync - 1 for sync-on-green

Return Value:

    None.

--*/

{
   int i;
   ULONG lutcmd;


   if ( Sync ) {
      DAC_WRITE(pRexRegs,CONTROL,3);          /* sync on green */
   }
   else  {
      DAC_WRITE(pRexRegs,CONTROL,2);
   }

   REX_WRITE(&(pRexRegs->p1.set.configsel),CONTROL); 
   lutcmd = REX_READ(&(pRexRegs->p1.go.rwdac)); 
   lutcmd = REX_READ(&(pRexRegs->p1.set.rwdac)); 

   lutcmd &= 0xf;



   // Init color map 0
   //
   DAC_WRITE(pRexRegs, CONTROL, lutcmd);
   DAC_WRITE(pRexRegs, WRITE_ADDR, 0x00);

   for (i = 0; i < 256; i++)
   {

       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x0);  //Red
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x0);  //Green
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x0);  //Blue


   }

   // Init color map 1
   //
   DAC_WRITE(pRexRegs, CONTROL, lutcmd | (1 << 6));
   DAC_WRITE(pRexRegs, WRITE_ADDR, 0);

   for (i = 0; i < 256; i++)
   {
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   }

   // Init color map 2
   //
   DAC_WRITE(pRexRegs, CONTROL, lutcmd | (2 << 6));
   DAC_WRITE(pRexRegs, WRITE_ADDR, 0);

   for (i = 0; i < 256; i++)
   {
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   }

   // Init color map 3
   //
   DAC_WRITE(pRexRegs, CONTROL, lutcmd | (3 << 6));
   DAC_WRITE(pRexRegs, WRITE_ADDR, 0);

   // Fourth map is used for the cursor
   //
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);	// entry 0, black
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);

   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);	// entry 1, black
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);

   DAC_WRITE(pRexRegs, PALETTE_RAM, 0xff);	// entry 2, black
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);

   DAC_WRITE(pRexRegs, PALETTE_RAM, 0xff);	// entry 3, white
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0xff);
   DAC_WRITE(pRexRegs, PALETTE_RAM, 0xff);

   for (i = 4; i < 256; i++)
   {
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
       DAC_WRITE(pRexRegs, PALETTE_RAM, 0x00);
   }

   // Command register 0
   //
   DAC_WRITE(pRexRegs, CONTROL, lutcmd);
   return;
}



VOID devpDisplayLoadSRAM
(
    LPREXCHIP   pRexRegs,
    PUCHAR       Data,
    USHORT       Addr,
    USHORT       Length
)

/*++

Routine Description:

    Load the data table into the external SRAM of the VC1.

Arguments:

    pRexRegs - Addres of Rex chip registers
    Data     - Pointer to data array to be placed in SRAM
    Addr     - Address in SRAM to load table
    Length   - Lenght of data table in UCHARs

Return Value:

    None.

--*/

{
   USHORT  i;
  
   VC1_WRITE_ADDR(pRexRegs, Addr, 0x02);
   for (i = 0; i < Length; i += 2)
   {
       VC1_WRITE8(pRexRegs, Data[i]);
       VC1_WRITE8(pRexRegs, Data[i + 1]);
   }
}


VOID devpDisplayLoadSRAMConstant
(
    LPREXCHIP    pRexRegs,
    UCHAR        Constant1,    
    UCHAR        Constant2,    
    UCHAR        LastValue1,    
    UCHAR        LastValue2,    
    USHORT       Addr,
    USHORT       Length
)

/*++

Routine Description:

    Load the data table into the external SRAM of the VC1.

Arguments:

    pRexRegs - Addres of Rex chip registers
    Data     - Pointer to data array to be placed in SRAM
    Addr     - Address in SRAM to load table
    Length   - Lenght of data table in UCHARs

Return Value:

    None.

--*/

{
   USHORT  i;
  
   VC1_WRITE_ADDR(pRexRegs, Addr, 0x02);
   for (i = 0; i < Length; i += 2)
   {
       VC1_WRITE8(pRexRegs, Constant1);
       VC1_WRITE8(pRexRegs, Constant2);
   }
   VC1_WRITE8(pRexRegs, LastValue1);
   VC1_WRITE8(pRexRegs, LastValue2);
}



void devpColor(DWORD c)
{
   REX_WRITE(&(REX->set.colorredi), c); 
}



void devprgbcolor(DWORD r, DWORD g, DWORD b)
{
    REX_WRITE(&(REX->set.colorredi),r);
    REX_WRITE(&(REX->set.colorgreeni),g);
    REX_WRITE(&(REX->set.colorbluei),b);
}


 

void devpBlock(DWORD x0, DWORD y0, DWORD x1, DWORD y1,DWORD logicop)
{
    REX_WAIT(REX);

    REX_WRITE(&(REX->set.xstarti),x0 + 2048);
    REX_WRITE(&(REX->set.ystarti),y0 + 2048);
    REX_WRITE(&(REX->set.xendi),x1   + 2048);
    REX_WRITE(&(REX->set.yendi),y1   + 2048);
    REX_WRITE(&(REX->set.command), logicop | BLOCK | QUADMODE | STOPONX | STOPONY | REX_DRAW);
    x1 = REX_READ(&(REX->go.command));
}



