/****************************************************************************\
*                                                                            *
* Function: Palette entrypoints                                              *
*                                                                            *
*       Set, get, and update palette colors.                                 *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "palette.h"
#include "lg1hw.h"

#include "iv2.h"

                                //
DWORD devpStatus = 0;           //  Global Variable - Used for Windows statuses
                                //

                                //
extern LPREXCHIP    REX;        // Global Variable - Base pointer to IV2 Board
                                //

//
// This is the system palette defined as IRGB, where I is the index into the
// device palette.
//


#define IRGB_DWORD(i, r, g, b) (((DWORD)(r)) | ((DWORD)(g) << 8) | ((DWORD)(b) << 16) | ((DWORD)(i) << 24))

DWORD devSystemPalette[20] =
{
    IRGB_DWORD(0,   0x00, 0x00, 0x00),
    IRGB_DWORD(1,   0x80, 0x00, 0x00),
    IRGB_DWORD(2,   0x00, 0x80, 0x00),
    IRGB_DWORD(3,   0x80, 0x80, 0x00),
    IRGB_DWORD(4,   0x00, 0x00, 0x80),
    IRGB_DWORD(5,   0x80, 0x00, 0x80),
    IRGB_DWORD(6,   0x00, 0x80, 0x80),
    IRGB_DWORD(7,   0xC0, 0xC0, 0xC0),
    IRGB_DWORD(8,   0xC0, 0xDC, 0xC0),
    IRGB_DWORD(9,   0xA4, 0xC8, 0xF0),
    IRGB_DWORD(246, 0xFF, 0xFB, 0xF0),
    IRGB_DWORD(247, 0xA0, 0xA0, 0xA4),
    IRGB_DWORD(248, 0x80, 0x80, 0x80),
    IRGB_DWORD(249, 0xFF, 0x00, 0x00),
    IRGB_DWORD(250, 0x00, 0xFF, 0x00),
    IRGB_DWORD(251, 0xFF, 0xFF, 0x00),
    IRGB_DWORD(252, 0x00, 0x00, 0xFF),
    IRGB_DWORD(253, 0xFF, 0x00, 0xFF),
    IRGB_DWORD(254, 0x00, 0xFF, 0xFF),
    IRGB_DWORD(255, 0xFF, 0xFF, 0xFF)
};

//
// This table reflects the high intensity colors of the system palette for
// converting color indeces into monochrome white or black.
//

BYTE devColorToMono[20] =
{
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x01,
    0x01,
    0x01,
    0x01,
    0x00,
    0x00,
    0x01,
    0x01,
    0x00,
    0x01,
    0x01,
    0x01
};

//
// Copy of the devices hardware palette.
//

RGBQUAD devPalette[256];

//
// Translation table from logical indeces to device indeces.
//

BYTE devXlateTbl[256];

//
// Translation table from device indeces to logical indeces.
//

BYTE devUnxlateTbl[256];

//
// Translateion table used in Update Colors
//
LPBYTE  devUpdateColorsTbl;

VOID PASCAL devpUpdateColors(SHORT, SHORT, LPBYTE, USHORT, USHORT, USHORT, SHORT, SHORT, SHORT, SHORT, DWORD, SHORT, USHORT);

VOID WINAPI SetPalette
(
    WORD      wStartIndex,
    WORD      wNumEntries,
    LPRGBQUAD lpPalette
)
{
    WORD ii;
    WORD i;
    ULONG lutcmd;

    DBGMSG("SetPalette\n\r");

    REX_WRITE(&(REX->p1.set.configsel),CONTROL); 
    lutcmd = REX_READ(&(REX->p1.go.rwdac)); 
    lutcmd = REX_READ(&(REX->p1.set.rwdac)); 
    lutcmd &= 0xf;

    //
    // Init color map 0
    //
    DAC_WRITE(REX, CONTROL, lutcmd);
    DAC_WRITE(REX, WRITE_ADDR, wStartIndex);

    for (i = 0; i < wNumEntries; i++)
    {
        //
        // Slight discrepancy about format of RGBQUAD
        //

        DAC_WRITE(REX, PALETTE_RAM, lpPalette[i].rgbBlue);  //Blue
        DAC_WRITE(REX, PALETTE_RAM, lpPalette[i].rgbGreen);  //Green
        DAC_WRITE(REX, PALETTE_RAM, lpPalette[i].rgbRed);  //Red
    }

    DAC_WRITE(REX, CONTROL, lutcmd);
    DAC_WRITE(REX, WRITE_ADDR, 0);

    for (ii = 0; ii < wNumEntries; ii++)
        devPalette[ii + wStartIndex] = lpPalette[ii];
}

VOID WINAPI GetPalette
(
    WORD      wStartIndex,
    WORD      wNumEntries,
    LPRGBQUAD lpPalette
)
{
    WORD ii;

    DBGMSG("GetPalette\n\r");

    for (ii = 0; ii < wNumEntries; ii++)
        lpPalette[ii] = devPalette[ii + wStartIndex];
}

VOID WINAPI SetPalTrans
(
    LPWORD lpIndexes
)
{
    WORD ii;

    DBGMSG("SetPalTrans\n\r");

    if (lpIndexes)
    {
        //
        // Copy translation vector.
        //

        for (ii = 0; ii < 256; ii++)
            devXlateTbl[ii] = (BYTE)lpIndexes[ii];

        devpStatus |= PALETTETRANS;
    }
    else
    {
        //
        // Build identity vector.
        //

        for (ii = 0; ii < 256; ii++)
            devXlateTbl[ii] = (BYTE)ii;
        devpStatus &= ~(PALETTETRANS);

    }

    //
    // Construct inverse translation vector.
    //

    for (ii = 0; ii < 256; ii++)
        devUnxlateTbl[devXlateTbl[ii]] = (BYTE)ii;
}

VOID WINAPI GetPalTrans
(
    LPWORD lpIndexes
)
{
    WORD ii;

    DBGMSG("GetPalTrans\n\r");

    for (ii = 0; ii < 256; ii++)
        lpIndexes[ii] = (WORD)devXlateTbl[ii];
}

VOID WINAPI UpdateColors
(
    WORD   wDstX,
    WORD   wDstY,
    WORD   wXext,
    WORD   wYext,
    LPWORD lpTranslate
)
{
    WORD ii;
    DWORD tmpStatus;
    LPBITMAP lpTmpBitmap;
    HANDLE   hMem;
    LPBYTE   lpbptr;

    DBGMSG("UpdateColors\n\r");

    //
    // Allocate and lock a bitmap structure.
    //

    hMem  = GlobalAlloc(0, 256);
    lpbptr = (LPBYTE)GlobalLock(hMem);

    for (ii = 0; ii < 256; ii++)
        lpbptr[ii] = (BYTE)lpTranslate[ii];

    lpTmpBitmap = CreateColorBitmap(wXext, wYext);

    tmpStatus = devpStatus;
    devpStatus &= ~PALETTETRANS;

    devBltSD_ToColor(lpTmpBitmap->bmBits,
                        lpTmpBitmap->bmWidthBytes,
                        lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                        lpTmpBitmap->bmFillBytes,
                        0,
                        0,
                        wDstX,
                        wDstY,
                        wXext,
                        wYext);

    //
    // Set global variable to translate table.
    //

    devUpdateColorsTbl = lpbptr;

    devpUpdateColors(wDstX,
                    wDstY,
                    lpTmpBitmap->bmBits,
                    lpTmpBitmap->bmWidthBytes,
                    lpTmpBitmap->bmSegmentIndex ? lpTmpBitmap->bmScanSegment : 0x7FFF,
                    lpTmpBitmap->bmFillBytes,
                    0,
                    0,
                    wXext,
                    wYext,
                    0L,
                    OPAQUE,
                    0x0C);


    //
    // Restore status.
    //

    devpStatus = tmpStatus;

    DestroyBitmap(lpTmpBitmap);
    GlobalUnlock(hMem);
    GlobalFree(hMem);
}
