;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Set and get individual pixels.                                   ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dave Schmenk                                                         ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       07/02/93 Dave Schmenk - wrote it.                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;
.MODEL SMALL, PASCAL

        INCLUDE COMMON.INC
        INCLUDE IV2.INC

.DATA

EXTERN _REX : DWORD
EXTERN Rop2XlateTable  : BYTE
EXTERN _devColorToMono : BYTE

.CODE
.386

devSetPixel     PROC NEAR USES gs                       \
                        xPos  : WORD,                   \
                        yPos  : WORD,                   \
                        color : DWORD,                  \
                        rop   : WORD
;
; Get REX version of rop.
;
        mov     bx, rop
        mov     bl, Rop2XlateTable[bx]
        shl     ebx, 28
;
; Wait until REX idle.
;
        mov     gs, WORD PTR [_REX][2]
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     ax, WORD PTR color
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     ax, xPos
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        mov     ax, yPos
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        mov     eax, CMD_DRAW
        or      eax, ebx                            ; or in ROP
        mov     gs:REX_GO + REX_REGS.CMD, eax
        ret
devSetPixel     ENDP

devGetPixel     PROC NEAR USES gs                       \
                        xPos  : WORD,                   \
                        yPos  : WORD
;
; Wait until REX idle.
;
        mov     gs, WORD PTR [_REX][2]
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     ax, xPos
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.XSTARTI, eax
        mov     ax, yPos
        add     ax, 2048
        mov     gs:REX_SET + REX_REGS.YSTARTI, eax
        mov     eax, CMD_LDPIXEL
        mov     gs:REX_GO + REX_REGS.CMD, eax
        mov     eax, gs:REX_GO_LE + REX_REGS.RWAUX1
;
; Force returned pixel into physical format.
;
        xor     bh, bh
        xor     ah, ah
        xor     dx, dx
        not     dh
        mov     bl, al
        cmp     bl, 10
        jb      @F
        cmp     bl, 246
        jb      Exit
        sub     bl, 236
@@:     mov     ah, _devColorToMono[bx]
Exit:
        ret
devGetPixel     ENDP

devClippedLine  PROC NEAR USES gs es si di              \
                        x1     : WORD,                  \
                        y1     : WORD,                  \
                        x2     : WORD,                  \
                        y2     : WORD,                  \
                        lpRect : DWORD,                 \
                        color  : DWORD,                 \
                        rop    : WORD
                LOCAL   ErrA   : WORD,                  \
                        ErrB   : WORD,                  \
                        majDir : WORD,                  \
                        minDir : WORD,                  \
                        majEnd : WORD
        mov     gs, WORD PTR [_REX][2]
        les     si, lpRect
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
;
; Set the clipping rectangle.
;
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_SMASK0 + AUX2_SMASK0IN + AUX2_MATCH0 + AUX2_PXLPLANES
        mov     ax, es:[si][4]                  ; rectRight
        dec     ax
        shl     eax, 16
        mov     ax, es:[si]                     ; rectLeft
        mov     gs:REX_SET + REX_REGS.SMASK1X, eax
        mov     ax, es:[si][6]                  ; rectBottom
        dec     ax
        shl     eax, 16
        mov     ax, es:[si][2]                  ; rectTop
        mov     gs:REX_SET + REX_REGS.SMASK1Y, eax
;
; Get REX version of rop.
;
        mov     bx, rop
        mov     bl, Rop2XlateTable[bx]
        shl     ebx, 28
        mov     ax, WORD PTR color
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     eax, CMD_DRAW
        or      eax, ebx                            ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
;
; Calculate some constants.
;
        mov     dx, -1
        mov     ax, x1
        sub     ax, x2
        jns     @F
        neg     ax
        neg     dx
@@:     mov     cx, -1                          ; ax = ABS(DeltaX)
        mov     bx, y1
        sub     bx, y2
        jns     @F
        neg     bx
        neg     cx
@@:     cmp     ax, bx                          ; bx = ABS(DeltaY)
        jl      Ymajor
;
; This is a X major line.
;
        mov     majDir, dx                      ; X direction in dx
        mov     minDir, cx                      ; Y direction in cx
        mov     cx, bx
        add     cx, cx
        mov     ErrA, cx
        sub     cx, ax
        sub     ax, bx
        neg     ax
        add     ax, ax
        mov     ErrB, ax
        mov     si, REX_GO  + REX_REGS.XSTARTI  ; Major axis in esi
        mov     di, REX_SET + REX_REGS.YSTARTI  ; Minor axis in edi
        mov     ax, x2
        add     ax, 2048
        mov     majEnd, ax                      ; Major axis endpoint
        mov     ax, x1
        add     ax, 2048
        mov     dx, y1
        add     dx, 2048
        jmp     DrawLine
;
; This is a Y major line.
Ymajor:
        mov     majDir, cx                      ; Y direction in cx
        mov     minDir, dx                      ; X direction in dx
        mov     cx, ax
        add     cx, cx
        mov     ErrA, cx
        sub     cx, bx
        sub     bx, ax
        neg     bx
        add     bx, bx
        mov     ErrB, bx
        mov     si, REX_GO  + REX_REGS.YSTARTI  ; Major axis in esi
        mov     di, REX_SET + REX_REGS.XSTARTI  ; Minor axis in edi
        mov     ax, y2
        add     ax, 2048
        mov     majEnd, ax                      ; Major axis endpoint
        mov     ax, y1
        add     ax, 2048
        mov     dx, x1
        add     dx, 2048
;
; The drawline loop does a Bressenham iteration.
;
; ax = major axis startpoint.
; dx = minor axis startpoint.
; cx = current error term.
; esi = pointer to major axis REX register.
; edi = pointer to minor axis REX register.
;
DrawLine:
        mov     bx, majDir                      ; Retrieve major direction
        mov     gs:[di], edx                   ; Save initial minor coordinate
DrawLoop:
        mov     gs:[si], eax                   ; Draw current pixel
        or      cx, cx
        jg      @F
        add     cx, ErrA
        add     ax, bx
        cmp     ax, majEnd
        jne     DrawLoop
        jmp     Exit
@@:     add     cx,ErrB
        add     ax, bx
        add     dx, minDir
        mov     gs:[di], edx                   ; Update minor coordinate
        cmp     ax, majEnd
        jne     DrawLoop
Exit:
        
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     gs:CFG_SET + CFG_REGS.AUX2, AUX2_PXLPLANES
        ret
devClippedLine  ENDP

devLine         PROC NEAR USES gs si di                  \
                        x1     : WORD,                  \
                        y1     : WORD,                  \
                        x2     : WORD,                  \
                        y2     : WORD,                  \
                        color  : DWORD,                 \
                        rop    : WORD
                LOCAL   ErrA   : WORD,                  \
                        ErrB   : WORD,                  \
                        majDir : WORD,                  \
                        minDir : WORD,                  \
                        majEnd : WORD

;
; Get REX version of rop.
;
        mov     bx, rop
        mov     bl, Rop2XlateTable[bx]
        shl     ebx, 28
        mov     gs, WORD PTR [_REX][2]
;
; Wait until REX idle.
;
@@:     mov     eax, gs:CFG_SET + CFG_REGS.CONFIGMODE
        test    al, REX_BUSY
        jnz     @B
        mov     ax, WORD PTR color
        mov     gs:REX_SET + REX_REGS.CLRREDI, eax
        mov     eax, CMD_DRAW
        or      eax, ebx                            ; or in ROP
        mov     gs:REX_SET + REX_REGS.CMD, eax
;
; Calculate some constants.
;
        mov     dx, -1
        mov     ax, x1
        sub     ax, x2
        jns     @F
        neg     ax
        neg     dx
@@:     mov     cx, -1                          ; ax = ABS(DeltaX)
        mov     bx, y1
        sub     bx, y2
        jns     @F
        neg     bx
        neg     cx
@@:     cmp     ax, bx                          ; bx = ABS(DeltaY)
        jl      Ymajor
;
; This is a X major line.
;
        mov     majDir, dx                      ; X direction in dx
        mov     minDir, cx                      ; Y direction in cx
        mov     cx, bx
        add     cx, cx
        mov     ErrA, cx
        sub     cx, ax
        sub     ax, bx
        neg     ax
        add     ax, ax
        mov     ErrB, ax
        mov     si, REX_GO  + REX_REGS.XSTARTI  ; Major axis in esi
        mov     di, REX_SET + REX_REGS.YSTARTI  ; Minor axis in edi
        mov     ax, x2
        add     ax, 2048
        mov     majEnd, ax                      ; Major axis endpoint
        mov     ax, x1
        add     ax, 2048
        mov     dx, y1
        add     dx, 2048
        jmp     DrawLine
;
; This is a Y major line.
Ymajor:
        mov     majDir, cx                      ; Y direction in cx
        mov     minDir, dx                      ; X direction in dx
        mov     cx, ax
        add     cx, cx
        mov     ErrA, cx
        sub     cx, bx
        sub     bx, ax
        neg     bx
        add     bx, bx
        mov     ErrB, bx
        mov     si, REX_GO  + REX_REGS.YSTARTI  ; Major axis in esi
        mov     di, REX_SET + REX_REGS.XSTARTI  ; Minor axis in edi
        mov     ax, y2
        add     ax, 2048
        mov     majEnd, ax                      ; Major axis endpoint
        mov     ax, y1
        add     ax, 2048
        mov     dx, x1
        add     dx, 2048
;
; The drawline loop does a Bressenham iteration.
;
; ax = major axis startpoint.
; dx = minor axis startpoint.
; cx = current error term.
; esi = pointer to major axis REX register.
; edi = pointer to minor axis REX register.
;
DrawLine:
        mov     bx, majDir                      ; Retrieve major direction
        mov     gs:[di], edx                   ; Save initial minor coordinate
DrawLoop:
        mov     gs:[si], eax                   ; Draw current pixel
        or      cx, cx
        jg      @F
        add     cx, ErrA
        add     ax, bx
        cmp     ax, majEnd
        jne     DrawLoop
        jmp     Exit
@@:     add     cx,ErrB
        add     ax, bx
        add     dx, minDir
        mov     gs:[di], edx                   ; Update minor coordinate
        cmp     ax, majEnd
        jne     DrawLoop
Exit:
        ret        
devLine         ENDP

        END


