/****************************************************************************\
*                                                                            *
* Function: Driver Resource entrypoint                                       *
*                                                                            *
*       Support multiple resource sizes.   .                                 *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/11/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#define OEMRESOURCE                 //
                                    // Get ICOCUR define with this define
                                    //
#include "common.h"
#include "iv2.h"

extern DWORD   devpStatus;         //  Global Variable - Used for Windows statuses

DWORD WINAPI GetDriverResourceID
(
    WORD  ResID,
    LPSTR lpResType
)
{
    DWORD   ReturnStatus;

    DBGMSG("GetDriverResourceID\n\r");
    
    ReturnStatus = (DWORD) ResID;
//
// if devpStatus is not set to MULTIRES_96DPI then do not map
// (use 120 dpi resources).
//
//
// if the ID identifies an icon or cursor then do not map it. 
// Otherwise, map it by adding 2000 from it.  If the ID
// is a 1 or 3, add 2000 to it.
// 1 is config
// 2 is colortable
// 3 is fonts
// ICOCUR is the "largest" icon/cursor, if id is bigger than this
//                                      it must be a bitmap
//
//
    if (devpStatus & MULTIRES_96DPI) {
        if ((ResID > OCR_ICOCUR) || (ResID == 1) || (ResID == 3))
            ReturnStatus += 2000;
    }
    return(ReturnStatus);

}

