        INCLUDE COMMON.INC

;----------------------------------------------------------------------------;
;                                                                            ;
; Function: Ring 0 Translation Routines.                                     ;
;                                                                            ;
; Author:                                                                    ;
;                                                                            ;
;       Dwight Diercks                                                       ;
;                                                                            ;
; History:                                                                   ;
;                                                                            ;
;       06/14/93 Dwight Diercks - wrote it.                                  ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
;                     Copyright 1993 pellucid, inc.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;




GET386API	EQU	1684h		;Get API entry point from VxD.
MULTIPLEX	EQU	2fh		;Multiplex interrupt.
VDD		EQU	000Ah		;id of Virtual Display Driver.

_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME DS: DGROUP
	ASSUME  SS: NOTHING

_DATA           SEGMENT WORD PUBLIC 'DATA'

lpfnVDD         DWORD 0
ToRing0         DWORD 0
ToRing3         DWORD 0    

_DATA           ENDS

_INIT           SEGMENT WORD PUBLIC 'CODE'
.386




devpMapFrameBuffer  Proc NEAR

	xor	di,di
	mov	es,di
	mov	ax,GET386API
	mov	bx,VDD
	int	MULTIPLEX
	mov	ax,es
	or	ax,ax
	jz	short G3P_MF_NoVDD		;will be zero if no VDD is present.

	mov	word ptr lpfnVDD,di
	mov	word ptr lpfnVDD+2,es


	xor	dx,dx
	xor	cx,cx
	mov	ax,069h                         ;IV2 API TO MAP PHYS TO LIN
	call	lpfnVDD
	ret
G3P_MF_NoVDD:
        xor     ax,ax
        ret
devpMapFrameBuffer  ENDP

_INIT   ENDS

END
