/****************************************************************************\
*                                                                            *
* Function: Brush support                                                    *
*                                                                            *
*       Device brush support routines to realize brushes dependent on the    *
*       pixel depth and convert between color and monochrome brushes.        *
*                                                                            *
* Author:                                                                    *
*                                                                            *
*       Dave Schmenk                                                         *
*                                                                            *
* History:                                                                   *
*                                                                            *
*       05/24/93 Dave Schmenk - wrote it.                                    *
*                                                                            *
******************************************************************************
*                                                                            *
*                     Copyright 1992 pellucid, inc.                          *
*                                                                            *
\****************************************************************************/

#include "common.h"
#include "8bpp.h"

//
// Some constants needed by the common code.
//

WORD     memBytesPerPixel = 1;
BYTE     memBitsPerPixel  = 8;
DWORD    devBrushSize = sizeof(BRUSH) + 64 - 1;

//
// Local instance of a temporary brush.
//

DEVBRUSH mempTmpBrush;

LPBRUSH PASCAL memGetTmpBrush
(
    VOID
)
{
    return((LPBRUSH)&mempTmpBrush);
}

